/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday.unmarshalling;

import java.io.InputStream;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.xerces.xs.XSAnnotation;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSImplementation;
import org.apache.xerces.xs.XSLoader;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSModelGroupDefinition;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.apache.xerces.xs.XSWildcard;
import org.jboss.logging.Logger;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.metadata.AddMethodMetaData;
import org.jboss.xb.binding.metadata.CharactersMetaData;
import org.jboss.xb.binding.metadata.ClassMetaData;
import org.jboss.xb.binding.metadata.MapEntryMetaData;
import org.jboss.xb.binding.metadata.PackageMetaData;
import org.jboss.xb.binding.metadata.PropertyMetaData;
import org.jboss.xb.binding.metadata.PutMethodMetaData;
import org.jboss.xb.binding.metadata.SchemaMetaData;
import org.jboss.xb.binding.metadata.ValueMetaData;
import org.jboss.xb.binding.metadata.XsdAnnotation;
import org.jboss.xb.binding.metadata.XsdAppInfo;
import org.jboss.xb.binding.sunday.unmarshalling.AttributeBinding;
import org.jboss.xb.binding.sunday.unmarshalling.DefaultSchemaResolver;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
import org.jboss.xb.binding.sunday.unmarshalling.LSInputAdaptor;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.TypeBinding;
import org.jboss.xb.binding.sunday.unmarshalling.impl.runtime.RtAttributeHandler;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.LSInput;

public class XsdBinder {
    private static final Logger log = Logger.getLogger(XsdBinder.class);
    private static final ThreadLocal xsdBinding = new ThreadLocal(){

        protected Object initialValue() {
            return new XsdBinding();
        }
    };

    private static XsdBinding getXsdBinding() {
        return (XsdBinding)xsdBinding.get();
    }

    private XsdBinder() {
    }

    public static final SchemaBinding bind(String xsdUrl) {
        XSModel model = XsdBinder.loadSchema(xsdUrl);
        return XsdBinder.bind(model, xsdUrl);
    }

    public static final SchemaBinding bind(InputStream xsdStream, String encoding, String baseURI) {
        XSModel model = XsdBinder.loadSchema(xsdStream, encoding, baseURI);
        return XsdBinder.bind(model, baseURI);
    }

    public static final SchemaBinding bind(Reader xsdReader, String encoding, String baseURI) {
        XSModel model = XsdBinder.loadSchema(xsdReader, encoding, baseURI);
        return XsdBinder.bind(model, baseURI);
    }

    public static final SchemaBinding bind(String xsd, String encoding) {
        XSModel model = XsdBinder.loadSchema(xsd, encoding);
        return XsdBinder.bind(model);
    }

    public static final SchemaBinding bind(XSModel model) {
        return XsdBinder.bind(model, null);
    }

    public static final SchemaBinding bind(XSModel model, String baseURI) {
        DefaultSchemaResolver resolver = new DefaultSchemaResolver();
        resolver.setBaseURI(baseURI);
        SchemaBinding schema = XsdBinder.getXsdBinding().schemaBinding;
        schema.setSchemaResolver(resolver);
        XSObjectList annotations = model.getAnnotations();
        for (int i = 0; i < annotations.getLength(); ++i) {
            SchemaMetaData schemaBindings;
            XSAnnotation annotation = (XSAnnotation)annotations.item(i);
            XsdAnnotation an = XsdAnnotation.unmarshal(annotation.getAnnotationString());
            XsdAppInfo appinfo = an.getAppInfo();
            if (appinfo == null || (schemaBindings = appinfo.getSchemaMetaData()) == null) continue;
            schema.setIgnoreUnresolvedFieldOrClass(schemaBindings.isIgnoreUnresolvedFieldOrClass());
            schema.setReplacePropertyRefs(schemaBindings.isReplacePropertyRefs());
            PackageMetaData packageMetaData = schemaBindings.getPackage();
            if (packageMetaData == null) continue;
            if (log.isTraceEnabled()) {
                log.trace("schema default package: " + packageMetaData.getName());
            }
            schema.setPackageMetaData(packageMetaData);
        }
        SharedElements sharedElements = new SharedElements();
        XSNamedMap groups = model.getComponents((short)6);
        for (int i = 0; i < groups.getLength(); ++i) {
            XSModelGroupDefinition groupDef = (XSModelGroupDefinition)groups.item(i);
            XSModelGroup group = groupDef.getModelGroup();
            XSObjectList particles = group.getParticles();
            block6: for (int j = 0; j < particles.getLength(); ++j) {
                XSParticle particle = (XSParticle)particles.item(j);
                XSTerm term = particle.getTerm();
                switch (term.getType()) {
                    case 2: {
                        XSElementDeclaration element = (XSElementDeclaration)term;
                        sharedElements.add(element);
                        continue block6;
                    }
                    case 9: {
                        continue block6;
                    }
                    default: {
                        throw new JBossXBRuntimeException("For now we don't support anything but elements in global model groups");
                    }
                }
            }
        }
        XSNamedMap types = model.getComponents((short)3);
        for (int i = 0; i < types.getLength(); ++i) {
            XSTypeDefinition type = (XSTypeDefinition)types.item(i);
            if ("http://www.w3.org/2001/XMLSchema".equals(type.getNamespace())) continue;
            XsdBinder.bindType(schema, type, sharedElements);
        }
        XSNamedMap elements = model.getComponents((short)2);
        for (int i = 0; i < elements.getLength(); ++i) {
            XSElementDeclaration element = (XSElementDeclaration)elements.item(i);
            XsdBinder.bindElement(schema, element, sharedElements, false);
        }
        return schema;
    }

    /*
     * WARNING - void declaration
     */
    private static final TypeBinding bindType(SchemaBinding doc, XSTypeDefinition type, SharedElements sharedElements) {
        void var3_3;
        switch (type.getTypeCategory()) {
            case 16: {
                TypeBinding binding = XsdBinder.bindSimpleType(doc, (XSSimpleTypeDefinition)type);
                break;
            }
            case 15: {
                TypeBinding binding = XsdBinder.bindComplexType(doc, (XSComplexTypeDefinition)type, sharedElements);
                break;
            }
            default: {
                throw new JBossXBRuntimeException("Unexpected type category: " + type.getTypeCategory());
            }
        }
        return var3_3;
    }

    private static final TypeBinding bindSimpleType(SchemaBinding doc, XSSimpleTypeDefinition type) {
        TypeBinding binding;
        QName typeName = type.getName() == null ? null : new QName(type.getNamespace(), type.getName());
        TypeBinding typeBinding = binding = typeName == null ? null : doc.getType(typeName);
        if (binding == null) {
            XSObjectList annotations;
            XSTypeDefinition baseTypeDef = type.getBaseType();
            TypeBinding baseType = baseTypeDef == null ? null : XsdBinder.bindType(doc, baseTypeDef, null);
            TypeBinding typeBinding2 = binding = baseType == null ? new TypeBinding(typeName) : new TypeBinding(typeName, baseType);
            if (typeName != null) {
                doc.addType(binding);
            }
            if (log.isTraceEnabled()) {
                String msg;
                String string = msg = typeName == null ? "simple anonymous type" : "simple type " + typeName;
                if (baseType != null) {
                    msg = msg + " inherited binding metadata from " + baseType.getQName();
                }
                log.trace(msg);
            }
            if ((annotations = type.getAnnotations()) != null) {
                for (int i = 0; i < annotations.getLength(); ++i) {
                    ValueMetaData valueMetaData;
                    XSAnnotation an = (XSAnnotation)annotations.item(i);
                    XsdAnnotation xsdAn = XsdAnnotation.unmarshal(an.getAnnotationString());
                    XsdAppInfo appInfo = xsdAn.getAppInfo();
                    if (appInfo == null) continue;
                    ClassMetaData classMetaData = appInfo.getClassMetaData();
                    if (classMetaData != null) {
                        if (log.isTraceEnabled()) {
                            log.trace("simple type " + type.getName() + ": impl=" + classMetaData.getImpl());
                        }
                        binding.setClassMetaData(classMetaData);
                    }
                    if ((valueMetaData = appInfo.getValueMetaData()) == null) continue;
                    if (log.isTraceEnabled()) {
                        log.trace("simple type " + type.getName() + ": unmarshalMethod=" + valueMetaData.getUnmarshalMethod() + ", marshalMethod=" + valueMetaData.getMarshalMethod());
                    }
                    binding.setValueMetaData(valueMetaData);
                }
            }
            binding.setSchemaBinding(doc);
        }
        return binding;
    }

    private static final TypeBinding bindComplexType(SchemaBinding doc, XSComplexTypeDefinition type, SharedElements sharedElements) {
        TypeBinding binding;
        QName typeName = type.getName() == null ? null : new QName(type.getNamespace(), type.getName());
        TypeBinding typeBinding = binding = typeName == null ? null : doc.getType(typeName);
        if (binding == null) {
            XSParticle particle;
            TypeBinding baseType = null;
            TypeBinding typeBinding2 = binding = baseType == null ? new TypeBinding(typeName) : new TypeBinding(typeName, baseType);
            if (typeName != null) {
                doc.addType(binding);
            }
            if (log.isTraceEnabled()) {
                String msg;
                String string = msg = typeName == null ? "complex anonymous type" : "complex type " + typeName;
                if (baseType != null) {
                    msg = msg + " inherited binding metadata from " + baseType.getQName();
                }
                log.trace(msg);
            }
            binding.setSchemaBinding(doc);
            XSObjectList attrs = type.getAttributeUses();
            for (int i = 0; i < attrs.getLength(); ++i) {
                XSAttributeUse attr = (XSAttributeUse)attrs.item(i);
                XsdBinder.bindAttributes(doc, binding, attr);
            }
            XSObjectList annotations = type.getAnnotations();
            if (annotations != null) {
                for (int i = 0; i < annotations.getLength(); ++i) {
                    AddMethodMetaData addMethodMetaData;
                    PropertyMetaData propertyMetaData;
                    boolean skip;
                    MapEntryMetaData mapEntryMetaData;
                    CharactersMetaData charactersMetaData;
                    XSAnnotation an = (XSAnnotation)annotations.item(i);
                    XsdAnnotation xsdAn = XsdAnnotation.unmarshal(an.getAnnotationString());
                    XsdAppInfo appInfo = xsdAn.getAppInfo();
                    if (appInfo == null) continue;
                    ClassMetaData classMetaData = appInfo.getClassMetaData();
                    if (classMetaData != null) {
                        if (log.isTraceEnabled()) {
                            log.trace("complex type " + type.getName() + ": impl=" + classMetaData.getImpl());
                        }
                        binding.setClassMetaData(classMetaData);
                    }
                    if ((charactersMetaData = appInfo.getCharactersMetaData()) != null) {
                        if (log.isTraceEnabled()) {
                            boolean mapEntryValue;
                            boolean mapEntryKey;
                            ValueMetaData valueMetaData;
                            PropertyMetaData propertyMetaData2 = charactersMetaData.getProperty();
                            if (propertyMetaData2 != null) {
                                log.trace("complex type " + type.getName() + ": characters bound to " + propertyMetaData2.getName());
                            }
                            if ((valueMetaData = charactersMetaData.getValue()) != null) {
                                log.trace("complex type " + type.getName() + ": characters unmarshalMethod=" + valueMetaData.getUnmarshalMethod() + ", marshalMethod=" + valueMetaData.getMarshalMethod());
                            }
                            if (mapEntryKey = appInfo.isMapEntryKey()) {
                                log.trace("complex type " + type.getName() + ": characters are bound as a key in a map entry");
                            }
                            if (mapEntryValue = appInfo.isMapEntryValue()) {
                                log.trace("complex type " + type.getName() + ": characters are bound as a value in a map entry");
                            }
                        }
                        binding.setCharactersMetaData(charactersMetaData);
                    }
                    if ((mapEntryMetaData = appInfo.getMapEntryMetaData()) != null) {
                        if (log.isTraceEnabled()) {
                            log.trace("complex type " + type.getName() + " is bound to a map entry: impl=" + mapEntryMetaData.getImpl() + ", getKeyMethod=" + mapEntryMetaData.getGetKeyMethod() + ", setKeyMethod=" + mapEntryMetaData.getSetKeyMethod() + ", getValueMethod=" + mapEntryMetaData.getGetValueMethod() + ", setValueMethod=" + mapEntryMetaData.getSetValueMethod() + ", valueType=" + mapEntryMetaData.getValueType() + ", nonNullValue=" + mapEntryMetaData.isNonNullValue());
                        }
                        if (classMetaData != null) {
                            throw new JBossXBRuntimeException("Illegal binding: both jbxb:class and jbxb:mapEntry are specified for complex type " + type.getName());
                        }
                        binding.setMapEntryMetaData(mapEntryMetaData);
                    }
                    if (skip = appInfo.isSkip()) {
                        if (log.isTraceEnabled()) {
                            log.trace("complex type " + type.getName() + ": elements of this type will be skipped; their attrs, character content " + "and elements will be set the parent.");
                        }
                        binding.setSkip(skip);
                    }
                    if ((propertyMetaData = appInfo.getPropertyMetaData()) != null) {
                        if (log.isTraceEnabled()) {
                            log.trace("complex type " + type.getName() + ": the content of elements of this type is bound to property " + propertyMetaData.getName());
                        }
                        binding.setPropertyMetaData(propertyMetaData);
                    }
                    if ((addMethodMetaData = appInfo.getAddMethodMetaData()) == null) continue;
                    if (log.isTraceEnabled()) {
                        log.trace("complex type " + type.getName() + ": elements of this type will be added to parent objects with addMethod=" + addMethodMetaData.getMethodName() + ", valueType=" + addMethodMetaData.getValueType());
                    }
                    binding.setAddMethodMetaData(addMethodMetaData);
                }
            }
            if ((particle = type.getParticle()) != null) {
                XsdBinder.pushType(binding);
                XsdBinder.bindParticle(doc, particle, sharedElements);
                XsdBinder.popType();
            }
        }
        return binding;
    }

    private static void bindAttributes(SchemaBinding doc, TypeBinding type, XSAttributeUse attrUse) {
        XsdAnnotation xsdAn;
        XsdAppInfo appInfo;
        XSAnnotation an;
        XSAttributeDeclaration attr = attrUse.getAttrDeclaration();
        XSSimpleTypeDefinition attrType = attr.getTypeDefinition();
        TypeBinding typeBinding = XsdBinder.bindSimpleType(doc, attrType);
        QName attrName = new QName(attr.getNamespace(), attr.getName());
        AttributeBinding binding = type.addAttribute(attrName, typeBinding, RtAttributeHandler.INSTANCE);
        if (attrUse.getConstraintType() == 1) {
            binding.setDefaultConstraint(attrUse.getConstraintValue());
        }
        if ((an = attr.getAnnotation()) != null && (appInfo = (xsdAn = XsdAnnotation.unmarshal(an.getAnnotationString())).getAppInfo()) != null) {
            boolean mapEntryValue;
            boolean mapEntryKey;
            PropertyMetaData propertyMetaData = appInfo.getPropertyMetaData();
            if (propertyMetaData != null) {
                binding.setPropertyMetaData(propertyMetaData);
            }
            if (mapEntryKey = appInfo.isMapEntryKey()) {
                binding.setMapEntryKey(mapEntryKey);
            }
            if (mapEntryValue = appInfo.isMapEntryValue()) {
                binding.setMapEntryValue(mapEntryValue);
            }
        }
        if (log.isTraceEnabled()) {
            String msg = "attribute " + new QName(attr.getNamespace(), attr.getName()) + ": ";
            msg = binding.getPropertyMetaData() != null ? msg + " property=" + binding.getPropertyMetaData().getName() + ", collectionType=" + binding.getPropertyMetaData().getCollectionType() : (binding.isMapEntryKey() ? msg + "bound as a key in a map entry" : (binding.isMapEntryValue() ? msg + "bound as a value in a map entry" : msg + " type=" + attrType.getName() + ", owner type=" + type.getQName()));
            if (binding.getDefaultConstraint() != null) {
                msg = msg + ", default=" + binding.getDefaultConstraint();
            }
            log.trace(msg);
        }
    }

    private static void bindParticle(SchemaBinding schema, XSParticle particle, SharedElements sharedElements) {
        XSTerm term = particle.getTerm();
        switch (term.getType()) {
            case 7: {
                XsdBinder.bindModelGroup(schema, (XSModelGroup)term, sharedElements);
                break;
            }
            case 9: {
                XsdBinder.bindWildcard(schema, (XSWildcard)term);
                break;
            }
            case 2: {
                XsdBinder.bindElement(schema, (XSElementDeclaration)term, sharedElements, particle.getMaxOccursUnbounded() || particle.getMaxOccurs() > 1);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected term type: " + term.getType());
            }
        }
    }

    private static void bindWildcard(SchemaBinding schema, XSWildcard wildcard) {
        XsdAnnotation xsdAn;
        XsdAppInfo appInfo;
        TypeBinding typeBinding = XsdBinder.peekType();
        XSAnnotation annotation = wildcard.getAnnotation();
        if (annotation != null && (appInfo = (xsdAn = XsdAnnotation.unmarshal(annotation.getAnnotationString())).getAppInfo()) != null) {
            PropertyMetaData propertyMetaData = appInfo.getPropertyMetaData();
            if (propertyMetaData != null && log.isTraceEnabled()) {
                log.trace("wildcard is bound to property: " + propertyMetaData.getName() + ", collectionType=" + propertyMetaData.getCollectionType());
            }
            typeBinding.setWildcardPropertyMetaData(propertyMetaData);
        }
    }

    private static void bindElement(SchemaBinding doc, XSElementDeclaration element, SharedElements sharedElements, boolean multiOccurs) {
        ElementBinding binding;
        QName qName = new QName(element.getNamespace(), element.getName());
        TypeBinding parentType = XsdBinder.peekType();
        ElementBinding elementBinding = binding = parentType == null ? null : parentType.getLocalElement(qName);
        if (binding == null) {
            boolean global;
            TypeBinding type = null;
            boolean shared = sharedElements.isShared(element);
            if (shared) {
                type = sharedElements.getTypeBinding(element);
            }
            if (type == null) {
                type = XsdBinder.bindType(doc, element.getTypeDefinition(), sharedElements);
                if (shared) {
                    sharedElements.setTypeBinding(element, type);
                }
            }
            boolean bl = global = element.getScope() == 1;
            if (global) {
                binding = doc.getElement(qName);
            }
            if (binding == null) {
                XsdAnnotation xsdAn;
                XsdAppInfo appInfo;
                XSAnnotation an;
                binding = new ElementBinding(doc, type);
                binding.setMultiOccurs(multiOccurs);
                if (global) {
                    doc.addElement(qName, binding);
                }
                if ((an = element.getAnnotation()) != null && (appInfo = (xsdAn = XsdAnnotation.unmarshal(an.getAnnotationString())).getAppInfo()) != null) {
                    boolean skip;
                    boolean mapEntryValue;
                    boolean mapEntryKey;
                    ValueMetaData valueMetaData;
                    AddMethodMetaData addMethodMetaData;
                    PutMethodMetaData putMethodMetaData;
                    MapEntryMetaData mapEntryMetaData;
                    PropertyMetaData propertyMetaData;
                    ClassMetaData classMetaData = appInfo.getClassMetaData();
                    if (classMetaData != null) {
                        log.trace("element: name=" + new QName(element.getNamespace(), element.getName()) + ", class=" + classMetaData.getImpl());
                        binding.setClassMetaData(classMetaData);
                    }
                    if ((propertyMetaData = appInfo.getPropertyMetaData()) != null) {
                        if (log.isTraceEnabled()) {
                            log.trace("element: name=" + new QName(element.getNamespace(), element.getName()) + ", property=" + propertyMetaData.getName() + ", collectionType=" + propertyMetaData.getCollectionType());
                        }
                        binding.setPropertyMetaData(propertyMetaData);
                    }
                    if ((mapEntryMetaData = appInfo.getMapEntryMetaData()) != null) {
                        if (propertyMetaData != null) {
                            throw new JBossXBRuntimeException("An element can be bound either as a property or as a map entry but not both: " + new QName(element.getNamespace(), element.getName()));
                        }
                        if (log.isTraceEnabled()) {
                            log.trace("element name=" + new QName(element.getNamespace(), element.getName()) + " is bound to a map entry: impl=" + mapEntryMetaData.getImpl() + ", getKeyMethod=" + mapEntryMetaData.getGetKeyMethod() + ", setKeyMethod=" + mapEntryMetaData.getSetKeyMethod() + ", getValueMethod=" + mapEntryMetaData.getGetValueMethod() + ", setValueMethod=" + mapEntryMetaData.getSetValueMethod() + ", valueType=" + mapEntryMetaData.getValueType() + ", nonNullValue=" + mapEntryMetaData.isNonNullValue());
                        }
                        if (classMetaData != null) {
                            throw new JBossXBRuntimeException("Invalid binding: both jbxb:class and jbxb:mapEntry are specified for element " + new QName(element.getNamespace(), element.getName()));
                        }
                        binding.setMapEntryMetaData(mapEntryMetaData);
                    }
                    if ((putMethodMetaData = appInfo.getPutMethodMetaData()) != null) {
                        if (log.isTraceEnabled()) {
                            log.trace("element: name=" + new QName(element.getNamespace(), element.getName()) + ", putMethod=" + putMethodMetaData.getName() + ", keyType=" + putMethodMetaData.getKeyType() + ", valueType=" + putMethodMetaData.getValueType());
                        }
                        binding.setPutMethodMetaData(putMethodMetaData);
                    }
                    if ((addMethodMetaData = appInfo.getAddMethodMetaData()) != null) {
                        if (log.isTraceEnabled()) {
                            log.trace("element: name=" + new QName(element.getNamespace(), element.getName()) + ", addMethod=" + addMethodMetaData.getMethodName() + ", valueType=" + addMethodMetaData.getValueType() + ", isChildType=" + addMethodMetaData.isChildType());
                        }
                        binding.setAddMethodMetaData(addMethodMetaData);
                    }
                    if ((valueMetaData = appInfo.getValueMetaData()) != null) {
                        if (log.isTraceEnabled()) {
                            log.trace("element " + new QName(element.getNamespace(), element.getName()) + ": unmarshalMethod=" + valueMetaData.getUnmarshalMethod());
                        }
                        binding.setValueMetaData(valueMetaData);
                    }
                    if (mapEntryKey = appInfo.isMapEntryKey()) {
                        if (log.isTraceEnabled()) {
                            log.trace("element name=" + new QName(element.getNamespace(), element.getName()) + ": is bound to a key in a map entry");
                        }
                        binding.setMapEntryKey(mapEntryKey);
                    }
                    if (mapEntryValue = appInfo.isMapEntryValue()) {
                        if (log.isTraceEnabled()) {
                            log.trace("element name=" + new QName(element.getNamespace(), element.getName()) + ": is bound to a value in a map entry");
                        }
                        binding.setMapEntryValue(mapEntryValue);
                    }
                    if (skip = appInfo.isSkip()) {
                        if (log.isTraceEnabled()) {
                            log.trace("element name=" + new QName(element.getNamespace(), element.getName()) + ": will be skipped, it's attributes, character content and children will be set on the parent");
                        }
                        binding.setSkip(skip);
                    }
                }
            }
            if (parentType != null) {
                parentType.addElement(qName, binding);
                if (log.isTraceEnabled()) {
                    log.trace("element: name=" + qName + ", type=" + type.getQName() + ", multiOccurs=" + binding.isMultiOccurs() + ", owner type=" + parentType.getQName());
                }
            }
        }
    }

    private static void bindModelGroup(SchemaBinding doc, XSModelGroup modelGroup, SharedElements sharedElements) {
        XSObjectList particles = modelGroup.getParticles();
        for (int i = 0; i < particles.getLength(); ++i) {
            XSParticle particle = (XSParticle)particles.item(i);
            XsdBinder.bindParticle(doc, particle, sharedElements);
        }
    }

    private static XSModel loadSchema(String xsdURL) {
        log.debug("loading xsd: " + xsdURL);
        XSImplementation impl = XsdBinder.getXSImplementation();
        XSLoader schemaLoader = impl.createXSLoader(null);
        XSModel model = schemaLoader.loadURI(xsdURL);
        if (model == null) {
            throw new IllegalArgumentException("Invalid URI for schema: " + xsdURL);
        }
        return model;
    }

    private static XSModel loadSchema(InputStream is, String encoding, String baseURI) {
        log.debug("loading xsd from InputStream");
        LSInputAdaptor input = new LSInputAdaptor(is, encoding, baseURI);
        XSImplementation impl = XsdBinder.getXSImplementation();
        XSLoader schemaLoader = impl.createXSLoader(null);
        XSModel model = schemaLoader.load((LSInput)input);
        return model;
    }

    private static XSModel loadSchema(Reader reader, String encoding, String baseURI) {
        log.debug("loading xsd from Reader");
        LSInputAdaptor input = new LSInputAdaptor(reader, encoding, baseURI);
        XSImplementation impl = XsdBinder.getXSImplementation();
        XSLoader schemaLoader = impl.createXSLoader(null);
        XSModel model = schemaLoader.load((LSInput)input);
        return model;
    }

    private static XSModel loadSchema(String data, String encoding) {
        log.debug("loading xsd from string");
        LSInputAdaptor input = new LSInputAdaptor(data, encoding);
        XSImplementation impl = XsdBinder.getXSImplementation();
        XSLoader schemaLoader = impl.createXSLoader(null);
        XSModel model = schemaLoader.load((LSInput)input);
        return model;
    }

    private static XSImplementation getXSImplementation() {
        XSImplementation impl;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            String name = "org.apache.xerces.dom.DOMXSImplementationSourceImpl";
            loader.loadClass(name);
            System.setProperty("org.w3c.dom.DOMImplementationSourceList", name);
        }
        catch (ClassNotFoundException e) {
            String name = "org.apache.xerces.dom.DOMXSImplementationSourceImpl";
            System.setProperty("org.w3c.dom.DOMImplementationSourceList", name);
        }
        try {
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            impl = (XSImplementation)registry.getDOMImplementation("XS-Loader");
        }
        catch (Exception e) {
            log.error("Failed to create schema loader.", e);
            throw new IllegalStateException("Failed to create schema loader: " + e.getMessage());
        }
        return impl;
    }

    private static void popType() {
        XsdBinder.getXsdBinding().typeStack.removeLast();
    }

    private static void pushType(TypeBinding binding) {
        XsdBinder.getXsdBinding().typeStack.addLast(binding);
    }

    private static TypeBinding peekType() {
        LinkedList typeStack = XsdBinder.getXsdBinding().typeStack;
        return typeStack.isEmpty() ? null : typeStack.getLast();
    }

    private static final class XsdBinding {
        public final LinkedList typeStack = new LinkedList();
        public final SchemaBinding schemaBinding = new SchemaBinding();

        private XsdBinding() {
        }
    }

    private static final class SharedElements {
        private Map elements = Collections.EMPTY_MAP;

        private SharedElements() {
        }

        public void add(XSElementDeclaration element) {
            switch (this.elements.size()) {
                case 0: {
                    this.elements = Collections.singletonMap(element, null);
                    break;
                }
                case 1: {
                    this.elements = new HashMap(this.elements);
                }
                default: {
                    this.elements.put(element, null);
                }
            }
        }

        public boolean isShared(XSElementDeclaration element) {
            return this.elements.containsKey(element);
        }

        public TypeBinding getTypeBinding(XSElementDeclaration element) {
            return (TypeBinding)this.elements.get(element);
        }

        public void setTypeBinding(XSElementDeclaration element, TypeBinding type) {
            this.elements.put(element, type);
        }
    }
}

