/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.command.impl;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.command.Command;
import org.jbpm.command.CommandService;

public class CommandServiceImpl
implements CommandService,
Serializable {
    private static final long serialVersionUID = 1L;
    protected JbpmConfiguration jbpmConfiguration = null;
    private static final Log log = LogFactory.getLog((Class)CommandServiceImpl.class);

    public CommandServiceImpl(JbpmConfiguration jbpmConfiguration) {
        this.jbpmConfiguration = jbpmConfiguration;
    }

    public Object execute(Command command) {
        JbpmContext jbpmContext = this.jbpmConfiguration.createJbpmContext();
        try {
            log.debug((Object)("executing " + command));
            Object object = command.execute(jbpmContext);
            return object;
        }
        catch (RuntimeException e) {
            jbpmContext.setRollbackOnly();
            throw e;
        }
        catch (Exception e) {
            jbpmContext.setRollbackOnly();
            throw new JbpmException("failed to execute " + command, e);
        }
        finally {
            jbpmContext.close();
        }
    }
}

