/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.node;

import org.dom4j.Element;
import org.jbpm.JbpmContext;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.node.SubProcessResolver;
import org.jbpm.jpdl.JpdlException;

public class DbSubProcessResolver
implements SubProcessResolver {
    private static final long serialVersionUID = 1L;

    public ProcessDefinition findSubProcess(Element subProcessElement) {
        ProcessDefinition subProcessDefinition = null;
        String subProcessName = subProcessElement.attributeValue("name");
        String subProcessVersion = subProcessElement.attributeValue("version");
        JbpmContext jbpmContext = JbpmContext.getCurrentJbpmContext();
        if (jbpmContext != null) {
            if (subProcessName != null) {
                if (subProcessVersion != null) {
                    try {
                        int version = Integer.parseInt(subProcessVersion);
                        subProcessDefinition = jbpmContext.getGraphSession().findProcessDefinition(subProcessName, version);
                    }
                    catch (NumberFormatException e) {
                        throw new JpdlException("version in process-state was not a number: " + subProcessElement.asXML());
                    }
                } else {
                    subProcessDefinition = jbpmContext.getGraphSession().findLatestProcessDefinition(subProcessName);
                }
            } else {
                throw new JpdlException("no sub-process name specfied in process-state: " + subProcessElement.asXML());
            }
        }
        return subProcessDefinition;
    }
}

