/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text;

import java.io.Serializable;
import java.util.Locale;
import oracle.i18n.text.OraLanguage;
import oracle.i18n.text.OraTerritory;
import oracle.i18n.util.GDKOracleMetaData;
import oracle.i18n.util.OraLocaleInfo;

public final class OraDateFormatSymbols
implements Serializable,
Cloneable {
    static final long serialVersionUID = GDKOracleMetaData.getOracleVersionID();
    private String[] amPmStrings;
    private char decimalSeparator;
    private String[] eras;
    private char groupingSeparator;
    private String[] months;
    private String[] shortMonths;
    private String[] weekdays;
    private String[] shortWeekdays;
    private int monthLength;
    private int shortMonthLength;
    private int weekdayLength;
    private int shortWeekdayLength;
    private int amPmLength;
    private int eraLength;

    public OraDateFormatSymbols() {
        this.initialize(OraLocaleInfo.getDefault());
    }

    public OraDateFormatSymbols(Locale locale) {
        this.initialize(OraLocaleInfo.getInstance(locale));
    }

    public OraDateFormatSymbols(OraLocaleInfo oraLocaleInfo) {
        this.initialize(oraLocaleInfo);
    }

    public String[] getEras() {
        return this.duplicateArray(this.eras);
    }

    public void setEras(String[] stringArray) {
        this.eras = this.duplicateArray(stringArray);
        this.eraLength = this.getMaxLength(this.eras);
    }

    public String[] getMonths() {
        return this.duplicateArray(this.months);
    }

    public void setMonths(String[] stringArray) {
        this.months = this.duplicateArray(stringArray);
        this.monthLength = this.getMaxLength(this.months);
    }

    public String[] getShortMonths() {
        return this.duplicateArray(this.shortMonths);
    }

    public void setShortMonths(String[] stringArray) {
        this.shortMonths = this.duplicateArray(stringArray);
        this.shortMonthLength = this.getMaxLength(this.shortMonths);
    }

    public String[] getWeekdays() {
        return this.duplicateArray(this.weekdays);
    }

    public void setWeekdays(String[] stringArray) {
        this.weekdays = this.duplicateArray(stringArray);
        this.weekdayLength = this.getMaxLength(this.weekdays);
    }

    public String[] getShortWeekdays() {
        return this.duplicateArray(this.shortWeekdays);
    }

    public void setShortWeekdays(String[] stringArray) {
        this.shortWeekdays = this.duplicateArray(stringArray);
        this.shortWeekdayLength = this.getMaxLength(this.shortWeekdays);
    }

    public String[] getAmPmStrings() {
        return this.duplicateArray(this.amPmStrings);
    }

    public void setAmPmStrings(String[] stringArray) {
        this.amPmStrings = this.duplicateArray(stringArray);
        this.amPmLength = this.getMaxLength(this.amPmStrings);
    }

    char getDecimalSeparator() {
        return this.decimalSeparator;
    }

    void setDecimalSeparator(char c) {
        this.decimalSeparator = c;
    }

    char getGroupingSeparator() {
        return this.groupingSeparator;
    }

    void setGroupingSeparator(char c) {
        this.groupingSeparator = c;
    }

    int getMonthLength() {
        return this.monthLength;
    }

    int getShortMonthLength() {
        return this.shortMonthLength;
    }

    int getWeekdayLength() {
        return this.weekdayLength;
    }

    int getShortWeekdayLength() {
        return this.shortWeekdayLength;
    }

    public Object clone() {
        try {
            OraDateFormatSymbols oraDateFormatSymbols = (OraDateFormatSymbols)super.clone();
            oraDateFormatSymbols.setAmPmStrings(this.amPmStrings);
            oraDateFormatSymbols.setEras(this.eras);
            oraDateFormatSymbols.setMonths(this.months);
            oraDateFormatSymbols.setShortMonths(this.shortMonths);
            oraDateFormatSymbols.setWeekdays(this.weekdays);
            oraDateFormatSymbols.setShortWeekdays(this.shortWeekdays);
            return oraDateFormatSymbols;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof OraDateFormatSymbols)) {
            return false;
        }
        OraDateFormatSymbols oraDateFormatSymbols = (OraDateFormatSymbols)object;
        return this.arrayEquals(this.amPmStrings, oraDateFormatSymbols.amPmStrings) && this.arrayEquals(this.eras, oraDateFormatSymbols.eras) && this.arrayEquals(this.months, oraDateFormatSymbols.months) && this.arrayEquals(this.shortMonths, oraDateFormatSymbols.shortMonths) && this.arrayEquals(this.weekdays, oraDateFormatSymbols.weekdays) && this.arrayEquals(this.shortWeekdays, oraDateFormatSymbols.shortWeekdays);
    }

    public int hashCode() {
        return this.months[0].hashCode() + this.weekdays[0].hashCode();
    }

    private void initialize(OraLocaleInfo oraLocaleInfo) {
        OraLanguage oraLanguage = oraLocaleInfo.getOraLanguage();
        OraTerritory oraTerritory = oraLocaleInfo.getOraTerritory();
        String[] stringArray = new String[]{oraLanguage.getBCString(), oraLanguage.getADString()};
        String[] stringArray2 = new String[]{oraLanguage.getMonth01Fullname(), oraLanguage.getMonth02Fullname(), oraLanguage.getMonth03Fullname(), oraLanguage.getMonth04Fullname(), oraLanguage.getMonth05Fullname(), oraLanguage.getMonth06Fullname(), oraLanguage.getMonth07Fullname(), oraLanguage.getMonth08Fullname(), oraLanguage.getMonth09Fullname(), oraLanguage.getMonth10Fullname(), oraLanguage.getMonth11Fullname(), oraLanguage.getMonth12Fullname()};
        String[] stringArray3 = new String[]{oraLanguage.getMonth01Abbreviation(), oraLanguage.getMonth02Abbreviation(), oraLanguage.getMonth03Abbreviation(), oraLanguage.getMonth04Abbreviation(), oraLanguage.getMonth05Abbreviation(), oraLanguage.getMonth06Abbreviation(), oraLanguage.getMonth07Abbreviation(), oraLanguage.getMonth08Abbreviation(), oraLanguage.getMonth09Abbreviation(), oraLanguage.getMonth10Abbreviation(), oraLanguage.getMonth11Abbreviation(), oraLanguage.getMonth12Abbreviation()};
        String[] stringArray4 = new String[]{oraLanguage.getSundayFullname(), oraLanguage.getMondayFullname(), oraLanguage.getTuesdayFullname(), oraLanguage.getWednesdayFullname(), oraLanguage.getThursdayFullname(), oraLanguage.getFridayFullname(), oraLanguage.getSaturdayFullname()};
        String[] stringArray5 = new String[]{oraLanguage.getSundayAbbreviation(), oraLanguage.getMondayAbbreviation(), oraLanguage.getTuesdayAbbreviation(), oraLanguage.getWednesdayAbbreviation(), oraLanguage.getThursdayAbbreviation(), oraLanguage.getFridayAbbreviation(), oraLanguage.getSaturdayAbbreviation()};
        String[] stringArray6 = new String[]{oraLanguage.getAMString(), oraLanguage.getPMString()};
        this.eras = stringArray;
        this.months = stringArray2;
        this.shortMonths = stringArray3;
        this.weekdays = stringArray4;
        this.shortWeekdays = stringArray5;
        this.amPmStrings = stringArray6;
        this.decimalSeparator = oraTerritory.getDecimalCharacter().charAt(0);
        this.groupingSeparator = oraTerritory.getGroupSeparator().charAt(0);
        this.monthLength = this.getMaxLength(this.months);
        this.shortMonthLength = this.getMaxLength(this.shortMonths);
        this.weekdayLength = this.getMaxLength(this.weekdays);
        this.shortWeekdayLength = this.getMaxLength(this.shortWeekdays);
        this.amPmLength = this.getMaxLength(this.amPmStrings);
        this.eraLength = this.getMaxLength(this.eras);
    }

    private final String[] duplicateArray(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        return stringArray2;
    }

    private final boolean arrayEquals(String[] stringArray, String[] stringArray2) {
        int n = 0;
        while (n < stringArray.length) {
            if (!stringArray[n].equals(stringArray2[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private int getMaxLength(String[] stringArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].length() > n) {
                n = stringArray[n2].length();
            }
            ++n2;
        }
        return n;
    }
}

