/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.util.builder;

import java.util.HashMap;
import java.util.Vector;
import oracle.i18n.util.builder.NLTParserException;
import oracle.i18n.util.builder.UnicodeMap;
import oracle.sql.ConverterArchive;

public class UnicodeMapChar
extends UnicodeMap {
    private static char flag_mask = (char)65280;
    private static char index_mask = (char)255;
    private char[] dataArray = null;
    private char[][] expandingTable = null;
    private char expanding_flag = (char)63488;
    private char surrogate_flag = (char)63744;

    public UnicodeMapChar(Vector vector) {
        if (vector == null) {
            return;
        }
        Vector vector2 = new Vector();
        int n = vector.size();
        char[] cArray = new char[65536];
        Vector vector3 = new Vector();
        int n2 = 0;
        while (n2 < n) {
            Object[] objectArray = (Object[])vector.elementAt(n2);
            int[] nArray = (int[])objectArray[0];
            if (nArray.length == 1) {
                nArray = this.toUTF16(nArray[0]);
            }
            int[] nArray2 = (int[])objectArray[1];
            this.putMap(nArray, nArray2, cArray, vector2, vector3);
            ++n2;
        }
        this.setSurrogateTable(vector2);
        this.setExpandingTable(vector3);
        this.setData(cArray);
    }

    public UnicodeMapChar(HashMap hashMap) {
        if (hashMap == null) {
            return;
        }
        Object[] objectArray = hashMap.keySet().toArray();
        Vector vector = new Vector();
        int n = objectArray.length;
        char[] cArray = new char[65536];
        Vector vector2 = new Vector();
        int n2 = 0;
        while (n2 < n) {
            Integer n3 = (Integer)objectArray[n2];
            int n4 = n3;
            int[] nArray = this.toUTF16(n4);
            int[] nArray2 = (int[])hashMap.get(n3);
            this.putMap(nArray, nArray2, cArray, vector, vector2);
            ++n2;
        }
        this.setSurrogateTable(vector);
        this.setExpandingTable(vector2);
        this.setData(cArray);
    }

    public UnicodeMapChar(char c, char c2, Vector vector) {
        this.expanding_flag = c;
        this.surrogate_flag = c2;
        if (vector == null) {
            return;
        }
        Vector vector2 = new Vector();
        int n = vector.size();
        char[] cArray = new char[65536];
        Vector vector3 = new Vector();
        int n2 = 0;
        while (n2 < n) {
            Object[] objectArray = (Object[])vector.elementAt(n2);
            int[] nArray = (int[])objectArray[0];
            if (nArray.length == 1) {
                nArray = this.toUTF16(nArray[0]);
            }
            int[] nArray2 = (int[])objectArray[1];
            this.putMap(nArray, nArray2, cArray, vector2, vector3);
            ++n2;
        }
        this.setSurrogateTable(vector2);
        this.setExpandingTable(vector3);
        this.setData(cArray);
    }

    public UnicodeMapChar(char c, char c2, HashMap hashMap) {
        this.expanding_flag = c;
        this.surrogate_flag = c2;
        if (hashMap == null) {
            return;
        }
        Object[] objectArray = hashMap.keySet().toArray();
        Vector vector = new Vector();
        int n = objectArray.length;
        char[] cArray = new char[65536];
        Vector vector2 = new Vector();
        int n2 = 0;
        while (n2 < n) {
            Integer n3 = (Integer)objectArray[n2];
            int n4 = n3;
            int[] nArray = this.toUTF16(n4);
            int[] nArray2 = (int[])hashMap.get(n3);
            this.putMap(nArray, nArray2, cArray, vector, vector2);
            ++n2;
        }
        this.setSurrogateTable(vector);
        this.setExpandingTable(vector2);
        this.setData(cArray);
    }

    public char[] getMapping(char c) {
        char c2 = this.getData(c);
        char c3 = (char)(c2 & flag_mask);
        char[] cArray = null;
        if (c3 == this.expanding_flag) {
            int n = c2 & index_mask;
            int n2 = this.expandingTable[n].length;
            cArray = new char[n2];
            System.arraycopy(this.expandingTable[n], 0, cArray, 0, n2);
        } else if (c3 != this.surrogate_flag) {
            cArray = new char[]{c2 != '\u0000' ? c2 : c};
        }
        return cArray;
    }

    public String getMapping(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (n2 < n) {
            char c;
            char c2;
            char c3;
            if ((c3 = (char)((c2 = this.getData(c = string.charAt(n2++))) & flag_mask)) == this.expanding_flag) {
                stringBuffer.append(this.expandingTable[c2 & index_mask]);
                continue;
            }
            if (c3 != this.surrogate_flag) {
                if (c2 != '\u0000') {
                    stringBuffer.append(c2);
                    continue;
                }
                stringBuffer.append(c);
                continue;
            }
            if (n2 == n) {
                stringBuffer.append(c);
                continue;
            }
            char c4 = string.charAt(n2);
            int n3 = c4 - 56320;
            if (n3 <= 0 || n3 >= 1023) {
                stringBuffer.append(c);
                continue;
            }
            ++n2;
            int n4 = this.surrogateTable[c2 & index_mask][n3];
            if (n4 == 0) {
                stringBuffer.append(c);
                stringBuffer.append(c4);
                continue;
            }
            char c5 = (char)(n4 >>> 16);
            char c6 = (char)(n4 & 0xFFFF);
            if (c5 != '\u0000') {
                stringBuffer.append(c5);
            }
            stringBuffer.append(c6);
        }
        return stringBuffer.toString();
    }

    public char[] getSurrogate(char c, char c2) {
        int n = c & 0xFFFF;
        int n2 = c2 & 0xFFFF;
        if (n < 55296 || n > 56319 || n2 < 56320 || n2 > 57343) {
            return null;
        }
        char c3 = this.getData(c);
        int n3 = this.surrogateTable[c3 & index_mask][c2 - 56320];
        char c4 = (char)(n3 >>> 16);
        char c5 = (char)(n3 & 0xFFFF);
        char[] cArray = c4 != '\u0000' ? new char[]{c4, c5} : (c5 != '\u0000' ? new char[]{c5} : new char[]{c, c2});
        return cArray;
    }

    private char getData(char c) {
        return this.dataArray[this.indexArray[c >>> 8] + (c & 0xFF)];
    }

    private void putMap(int[] nArray, int[] nArray2, char[] cArray, Vector vector, Vector vector2) {
        if (nArray.length == 1) {
            if (nArray2.length == 1) {
                cArray[nArray[0]] = (char)nArray2[0];
                return;
            }
            int n = vector2.size();
            cArray[nArray[0]] = (char)(this.expanding_flag + n);
            char[] cArray2 = new char[nArray2.length];
            int n2 = 0;
            while (n2 < nArray2.length) {
                cArray2[n2] = (char)nArray2[n2];
                ++n2;
            }
            vector2.addElement(cArray2);
            return;
        }
        if (nArray[0] < 55296 || nArray[0] > 56319 || nArray[1] < 56320 || nArray[1] > 57343) {
            System.out.println("NLT error -- invalid surrogate code points");
        } else {
            int n = nArray[0] - 55296;
            int n3 = nArray[1] - 56320;
            int[] nArray3 = null;
            if (cArray[nArray[0]] == '\u0000') {
                char c;
                nArray3 = new int[1024];
                int n4 = vector.size();
                cArray[nArray[0]] = c = (char)(this.surrogate_flag + n4);
                vector.addElement(nArray3);
            } else {
                int n5 = cArray[nArray[0]] & index_mask;
                nArray3 = (int[])vector.elementAt(n5);
            }
            if (nArray2.length == 1) {
                nArray3[n3] = nArray2[0];
            } else if (nArray2.length == 2) {
                nArray3[n3] = nArray2[0] << 16 + nArray2[1] & 0xFFFF;
            }
        }
    }

    private void setExpandingTable(Vector vector) {
        if (vector == null || vector.size() == 0) {
            return;
        }
        int n = vector.size();
        this.expandingTable = new char[n][];
        int n2 = 0;
        while (n2 < n) {
            if (n2 == 240) {
                System.out.println(n2);
            }
            char[] cArray = (char[])vector.elementAt(n2);
            this.expandingTable[n2] = new char[cArray.length];
            int n3 = 0;
            while (n3 < cArray.length) {
                this.expandingTable[n2][n3] = cArray[n3];
                ++n3;
            }
            ++n2;
        }
    }

    private void setData(char[] cArray) {
        this.indexArray = new int[256];
        int n = this.compressCharArray(cArray, this.indexArray);
        this.dataArray = new char[n];
        System.arraycopy(cArray, 0, this.dataArray, 0, n);
    }

    private int compressCharArray(char[] cArray, int[] nArray) {
        nArray[0] = 0;
        int n = 256;
        int n2 = 1;
        while (n2 < 256) {
            int n3;
            int n4 = 0;
            while (n4 < n) {
                n3 = 0;
                while (n3 < (256 < n - n4 ? 256 : n - n4)) {
                    char c = cArray[n4 + n3];
                    int n5 = n2 << 8;
                    char c2 = cArray[n5 | n3];
                    if (c != c2) break;
                    ++n3;
                }
                if (n3 == (256 < n - n4 ? 256 : n - n4)) break;
                ++n4;
            }
            nArray[n2] = (short)n4;
            n3 = (n2 << 8) + (n - n4);
            while (n3 < n2 + 1 << 8) {
                cArray[n++] = cArray[n3];
                ++n3;
            }
            ++n2;
        }
        return n;
    }

    private int[] toUTF16(int n) {
        int[] nArray = new int[1];
        if ((n & 0xFFFF0000) != 0) {
            nArray = new int[]{(n & 0xFFFF0000) >>> 16, n & 0xFFFF};
        } else {
            nArray[0] = n;
        }
        return nArray;
    }

    private void statistic() {
        System.out.println("dataArray length is " + this.dataArray.length);
        System.out.println("expanding table length is  " + this.expandingTable.length);
        System.out.println("surrogate table length is " + this.surrogateTable.length);
        System.out.println("surrogate table block length is " + this.surrogateTable[0].length);
    }

    public static void main(String[] stringArray) throws NLTParserException {
        ConverterArchive converterArchive = new ConverterArchive();
        UnicodeMapChar unicodeMapChar = (UnicodeMapChar)converterArchive.readObj("/oracle/i18n/data/lx40010.glb");
        unicodeMapChar.statistic();
        String string = "\u0133\ud801\udc24";
        String string2 = unicodeMapChar.getMapping(string);
        System.out.println(string + " " + string2);
    }
}

