/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xalan.internal.xsltc.compiler;

import com.sun.org.apache.xalan.internal.xsltc.compiler.AttributeSet;
import com.sun.org.apache.xalan.internal.xsltc.compiler.DecimalFormatting;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Param;
import com.sun.org.apache.xalan.internal.xsltc.compiler.QName;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Stylesheet;
import com.sun.org.apache.xalan.internal.xsltc.compiler.SyntaxTreeNode;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Template;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Variable;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.MethodType;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

final class SymbolTable {
    private final Hashtable _stylesheets = new Hashtable();
    private final Hashtable _primops = new Hashtable();
    private Hashtable _variables = null;
    private Hashtable _templates = null;
    private Hashtable _attributeSets = null;
    private Hashtable _aliases = null;
    private Hashtable _excludedURI = null;
    private Hashtable _decimalFormats = null;
    private int _nsCounter = 0;
    private SyntaxTreeNode _current = null;

    SymbolTable() {
    }

    public DecimalFormatting getDecimalFormatting(QName qName) {
        if (this._decimalFormats == null) {
            return null;
        }
        return (DecimalFormatting)this._decimalFormats.get(qName);
    }

    public void addDecimalFormatting(QName qName, DecimalFormatting decimalFormatting) {
        if (this._decimalFormats == null) {
            this._decimalFormats = new Hashtable();
        }
        this._decimalFormats.put(qName, decimalFormatting);
    }

    public Stylesheet addStylesheet(QName qName, Stylesheet stylesheet) {
        return this._stylesheets.put(qName, stylesheet);
    }

    public Stylesheet lookupStylesheet(QName qName) {
        return (Stylesheet)this._stylesheets.get(qName);
    }

    public Template addTemplate(Template template) {
        QName qName = template.getName();
        if (this._templates == null) {
            this._templates = new Hashtable();
        }
        return this._templates.put(qName, template);
    }

    public Template lookupTemplate(QName qName) {
        if (this._templates == null) {
            return null;
        }
        return (Template)this._templates.get(qName);
    }

    public Variable addVariable(Variable variable) {
        if (this._variables == null) {
            this._variables = new Hashtable();
        }
        String string = variable.getName().getStringRep();
        return this._variables.put(string, variable);
    }

    public Param addParam(Param param) {
        if (this._variables == null) {
            this._variables = new Hashtable();
        }
        String string = param.getName().getStringRep();
        return this._variables.put(string, param);
    }

    public Variable lookupVariable(QName qName) {
        if (this._variables == null) {
            return null;
        }
        String string = qName.getStringRep();
        Object v = this._variables.get(string);
        return v instanceof Variable ? (Variable)v : null;
    }

    public Param lookupParam(QName qName) {
        if (this._variables == null) {
            return null;
        }
        String string = qName.getStringRep();
        Object v = this._variables.get(string);
        return v instanceof Param ? (Param)v : null;
    }

    public SyntaxTreeNode lookupName(QName qName) {
        if (this._variables == null) {
            return null;
        }
        String string = qName.getStringRep();
        return (SyntaxTreeNode)this._variables.get(string);
    }

    public AttributeSet addAttributeSet(AttributeSet attributeSet) {
        if (this._attributeSets == null) {
            this._attributeSets = new Hashtable();
        }
        return this._attributeSets.put(attributeSet.getName(), attributeSet);
    }

    public AttributeSet lookupAttributeSet(QName qName) {
        if (this._attributeSets == null) {
            return null;
        }
        return (AttributeSet)this._attributeSets.get(qName);
    }

    public void addPrimop(String string, MethodType methodType) {
        Vector<MethodType> vector = (Vector<MethodType>)this._primops.get(string);
        if (vector == null) {
            vector = new Vector<MethodType>();
            this._primops.put(string, vector);
        }
        vector.addElement(methodType);
    }

    public Vector lookupPrimop(String string) {
        return (Vector)this._primops.get(string);
    }

    public String generateNamespacePrefix() {
        return new String("ns" + this._nsCounter++);
    }

    public void setCurrentNode(SyntaxTreeNode syntaxTreeNode) {
        this._current = syntaxTreeNode;
    }

    public String lookupNamespace(String string) {
        if (this._current == null) {
            return "";
        }
        return this._current.lookupNamespace(string);
    }

    public void addPrefixAlias(String string, String string2) {
        if (this._aliases == null) {
            this._aliases = new Hashtable();
        }
        this._aliases.put(string, string2);
    }

    public String lookupPrefixAlias(String string) {
        if (this._aliases == null) {
            return null;
        }
        return (String)this._aliases.get(string);
    }

    public void excludeURI(String string) {
        Integer n;
        if (string == null) {
            return;
        }
        if (this._excludedURI == null) {
            this._excludedURI = new Hashtable();
        }
        n = (n = (Integer)this._excludedURI.get(string)) == null ? new Integer(1) : new Integer(n + 1);
        this._excludedURI.put(string, n);
    }

    public void excludeNamespaces(String string) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                String string3 = string2.equals("#default") ? this.lookupNamespace("") : this.lookupNamespace(string2);
                if (string3 == null) continue;
                this.excludeURI(string3);
            }
        }
    }

    public boolean isExcludedNamespace(String string) {
        if (string != null && this._excludedURI != null) {
            Integer n = (Integer)this._excludedURI.get(string);
            return n != null && n > 0;
        }
        return false;
    }

    public void unExcludeNamespaces(String string) {
        if (this._excludedURI == null) {
            return;
        }
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                String string3 = string2.equals("#default") ? this.lookupNamespace("") : this.lookupNamespace(string2);
                Integer n = (Integer)this._excludedURI.get(string3);
                if (n == null) continue;
                this._excludedURI.put(string3, new Integer(n - 1));
            }
        }
    }
}

