/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import sun.font.Font2D;
import sun.font.FontManager;
import sun.font.FontStrike;
import sun.font.StrikeMetrics;

public final class FontDesignMetrics
extends FontMetrics {
    static final long serialVersionUID = 4480069578560887773L;
    private static final float UNKNOWN_WIDTH = -1.0f;
    private static final int CURRENT_VERSION = 1;
    private static float roundingUpValue = 0.95f;
    private Font font;
    private float ascent;
    private float descent;
    private float leading;
    private float maxAdvance;
    private double[] matrix;
    private int[] cache;
    private int serVersion = 0;
    private boolean isAntiAliased;
    private boolean usesFractionalMetrics;
    private AffineTransform frcTx;
    private transient float[] advCache;
    private transient int height = -1;
    private transient FontRenderContext frc;
    private transient double[] devmatrix = null;
    private transient FontStrike fontStrike;
    private static FontRenderContext DEFAULT_FRC = null;

    private static FontRenderContext createDefaultFrc() {
        if (DEFAULT_FRC == null) {
            AffineTransform affineTransform = GraphicsEnvironment.isHeadless() ? new AffineTransform() : GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getDefaultTransform();
            DEFAULT_FRC = new FontRenderContext(affineTransform, false, false);
        }
        return DEFAULT_FRC;
    }

    public FontDesignMetrics(Font font) {
        this(font, FontDesignMetrics.createDefaultFrc());
    }

    public FontDesignMetrics(Font font, FontRenderContext fontRenderContext) {
        super(font);
        this.font = font;
        this.frc = fontRenderContext;
        this.isAntiAliased = fontRenderContext.isAntiAliased();
        this.usesFractionalMetrics = fontRenderContext.usesFractionalMetrics();
        this.frcTx = fontRenderContext.getTransform();
        this.matrix = new double[4];
        this.initMatrixAndMetrics();
        this.initAdvCache();
    }

    private void initMatrixAndMetrics() {
        Font2D font2D = FontManager.getFont2D(this.font);
        this.fontStrike = font2D.getStrike(this.font, this.frc);
        StrikeMetrics strikeMetrics = this.fontStrike.getFontMetrics();
        this.ascent = strikeMetrics.getAscent();
        this.descent = strikeMetrics.getDescent();
        this.leading = strikeMetrics.getLeading();
        this.maxAdvance = strikeMetrics.getMaxAdvance();
        this.devmatrix = new double[4];
        this.frcTx.getMatrix(this.devmatrix);
    }

    private void initAdvCache() {
        this.advCache = new float[256];
        for (int i = 0; i < 256; ++i) {
            this.advCache[i] = -1.0f;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.serVersion != 1) {
            this.frc = FontDesignMetrics.createDefaultFrc();
            this.isAntiAliased = this.frc.isAntiAliased();
            this.usesFractionalMetrics = this.frc.usesFractionalMetrics();
            this.frcTx = this.frc.getTransform();
        } else {
            this.frc = new FontRenderContext(this.frcTx, this.isAntiAliased, this.usesFractionalMetrics);
        }
        this.height = -1;
        this.cache = null;
        this.initMatrixAndMetrics();
        this.initAdvCache();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.cache = new int[256];
        for (int i = 0; i < 256; ++i) {
            this.cache[i] = -1;
        }
        this.serVersion = 1;
        objectOutputStream.defaultWriteObject();
        this.cache = null;
    }

    private float handleCharWidth(int n) {
        return this.fontStrike.getCodePointAdvance(n);
    }

    private float getLatinCharWidth(char c) {
        float f = this.advCache[c];
        if (f == -1.0f) {
            this.advCache[c] = f = this.handleCharWidth(c);
        }
        return f;
    }

    public FontRenderContext getFRC() {
        return this.frc;
    }

    public int charWidth(char c) {
        float f = c < '\u0100' ? this.getLatinCharWidth(c) : this.handleCharWidth(c);
        return (int)(0.5 + (double)f);
    }

    public int charWidth(int n) {
        if (!Character.isValidCodePoint(n)) {
            n = 65535;
        }
        float f = this.handleCharWidth(n);
        return (int)(0.5 + (double)f);
    }

    private boolean requiresLayout(char c) {
        return c >= '\u0590' && c < '\u0e80' || c >= '\u202a' && c < '\u202f' || c >= '\ud800' && c < '\ue000';
    }

    public int stringWidth(String string) {
        int n = string.length();
        float f = 0.0f;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c < '\u0100') {
                f += this.getLatinCharWidth(c);
                continue;
            }
            if (this.requiresLayout(c)) {
                f = new TextLayout(string, this.font, this.frc).getAdvance();
                break;
            }
            f += this.handleCharWidth(c);
        }
        return (int)(0.5 + (double)f);
    }

    public int charsWidth(char[] cArray, int n, int n2) {
        float f = 0.0f;
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            char c = cArray[i];
            if (c < '\u0100') {
                f += this.getLatinCharWidth(c);
                continue;
            }
            if (this.requiresLayout(c)) {
                String string = new String(cArray, n, n2);
                f = new TextLayout(string, this.font, this.frc).getAdvance();
                break;
            }
            f += this.handleCharWidth(c);
        }
        return (int)(0.5 + (double)f);
    }

    public int[] getWidths() {
        int[] nArray = new int[256];
        for (int n = 0; n < 256; n = (int)((char)(n + 1))) {
            float f = this.advCache[n];
            if (f == -1.0f) {
                f = this.advCache[n] = this.handleCharWidth(n);
            }
            nArray[n] = (int)(0.5 + (double)f);
        }
        return nArray;
    }

    public int getMaxAdvance() {
        return (int)(0.99f + this.maxAdvance);
    }

    public int getAscent() {
        return (int)(roundingUpValue + this.ascent);
    }

    public int getDescent() {
        return (int)(roundingUpValue + this.descent);
    }

    public int getLeading() {
        return (int)(roundingUpValue + this.descent + this.leading) - (int)(roundingUpValue + this.descent);
    }

    public int getHeight() {
        if (this.height < 0) {
            this.height = this.getAscent() + (int)(roundingUpValue + this.descent + this.leading);
        }
        return this.height;
    }
}

