/*
 * Decompiled with CFR 0.152.
 */
package CoreFS.SA02;

import CoreFS.SC01.CoreConstantData;
import Ice.Communicator;
import Ice.InitializationData;
import Ice.LocalException;
import Ice.ObjectPrx;
import Ice.Properties;
import Ice.Util;
import SA02.CoreIceServicePrx;
import SA02.CoreIceServicePrxHelper;

public class CoreIceClient {
    public int SendMessage(String IP, byte[] message) {
        int status = 0;
        Communicator ic = null;
        try {
            String ipStr = "SimplePrinter:tcp -h " + IP + " -p " + CoreConstantData.clientPort;
            Properties properties = Util.createProperties();
            properties.setProperty("Ice.MessageSizeMax", CoreConstantData.messageSizeMax);
            InitializationData id = new InitializationData();
            id.properties = properties;
            ic = Util.initialize((InitializationData)id);
            ObjectPrx base = ic.stringToProxy(ipStr).ice_twoway().ice_timeout(10000).ice_secure(false);
            CoreIceServicePrx iceService = CoreIceServicePrxHelper.checkedCast(base);
            if (iceService == null) {
                throw new Error("Invalid proxy");
            }
            iceService.RunIceGangway(message);
        }
        catch (LocalException e) {
            System.err.println("IP\u4e3a " + IP + " \u7684\u5ba2\u6237\u7aef\u8fde\u63a5\u5df2\u65ad\u5f00");
            status = 1;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            status = 1;
        }
        if (ic != null) {
            try {
                ic.destroy();
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                status = 1;
            }
        }
        return status;
    }
}

