/*
 * Decompiled with CFR 0.152.
 */
package CoreFS.SA02;

import CoreFS.SA01.CoreException;
import CoreFS.SA06.CoreParamObject;
import CoreFS.SA06.CoreReturnObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CoreMuleServer {
    protected final Log log = LogFactory.getLog(this.getClass());

    public Object RunMule(CoreParamObject ctx) {
        CoreReturnObject rtnContext = new CoreReturnObject();
        Object message = null;
        boolean isover = false;
        String overDate = "2010-01-01";
        SimpleDateFormat tempDate = new SimpleDateFormat("yyyy-MM-dd");
        String datetime = tempDate.format(new Date());
        Date od = null;
        try {
            od = tempDate.parse(overDate);
        }
        catch (ParseException e2) {
            this.log.error((Object)e2.getMessage());
        }
        if (!isover) {
            String className = ctx.v_serviceName;
            String methodName = ctx.v_method;
            Object[] strParms = ctx.v_reqParameters;
            this.log.info((Object)("className--> " + className + " method-->" + methodName));
            Object instance = null;
            Method method = null;
            Object errmsg = null;
            try {
                if (this.isSupport(className)) {
                    instance = Class.forName(className).newInstance();
                }
                Class[] types = null;
                if (strParms != null) {
                    int len = strParms.length;
                    types = new Class[len];
                    int i = 0;
                    while (i < len) {
                        types[i] = strParms[i] == null ? Object.class : strParms[i].getClass();
                        ++i;
                    }
                }
                method = instance.getClass().getMethod(methodName, types);
                rtnContext = (CoreReturnObject)method.invoke(instance, strParms);
            }
            catch (CoreException ce) {
                rtnContext = rtnContext.SetErrInfo(ce.getMessage());
            }
            catch (Exception e) {
                Throwable t = null;
                if (e instanceof InvocationTargetException) {
                    InvocationTargetException targetEx = (InvocationTargetException)e;
                    t = targetEx.getTargetException();
                    rtnContext = rtnContext.SetErrInfo(t.getMessage());
                }
                rtnContext = rtnContext.SetErrInfo(e.getMessage());
            }
        }
        this.log.info((Object)("result-->\n" + (rtnContext.getResult() == null ? "" : "SUCCESS")));
        rtnContext.setClientIp(ctx.getV_ip());
        rtnContext.setV_formkey(ctx.getV_formkey());
        return rtnContext;
    }

    private boolean isSupport(String classname) {
        try {
            Class.forName(classname).newInstance();
            return true;
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
            return false;
        }
    }
}

