/*
 * Decompiled with CFR 0.152.
 */
package CoreFS.SA04;

import CoreBpm.Utility.Data.DataObject;
import CoreBpm.Utility.Data.DataObjectCollection;
import CoreFS.SA01.CoreException;
import CoreFS.SA01.CoreExceptionHandler;
import CoreFS.SA04.CoreDBProxy;
import CoreFS.SA04.ICallBack;
import CoreFS.SA06.CorePageObject;
import CoreFS.SA06.CoreReturnObject;
import CoreFS.SA06.CoreReturnSortObject;
import CoreFS.SA06.CoreSqlType;
import CoreFS.SC01.StoreFactory;
import CoreFS.Util.StringUtils;
import com.ibm.websphere.rsadapter.WSCallHelper;
import com.ibm.ws.rsadapter.jdbc.WSJdbcConnection;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.jdbc.OracleConnection;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreDBManager {
    private static final long serialVersionUID = -986600646149636690L;
    protected final Log log = LogFactory.getLog(this.getClass());
    public CoreDBProxy dbProxy;

    public CoreDBManager() {
    }

    public CoreDBManager(CoreDBProxy dbproxy) {
        this.dbProxy = dbproxy;
    }

    public Connection getConnection() {
        Connection conn = null;
        try {
            conn = this.dbProxy.getJdbcTemplate().getDataSource().getConnection();
            this.log.info((Object)("\u8fde\u63a5\u6570\u636e\u5e93\u6210\u529f\uff01conn= " + conn));
        }
        catch (SQLException e) {
            throw new CoreException("\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25 \u8bf7\u68c0\u67e5\u7f51\u7edc\u6216\u6570\u636e\u5e93\u914d\u7f6e\u6587\u4ef6...");
        }
        return conn;
    }

    public CoreReturnObject ExcuteQuery(String sql) {
        return this.ExcuteQuery(sql, null);
    }

    public CoreReturnObject ExcuteQuery(String sql, Object[] args) {
        long time = System.currentTimeMillis();
        Date begintime = new Date(time);
        long btime = System.nanoTime();
        List rsls = new ArrayList();
        this.getPreparedSQL(sql, args);
        CoreReturnObject cro = new CoreReturnObject();
        rsls = this.dbProxy.getJdbcTemplate().queryForList(sql, args);
        long time1 = System.currentTimeMillis();
        long etime = System.nanoTime();
        Date endtime = new Date(time1);
        StoreFactory.getStore().AddSql(sql, begintime, endtime, etime - btime);
        cro.setResult(rsls);
        return cro;
    }

    public CoreReturnObject ExcuteSortResultByQuery(String sql) {
        return this.ExcuteSortResultByQuery(sql, null);
    }

    public CoreReturnObject ExcuteSortResultByQuery(String sql, Object[] args) {
        CoreReturnSortObject crso;
        block21: {
            crso = new CoreReturnSortObject();
            PreparedStatement prepStatement = null;
            Connection conn = null;
            ResultSet rs = null;
            try {
                try {
                    conn = this.getConnection();
                    prepStatement = conn.prepareStatement(sql);
                    String sqlstr = sql;
                    if (args != null) {
                        int i = 1;
                        Object[] objectArray = args;
                        int n = args.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object param = objectArray[n2];
                            if (param instanceof Integer) {
                                int value = (Integer)param;
                                prepStatement.setInt(i, value);
                            } else if (param instanceof String) {
                                String s = (String)param;
                                prepStatement.setString(i, s);
                            } else if (param instanceof Double) {
                                double d = (Double)param;
                                prepStatement.setDouble(i, d);
                            } else if (param instanceof Float) {
                                float f = ((Float)param).floatValue();
                                prepStatement.setFloat(i, f);
                            } else if (param instanceof Long) {
                                long l = (Long)param;
                                prepStatement.setLong(i, l);
                            } else if (param instanceof Boolean) {
                                boolean b = (Boolean)param;
                                prepStatement.setBoolean(i, b);
                            } else if (param instanceof Date) {
                                Date d = (Date)param;
                                prepStatement.setDate(i, (Date)param);
                            }
                            ++i;
                            ++n2;
                        }
                    }
                    rs = prepStatement.executeQuery();
                    ResultSetMetaData rsmd = rs.getMetaData();
                    String[] col = new String[rsmd.getColumnCount()];
                    int i = 0;
                    while (i < rsmd.getColumnCount()) {
                        col[i] = rsmd.getColumnName(i + 1);
                        ++i;
                    }
                    crso.setColIdx(col);
                }
                catch (SQLException e) {
                    this.log.error((Object)e.getMessage());
                    this.close(conn, prepStatement, rs);
                    break block21;
                }
            }
            catch (Throwable throwable) {
                this.close(conn, prepStatement, rs);
                throw throwable;
            }
            this.close(conn, prepStatement, rs);
        }
        List rsls = new ArrayList();
        CoreReturnObject cro = new CoreReturnObject();
        this.getPreparedSQL(sql, args);
        rsls = this.dbProxy.getJdbcTemplate().queryForList(sql, args);
        crso.setResult(rsls);
        cro.setResult(crso);
        return cro;
    }

    public CoreReturnObject ExcuteSortResultByQueryForCoreMes2(String sql, Object[] args) {
        CoreReturnSortObject crso;
        block21: {
            crso = new CoreReturnSortObject();
            PreparedStatement prepStatement = null;
            Connection conn = null;
            ResultSet rs = null;
            try {
                try {
                    conn = this.getConnection();
                    prepStatement = conn.prepareStatement(sql);
                    String sqlstr = sql;
                    if (args != null) {
                        int i = 1;
                        Object[] objectArray = args;
                        int n = args.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object param = objectArray[n2];
                            if (param instanceof Integer) {
                                int value = (Integer)param;
                                prepStatement.setInt(i, value);
                            } else if (param instanceof String) {
                                String s = (String)param;
                                prepStatement.setString(i, s);
                            } else if (param instanceof Double) {
                                double d = (Double)param;
                                prepStatement.setDouble(i, d);
                            } else if (param instanceof Float) {
                                float f = ((Float)param).floatValue();
                                prepStatement.setFloat(i, f);
                            } else if (param instanceof Long) {
                                long l = (Long)param;
                                prepStatement.setLong(i, l);
                            } else if (param instanceof Boolean) {
                                boolean b = (Boolean)param;
                                prepStatement.setBoolean(i, b);
                            } else if (param instanceof Date) {
                                Date d = (Date)param;
                                prepStatement.setDate(i, (Date)param);
                            }
                            ++i;
                            ++n2;
                        }
                    }
                    rs = prepStatement.executeQuery();
                    ResultSetMetaData rsmd = rs.getMetaData();
                    String[] col = new String[rsmd.getColumnCount()];
                    String[] coldt = new String[rsmd.getColumnCount()];
                    int i = 0;
                    while (i < rsmd.getColumnCount()) {
                        col[i] = rsmd.getColumnName(i + 1);
                        coldt[i] = rsmd.getColumnTypeName(i + 1);
                        ++i;
                    }
                    crso.setColIdx(col);
                }
                catch (SQLException e) {
                    this.log.error((Object)e.getMessage());
                    this.close(conn, prepStatement, rs);
                    break block21;
                }
            }
            catch (Throwable throwable) {
                this.close(conn, prepStatement, rs);
                throw throwable;
            }
            this.close(conn, prepStatement, rs);
        }
        List rsls = new ArrayList();
        CoreReturnObject cro = new CoreReturnObject();
        this.getPreparedSQL(sql, args);
        rsls = this.dbProxy.getJdbcTemplate().queryForList(sql, args);
        crso.setResult(rsls);
        cro.setResult(crso);
        return cro;
    }

    public List ExcuteQueryReturnList(String sql, Object[] args) throws SQLException {
        List rsls = new ArrayList();
        long time = System.currentTimeMillis();
        Date begintime = new Date(time);
        long btime = System.nanoTime();
        rsls = this.dbProxy.getJdbcTemplate().queryForList(sql, args);
        long etime = System.nanoTime();
        long time1 = System.currentTimeMillis();
        Date endtime = new Date(time1);
        StoreFactory.getStore().AddSql(sql, begintime, endtime, etime - btime);
        return rsls;
    }

    public CoreReturnObject ExcuteQueryById(String sqlid) throws SQLException {
        HashMap<String, ArrayList> args = new HashMap<String, ArrayList>();
        return this.ExcuteQueryById(sqlid, args);
    }

    public CoreReturnObject ExcuteQueryById(String sqlid, HashMap<String, ArrayList> args) throws SQLException {
        List rsls = new ArrayList();
        String sql = "";
        sql = this.getSql(sqlid, args);
        Object[] parm = this.getSqlParmForQuery(sqlid, args);
        CoreReturnObject cro = new CoreReturnObject();
        this.getPreparedSQL(sql, parm);
        rsls = this.dbProxy.getJdbcTemplate().queryForList(sql, parm);
        cro.setResult(rsls);
        return cro;
    }

    public CoreReturnObject ExecutequeryForRowSet(String sql, Object[] args) throws SQLException {
        SqlRowSet srs = null;
        this.PrintSQL(sql, args);
        CoreReturnObject cro = new CoreReturnObject();
        this.getPreparedSQL(sql, args);
        srs = this.dbProxy.getJdbcTemplate().queryForRowSet(sql, args);
        cro.setResult(srs);
        return cro;
    }

    public CoreReturnObject ExecutequeryForRowSet(String sql) throws SQLException {
        return this.ExecutequeryForRowSet(sql, null);
    }

    public int getQueryCount(String sql) {
        return this.getQueryCount(sql, null);
    }

    public int getQueryCount(String sql, Object[] args) {
        return this.dbProxy.getJdbcTemplate().queryForList(sql, args).size();
    }

    public CoreReturnObject ExceuteNonQueryForBlobList(String sql) throws SQLException {
        return this.ExceuteNonQueryForBlobList(sql, null);
    }

    public CoreReturnObject ExceuteNonQueryForBlobList(String sql, Object[] args) throws SQLException {
        CoreReturnObject cro;
        block22: {
            this.PrintSQL(sql, args);
            cro = new CoreReturnObject();
            PreparedStatement stmt = null;
            Connection conn = null;
            try {
                try {
                    conn = this.getConnection();
                    stmt = conn.prepareStatement(sql);
                    if (args != null) {
                        int i = 0;
                        while (i < args.length) {
                            int j = i + 1;
                            if (args[i] != null) {
                                if (args[i] instanceof String) {
                                    if (((String)args[i]).length() < 800) {
                                        stmt.setString(j, (String)args[i]);
                                    } else {
                                        this.dbProxy.getLobHandler().getLobCreator().setClobAsString(stmt, j, (String)args[i]);
                                    }
                                } else if (args[i] instanceof Integer) {
                                    stmt.setInt(i, (Integer)args[i]);
                                } else if (args[i] instanceof Double) {
                                    stmt.setDouble(i, (Double)args[i]);
                                } else if (args[i] instanceof Float) {
                                    stmt.setFloat(i, ((Float)args[i]).floatValue());
                                } else if (args[i] instanceof Date) {
                                    stmt.setDate(i, (Date)args[i]);
                                } else if (args[i] instanceof byte[]) {
                                    this.dbProxy.getLobHandler().getLobCreator().setBlobAsBytes(stmt, j, (byte[])args[i]);
                                }
                            }
                            ++i;
                        }
                    }
                    int count = stmt.executeUpdate();
                    cro.setResult(count);
                }
                catch (SQLException sqlex) {
                    throw sqlex;
                }
                catch (Exception ex) {
                    this.log.error((Object)ex);
                    this.close(conn, stmt, null);
                    break block22;
                }
            }
            catch (Throwable throwable) {
                this.close(conn, stmt, null);
                throw throwable;
            }
            this.close(conn, stmt, null);
        }
        return cro;
    }

    public CoreReturnObject ExceuteQueryForBlobList(String sql, Object[] args) throws SQLException {
        ArrayList ls;
        CoreReturnObject cro;
        block33: {
            cro = new CoreReturnObject();
            this.PrintSQL(sql, args);
            Connection conn = null;
            ls = new ArrayList();
            ResultSet rs = null;
            PreparedStatement stmt = null;
            try {
                try {
                    try {
                        conn = this.dbProxy.getJdbcTemplate().getDataSource().getConnection();
                        this.log.info((Object)("\u8fde\u63a5\u6570\u636e\u5e93\u6210\u529f\uff01 " + conn));
                    }
                    catch (SQLException e) {
                        throw new CoreException("\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25 \u8bf7\u68c0\u67e5\u7f51\u7edc\u6216\u6570\u636e\u5e93\u914d\u7f6e\u6587\u4ef6...");
                    }
                    conn.setAutoCommit(false);
                    stmt = conn.prepareStatement(sql);
                    if (args != null) {
                        int i = 0;
                        while (i < args.length) {
                            int j = i + 1;
                            String ii = args[i].toString();
                            if (args[i] != null) {
                                if (args[i] instanceof String) {
                                    stmt.setString(j, (String)args[i]);
                                } else if (args[i] instanceof Integer) {
                                    stmt.setInt(i, (Integer)args[i]);
                                } else if (args[i] instanceof Double) {
                                    stmt.setDouble(i, (Double)args[i]);
                                } else if (args[i] instanceof Float) {
                                    stmt.setFloat(i, ((Float)args[i]).floatValue());
                                } else if (args[i] instanceof Date) {
                                    stmt.setDate(i, (Date)args[i]);
                                }
                            }
                            ++i;
                        }
                    }
                    rs = stmt.executeQuery();
                    int clumncount = rs.getMetaData().getColumnCount();
                    int columntype = 0;
                    String columnname = "";
                    while (rs.next()) {
                        LinkedHashMap rowmap = new LinkedHashMap();
                        int i = 1;
                        while (i <= clumncount) {
                            HashMap<String, Object> table = new HashMap<String, Object>();
                            columntype = rs.getMetaData().getColumnType(i);
                            columnname = rs.getMetaData().getColumnName(i);
                            switch (columntype) {
                                case 12: {
                                    table.put(columnname, (String)rs.getObject(i));
                                    break;
                                }
                                case 2: {
                                    table.put(columnname, (Number)rs.getObject(i));
                                    break;
                                }
                                case 2004: {
                                    byte[] barry = this.dbProxy.getLobHandler().getBlobAsBytes(rs, i);
                                    if (barry == null) {
                                        table.put(columnname, new byte[0]);
                                        break;
                                    }
                                    table.put(columnname, barry);
                                    break;
                                }
                                case 2005: {
                                    table.put(columnname, this.dbProxy.getLobHandler().getClobAsString(rs, i));
                                    break;
                                }
                                case 4: {
                                    table.put(columnname, (Integer)rs.getObject(i));
                                    break;
                                }
                                case 8: {
                                    table.put(columnname, (Double)rs.getObject(i));
                                    break;
                                }
                                case 6: {
                                    table.put(columnname, (Float)rs.getObject(i));
                                    break;
                                }
                                case 91: {
                                    table.put(columnname, (Date)rs.getObject(i));
                                    break;
                                }
                                default: {
                                    throw new CoreException("\u8d85\u51fa\u5e73\u53f0\u6240\u5b9a\u4e49\u7684\u7c7b\u578b ... ");
                                }
                            }
                            rowmap.putAll(table);
                            ++i;
                        }
                        ls.add(rowmap);
                    }
                }
                catch (SQLException e) {
                    conn.rollback();
                    throw e;
                }
                catch (Exception ex) {
                    this.log.error((Object)ex.getMessage());
                    this.close(conn, stmt, rs);
                    break block33;
                }
            }
            catch (Throwable throwable) {
                this.close(conn, stmt, rs);
                throw throwable;
            }
            this.close(conn, stmt, rs);
        }
        cro.setResult(ls);
        return cro;
    }

    public CoreReturnObject ExceuteQueryForBlobList(String sql) throws SQLException {
        return this.ExceuteQueryForBlobList(sql, null);
    }

    public ResultSet ExceuteQueryForResultSet(String sql, Object[] args) throws SQLException {
        this.PrintSQL(sql, args);
        ResultSet rs = null;
        Statement stmt = null;
        Connection conn = this.getConnection();
        try {
            stmt = conn.createStatement(1005, 1008);
            rs = stmt.executeQuery(sql);
        }
        catch (SQLException e) {
            JdbcUtils.closeConnection((Connection)conn);
            conn = null;
            JdbcUtils.closeStatement((Statement)stmt);
            stmt = null;
            JdbcUtils.closeResultSet((ResultSet)rs);
            rs = null;
            this.log.error((Object)e.getMessage());
        }
        return rs;
    }

    public ResultSet ExceuteQueryForResultSet(String sql) throws SQLException {
        return this.ExceuteQueryForResultSet(sql, null);
    }

    public CoreReturnObject ExcuteNonQuery(String sql) throws SQLException {
        return this.ExcuteNonQuery(sql, null);
    }

    public CoreReturnObject ExcuteNonQuery(String sql, Object[] args) throws SQLException {
        CoreReturnObject cro = new CoreReturnObject();
        int count = 0;
        try {
            this.getPreparedSQL(sql, args);
            count = this.dbProxy.getJdbcTemplate().update(sql, args);
        }
        catch (CoreException ce) {
            cro = CoreExceptionHandler.coreExceptionHandler(ce);
        }
        cro.setResult(count);
        return cro;
    }

    public CoreReturnObject ExcuteNonQueryById(String sqlid) throws SQLException {
        HashMap<String, ArrayList> parm = new HashMap<String, ArrayList>();
        return this.ExcuteNonQueryById(sqlid, parm);
    }

    public CoreReturnObject ExcuteNonQueryById(String sqlid, HashMap<String, ArrayList> args) throws SQLException {
        CoreReturnObject cro = new CoreReturnObject();
        String sql = "";
        sql = this.getSql(sqlid, args);
        Object[] parm = this.getSqlParm(sqlid, args);
        this.PrintSQL(sql, parm);
        int count = 0;
        try {
            count = this.dbProxy.getJdbcTemplate().update(sql, parm);
        }
        catch (CoreException ce) {
            cro = CoreExceptionHandler.coreExceptionHandler(ce);
        }
        catch (Exception e) {
            cro = CoreExceptionHandler.exceptionHandler(e);
        }
        cro.setResult(count);
        return cro;
    }

    public CallableStatement getCallableStatement(String s) {
        CallableStatement callablestatement = null;
        try {
            callablestatement = this.getConnection().prepareCall(s);
        }
        catch (Exception e) {
            try {
                throw new Exception("Can not create CallableStatement!! SQL [" + s + "]", e);
            }
            catch (Exception ex) {
                try {
                    callablestatement.getConnection().close();
                    callablestatement.close();
                }
                catch (SQLException e1) {
                    this.log.error((Object)e1.getMessage());
                }
                callablestatement = null;
                this.log.error((Object)ex.getMessage());
            }
        }
        return callablestatement;
    }

    public CoreReturnObject ExcuteProcedure(String name) throws SQLException {
        ArrayList temp = new ArrayList();
        return this.ExcuteProcedure(name, temp, temp, temp, temp, temp);
    }

    public CoreReturnObject ExcuteProcedure(String name, ArrayList sqltypes, ArrayList sqlparams) throws SQLException {
        ArrayList temp = new ArrayList();
        return this.ExcuteProcedure(name, sqltypes, sqlparams, temp, temp, null);
    }

    public CoreReturnObject ExcuteProcedure(String name, ArrayList sqltypes, ArrayList sqlparams, ArrayList outSqltypes, ArrayList outparm) throws SQLException {
        return this.ExcuteProcedure(name, sqltypes, sqlparams, outSqltypes, outparm, null);
    }

    public CoreReturnObject ExcuteProcedure(String name, ArrayList sqltypes, ArrayList sqlparams, ArrayList outSqltypes, ArrayList outparm, ArrayList cusTypeDB) throws SQLException {
        CoreReturnObject cro;
        block9: {
            cro = new CoreReturnObject();
            int len = sqltypes.size() + outSqltypes.size();
            String query = "";
            int i = 0;
            while (i < len) {
                query = i == len - 1 ? String.valueOf(query) + "?" : String.valueOf(query) + "?,";
                ++i;
            }
            String sname = "";
            sname = query.equals("") ? "{call " + name + "}" : "{call " + name + "(" + query + ")}";
            CallableStatement cstmt = null;
            Connection conn = null;
            try {
                try {
                    try {
                        conn = this.dbProxy.getJdbcTemplate().getDataSource().getConnection();
                        this.log.info((Object)("\u8fde\u63a5\u6570\u636e\u5e93\u6210\u529f\uff01 " + conn));
                    }
                    catch (SQLException e) {
                        conn = null;
                        throw new CoreException("\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25 \u8bf7\u68c0\u67e5\u7f51\u7edc\u6216\u6570\u636e\u5e93\u914d\u7f6e\u6587\u4ef6...");
                    }
                    cstmt = conn.prepareCall(sname);
                    cro = this.setbatch(sqltypes, sqlparams, cstmt, outSqltypes, outparm, cusTypeDB);
                }
                catch (SQLException se) {
                    throw se;
                }
                catch (Exception ex) {
                    this.log.error((Object)ex);
                    System.err.print(ex.getMessage());
                    cro = cro.SetErrInfo(ex.getMessage());
                    this.close(conn, cstmt, null);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                this.close(conn, cstmt, null);
                throw throwable;
            }
            this.close(conn, cstmt, null);
        }
        return cro;
    }

    public CoreReturnObject ExcuteProcedure(String name, String[] inparams, String[] outparams) throws SQLException {
        CoreReturnObject cro;
        block12: {
            cro = new CoreReturnObject();
            CallableStatement cstmt = null;
            Connection conn = null;
            try {
                try {
                    try {
                        conn = this.dbProxy.getJdbcTemplate().getDataSource().getConnection();
                        this.log.info((Object)("\u8fde\u63a5\u6570\u636e\u5e93\u6210\u529f\uff01 " + conn));
                    }
                    catch (SQLException e) {
                        conn = null;
                        throw new CoreException("\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25 \u8bf7\u68c0\u67e5\u7f51\u7edc\u6216\u6570\u636e\u5e93\u914d\u7f6e\u6587\u4ef6...");
                    }
                    cstmt = conn.prepareCall(name);
                    if (cstmt != null) {
                        int i = 0;
                        while (i < inparams.length) {
                            cstmt.setString(i + 1, inparams[i]);
                            ++i;
                        }
                        i = 0;
                        int j = inparams.length + 1;
                        while (i < outparams.length) {
                            cstmt.registerOutParameter(j, 12);
                            ++i;
                            ++j;
                        }
                        cstmt.execute();
                        ArrayList<String> outls = new ArrayList<String>();
                        int i2 = 0;
                        int j2 = inparams.length + 1;
                        while (i2 < outparams.length) {
                            outparams[i2] = cstmt.getString(j2);
                            outls.add(outparams[i2]);
                            ++i2;
                            ++j2;
                        }
                        cro.setResult(outls);
                    }
                }
                catch (SQLException se) {
                    throw se;
                }
                catch (Exception e) {
                    this.log.error((Object)e);
                    System.err.print(e.getMessage());
                    cro = cro.SetErrInfo(e.getMessage());
                    this.close(conn, cstmt, null);
                    break block12;
                }
            }
            catch (Throwable throwable) {
                this.close(conn, cstmt, null);
                throw throwable;
            }
            this.close(conn, cstmt, null);
        }
        return cro;
    }

    public PreparedStatement getPreparedStatement(String sql) {
        Statement pstmt = null;
        Connection conn = null;
        try {
            conn = this.getConnection();
            pstmt = conn.prepareStatement(sql);
        }
        catch (SQLException e) {
            try {
                pstmt.close();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            conn = null;
            this.log.error((Object)e.getMessage());
        }
        return pstmt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CoreReturnObject setbatch(ArrayList lts, ArrayList lps, CallableStatement cstmt) {
        CoreReturnObject cro = new CoreReturnObject();
        try {
            try {
                if (cstmt == null) return cro;
                ArrayList<String> outMsgList = new ArrayList<String>();
                Object obj = null;
                int outbegin = 0;
                boolean cnt_out_begin = false;
                int i = 0;
                while (i < lts.size()) {
                    int j = i + 1;
                    CoreSqlType.CoreOracleType m = (CoreSqlType.CoreOracleType)((Object)lts.get(i));
                    obj = lps.get(i);
                    if (m == CoreSqlType.CoreOracleType.STRING_TYPE) {
                        cstmt.setString(j, (String)obj);
                    } else if (m == CoreSqlType.CoreOracleType.INTEGER_TYPE) {
                        cstmt.setInt(j, (int)obj);
                    } else if (m == CoreSqlType.CoreOracleType.FLOAT_TYPE) {
                        cstmt.setFloat(j, ((Float)obj).floatValue());
                    } else if (m == CoreSqlType.CoreOracleType.DOUBLE_TYPE) {
                        cstmt.setDouble(j, (double)obj);
                    } else if (m == CoreSqlType.CoreOracleType.DATE_TYPE) {
                        cstmt.setDate(j, (Date)obj);
                    } else if (m == CoreSqlType.CoreOracleType.TIME_TYPE) {
                        cstmt.setTime(j, (Time)obj);
                    } else if (m == CoreSqlType.CoreOracleType.TIMESTAMP_TYPE) {
                        cstmt.setTimestamp(j, (Timestamp)obj);
                    } else if (m == CoreSqlType.CoreOracleType.BLOB_TYPE) {
                        this.dbProxy.getLobHandler().getLobCreator().setBlobAsBytes((PreparedStatement)cstmt, j, (byte[])obj);
                    } else if (m == CoreSqlType.CoreOracleType.CLOB_TYPE) {
                        this.dbProxy.getLobHandler().getLobCreator().setClobAsString((PreparedStatement)cstmt, j, (String)obj);
                    } else if (m == CoreSqlType.CoreOracleType.BOOLEAN_TYPE) {
                        cstmt.setBoolean(j, (boolean)obj);
                    } else if (m == CoreSqlType.CoreOracleType.BYTES_TYPE) {
                        this.dbProxy.getLobHandler().getLobCreator().setBlobAsBytes((PreparedStatement)cstmt, j, (byte[])obj);
                    }
                    ++i;
                }
                cstmt.execute();
                int j = outbegin;
                while (outbegin <= lts.size()) {
                    outMsgList.add(cstmt.getString(j));
                    ++outbegin;
                }
                cro.setResult(outMsgList);
                return cro;
            }
            catch (CoreException ce) {
                cro = CoreExceptionHandler.coreExceptionHandler(ce);
                if (cstmt == null) return cro;
                try {
                    this.close(cstmt.getConnection(), cstmt, null);
                    return cro;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                return cro;
            }
            catch (Exception e) {
                cro = CoreExceptionHandler.exceptionHandler(e);
                if (cstmt == null) return cro;
                try {
                    this.close(cstmt.getConnection(), cstmt, null);
                    return cro;
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
                return cro;
            }
        }
        finally {
            if (cstmt != null) {
                try {
                    this.close(cstmt.getConnection(), cstmt, null);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private CoreReturnObject setbatch(ArrayList lts, ArrayList lps, CallableStatement cstmt, ArrayList outparm, ArrayList outty, ArrayList cusTypeDB) throws Exception {
        CoreReturnObject cro = new CoreReturnObject();
        try {
            if (cstmt != null) {
                int m;
                Object obj = null;
                boolean outbegin = false;
                boolean cnt_out_begin = false;
                int i = 0;
                while (i < lts.size()) {
                    int j = i + 1;
                    m = Integer.parseInt(lts.get(i).toString());
                    obj = lps.get(i);
                    if (m == CoreSqlType.CoreOracleType.STRING_TYPE.ordinal()) {
                        cstmt.setString(j, (String)obj);
                    } else if (m == CoreSqlType.CoreOracleType.INTEGER_TYPE.ordinal()) {
                        cstmt.setInt(j, (int)obj);
                    } else if (m == CoreSqlType.CoreOracleType.FLOAT_TYPE.ordinal()) {
                        cstmt.setFloat(j, ((Float)obj).floatValue());
                    } else if (m == CoreSqlType.CoreOracleType.DOUBLE_TYPE.ordinal()) {
                        cstmt.setDouble(j, (double)obj);
                    } else if (m == CoreSqlType.CoreOracleType.DATE_TYPE.ordinal()) {
                        cstmt.setDate(j, (Date)obj);
                    } else if (m == CoreSqlType.CoreOracleType.TIME_TYPE.ordinal()) {
                        cstmt.setTime(j, (Time)obj);
                    } else if (m == CoreSqlType.CoreOracleType.TIMESTAMP_TYPE.ordinal()) {
                        cstmt.setTimestamp(j, (Timestamp)obj);
                    } else if (m == CoreSqlType.CoreOracleType.BLOB_TYPE.ordinal()) {
                        this.dbProxy.getLobHandler().getLobCreator().setBlobAsBytes((PreparedStatement)cstmt, j, (byte[])obj);
                    } else if (m == CoreSqlType.CoreOracleType.CLOB_TYPE.ordinal()) {
                        this.dbProxy.getLobHandler().getLobCreator().setClobAsString((PreparedStatement)cstmt, j, (String)obj);
                    } else if (m == CoreSqlType.CoreOracleType.BOOLEAN_TYPE.ordinal()) {
                        cstmt.setBoolean(j, (boolean)obj);
                    } else if (m == CoreSqlType.CoreOracleType.BYTES_TYPE.ordinal()) {
                        this.dbProxy.getLobHandler().getLobCreator().setBlobAsBytes((PreparedStatement)cstmt, j, (byte[])obj);
                    } else if (m == CoreSqlType.CoreOracleType.ARRAY_TYPE.ordinal()) {
                        cstmt.setArray(j, obj);
                    }
                    ++i;
                }
                int k = 0;
                int i2 = 0;
                int j = lts.size() + 1;
                while (i2 < outparm.size()) {
                    m = Integer.parseInt(outparm.get(i2).toString());
                    if (m == CoreSqlType.CoreOracleType.STRING_TYPE.ordinal()) {
                        cstmt.registerOutParameter(j, 12);
                    } else if (m == CoreSqlType.CoreOracleType.INTEGER_TYPE.ordinal()) {
                        cstmt.registerOutParameter(j, 4);
                    } else if (m == CoreSqlType.CoreOracleType.FLOAT_TYPE.ordinal()) {
                        cstmt.registerOutParameter(j, 6);
                    } else if (m == CoreSqlType.CoreOracleType.DOUBLE_TYPE.ordinal()) {
                        cstmt.registerOutParameter(j, 8);
                    } else if (m == CoreSqlType.CoreOracleType.DATE_TYPE.ordinal()) {
                        cstmt.registerOutParameter(j, 91);
                    } else if (m == CoreSqlType.CoreOracleType.TIME_TYPE.ordinal()) {
                        cstmt.registerOutParameter(j, 92);
                    } else if (m == CoreSqlType.CoreOracleType.TIMESTAMP_TYPE.ordinal()) {
                        cstmt.registerOutParameter(j, 93);
                    } else if (m == CoreSqlType.CoreOracleType.BLOB_TYPE.ordinal()) {
                        cstmt.registerOutParameter(j, 2004);
                    } else if (m == CoreSqlType.CoreOracleType.CLOB_TYPE.ordinal()) {
                        cstmt.registerOutParameter(j, 2005);
                    } else if (m == CoreSqlType.CoreOracleType.BOOLEAN_TYPE.ordinal()) {
                        cstmt.registerOutParameter(j, 16);
                    } else if (m == CoreSqlType.CoreOracleType.ARRAY_TYPE.ordinal()) {
                        String dtype = (String)cusTypeDB.get(k);
                        cstmt.registerOutParameter(j, 2003, dtype.toUpperCase());
                        ++k;
                    } else if (m == CoreSqlType.CoreOracleType.CURSOR_TYPE.ordinal()) {
                        cstmt.registerOutParameter(j, -10);
                    }
                    ++i2;
                    ++j;
                }
                cstmt.execute();
                i2 = 0;
                j = lts.size() + 1;
                while (i2 < outparm.size()) {
                    m = Integer.parseInt(outparm.get(i2).toString());
                    if (m == CoreSqlType.CoreOracleType.STRING_TYPE.ordinal()) {
                        outty.add(cstmt.getString(j));
                    } else if (m == CoreSqlType.CoreOracleType.INTEGER_TYPE.ordinal()) {
                        outty.add(cstmt.getInt(j));
                    } else if (m == CoreSqlType.CoreOracleType.FLOAT_TYPE.ordinal()) {
                        outty.add(Float.valueOf(cstmt.getFloat(j)));
                    } else if (m == CoreSqlType.CoreOracleType.DOUBLE_TYPE.ordinal()) {
                        outty.add(cstmt.getDouble(j));
                    } else if (m == CoreSqlType.CoreOracleType.DATE_TYPE.ordinal()) {
                        outty.add(cstmt.getDate(j));
                    } else if (m == CoreSqlType.CoreOracleType.TIME_TYPE.ordinal()) {
                        outty.add(cstmt.getTime(j));
                    } else if (m == CoreSqlType.CoreOracleType.TIMESTAMP_TYPE.ordinal()) {
                        outty.add(cstmt.getTimestamp(j));
                    } else if (m == CoreSqlType.CoreOracleType.BLOB_TYPE.ordinal()) {
                        outty.add(cstmt.getBlob(j));
                    } else if (m == CoreSqlType.CoreOracleType.CLOB_TYPE.ordinal()) {
                        outty.add(cstmt.getClob(j));
                    } else if (m == CoreSqlType.CoreOracleType.BOOLEAN_TYPE.ordinal()) {
                        outty.add(cstmt.getBoolean(j));
                    } else if (m == CoreSqlType.CoreOracleType.ARRAY_TYPE.ordinal()) {
                        try {
                            Array simpleArray = cstmt.getArray(j);
                            String[] values = (String[])simpleArray.getArray();
                            outty.add(values);
                        }
                        catch (Exception ex) {
                            outty.add("\u81ea\u5b9a\u4e49\u8f93\u51fa\u7c7b\u578b\u9519\u8bef\uff1a" + ex.getMessage());
                        }
                    } else if (m == CoreSqlType.CoreOracleType.CURSOR_TYPE.ordinal()) {
                        ResultSet rs = (ResultSet)cstmt.getObject(j);
                        List result = this.ConvertRsToList(rs);
                        outty.add(result);
                    }
                    ++i2;
                    ++j;
                }
                cro.setResult(outty);
            }
        }
        catch (CoreException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw e;
        }
        return cro;
    }

    public Array getArray(String Oraclelist, ArrayList objlist) throws SQLException {
        Connection conn = null;
        try {
            conn = this.dbProxy.getJdbcTemplate().getDataSource().getConnection();
            this.log.info((Object)("\u8fde\u63a5\u6570\u636e\u5e93\u6210\u529f\uff01 " + conn));
        }
        catch (SQLException e) {
            conn = null;
            throw new CoreException("\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25 \u8bf7\u68c0\u67e5\u7f51\u7edc\u6216\u6570\u636e\u5e93\u914d\u7f6e\u6587\u4ef6...");
        }
        Object[] parm = objlist.toArray();
        ARRAY list = null;
        try {
            try {
                ArrayDescriptor desc = ArrayDescriptor.createDescriptor((String)Oraclelist.toUpperCase(), (Connection)CoreDBManager.getNativeConnection(conn));
                list = new ARRAY(desc, CoreDBManager.getNativeConnection(conn), (Object)parm);
            }
            catch (Exception ex) {
                System.out.println("\u81ea\u5b9a\u4e49\u6570\u636e\u5e93\u6570\u7ec4\u8f6c\u6362\u5931\u8d25" + ex.getMessage());
                this.close(conn, null, null);
            }
        }
        finally {
            this.close(conn, null, null);
        }
        return list;
    }

    private List ConvertRsToList(ResultSet rs) {
        ArrayList ls = new ArrayList();
        try {
            int clumncount = rs.getMetaData().getColumnCount();
            int columntype = 0;
            String columnname = "";
            while (rs.next()) {
                LinkedHashMap rowmap = new LinkedHashMap();
                int i = 1;
                while (i <= clumncount) {
                    HashMap<String, Object> table = new HashMap<String, Object>();
                    columntype = rs.getMetaData().getColumnType(i);
                    columnname = rs.getMetaData().getColumnName(i);
                    switch (columntype) {
                        case 12: {
                            table.put(columnname, (String)rs.getObject(i));
                            break;
                        }
                        case 2: {
                            table.put(columnname, (Number)rs.getObject(i));
                            break;
                        }
                        case 2004: {
                            byte[] barry = this.dbProxy.getLobHandler().getBlobAsBytes(rs, i);
                            if (barry == null) {
                                table.put(columnname, new byte[0]);
                                break;
                            }
                            table.put(columnname, barry);
                            break;
                        }
                        case 2005: {
                            table.put(columnname, this.dbProxy.getLobHandler().getClobAsString(rs, i));
                            break;
                        }
                        case 4: {
                            table.put(columnname, (Integer)rs.getObject(i));
                            break;
                        }
                        case 8: {
                            table.put(columnname, (Double)rs.getObject(i));
                            break;
                        }
                        case 6: {
                            table.put(columnname, (Float)rs.getObject(i));
                            break;
                        }
                        case 91: {
                            table.put(columnname, (Date)rs.getObject(i));
                            break;
                        }
                        default: {
                            throw new CoreException("\u8d85\u51fa\u5e73\u53f0\u6240\u5b9a\u4e49\u7684\u7c7b\u578b ... ");
                        }
                    }
                    rowmap.putAll(table);
                    ++i;
                }
                ls.add(rowmap);
            }
        }
        catch (Exception es) {
            this.log.error((Object)es.getMessage());
        }
        return ls;
    }

    private static Connection getNativeConnection(Connection con) throws SQLException {
        if (con instanceof DelegatingConnection) {
            Connection nativeCon = ((DelegatingConnection)con).getInnermostDelegate();
            return nativeCon != null ? nativeCon : con.getMetaData().getConnection();
        }
        if (con instanceof WSJdbcConnection) {
            OracleConnection nativeCon = (OracleConnection)WSCallHelper.getNativeConnection((Object)((WSJdbcConnection)con));
            return nativeCon;
        }
        return con;
    }

    private static boolean isSupport(String classname) {
        try {
            System.err.println(classname);
            Class.forName(classname);
            return true;
        }
        catch (Exception e) {
            System.err.println(String.valueOf(classname) + ":" + e.getMessage());
            return false;
        }
    }

    public String LoadXMLFromDB(String sql, String id) throws SQLException {
        Connection conn = null;
        String xml = "";
        ResultSet rs = null;
        PreparedStatement stmt = null;
        try {
            try {
                conn = this.dbProxy.getJdbcTemplate().getDataSource().getConnection();
                this.log.info((Object)("\u8fde\u63a5\u6570\u636e\u5e93\u6210\u529f\uff01 " + conn));
            }
            catch (SQLException e) {
                conn = null;
                throw new CoreException("\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25 \u8bf7\u68c0\u67e5\u7f51\u7edc\u6216\u6570\u636e\u5e93\u914d\u7f6e\u6587\u4ef6...");
            }
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, id);
            rs = stmt.executeQuery();
            while (rs.next()) {
                xml = this.dbProxy.getLobHandler().getClobAsString(rs, 1);
            }
        }
        catch (Throwable throwable) {
            this.close(conn, stmt, rs);
            throw throwable;
        }
        this.close(conn, stmt, rs);
        return xml;
    }

    public String getSql(String SqlId) {
        String selSql = "SELECT CONTENT,TYPE FROM PT4DEV_SQLDATA where ID='" + SqlId + "' AND MID='" + StringUtils.Sysid + "'";
        String sql = "";
        CoreReturnObject cro = new CoreReturnObject();
        try {
            cro = this.ExceuteQueryForBlobList(selSql);
            ArrayList sreuslt = (ArrayList)cro.getResult();
            if (sreuslt.size() == 0) {
                throw new CoreException("\u672a\u627e\u5230SQLID:" + SqlId + "\u5bf9\u5e94\u7684SQL\u8bed\u53e5\uff01\u8bf7\u68c0\u67e5SQLID\u662f\u5426\u6b63\u786e\u3002");
            }
            for (Map rece : sreuslt) {
                byte[] result = (byte[])rece.get("CONTENT");
                sql = new String(result);
            }
        }
        catch (Exception ex) {
            this.log.error((Object)ex.getMessage());
        }
        return sql;
    }

    public String getSql(String SqlId, HashMap<String, ArrayList> parm) {
        String selSql = "SELECT CONTENT,TYPE FROM PT4DEV_SQLDATA where ID='" + SqlId + "' AND MID='" + StringUtils.Sysid + "'";
        String sql = "";
        CoreReturnObject cro = new CoreReturnObject();
        try {
            Object result;
            cro = this.ExceuteQueryForBlobList(selSql);
            ArrayList sreuslt = (ArrayList)cro.getResult();
            if (sreuslt.size() == 0) {
                throw new CoreException("\u672a\u627e\u5230SQLID:" + SqlId + "\u5bf9\u5e94\u7684SQL\u8bed\u53e5\uff01\u8bf7\u68c0\u67e5SQLID\u662f\u5426\u6b63\u786e\u3002");
            }
            for (Map rece : sreuslt) {
                result = (byte[])rece.get("CONTENT");
                sql = new String((byte[])result);
                sql = String.valueOf(sql) + " ";
            }
            String sqlparm = "SELECT NAME FROM PT4DEV_SQLDATA_PARAMETER where PID='" + SqlId + "' AND MID='" + StringUtils.Sysid + "' ORDER BY length(ID),ID";
            result = this.ExcuteQueryReturnList(sqlparm, null);
            if (parm.size() == 0) {
                String pn = "";
                if (result.size() > 0) {
                    pn = ((ListOrderedMap)result.get(result.size() - 1)).get((Object)"NAME").toString();
                }
                String regex1 = "(WHERE[\\w\\W]+" + pn + "[\\w\\W]+?\\?[\\w\\W]*?\\s)";
                sql = CoreDBManager.replacesql(sql, regex1);
            } else {
                Iterator itparm = result.iterator();
                while (itparm.hasNext()) {
                    Map rece = (Map)itparm.next();
                    String pname = (String)rece.get("NAME");
                    if (parm.containsKey(pname)) continue;
                    String regex = "WHERE[\\w\\W]+?([a-zA-Z\\.]*?" + pname + "[\\w\\W]+?\\?[\\w\\W]*?\\sOR\\s*)";
                    sql = CoreDBManager.replacesql(sql, regex);
                    regex = "WHERE[\\w\\W]+?([a-zA-Z\\.]*?" + pname + "[\\w\\W]+?\\?[\\w\\W]*?\\sAND\\s*)";
                    sql = CoreDBManager.replacesql(sql, regex);
                    regex = "WHERE[\\w\\W]+?(\\sAND\\s[a-zA-Z\\.]*?" + pname + "[\\w\\W]+?\\?[\\w\\W]*?)\\s";
                    sql = CoreDBManager.replacesql(sql, regex);
                    regex = "WHERE[\\w\\W]+?(\\sOR\\s[a-zA-Z\\.]*?" + pname + "[\\w\\W]+?\\?[\\w\\W]*?)\\s";
                    sql = CoreDBManager.replacesql(sql, regex);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.log.info((Object)("\u6700\u7ec8\u6267\u884cSQL\u4e3a---" + sql));
        return sql.trim();
    }

    private static String replacesql(String sql, String regex) {
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(sql);
        while (m.find()) {
            sql = sql.replace(m.group(1), "");
        }
        return sql;
    }

    public Object[] getSqlParm(String SqlId, HashMap<String, ArrayList> parms) throws SQLException {
        String selSql = "SELECT NAME FROM PT4DEV_SQLDATA_PARAMETER where PID='" + SqlId + "' AND MID='" + StringUtils.Sysid + "' " + "ORDER BY length(ID),ID";
        List result = this.ExcuteQueryReturnList(selSql, null);
        ArrayList al = new ArrayList();
        block0: for (Map rece : result) {
            String pname = (String)rece.get("NAME");
            for (Map.Entry<String, ArrayList> entry : parms.entrySet()) {
                String vkey = entry.getKey();
                if (!vkey.toLowerCase().equals(pname.toLowerCase())) continue;
                ArrayList objs = parms.get(pname);
                int i = 0;
                while (i < objs.size()) {
                    al.add(objs.get(i));
                    ++i;
                }
                continue block0;
            }
        }
        Object[] obj = new Object[al.size()];
        int i = 0;
        while (i < al.size()) {
            obj[i] = al.get(i);
            ++i;
        }
        return obj;
    }

    public Object[] getSqlParmForQuery(String SqlId, HashMap<String, ArrayList> parms) throws SQLException {
        String selSql = "SELECT NAME,PARADATATYPE FROM PT4DEV_SQLDATA_PARAMETER where PID='" + SqlId + "' AND MID='" + StringUtils.Sysid + "' " + "ORDER BY length(ID),ID";
        List result = this.ExcuteQueryReturnList(selSql, null);
        ArrayList al = new ArrayList();
        for (Map rece : result) {
            String pname = (String)rece.get("NAME");
            if (!parms.containsKey(pname)) continue;
            ArrayList objs = parms.get(pname);
            int i = 0;
            while (i < objs.size()) {
                al.add(objs.get(i));
                ++i;
            }
        }
        Object[] obj = new Object[al.size()];
        int i = 0;
        while (i < al.size()) {
            obj[i] = al.get(i);
            ++i;
        }
        return obj;
    }

    public CoreReturnObject ExcuteCommNonQuery(String SqlId, DataObjectCollection Condition) {
        String selSql = "SELECT CONTENT,TYPE FROM PT4DEV_SQLDATA where ID='" + SqlId + "' AND MID='" + StringUtils.Sysid + "'";
        CoreReturnObject cro = new CoreReturnObject();
        try {
            cro = this.ExceuteQueryForBlobList(selSql);
            ArrayList sreuslt = (ArrayList)cro.getResult();
            if (sreuslt.size() == 0) {
                throw new CoreException("\u672a\u627e\u5230SQLID:" + SqlId + "\u5bf9\u5e94\u7684SQL\u8bed\u53e5\uff01\u8bf7\u68c0\u67e5SQLID\u662f\u5426\u6b63\u786e\u3002");
            }
            Iterator it = sreuslt.iterator();
            String sql = "";
            String Type2 = "";
            while (it.hasNext()) {
                Map rece = (Map)it.next();
                byte[] result = (byte[])rece.get("CONTENT");
                sql = new String(result);
                Type2 = (String)rece.get("TYPE");
            }
            if (Type2.equals("0")) {
                Object[] args = this.getSqlParm(SqlId, Condition);
                this.PrintSQL(sql, args);
                cro = this.ExcuteNonQuery(sql, args);
            } else if (!Type2.equals("1") && Type2.equals("2")) {
                ArrayList para = this.getProcedureParam(SqlId, Condition);
                int size = para.size();
                if (size == 0) {
                    cro = this.ExcuteProcedure(sql);
                } else if (size == 2) {
                    cro = this.ExcuteProcedure(sql, (ArrayList)para.get(0), (ArrayList)para.get(1));
                } else if (size == 3) {
                    ArrayList result = new ArrayList();
                    cro = this.ExcuteProcedure(sql, (ArrayList)para.get(0), (ArrayList)para.get(1), (ArrayList)para.get(2), result);
                }
            }
        }
        catch (SQLException e) {
            cro = cro.SetErrInfo(e.getMessage());
            this.log.error((Object)e);
        }
        return cro;
    }

    public CoreReturnObject ExcuteCommNonQuery(String SqlId, DataObjectCollection Condition, DataObjectCollection Construct) {
        CoreReturnObject cro = new CoreReturnObject();
        String selSql = "SELECT CONTENT,TYPE FROM PT4DEV_SQLDATA where ID='" + SqlId + "' AND MID='" + StringUtils.Sysid + "'";
        try {
            cro = this.ExceuteQueryForBlobList(selSql);
            ArrayList sreuslt = (ArrayList)cro.getResult();
            if (sreuslt.size() == 0) {
                throw new CoreException("\u672a\u627e\u5230SQLID:" + SqlId + "\u5bf9\u5e94\u7684SQL\u8bed\u53e5\uff01\u8bf7\u68c0\u67e5SQLID\u662f\u5426\u6b63\u786e\u3002");
            }
            Iterator it = sreuslt.iterator();
            String sql = "";
            String Type2 = "";
            while (it.hasNext()) {
                Map rece = (Map)it.next();
                byte[] result = (byte[])rece.get("CONTENT");
                sql = new String(result);
                Type2 = (String)rece.get("TYPE");
            }
            ArrayList para = this.getProcedureParam(SqlId, Condition);
            int size = para.size();
            ArrayList<Integer> outType = new ArrayList<Integer>();
            outType.add(CoreSqlType.CoreOracleType.CURSOR_TYPE.ordinal());
            ArrayList result = new ArrayList();
            cro = size == 1 ? this.ExcuteProcedure(sql, result, result, outType, result) : this.ExcuteProcedure(sql, (ArrayList)para.get(0), (ArrayList)para.get(1), outType, result);
            List rs = (List)((List)cro.getResult()).get(0);
            cro = this.setResult(rs, Construct);
        }
        catch (SQLException e) {
            cro = cro.SetErrInfo(e.getMessage());
            this.log.error((Object)e);
        }
        return cro;
    }

    private ArrayList getProcedureParam(String SqlId, DataObjectCollection Condition) throws SQLException {
        String selSql = "SELECT NAME,PARADATATYPE,IOTYPE FROM PT4DEV_SQLDATA_PARAMETER where PID='" + SqlId + "' " + "ORDER BY length(ID),ID";
        List result = this.ExcuteQueryReturnList(selSql, null);
        ArrayList lastResult = new ArrayList();
        ArrayList InParaType = new ArrayList();
        ArrayList<Object> Inpara = new ArrayList<Object>();
        ArrayList OutParaType = new ArrayList();
        for (Map rece : result) {
            String pname = (String)rece.get("NAME");
            String IoType = (String)rece.get("IOTYPE");
            for (DataObject dto : Condition.dbs) {
                if (!dto.Name.toUpperCase().equals(pname.toUpperCase())) continue;
                if (IoType.toUpperCase().equals("input")) {
                    InParaType.add(rece.get("PARADATATYPE"));
                    if (dto.Value.getClass().toString().equals("class java.util.ArrayList")) {
                        ArrayList al = (ArrayList)dto.Value;
                        int k = 0;
                        while (k < al.size()) {
                            Inpara.add(al.get(k));
                            ++k;
                        }
                        continue;
                    }
                    Inpara.add(dto.Value);
                    continue;
                }
                OutParaType.add(rece.get("PARADATATYPE"));
            }
        }
        if (Inpara.size() > 0 && InParaType.size() > 0) {
            lastResult.add(InParaType);
            lastResult.add(Inpara);
        }
        if (OutParaType.size() > 0) {
            lastResult.add(OutParaType);
        }
        return lastResult;
    }

    public CoreReturnObject ExcuteCommQuery(String SqlId, DataObjectCollection Condition, DataObjectCollection Construct) {
        String selSql = "SELECT CONTENT,TYPE FROM PT4DEV_SQLDATA where ID='" + SqlId + "' AND MID='" + StringUtils.Sysid + "'";
        CoreReturnObject cro = new CoreReturnObject();
        try {
            Object result;
            cro = this.ExceuteQueryForBlobList(selSql);
            ArrayList sreuslt = (ArrayList)cro.getResult();
            if (sreuslt.size() == 0) {
                throw new CoreException("\u672a\u627e\u5230SQLID:" + SqlId + "\u5bf9\u5e94\u7684SQL\u8bed\u53e5\uff01\u8bf7\u68c0\u67e5SQLID\u662f\u5426\u6b63\u786e\u3002");
            }
            Iterator it = sreuslt.iterator();
            String sql = "";
            while (it.hasNext()) {
                Map rece = (Map)it.next();
                result = (byte[])rece.get("CONTENT");
                sql = new String((byte[])result);
            }
            Object[] args = this.getSqlParm(SqlId, Condition);
            this.PrintSQL(sql, args);
            this.getPreparedSQL(sql, args);
            result = this.ExcuteQueryReturnList(sql, args);
            if (result.size() > 0) {
                cro = Construct.dbs.size() > 0 ? this.setResult((List)result, Construct) : this.setResult((List)result);
            } else {
                cro.setResult(result);
            }
        }
        catch (SQLException e) {
            cro = cro.SetErrInfo(e.getMessage());
            this.log.error((Object)e);
        }
        return cro;
    }

    private CoreReturnObject setResult(List result) {
        CoreReturnObject cro = new CoreReturnObject();
        try {
            ArrayList<DataObjectCollection> rs = new ArrayList<DataObjectCollection>();
            for (Map rece : result) {
                Iterator itt = rece.entrySet().iterator();
                DataObjectCollection Con = new DataObjectCollection();
                while (itt.hasNext()) {
                    DataObject doo = new DataObject();
                    Map.Entry entry = itt.next();
                    doo.Name = entry.getKey().toString();
                    doo.Value = entry.getValue();
                    Con.dbs.add(doo);
                }
                rs.add(Con);
            }
            cro.setResult(rs);
        }
        catch (Exception ex) {
            throw new CoreException(ex.getMessage());
        }
        return cro;
    }

    private CoreReturnObject setResult(List result, DataObjectCollection Construct) {
        CoreReturnObject cro = new CoreReturnObject();
        try {
            ArrayList<DataObjectCollection> rs = new ArrayList<DataObjectCollection>();
            for (Map rece : result) {
                DataObjectCollection Con = new DataObjectCollection();
                for (DataObject doj : Construct.dbs) {
                    DataObject doo = new DataObject();
                    if (!rece.containsKey(doj.Name)) continue;
                    Object obj = rece.get(doj.Name);
                    doo.Value = obj instanceof BigDecimal ? Double.valueOf(((BigDecimal)obj).doubleValue()) : obj;
                    doo.Name = doj.Name;
                    Con.dbs.add(doo);
                }
                rs.add(Con);
            }
            cro.setResult(rs);
        }
        catch (Exception ex) {
            throw new CoreException(ex.getMessage());
        }
        return cro;
    }

    private Object[] getSqlParm(String SqlId, DataObjectCollection Condition) throws SQLException {
        String selSql = "SELECT NAME FROM PT4DEV_SQLDATA_PARAMETER where PID='" + SqlId + "' AND MID='" + StringUtils.Sysid + "' " + "ORDER BY length(ID),ID";
        List result = this.ExcuteQueryReturnList(selSql, null);
        ArrayList<Object> al = new ArrayList<Object>();
        for (Map rece : result) {
            String pname = (String)rece.get("NAME");
            for (DataObject dto : Condition.dbs) {
                if (!dto.Name.toUpperCase().equals(pname.toUpperCase())) continue;
                if (dto.Value.getClass().toString().equals("class java.util.ArrayList")) {
                    ArrayList par = (ArrayList)dto.Value;
                    int k = 0;
                    while (k < par.size()) {
                        al.add(par.get(k));
                        ++k;
                    }
                    continue;
                }
                al.add(dto.Value);
            }
        }
        Object[] obj = new Object[al.size()];
        int i = 0;
        while (i < al.size()) {
            obj[i] = al.get(i);
            ++i;
        }
        return obj;
    }

    private String getPreparedSQL(String sql, Object[] params) {
        int paramNum = 0;
        if (params != null) {
            paramNum = params.length;
        }
        if (1 > paramNum) {
            this.log.info((Object)("SQL---" + sql));
            return sql;
        }
        StringBuffer returnSQL = new StringBuffer();
        String[] subSQL = sql.split("\\?|:[\\d]+");
        int i = 0;
        while (i < paramNum) {
            try {
                if (params[i] instanceof java.util.Date) {
                    Date dt = new Date(((java.util.Date)params[i]).getDate());
                    SimpleDateFormat tempDate = new SimpleDateFormat("yyyy-MM-dd");
                    String time = tempDate.format((java.util.Date)params[i]);
                    returnSQL.append(subSQL[i]).append(" to_date('").append(time).append("','yyyy/mm/dd HH24:MI:SS')");
                } else {
                    returnSQL.append(subSQL[i]).append(" '").append(params[i]).append("' ");
                }
            }
            catch (Exception ex) {
                this.log.error((Object)("\u6253\u5370SQL\u65f6\u6709\u9519\u8bef\uff1a" + ex.getMessage()));
            }
            ++i;
        }
        if (subSQL.length > params.length) {
            returnSQL.append(subSQL[subSQL.length - 1]);
        }
        this.log.info((Object)("SQL---" + returnSQL.toString()));
        return returnSQL.toString();
    }

    public CoreReturnObject ExcuteTransction(final ArrayList sqllist, final ArrayList<Object[]> parmlist) {
        CoreReturnObject cro = new CoreReturnObject();
        Object result = 0;
        try {
            DataSourceTransactionManager ptm = new DataSourceTransactionManager(this.dbProxy.getDataSource());
            TransactionTemplate tst = new TransactionTemplate((PlatformTransactionManager)ptm);
            result = tst.execute(new TransactionCallback(){

                public Object doInTransaction(TransactionStatus status) {
                    String sql = "";
                    Object[] args = null;
                    int i = 0;
                    while (i < sqllist.size()) {
                        sql = sqllist.get(i).toString();
                        args = (Object[])parmlist.get(i);
                        this.PrintSQL(sql, args);
                        CoreDBManager.this.dbProxy.getJdbcTemplate().update(sql, args);
                        ++i;
                    }
                    return 1;
                }

                private void PrintSQL(String sql, Object[] args) {
                    String parm = "";
                    if (args != null) {
                        parm = "Sql Parameter is\n";
                        int i = 0;
                        while (i < args.length) {
                            parm = String.valueOf(parm) + "paramter[" + i + "]:" + args[i].toString() + "\n";
                            ++i;
                        }
                    }
                    CoreDBManager.this.log.info((Object)("Excute SQL is\n" + sql + "\n" + parm + "------------------------------"));
                }
            });
        }
        catch (Exception ce) {
            this.log.error((Object)ce);
            cro = cro.SetErrInfo("\u4e8b\u52a1\u5904\u7406\u5931\u8d25");
        }
        cro.setResult(result);
        return cro;
    }

    public CoreReturnObject ExcuteTransction(final ArrayList sqllist) {
        CoreReturnObject cro = new CoreReturnObject();
        Object result = 0;
        try {
            DataSourceTransactionManager ptm = new DataSourceTransactionManager(this.dbProxy.getDataSource());
            TransactionTemplate tst = new TransactionTemplate((PlatformTransactionManager)ptm);
            result = tst.execute(new TransactionCallback(){

                public Object doInTransaction(TransactionStatus status) {
                    int i = 0;
                    while (i < sqllist.size()) {
                        CoreDBManager.this.dbProxy.getJdbcTemplate().update(sqllist.get(i).toString());
                        ++i;
                    }
                    return 1;
                }
            });
        }
        catch (Exception ce) {
            this.log.error((Object)ce.getMessage());
            cro = cro.SetErrInfo("\u4e8b\u52a1\u5904\u7406\u5931\u8d25");
        }
        cro.setResult(result);
        return cro;
    }

    public CoreReturnObject ExcuteTransction(final ICallBack callback) {
        CoreReturnObject cro = new CoreReturnObject();
        Integer result = 0;
        DataSourceTransactionManager ptm = new DataSourceTransactionManager(this.dbProxy.getDataSource());
        TransactionTemplate tst = new TransactionTemplate((PlatformTransactionManager)ptm);
        Object sta = null;
        try {
            sta = tst.execute(new TransactionCallback(){

                public Object doInTransaction(TransactionStatus status) {
                    callback.Execute();
                    return status;
                }
            });
        }
        catch (Exception ce) {
            this.log.error((Object)ce.getMessage());
            cro = cro.SetErrInfo("\u4e8b\u52a1\u5904\u7406\u5931\u8d25");
        }
        ptm.rollback((TransactionStatus)sta);
        cro.setResult(result);
        return cro;
    }

    public Map CoreBeginTranscation() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        DataSourceTransactionManager tran = new DataSourceTransactionManager(this.dbProxy.getDataSource());
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(0);
        TransactionStatus status = tran.getTransaction((TransactionDefinition)def);
        result.put("tran", tran);
        result.put("status", status);
        return result;
    }

    public void CoreCommit(Map result) {
        DataSourceTransactionManager tran = (DataSourceTransactionManager)result.get("tran");
        TransactionStatus status = (TransactionStatus)result.get("status");
        tran.commit(status);
    }

    public void CoreRollBack(Map result) {
        DataSourceTransactionManager tran = (DataSourceTransactionManager)result.get("tran");
        TransactionStatus status = (TransactionStatus)result.get("status");
        tran.rollback(status);
    }

    private void PrintSQL(String sql, Object[] paramter) {
        String parm = "";
        if (paramter != null) {
            parm = "Sql Parameter is\n";
            int i = 0;
            while (i < paramter.length) {
                try {
                    parm = String.valueOf(parm) + "paramter[" + i + "]:" + (paramter[i] == null ? "" : paramter[i].toString()) + "\n";
                }
                catch (Exception ex) {
                    this.log.error((Object)ex.getMessage());
                }
                ++i;
            }
        }
        this.log.info((Object)("Excute SQL is\n" + sql + "\n" + parm + "------------------------------"));
    }

    public CoreReturnObject ActiveConnectionNum() {
        CoreReturnObject cro = new CoreReturnObject();
        BasicDataSource ds = (BasicDataSource)this.dbProxy.getJdbcTemplate().getDataSource();
        int Activenum = ds.getNumActive();
        int IdleNum = ds.getNumIdle();
        int MaxActive = ds.getMaxActive();
        int MaxIdle = ds.getMaxIdle();
        int MinIdel = ds.getMinIdle();
        String result = String.valueOf(Activenum) + "," + IdleNum + "," + MaxActive + "," + MaxIdle + "," + MinIdel;
        cro.setResult(result);
        this.log.info((Object)("\n\u8fde\u63a5\u6c60\u4e2d\u6fc0\u6d3b\u7684\u8fde\u63a5\u6570\u4e3a\uff1a" + Activenum + "\n\u5141\u8bb8\u6700\u5927\u5e76\u53d1\u6570\uff1a" + MaxActive + "\n \u6700\u5927\u7b49\u5f85\u6570\uff1a " + MaxIdle + "\n\u6700\u5c0f\u7b49\u5f85\u6570:" + MinIdel + "\n\u7a7a\u95f2\u8fde\u63a5\u6570\uff1a" + IdleNum + "\n"));
        return cro;
    }

    public CoreReturnObject ExcutePageQuery(CorePageObject cpo) {
        Object[] paramter;
        String sql;
        CoreReturnObject cro;
        block25: {
            cro = new CoreReturnObject();
            Statement st = null;
            Connection conn = null;
            sql = cpo.getSql();
            paramter = cpo.getSqlparamter();
            if (cpo.getCurrentPage() == 0) {
                cpo.setCurrentPage(1);
            }
            try {
                try {
                    conn = this.getConnection();
                    st = conn.createStatement();
                    String sqlstr = sql;
                    if (cpo.getSqlparamter() != null) {
                        sqlstr = this.getPreparedSQL(sql, paramter);
                    }
                    ResultSet rs = st.executeQuery(sqlstr);
                    ResultSetMetaData rsmd = rs.getMetaData();
                    String[] col = new String[rsmd.getColumnCount()];
                    int i = 0;
                    while (i < rsmd.getColumnCount()) {
                        col[i] = rsmd.getColumnName(i + 1);
                        ++i;
                    }
                    cpo.setColIdx(col);
                }
                catch (SQLException e) {
                    this.log.error((Object)e.getMessage());
                    try {
                        if (st != null) {
                            st.close();
                        }
                        if (conn != null) {
                            conn.close();
                        }
                        break block25;
                    }
                    catch (SQLException e1) {
                        this.log.error((Object)e1.getMessage());
                    }
                    break block25;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (st != null) {
                        st.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e1) {
                    this.log.error((Object)e1.getMessage());
                }
                throw throwable;
            }
            try {
                if (st != null) {
                    st.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                this.log.error((Object)e1.getMessage());
            }
        }
        StringBuffer sqlQuery = new StringBuffer();
        sqlQuery.append("select * from (select temp.*,rownum rownumber from (").append(sql).append(")");
        StringBuffer sqlCount = new StringBuffer();
        sqlCount.append("select count(*) from (").append(sql).append(")");
        int totalRows = this.dbProxy.getJdbcTemplate().queryForInt(sqlCount.toString(), paramter);
        cpo.setNMax(totalRows);
        int startIndex = (cpo.getCurrentPage() - 1) * cpo.getPageSize();
        int lastIndex = 0;
        int totalPages = 0;
        totalPages = totalRows % cpo.getPageSize() == 0 ? totalRows / cpo.getPageSize() : totalRows / cpo.getPageSize() + 1;
        if (totalRows < cpo.getPageSize()) {
            lastIndex = totalRows;
        } else if (cpo.getCurrentPage() == totalPages && totalRows % cpo.getPageSize() == 0 || cpo.getCurrentPage() < totalPages) {
            lastIndex = cpo.getCurrentPage() * cpo.getPageSize();
        } else if (cpo.getCurrentPage() == totalPages && totalRows % cpo.getPageSize() != 0) {
            lastIndex = totalRows;
        }
        sqlQuery.append(" temp) where rownumber <= ").append(lastIndex).append(" and rownumber > ").append(startIndex);
        List list = this.dbProxy.getJdbcTemplate().queryForList(sqlQuery.toString(), paramter);
        cpo.setResult(list);
        cpo.setTotalPage(totalPages);
        cro.setResult(cpo);
        return cro;
    }

    public CoreReturnObject executeSPTranscation(String name, ArrayList sqltypes, ArrayList sqlparams, ArrayList outSqltypes, ArrayList outparm, ArrayList cusTypeDB, Connection conn) throws Exception {
        int len = sqltypes.size() + outSqltypes.size();
        String query = "";
        int i = 0;
        while (i < len) {
            query = i == len - 1 ? String.valueOf(query) + "?" : String.valueOf(query) + "?,";
            ++i;
        }
        String sname = "";
        sname = query.equals("") ? "{call " + name + "}" : "{call " + name + "(" + query + ")}";
        String spName = sname;
        conn.setAutoCommit(false);
        CoreReturnObject cro = new CoreReturnObject();
        CallableStatement cstmt = conn.prepareCall(spName);
        try {
            cro = this.setbatch(sqltypes, sqlparams, cstmt, outSqltypes, outparm, cusTypeDB);
        }
        catch (SQLException sqlEx) {
            throw sqlEx;
        }
        catch (Exception e) {
            throw e;
        }
        return cro;
    }

    public CoreReturnObject ExceuteNonQueryTranscation(String sql, Object[] args, Connection conn) throws Exception {
        this.PrintSQL(sql, args);
        CoreReturnObject cro = new CoreReturnObject();
        PreparedStatement stmt = null;
        conn.setAutoCommit(false);
        try {
            stmt = conn.prepareStatement(sql);
            if (args != null) {
                int i = 0;
                while (i < args.length) {
                    int j = i + 1;
                    if (args[i] != null) {
                        if (args[i] instanceof String) {
                            if (((String)args[i]).length() < 800) {
                                stmt.setString(j, (String)args[i]);
                            } else {
                                this.dbProxy.getLobHandler().getLobCreator().setClobAsString(stmt, j, (String)args[i]);
                            }
                        } else if (args[i] instanceof Integer) {
                            stmt.setInt(j, (Integer)args[i]);
                        } else if (args[i] instanceof Double) {
                            stmt.setDouble(j, (Double)args[i]);
                        } else if (args[i] instanceof Float) {
                            stmt.setFloat(j, ((Float)args[i]).floatValue());
                        } else if (args[i] instanceof Date) {
                            stmt.setDate(j, (Date)args[i]);
                        } else if (args[i] instanceof byte[]) {
                            this.dbProxy.getLobHandler().getLobCreator().setBlobAsBytes(stmt, j, (byte[])args[i]);
                        }
                    }
                    ++i;
                }
            }
            int count = stmt.executeUpdate();
            cro.setResult(count);
        }
        catch (SQLException sqlex) {
            throw sqlex;
        }
        catch (Exception ex) {
            throw ex;
        }
        return cro;
    }

    public CoreReturnObject ExceuteQueryTranscation(String sql, Object[] args, Connection conn) throws Exception {
        CoreReturnObject cro = new CoreReturnObject();
        this.PrintSQL(sql, args);
        ArrayList ls = new ArrayList();
        ResultSet rs = null;
        PreparedStatement stmt = null;
        try {
            conn.setAutoCommit(false);
            stmt = conn.prepareStatement(sql);
            if (args != null) {
                int i = 0;
                while (i < args.length) {
                    int j = i + 1;
                    String ii = args[i].toString();
                    if (args[i] != null) {
                        if (args[i] instanceof String) {
                            stmt.setString(j, (String)args[i]);
                        } else if (args[i] instanceof Integer) {
                            stmt.setInt(j, (Integer)args[i]);
                        } else if (args[i] instanceof Double) {
                            stmt.setDouble(j, (Double)args[i]);
                        } else if (args[i] instanceof Float) {
                            stmt.setFloat(j, ((Float)args[i]).floatValue());
                        } else if (args[i] instanceof Date) {
                            stmt.setDate(j, (Date)args[i]);
                        }
                    }
                    ++i;
                }
            }
            rs = stmt.executeQuery();
            int clumncount = rs.getMetaData().getColumnCount();
            int columntype = 0;
            String columnname = "";
            while (rs.next()) {
                LinkedHashMap rowmap = new LinkedHashMap();
                int i = 1;
                while (i <= clumncount) {
                    HashMap<String, Object> table = new HashMap<String, Object>();
                    columntype = rs.getMetaData().getColumnType(i);
                    columnname = rs.getMetaData().getColumnName(i);
                    switch (columntype) {
                        case 12: {
                            table.put(columnname, (String)rs.getObject(i));
                            break;
                        }
                        case 2: {
                            table.put(columnname, (Number)rs.getObject(i));
                            break;
                        }
                        case 2004: {
                            byte[] barry = this.dbProxy.getLobHandler().getBlobAsBytes(rs, i);
                            if (barry == null) {
                                table.put(columnname, new byte[0]);
                                break;
                            }
                            table.put(columnname, barry);
                            break;
                        }
                        case 2005: {
                            table.put(columnname, this.dbProxy.getLobHandler().getClobAsString(rs, i));
                            break;
                        }
                        case 4: {
                            table.put(columnname, (Integer)rs.getObject(i));
                            break;
                        }
                        case 8: {
                            table.put(columnname, (Double)rs.getObject(i));
                            break;
                        }
                        case 6: {
                            table.put(columnname, (Float)rs.getObject(i));
                            break;
                        }
                        case 91: {
                            table.put(columnname, (java.util.Date)rs.getObject(i));
                            break;
                        }
                        default: {
                            throw new CoreException("\u8d85\u51fa\u5e73\u53f0\u6240\u5b9a\u4e49\u7684\u7c7b\u578b ... ");
                        }
                    }
                    rowmap.putAll(table);
                    ++i;
                }
                ls.add(rowmap);
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception ex) {
            throw ex;
        }
        cro.setResult(ls);
        return cro;
    }

    public void closeRs(ResultSet rs) {
        Statement st = null;
        Connection con = null;
        if (rs != null) {
            try {
                st = rs.getStatement();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            if (st != null) {
                try {
                    con = st.getConnection();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            this.close(con, st, rs);
        }
    }

    public void close(Connection con, Statement st, ResultSet rs) {
        try {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                this.log.error((Object)e, (Throwable)e);
                try {
                    try {
                        if (st != null) {
                            if (con == null) {
                                con = st.getConnection();
                            }
                            st.close();
                        }
                    }
                    catch (Exception e2) {
                        this.log.error((Object)e2, (Throwable)e2);
                        try {
                            if (con != null) {
                                con.close();
                            }
                        }
                        catch (Exception e3) {
                            con = null;
                            this.log.error((Object)e3, (Throwable)e3);
                        }
                    }
                }
                finally {
                    try {
                        if (con != null) {
                            con.close();
                        }
                    }
                    catch (Exception e4) {
                        con = null;
                        this.log.error((Object)e4, (Throwable)e4);
                    }
                }
            }
        }
        finally {
            block48: {
                try {
                    try {
                        if (st != null) {
                            if (con == null) {
                                con = st.getConnection();
                            }
                            st.close();
                        }
                    }
                    catch (Exception e) {
                        this.log.error((Object)e, (Throwable)e);
                        try {
                            if (con != null) {
                                con.close();
                            }
                            break block48;
                        }
                        catch (Exception e5) {
                            con = null;
                            this.log.error((Object)e5, (Throwable)e5);
                        }
                        break block48;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (con != null) {
                            con.close();
                        }
                    }
                    catch (Exception e) {
                        con = null;
                        this.log.error((Object)e, (Throwable)e);
                    }
                    throw throwable;
                }
                try {
                    if (con != null) {
                        con.close();
                    }
                }
                catch (Exception e) {
                    con = null;
                    this.log.error((Object)e, (Throwable)e);
                }
            }
        }
    }

    public static void main(String[] args) {
        CoreDBManager man = new CoreDBManager();
        String sql = "select * from testic where id=?";
        Object[] par = new Object[]{"3"};
        CoreReturnObject cro = new CoreReturnObject();
        CorePageObject cpo = new CorePageObject();
        cro = man.ExcutePageQuery(cpo);
    }
}

