/*
 * Decompiled with CFR 0.152.
 */
package CoreFS.SA08;

import CoreFS.SA08.CoreFileStorageImpl;
import CoreFS.SA08.CoreUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;

public class CoreFTPClient {
    private static String IP = null;
    private static String userName = null;
    private static String PWD = null;
    private static int maxBackupIndex = 0;
    private static long gapTime = 0L;

    private static void loadPro() {
        Properties pro = new Properties();
        try {
            pro.load(CoreFileStorageImpl.class.getResourceAsStream("/imagePath.properties"));
            IP = pro.getProperty("IP");
            userName = pro.getProperty("UserName");
            PWD = pro.getProperty("PWD");
            String str = pro.getProperty("maxBackupIndex");
            String str1 = pro.getProperty("gapTime");
            maxBackupIndex = Integer.parseInt(str);
            gapTime = Long.parseLong(str1);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static boolean createDir(FTPClient ftpClient, String path) throws IOException {
        if (path == null || path == "" || ftpClient == null) {
            return false;
        }
        if (path.startsWith("/")) {
            path = path.substring(1, path.length());
        }
        String[] paths = path.split("/");
        String workPath = "/";
        int i = 0;
        while (i < paths.length) {
            ftpClient.makeDirectory(paths[i]);
            workPath = String.valueOf(workPath) + "/" + paths[i];
            ftpClient.changeWorkingDirectory(workPath);
            ++i;
        }
        return true;
    }

    public static FTPClient open() throws IOException {
        FTPClient ftpClient = new FTPClient();
        try {
            if (IP == null || userName == null || PWD == null) {
                CoreFTPClient.loadPro();
            }
            ftpClient.connect(IP);
            ftpClient.login(userName, PWD);
            ftpClient.setControlEncoding("UTF-8");
        }
        catch (SocketException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        return ftpClient;
    }

    public static void Upload(byte[] b, String name, String path) {
        FTPClient ftpClient = null;
        InputStream fis = null;
        try {
            try {
                ftpClient = CoreFTPClient.open();
                ByteArrayInputStream stream = new ByteArrayInputStream(b);
                boolean bn = ftpClient.changeWorkingDirectory(path);
                if (!bn) {
                    CoreFTPClient.createDir(ftpClient, path);
                }
                ftpClient.setBufferSize(1024);
                ftpClient.setControlEncoding("GBK");
                ftpClient.setFileType(2);
                ftpClient.storeFile(new String(name.getBytes("GBK"), "iso-8859-1"), (InputStream)stream);
            }
            catch (IOException e) {
                throw new RuntimeException("FTP\u5ba2\u6237\u7aef\u51fa\u9519\uff01", e);
            }
        }
        finally {
            IOUtils.closeQuietly(fis);
            try {
                if (ftpClient != null) {
                    ftpClient.disconnect();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("\u5173\u95edFTP\u8fde\u63a5\u53d1\u751f\u5f02\u5e38\uff01", e);
            }
        }
    }

    public static byte[] Download(String fileName) {
        FTPClient ftpClient = null;
        InputStream is = null;
        byte[] bytess = null;
        try {
            try {
                ftpClient = CoreFTPClient.open();
                ftpClient.setBufferSize(1024);
                ftpClient.setControlEncoding("UTF-8");
                ftpClient.setFileType(2);
                is = ftpClient.retrieveFileStream(fileName);
                bytess = CoreUtil.toByteArray(is);
            }
            catch (Exception e) {
                throw new RuntimeException("FTP\u5ba2\u6237\u7aef\u51fa\u9519--\u8bfb\u53d6\u56fe\u7247\u5931\u8d25\uff01", e);
            }
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            try {
                if (ftpClient != null) {
                    ftpClient.disconnect();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("\u5173\u95edFTP\u8fde\u63a5\u53d1\u751f\u5f02\u5e38\uff01", e);
            }
        }
        return bytess;
    }

    public static boolean delFile(String path) {
        FTPClient ftpClient = null;
        boolean falg = false;
        try {
            try {
                ftpClient = CoreFTPClient.open();
                falg = ftpClient.deleteFile(path);
            }
            catch (SocketException e) {
                e.printStackTrace();
                try {
                    if (ftpClient != null) {
                        ftpClient.disconnect();
                    }
                }
                catch (IOException e2) {
                    throw new RuntimeException("\u5173\u95edFTP\u8fde\u63a5\u53d1\u751f\u5f02\u5e38\uff01", e2);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    if (ftpClient != null) {
                        ftpClient.disconnect();
                    }
                }
                catch (IOException e3) {
                    throw new RuntimeException("\u5173\u95edFTP\u8fde\u63a5\u53d1\u751f\u5f02\u5e38\uff01", e3);
                }
            }
        }
        finally {
            try {
                if (ftpClient != null) {
                    ftpClient.disconnect();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("\u5173\u95edFTP\u8fde\u63a5\u53d1\u751f\u5f02\u5e38\uff01", e);
            }
        }
        return falg;
    }

    public static void delFileByCount(String path) {
        FTPClient ftpClient = null;
        try {
            try {
                ftpClient = CoreFTPClient.open();
                FTPFile[] ftpFiles = ftpClient.listFiles(path);
                ArrayList<FTPFile> list = new ArrayList<FTPFile>();
                int i = 0;
                while (i < ftpFiles.length) {
                    if (!ftpFiles[i].getName().equals(".") && !ftpFiles[i].getName().equals("..")) {
                        System.out.println(ftpFiles[i].getName());
                        list.add(ftpFiles[i]);
                    }
                    ++i;
                }
                FTPFile[] newftpFiles = list.toArray(new FTPFile[list.size()]);
                int i2 = 0;
                while (i2 < newftpFiles.length) {
                    int j = 0;
                    while (j < newftpFiles.length) {
                        if (newftpFiles[i2].getTimestamp().getTimeInMillis() < newftpFiles[j].getTimestamp().getTimeInMillis()) {
                            FTPFile temp = newftpFiles[j];
                            newftpFiles[j] = newftpFiles[i2];
                            newftpFiles[i2] = temp;
                        }
                        ++j;
                    }
                    ++i2;
                }
                int count = newftpFiles.length;
                if (count >= maxBackupIndex) {
                    int i3 = 0;
                    while (i3 < count - maxBackupIndex) {
                        ftpClient.deleteFile(String.valueOf(path) + newftpFiles[i3].getName());
                        ++i3;
                    }
                }
            }
            catch (SocketException e) {
                e.printStackTrace();
                try {
                    if (ftpClient != null) {
                        ftpClient.disconnect();
                    }
                }
                catch (IOException e2) {
                    throw new RuntimeException("\u5173\u95edFTP\u8fde\u63a5\u53d1\u751f\u5f02\u5e38\uff01", e2);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    if (ftpClient != null) {
                        ftpClient.disconnect();
                    }
                }
                catch (IOException e3) {
                    throw new RuntimeException("\u5173\u95edFTP\u8fde\u63a5\u53d1\u751f\u5f02\u5e38\uff01", e3);
                }
            }
        }
        finally {
            try {
                if (ftpClient != null) {
                    ftpClient.disconnect();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("\u5173\u95edFTP\u8fde\u63a5\u53d1\u751f\u5f02\u5e38\uff01", e);
            }
        }
    }

    public static void delFileByDate(String path) {
        FTPClient ftpClient = null;
        try {
            try {
                ftpClient = CoreFTPClient.open();
                FTPFile[] ftpFiles = ftpClient.listFiles(path);
                long nextCheck = System.currentTimeMillis();
                int i = 0;
                while (i < ftpFiles.length) {
                    long l = ftpFiles[i].getTimestamp().getTimeInMillis();
                    if (nextCheck - l >= gapTime * 24L * 60L * 60L * 1000L) {
                        ftpClient.deleteFile(String.valueOf(path) + ftpFiles[i].getName());
                    }
                    ++i;
                }
            }
            catch (SocketException e) {
                e.printStackTrace();
                try {
                    if (ftpClient != null) {
                        ftpClient.disconnect();
                    }
                }
                catch (IOException e2) {
                    throw new RuntimeException("\u5173\u95edFTP\u8fde\u63a5\u53d1\u751f\u5f02\u5e38\uff01", e2);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    if (ftpClient != null) {
                        ftpClient.disconnect();
                    }
                }
                catch (IOException e3) {
                    throw new RuntimeException("\u5173\u95edFTP\u8fde\u63a5\u53d1\u751f\u5f02\u5e38\uff01", e3);
                }
            }
        }
        finally {
            try {
                if (ftpClient != null) {
                    ftpClient.disconnect();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("\u5173\u95edFTP\u8fde\u63a5\u53d1\u751f\u5f02\u5e38\uff01", e);
            }
        }
    }

    public static void main(String[] args) {
        CoreFTPClient.Download("test/123.jpg");
    }
}

