/*
 * Decompiled with CFR 0.152.
 */
package CoreFS.SA08;

import CoreFS.SA01.CoreCommunicationService;
import CoreFS.SA01.CoreIComponent;
import CoreFS.SA06.CoreParamObject;
import CoreFS.SA06.CoreReturnObject;
import CoreFS.SA08.CoreFTPClient;
import CoreFS.SA08.CoreFileBean;
import CoreFS.SA08.CoreFileParsersFactory;
import CoreFS.SA08.CoreFileRollDelete;
import CoreFS.SA08.CoreFileStorage;
import CoreFS.SA08.CoreUtil;
import CoreFS.SA08.CoreXmlSqlParsersFactory;
import CoreFS.SC01.CoreConstantData;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.map.ListOrderedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreFileStorageImpl
extends CoreIComponent
implements CoreFileStorage {
    @Override
    public CoreReturnObject storageFile(String classname, String methodname, Object[] param) {
        CoreReturnObject cro = new CoreReturnObject();
        if (classname != null && classname.length() != 0 && methodname != null && methodname.length() != 0 && param.length != 0 && param != null) {
            ArrayList<String> pathlist = new ArrayList<String>();
            List list = (List)param[param.length - 1];
            if (list != null && list.size() != 0) {
                BufferedOutputStream bos = null;
                try {
                    int i = 0;
                    while (i < list.size()) {
                        String path = this.depositPath(((CoreFileBean)list.get(i)).getPathName());
                        Date dt = new Date();
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                        path = String.valueOf(path) + sdf.format(dt);
                        if (!CoreConstantData.isFTP.booleanValue()) {
                            File f = new File(path);
                            if (!f.exists()) {
                                f.mkdirs();
                            }
                            bos = new BufferedOutputStream(new FileOutputStream(new File(String.valueOf(path) + new String(((CoreFileBean)list.get(i)).getFileName().getBytes("GBK"), "iso-8859-1"))));
                            bos.write(((CoreFileBean)list.get(i)).getFile());
                            bos.flush();
                            bos.close();
                            pathlist.add(String.valueOf(path) + ((CoreFileBean)list.get(i)).getFileName());
                            File file = new File(path);
                            CoreFileRollDelete ird = new CoreFileRollDelete();
                            if (CoreConstantData.delCondition.booleanValue()) {
                                ird.deleteImageByCount(file);
                            } else {
                                ird.deleteImageByDate(file);
                            }
                        } else {
                            CoreFTPClient coreFTP = new CoreFTPClient();
                            CoreFTPClient.Upload(((CoreFileBean)list.get(i)).getFile(), ((CoreFileBean)list.get(i)).getFileName(), path);
                            pathlist.add(String.valueOf(path) + "\\" + ((CoreFileBean)list.get(i)).getFileName());
                            if (CoreConstantData.delCondition.booleanValue()) {
                                CoreFTPClient.delFileByCount(path);
                            } else {
                                CoreFTPClient.delFileByDate(path);
                            }
                        }
                        ++i;
                    }
                    cro = this.storagepath(classname, methodname, param, pathlist);
                    if (cro.getV_errCode() == -1) {
                        this.delFile(pathlist);
                        return cro.SetErrInfo("\u4fdd\u5b58\u56fe\u7247\u5931\u8d25" + cro.getV_errMsg());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return cro.SetErrInfo("\u4fdd\u5b58\u56fe\u7247\u5931\u8d25" + e.getMessage());
                }
                return cro;
            }
            return cro.SetErrInfo("\u56fe\u7247\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return cro.SetErrInfo("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private CoreReturnObject storagepath(String classname, String methodname, Object[] param, List<String> pathlist) {
        CoreParamObject ctx = new CoreParamObject();
        ctx.setV_serviceName(classname);
        ctx.setV_method(methodname);
        Object[] params = param;
        params[params.length - 1] = pathlist;
        ctx.setV_reqParameters(params);
        CoreCommunicationService cic = new CoreCommunicationService();
        return cic.runActivtity(ctx);
    }

    @Override
    public List<byte[]> fileTake(String sqlID, String ID) {
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        if (sqlID.length() != 0 && sqlID != null) {
            List<String> pathlist = this.Sql(sqlID, ID);
            try {
                if (pathlist.size() == 0) {
                    return list;
                }
                ListOrderedMap map = (ListOrderedMap)pathlist.get(0);
                int i = 0;
                while (i < map.size()) {
                    if (!CoreConstantData.isFTP.booleanValue()) {
                        FileInputStream is = new FileInputStream(new File(map.getValue(i).toString()));
                        byte[] bytess = CoreUtil.toByteArray(is);
                        ((InputStream)is).close();
                        list.add(bytess);
                    } else if (map.getValue(i) == null) {
                        list.add(new byte[0]);
                    } else {
                        byte[] bytess = CoreFTPClient.Download(map.getValue(i).toString());
                        list.add(bytess);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    private List<String> Sql(String sqlID, String ID) {
        String sql = CoreXmlSqlParsersFactory.getSql(sqlID);
        CoreReturnObject path = this.getDao(CoreConstantData.sysbeanstr).ExcuteQuery(sql, new Object[]{ID});
        return (List)path.getResult();
    }

    private void delFile(List<String> pathlist) {
        int i = 0;
        while (i < pathlist.size()) {
            try {
                if (!CoreConstantData.isFTP.booleanValue()) {
                    File myFilePath = new File(pathlist.get(i));
                    myFilePath.delete();
                } else {
                    CoreFTPClient.delFile(pathlist.get(i));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    private String depositPath(String pathName) {
        String path = null;
        try {
            path = CoreFileParsersFactory.getPro().getProperty(pathName);
            if (path == null) {
                CoreFileParsersFactory cfpf = new CoreFileParsersFactory();
                cfpf.loadpro();
                path = CoreFileParsersFactory.getPro().getProperty(pathName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return path;
    }
}

