/*
 * Decompiled with CFR 0.152.
 */
package CoreFS.SC01;

import CoreFS.SA06.CoreReturnObject;
import CoreFS.SC01.Bytes;
import CoreFS.SC01.StoreFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.sigar.Cpu;
import org.hyperic.sigar.CpuInfo;
import org.hyperic.sigar.CpuPerc;
import org.hyperic.sigar.FileSystem;
import org.hyperic.sigar.FileSystemUsage;
import org.hyperic.sigar.Mem;
import org.hyperic.sigar.Sigar;

public class CorePerformanceMonitor {
    private static final int CPUTIME = 1000;
    private static final int PERCENT = 100;
    private static final int FAULTLENGTH = 10;
    private static final int delt = 0x100000;
    static final BigDecimal DIVISOR = BigDecimal.valueOf(1024L);
    private static List monitorInfoList = new ArrayList();
    protected static final Log log = LogFactory.getLog(CorePerformanceMonitor.class);
    private static float kb = 1048576.0f;

    public CorePerformanceMonitor() {
        Sigar sigar = null;
        try {
            try {
                CorePerformanceMonitor.exec("");
                sigar = new Sigar();
            }
            catch (Exception ex) {
                if (sigar != null) {
                    sigar.close();
                }
                if (sigar != null) {
                    sigar.close();
                }
            }
        }
        finally {
            if (sigar != null) {
                sigar.close();
            }
        }
    }

    public static CoreReturnObject getMonitorInfo() {
        String osName = System.getProperty("os.name");
        ArrayList<Serializable> monitorInfoList = new ArrayList<Serializable>();
        monitorInfoList.add(0, CorePerformanceMonitor.getJvmMemoryInfo());
        double cpuUsedRatio = 0.0;
        monitorInfoList.add(1, CorePerformanceMonitor.getPhysicMemoryInfo());
        monitorInfoList.add(2, Double.valueOf(CorePerformanceMonitor.getCpuUsedInfo()));
        monitorInfoList.add(3, CorePerformanceMonitor.getThreadInfo());
        monitorInfoList.add(4, Integer.valueOf(StoreFactory.getStore().getCount()));
        monitorInfoList.add(5, CorePerformanceMonitor.getCpuInfo());
        ArrayList<Integer> al = new ArrayList<Integer>();
        al.add(StoreFactory.getStore().getComCount());
        al.add(StoreFactory.getStore().GetSqlCount());
        monitorInfoList.add(6, al);
        CoreReturnObject cro = new CoreReturnObject();
        cro.setResult(monitorInfoList);
        return cro;
    }

    public static ArrayList getCpuInfo() {
        ArrayList<Object> al = new ArrayList<Object>();
        Sigar si = null;
        try {
            try {
                si = new Sigar();
                CpuPerc cpup = si.getCpuPerc();
                CpuInfo cpuinfo = si.getCpuInfoList()[0];
                Cpu cpu = si.getCpu();
                al.add(String.valueOf(cpuinfo.getVendor()) + " " + cpuinfo.getModel());
                al.add(cpuinfo.getMhz());
                al.add(cpu.getTotal() / 1000L / 60L);
            }
            catch (Exception e) {
                al.add("");
                al.add(0);
                al.add(0);
                log.error((Object)e.getMessage());
                if (si != null) {
                    si.close();
                }
            }
        }
        finally {
            if (si != null) {
                si.close();
            }
        }
        return al;
    }

    public static HashMap getJvmMemoryInfo() {
        long totalMemory = Runtime.getRuntime().totalMemory() / 0x100000L;
        long freeMemory = Runtime.getRuntime().freeMemory() / 0x100000L;
        long maxMemory = Runtime.getRuntime().maxMemory() / 0x100000L;
        HashMap<String, Long> jvmMemoryHash = new HashMap<String, Long>();
        jvmMemoryHash.put("jvmTotalMemory", totalMemory);
        jvmMemoryHash.put("jvmFreeMemory", freeMemory);
        jvmMemoryHash.put("jvmMaxMemory", maxMemory);
        return jvmMemoryHash;
    }

    public static HashMap getPhysicMemoryInfo() {
        HashMap<String, Number> physicMemoryHash = new HashMap<String, Number>();
        Sigar sigar = null;
        Mem mem = null;
        try {
            try {
                sigar = new Sigar();
                mem = sigar.getMem();
                long totalPhysicMemory = mem.getTotal() / 0x100000L;
                long freePhysicalMemory = mem.getActualFree() / 0x100000L;
                long usedPhysicMemory = mem.getActualUsed() / 0x100000L;
                physicMemoryHash.put("physicTotalMemory", totalPhysicMemory);
                physicMemoryHash.put("physicFreeMemory", freePhysicalMemory);
                physicMemoryHash.put("physicUsedMemory", usedPhysicMemory);
            }
            catch (Exception e) {
                physicMemoryHash.put("physicTotalMemory", 0);
                physicMemoryHash.put("physicFreeMemory", 0);
                physicMemoryHash.put("physicUsedMemory", 0);
                log.error((Object)("\u83b7\u53d6\u7269\u7406\u5185\u5b58" + e.getMessage()));
                if (sigar != null) {
                    sigar.close();
                }
            }
        }
        finally {
            if (sigar != null) {
                sigar.close();
            }
        }
        return physicMemoryHash;
    }

    public static int getPid() {
        return Integer.parseInt(ManagementFactory.getRuntimeMXBean().getName().split("@")[0]);
    }

    public static HashMap getMonitorInfoBean() {
        HashMap<String, Number> monitorInfo = new HashMap<String, Number>();
        Runtime rt = Runtime.getRuntime();
        BufferedReader in = null;
        try {
            try {
                int pid = CorePerformanceMonitor.getPid();
                String[] cmd = new String[]{"/bin/sh", "-c", "top -b -n 1 | grep " + pid};
                Process p = rt.exec(cmd);
                in = new BufferedReader(new InputStreamReader(p.getInputStream()));
                String str = null;
                String[] strArray = null;
                long useMem = 0L;
                while ((str = in.readLine()) != null) {
                    int m = 0;
                    strArray = str.split(" ");
                    int i = 0;
                    while (i < strArray.length) {
                        String info = strArray[i];
                        if (info.trim().length() != 0) {
                            if (m == 5) {
                                BigDecimal memUseSize;
                                String unit = info.substring(info.length() - 1);
                                if (unit.equalsIgnoreCase("g")) {
                                    useMem = Long.parseLong(info);
                                } else if (unit.equalsIgnoreCase("m")) {
                                    memUseSize = new BigDecimal(info.substring(0, info.length() - 1));
                                    useMem = Long.parseLong(memUseSize.divide(DIVISOR, 2, 4).toString());
                                } else {
                                    memUseSize = new BigDecimal(info).divide(DIVISOR);
                                    useMem = Long.parseLong(memUseSize.divide(DIVISOR, 2, 4).toString());
                                }
                                monitorInfo.put("physicUsedMemory", useMem);
                            }
                            if (m == 9) {
                                monitorInfo.put("physicTotalMemory", 3000);
                                monitorInfo.put("physicFreeMemory", 0);
                            }
                            ++m;
                        }
                        ++i;
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    in.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return monitorInfo;
    }

    public static double getCpuUsedInfo() {
        String osName = System.getProperty("os.name");
        double cpuUsedRatio = 0.0;
        cpuUsedRatio = osName.toLowerCase().startsWith("windows") ? CorePerformanceMonitor.getCpuRatioForWindows() : CorePerformanceMonitor.getCpuRateForUnixSigar();
        return cpuUsedRatio;
    }

    private static double getCpuRateForUnixSigar() {
        Sigar sigar = new Sigar();
        double rate = 0.0;
        try {
            try {
                CpuInfo[] infos = sigar.getCpuInfoList();
                CpuPerc[] cpuList = null;
                cpuList = sigar.getCpuPercList();
                rate = Double.parseDouble(CpuPerc.format((double)cpuList[0].getCombined()).replace("%", ""));
            }
            catch (Exception ex) {
                log.error((Object)ex.getMessage());
                if (sigar != null) {
                    sigar.close();
                }
            }
        }
        finally {
            if (sigar != null) {
                sigar.close();
            }
        }
        return rate;
    }

    private static double getCpuRateForUnix() {
        double d;
        InputStream is = null;
        InputStreamReader isr = null;
        BufferedReader brStat = null;
        StringTokenizer tokenStat = null;
        try {
            Process process = Runtime.getRuntime().exec("top -b -n 1");
            is = process.getInputStream();
            isr = new InputStreamReader(is);
            brStat = new BufferedReader(isr);
            brStat.readLine();
            brStat.readLine();
            brStat.readLine();
            brStat.readLine();
            tokenStat = new StringTokenizer(brStat.readLine());
            tokenStat.nextToken();
            tokenStat.nextToken();
            String user = tokenStat.nextToken();
            tokenStat.nextToken();
            String system = tokenStat.nextToken();
            tokenStat.nextToken();
            String nice = tokenStat.nextToken();
            System.out.println(String.valueOf(user) + " , " + system + " , " + nice);
            user = user.substring(0, user.indexOf("%"));
            system = system.substring(0, system.indexOf("%"));
            nice = nice.substring(0, nice.indexOf("%"));
            double userUsage = new Float(user).floatValue();
            double systemUsage = new Float(system).floatValue();
            double niceUsage = new Float(nice).floatValue();
            d = (userUsage + systemUsage + niceUsage) / 100.0;
        }
        catch (IOException ioe) {
            try {
                System.out.println(ioe.getMessage());
                CorePerformanceMonitor.freeResource(is, isr, brStat);
            }
            catch (Throwable throwable) {
                CorePerformanceMonitor.freeResource(is, isr, brStat);
                throw throwable;
            }
            CorePerformanceMonitor.freeResource(is, isr, brStat);
            return 1.0;
        }
        CorePerformanceMonitor.freeResource(is, isr, brStat);
        return d;
    }

    private static void freeResource(InputStream is, InputStreamReader isr, BufferedReader br) {
        try {
            if (is != null) {
                is.close();
            }
            if (isr != null) {
                isr.close();
            }
            if (br != null) {
                br.close();
            }
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
        }
    }

    private static double getCpuRatioForWindows() {
        try {
            String procCmd = String.valueOf(System.getenv("windir")) + "\\system32\\wbem\\wmic.exe process get Caption,CommandLine," + "KernelModeTime,ReadOperationCount,ThreadCount,UserModeTime,WriteOperationCount";
            long[] c0 = CorePerformanceMonitor.readCpu(Runtime.getRuntime().exec(procCmd));
            Thread.sleep(1000L);
            long[] c1 = CorePerformanceMonitor.readCpu(Runtime.getRuntime().exec(procCmd));
            if (c0 != null && c1 != null) {
                long idletime = c1[0] - c0[0];
                long busytime = c1[1] - c0[1];
                return 100L * busytime / (busytime + idletime);
            }
            return 0.0;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0.0;
        }
    }

    private static long[] readCpu(Process proc) {
        long[] retn = new long[2];
        try {
            proc.getOutputStream().close();
            InputStreamReader ir = new InputStreamReader(proc.getInputStream());
            LineNumberReader input = new LineNumberReader(ir);
            String line = input.readLine();
            if (line == null || line.length() < 10) {
                return null;
            }
            int capidx = line.indexOf("Caption");
            int cmdidx = line.indexOf("CommandLine");
            int rocidx = line.indexOf("ReadOperationCount");
            int umtidx = line.indexOf("UserModeTime");
            int kmtidx = line.indexOf("KernelModeTime");
            int wocidx = line.indexOf("WriteOperationCount");
            long idletime = 0L;
            long kneltime = 0L;
            long usertime = 0L;
            while ((line = input.readLine()) != null) {
                if (line.length() < wocidx) continue;
                String caption = Bytes.substring(line, capidx, cmdidx - 1).trim();
                String cmd = Bytes.substring(line, cmdidx, kmtidx - 1).trim();
                if (cmd.indexOf("wmic.exe") >= 0) continue;
                if (caption.equals("System Idle Process") || caption.equals("System")) {
                    idletime += Long.valueOf(Bytes.substring(line, kmtidx, rocidx - 1).trim()).longValue();
                    idletime += Long.valueOf(Bytes.substring(line, umtidx, wocidx - 1).trim()).longValue();
                    continue;
                }
                kneltime += Long.valueOf(Bytes.substring(line, kmtidx, rocidx - 1).trim()).longValue();
                usertime += Long.valueOf(Bytes.substring(line, umtidx, wocidx - 1).trim()).longValue();
            }
            retn[0] = idletime;
            retn[1] = kneltime + usertime;
            long[] lArray = retn;
            return lArray;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                proc.getInputStream().close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static HashMap getThreadInfo() {
        String osName = System.getProperty("os.name");
        HashMap<String, Number> threadHash = new HashMap<String, Number>();
        ThreadMXBean th = ManagementFactory.getThreadMXBean();
        int activeThrdCount = th.getThreadCount();
        int daemonThrdCount = th.getDaemonThreadCount();
        int peakThrdCount = th.getPeakThreadCount();
        long currentThrdTime = th.getCurrentThreadCpuTime();
        long currentThrdUserTime = th.getCurrentThreadUserTime();
        threadHash.put("activeThrdCount", activeThrdCount);
        threadHash.put("deamonThrdCount", daemonThrdCount);
        threadHash.put("peakThrdCount", peakThrdCount);
        threadHash.put("currentThrdTime", currentThrdTime / 1000L);
        threadHash.put("currentThrdUserTime", currentThrdUserTime / 1000L);
        return threadHash;
    }

    public CoreReturnObject getDistInfo() {
        CoreReturnObject cro = new CoreReturnObject();
        cro.setResult(CorePerformanceMonitor.getDiskInof());
        return cro;
    }

    private static ArrayList getDiskInof() {
        ArrayList result;
        block17: {
            String osName = System.getProperty("os.name");
            result = new ArrayList();
            String diskinfo = "";
            long total = 0L;
            Sigar disk = null;
            try {
                try {
                    if (osName.startsWith("Win") || osName.startsWith("win")) {
                        disk = new Sigar();
                        File file = disk.getNativeLibrary();
                        FileSystem[] fslist = disk.getFileSystemList();
                        int i = 0;
                        while (i < fslist.length) {
                            ArrayList<String> al = new ArrayList<String>();
                            FileSystem fs = fslist[i];
                            if (fs.getType() == 2) {
                                FileSystemUsage usage = disk.getFileSystemUsage(fs.getDirName());
                                al.add(fs.getDirName());
                                al.add(CorePerformanceMonitor.NumDist((float)usage.getTotal() / kb));
                                al.add(CorePerformanceMonitor.NumDist((float)usage.getUsed() / kb));
                                al.add(CorePerformanceMonitor.NumDist((float)usage.getAvail() / kb));
                                result.add(al);
                            }
                            ++i;
                        }
                        break block17;
                    }
                    float count = 0.0f;
                    float free = 0.0f;
                    float used = 0.0f;
                    HashMap hm = new HashMap();
                    disk = new Sigar();
                    FileSystem[] fslist = disk.getFileSystemList();
                    int i = 0;
                    while (i < fslist.length) {
                        FileSystem fs = fslist[i];
                        if (fs.getType() == 2) {
                            count = 0.0f;
                            String devName = fs.getDevName();
                            String subdevName = devName.substring(0, devName.length() - 1);
                            if (hm.containsKey(subdevName)) {
                                float mycountvalue = 0.0f;
                                float myuservalue = 0.0f;
                                float myfreevalue = 0.0f;
                                ArrayList altmp = (ArrayList)hm.get(subdevName);
                                try {
                                    mycountvalue = Float.parseFloat(altmp.get(0).toString());
                                    myuservalue = Float.parseFloat(altmp.get(1).toString());
                                    myfreevalue = Float.parseFloat(altmp.get(2).toString());
                                }
                                catch (Exception ex) {
                                    log.error((Object)("error01" + ex.getMessage()));
                                }
                                FileSystemUsage usage = disk.getFileSystemUsage(fs.getDirName());
                                count += (float)usage.getTotal();
                                used += (float)usage.getUsed();
                                free += (float)usage.getFree();
                                altmp.set(0, Float.valueOf(count += mycountvalue));
                                altmp.set(1, Float.valueOf(used += myuservalue));
                                altmp.set(2, Float.valueOf(free += myfreevalue));
                                hm.remove(subdevName);
                                hm.put(subdevName, altmp);
                            } else {
                                ArrayList<Float> alTemp = new ArrayList<Float>();
                                FileSystemUsage usage = disk.getFileSystemUsage(fs.getDirName());
                                alTemp.add(Float.valueOf(count += (float)usage.getTotal()));
                                alTemp.add(Float.valueOf(used += (float)usage.getUsed()));
                                alTemp.add(Float.valueOf(free += (float)usage.getFree()));
                                hm.put(subdevName, alTemp);
                            }
                        }
                        ++i;
                    }
                    Iterator iter = hm.entrySet().iterator();
                    while (iter.hasNext()) {
                        ArrayList<String> al = new ArrayList<String>();
                        Map.Entry entry = iter.next();
                        Object key = entry.getKey();
                        ArrayList altmp = (ArrayList)entry.getValue();
                        al.add(key.toString());
                        al.add(CorePerformanceMonitor.NumDist(Float.parseFloat(altmp.get(0).toString()) / kb));
                        al.add(CorePerformanceMonitor.NumDist(Float.parseFloat(altmp.get(1).toString()) / kb));
                        al.add(CorePerformanceMonitor.NumDist(Float.parseFloat(altmp.get(2).toString()) / kb));
                        result.add(al);
                    }
                }
                catch (Exception e) {
                    log.error((Object)("\u83b7\u53d6\u78c1\u76d8\u4fe1\u606f\u9519\u8bef \uff1a" + e.getMessage()));
                    e.printStackTrace();
                    if (disk != null) {
                        disk.close();
                    }
                }
            }
            finally {
                if (disk != null) {
                    disk.close();
                }
            }
        }
        return result;
    }

    private static String NumDist(float num) {
        NumberFormat numFormat = NumberFormat.getNumberInstance();
        numFormat.setMaximumFractionDigits(1);
        String str = numFormat.format(num);
        return str;
    }

    public static CoreReturnObject getOsInfo() {
        CoreReturnObject cro = new CoreReturnObject();
        ArrayList<String> result = new ArrayList<String>();
        Properties props = System.getProperties();
        String osName = props.getProperty("os.name");
        String osArch = props.getProperty("os.arch");
        String osVersion = props.getProperty("os.version");
        result.add(osName);
        result.add(osArch);
        result.add(osVersion);
        cro.setResult(result);
        return cro;
    }

    public CoreReturnObject getOnlineInfo() {
        CoreReturnObject cro = new CoreReturnObject();
        try {
            cro.setResult(StoreFactory.getStore().getUsers());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return cro;
    }

    public CoreReturnObject getComponentInfo() {
        CoreReturnObject cro = new CoreReturnObject();
        try {
            cro.setResult(StoreFactory.getStore().getComponents());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return cro;
    }

    public CoreReturnObject getSQLInfo() {
        CoreReturnObject cro = new CoreReturnObject();
        try {
            cro.setResult(StoreFactory.getStore().getSqlInfo());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return cro;
    }

    public CoreReturnObject RefreshLoginTime(String username) {
        CoreReturnObject cro = new CoreReturnObject();
        long time = System.currentTimeMillis();
        Date datetime = new Date(time);
        StoreFactory.getStore().resetSaveTime(username, datetime);
        return cro;
    }

    public static CoreReturnObject exec(String ss) {
        CoreReturnObject cro = new CoreReturnObject();
        String cfgpath = Thread.currentThread().getContextClassLoader().getResource("../lib").getPath();
        cfgpath = cfgpath.replace("%20", " ");
        File nativeDir = new File(cfgpath);
        File[] libs = nativeDir.listFiles();
        int i = 0;
        while (i < libs.length) {
            if (libs[i].isFile()) {
                try {
                    if (libs[i].getName().endsWith(".so") || libs[i].getName().endsWith(".dll")) {
                        System.load(String.valueOf(cfgpath) + libs[i].getName());
                        cro.setResult("\u6210\u529f:" + cfgpath);
                    }
                }
                catch (Throwable t) {
                    cro.setResult("\u5931\u8d25:" + cfgpath + "==  " + libs[i].getName() + "  ===" + t.getMessage());
                }
            }
            ++i;
        }
        return cro;
    }

    public static void main(String[] args) {
        CorePerformanceMonitor.getCpuRateForUnixSigar();
    }
}

