/*
 * Decompiled with CFR 0.152.
 */
package CoreFS.SC01;

import CoreFS.SA01.CoreIComponent;
import CoreFS.SC01.ComponentsBean;
import CoreFS.SC01.CoreConstantData;
import CoreFS.SC01.CoreLoginRecord;
import CoreFS.SC01.CoreSqlInfoBean;
import CoreFS.SC01.IStatStore;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemStat
extends CoreIComponent
implements IStatStore {
    private static Map userMap = null;
    private static Map comMap = null;
    private static Map sqlMap = null;
    private static Map<String, ArrayList> backMap = null;
    protected final Log log = LogFactory.getLog(this.getClass());

    static {
        userMap = new HashMap();
        comMap = new HashMap();
        sqlMap = new HashMap();
        backMap = new HashMap<String, ArrayList>();
    }

    @Override
    public int getCount() {
        return userMap.size();
    }

    @Override
    public void RegisterWinForm(String winFormName, String IP) {
        if (backMap.containsKey(winFormName)) {
            ArrayList al = backMap.get(winFormName);
            al.add(IP);
        } else {
            ArrayList<String> al = new ArrayList<String>();
            al.add(IP);
            backMap.put(winFormName, al);
        }
    }

    @Override
    public ArrayList GetReturnIp(String winFormName) {
        ArrayList result = new ArrayList();
        if (backMap.containsKey(winFormName)) {
            result = backMap.get(winFormName);
        }
        return result;
    }

    @Override
    public void RemoveReturnIP(String winFormName, String IP) {
        if (backMap.containsKey(winFormName)) {
            ArrayList al = backMap.get(winFormName);
            al.remove(IP);
        }
    }

    @Override
    public List getUsers() {
        ArrayList<ListOrderedMap> list = new ArrayList<ListOrderedMap>();
        String user2 = null;
        for (String user2 : userMap.keySet()) {
            ListOrderedMap result = new ListOrderedMap();
            CoreLoginRecord loginrecord = (CoreLoginRecord)userMap.get(user2);
            result.put("USERID", loginrecord.getStrUserID());
            result.put("USERNAME", loginrecord.getStrUserName());
            result.put("MACHINEIP", loginrecord.getStrMachineIP());
            result.put("MACHINENAME", loginrecord.getStrMachineName());
            result.put("LOGINTIME", loginrecord.getStrLoginTime());
            result.put("ROLE", loginrecord.getStrRole());
            result.put("DEPARTMENT", loginrecord.getStrDepartment());
            list.add(result);
        }
        return list;
    }

    @Override
    public List<CoreLoginRecord> getOnlineUsers() {
        ArrayList<CoreLoginRecord> list = new ArrayList<CoreLoginRecord>();
        String user2 = null;
        for (String user2 : userMap.keySet()) {
            ListOrderedMap result = new ListOrderedMap();
            CoreLoginRecord loginrecord = (CoreLoginRecord)userMap.get(user2);
            list.add(loginrecord);
        }
        return list;
    }

    @Override
    public void login(String username, CoreLoginRecord loginrecord) {
        this.updLoginState(username, loginrecord.getStrMachineIP(), "1");
        userMap.put(username, loginrecord);
    }

    @Override
    public void logoff(String username) {
        this.updLoginState(username, "", "0");
        userMap.remove(username);
    }

    private void updLoginState(String userid, String ip, String islogin) {
        String sql = "UPDATE CORE_APP_USER SET ISLOGIN='" + islogin + "',IP='" + ip + "' WHERE USERID='" + userid + "'";
        try {
            this.getDao(CoreConstantData.sysbeanstr).ExcuteNonQuery(sql);
        }
        catch (SQLException e) {
            this.log.error((Object)e.getMessage());
        }
    }

    @Override
    public Boolean islogin(String username, String IP) {
        if (userMap.containsKey(username)) {
            CoreLoginRecord loginrecord = (CoreLoginRecord)userMap.get(username);
            if (loginrecord.getStrMachineIP().equals(IP)) {
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void resetSaveTime(String username, Date date) {
        if (userMap.containsKey(username)) {
            CoreLoginRecord loginrecord = (CoreLoginRecord)userMap.get(username);
            loginrecord.setStrSaveTime(date);
            userMap.put(username, loginrecord);
        }
    }

    @Override
    public void removeErrorUser() {
        long time = System.currentTimeMillis();
        Date datetime = new Date(time);
        String user2 = null;
        for (String user2 : userMap.keySet()) {
            CoreLoginRecord loginrecord = (CoreLoginRecord)userMap.get(user2);
            if ((datetime.getTime() - loginrecord.getStrSaveTime().getTime()) / 1000L <= 300L) continue;
            this.updLoginState(user2, "", "0");
            userMap.remove(user2);
        }
    }

    @Override
    public void removeErrorUser(String userid) {
        this.updLoginState(userid, "", "0");
        userMap.remove(userid);
    }

    @Override
    public void AddComponents(String comName, Date callTime) {
        ComponentsBean components = null;
        if (comMap.containsKey(comName)) {
            components = (ComponentsBean)comMap.get(comName);
            components.setCallTime(callTime);
            components.setUseTimes(components.getUseTimes() + 1);
        } else {
            components = new ComponentsBean();
            components.setComName(comName);
            components.setCallTime(callTime);
            components.setUseTimes(1);
        }
        comMap.put(comName, components);
    }

    @Override
    public List getComponents() {
        ArrayList<ListOrderedMap> list = new ArrayList<ListOrderedMap>();
        String components2 = null;
        for (String components2 : comMap.keySet()) {
            ListOrderedMap result = new ListOrderedMap();
            ComponentsBean com = (ComponentsBean)comMap.get(components2);
            result.put("COMPONENTS", com.getComName());
            result.put("CALLTIME", com.getCallTime());
            result.put("USETIMES", com.getUseTimes());
            list.add(result);
        }
        return list;
    }

    @Override
    public int getComCount() {
        return comMap.size();
    }

    @Override
    public void AddSql(String sql, Date begintime, Date endtime, long usetime) {
        CoreSqlInfoBean sqlinfo = null;
        if (sqlMap.containsKey(sql)) {
            sqlinfo = (CoreSqlInfoBean)sqlMap.get(sql);
            sqlinfo.setSql(sql);
            sqlinfo.setBegintime(begintime);
            sqlinfo.setEndtime(endtime);
            sqlinfo.setUsetime(usetime);
        } else {
            sqlinfo = new CoreSqlInfoBean();
            sqlinfo.setSql(sql);
            sqlinfo.setBegintime(begintime);
            sqlinfo.setEndtime(endtime);
            sqlinfo.setUsetime(usetime);
        }
        sqlMap.put(sql, sqlinfo);
    }

    @Override
    public int GetSqlCount() {
        return sqlMap.size();
    }

    @Override
    public List getSqlInfo() {
        ArrayList<ListOrderedMap> list = new ArrayList<ListOrderedMap>();
        String sqls2 = null;
        for (String sqls2 : sqlMap.keySet()) {
            ListOrderedMap result = new ListOrderedMap();
            CoreSqlInfoBean sqlinfo = (CoreSqlInfoBean)sqlMap.get(sqls2);
            result.put("SQL", sqlinfo.getSql());
            result.put("USETIME", (double)sqlinfo.getUsetime() / 1000000.0);
            list.add(result);
        }
        return list;
    }
}

