/*
 * Decompiled with CFR 0.152.
 */
package CoreFS.SD01;

import CoreFS.SA01.CoreBeanFacotry;
import CoreFS.SA01.CoreGlobalConstants;
import CoreFS.SA06.CoreReturnObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class CoreServerConfig {
    protected final Log log = LogFactory.getLog(this.getClass());
    public static CoreBeanFacotry beanfactory;

    public CoreReturnObject ReadConnect() {
        CoreReturnObject cro = new CoreReturnObject();
        String filePath = CoreGlobalConstants.SPRINGCONFIG_LOACLXMLCONFIGPATH;
        filePath = filePath.replace("%20", " ");
        SAXBuilder sh = new SAXBuilder();
        ArrayList<ListOrderedMap> result = new ArrayList<ListOrderedMap>();
        try {
            Document dc = sh.build(new File(filePath));
            Element el = dc.getRootElement();
            List beansNode = el.getChildren();
            for (Object object : beansNode) {
                Element bean1 = null;
                ListOrderedMap recode = new ListOrderedMap();
                bean1 = (Element)object;
                if (!bean1.getAttributeValue("class").equals("org.apache.commons.dbcp.BasicDataSource")) continue;
                String dataSource = bean1.getAttributeValue("id");
                recode.put((Object)"dataSource", (Object)dataSource);
                String jdbcTemp = "";
                jdbcTemp = this.getJdbctemp(beansNode, dataSource, "org.springframework.jdbc.core.JdbcTemplate");
                String Daoname = "";
                Daoname = this.getJdbctemp(beansNode, jdbcTemp, "CoreFS.SA04.CoreDBProxy");
                recode.put((Object)"JdbcTemp", (Object)jdbcTemp);
                recode.put((Object)"Dao", (Object)Daoname);
                List beanNode = bean1.getChildren();
                Element proDriverNode = (Element)beanNode.get(0);
                String driver = proDriverNode.getChildText("value");
                recode.put((Object)"Driver", (Object)driver);
                Element ProurlNode = (Element)beanNode.get(1);
                String url = ProurlNode.getChildText("value");
                recode.put((Object)"Url", (Object)url);
                Element ProuserNode = (Element)beanNode.get(2);
                String user = ProuserNode.getChildText("value");
                recode.put((Object)"User", (Object)user);
                Element ProPwdNode = (Element)beanNode.get(3);
                String pwd = ProPwdNode.getChildText("value");
                recode.put((Object)"Pwd", (Object)pwd);
                Element ProMaxActiveNode = (Element)beanNode.get(4);
                String maxactive = ProMaxActiveNode.getChildText("value");
                recode.put((Object)"MaxActive", (Object)maxactive);
                Element ProMaxIdleNode = (Element)beanNode.get(5);
                String maxIdle = ProMaxIdleNode.getChildText("value");
                recode.put((Object)"MaxIdle", (Object)maxIdle);
                Element ProMinIdleNode = (Element)beanNode.get(6);
                String minidle = ProMinIdleNode.getChildText("value");
                recode.put((Object)"Mididle", (Object)minidle);
                Element ProMaxWaitNode = (Element)beanNode.get(7);
                String maxwait = ProMaxWaitNode.getChildText("value");
                recode.put((Object)"MaxWait", (Object)maxwait);
                Element ProIdleTimeNode = (Element)beanNode.get(10);
                String idletime = ProIdleTimeNode.getChildText("value");
                recode.put((Object)"IdleTime", (Object)idletime);
                result.add(recode);
            }
            cro.setResult(result);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
            cro.setV_errCode(-1);
            cro.setV_errMsg(e.getMessage());
        }
        return cro;
    }

    private String getJdbctemp(List beansNode, String DataSource, String querystr) {
        String jdbctemp = "";
        block0: for (Object object : beansNode) {
            Element bean = null;
            bean = (Element)object;
            if (!bean.getAttributeValue("class").equals(querystr)) continue;
            List beanCnode = bean.getChildren();
            for (Object node : beanCnode) {
                Element node1 = (Element)node;
                if (!node1.getAttributeValue("ref").equals(DataSource)) continue;
                jdbctemp = bean.getAttributeValue("id");
                continue block0;
            }
        }
        return jdbctemp;
    }

    public CoreReturnObject DeleteNode(String dataSource, String jdbcTemp, String Dao) {
        CoreReturnObject cro = new CoreReturnObject();
        try {
            if (this.delete(dataSource)) {
                this.delete(jdbcTemp);
                this.delete(Dao);
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
            cro.setV_errCode(-1);
            cro.setV_errMsg(e.getMessage());
        }
        return cro;
    }

    private boolean delete(String parm) throws Exception {
        boolean isdel = false;
        String filePath = CoreGlobalConstants.SPRINGCONFIG_LOACLXMLCONFIGPATH;
        filePath = filePath.replace("%20", " ");
        SAXBuilder sh = new SAXBuilder();
        ArrayList result = new ArrayList();
        Document dc = sh.build(new File(filePath));
        Element el = dc.getRootElement();
        List beansNode = el.getChildren();
        for (Object object : beansNode) {
            Element bean1 = null;
            ListOrderedMap recode = new ListOrderedMap();
            bean1 = (Element)object;
            if (!bean1.getAttributeValue("id").equals(parm)) continue;
            isdel = true;
            el.removeContent((Content)bean1);
            break;
        }
        Format format = Format.getPrettyFormat();
        format.setEncoding("utf-8");
        XMLOutputter outputter = new XMLOutputter();
        outputter.setFormat(format);
        outputter.output(dc, (OutputStream)new FileOutputStream(filePath));
        return isdel;
    }

    public CoreReturnObject WriterConnect(String datasource, String jdbcTemp, String Dao, String driver, String url, String user, String pwd, String MaxActive, String MaxIdle, String MinIdle, String MaxWait, String IdleTime) {
        CoreReturnObject cro = new CoreReturnObject();
        String filePath = CoreGlobalConstants.SPRINGCONFIG_LOACLXMLCONFIGPATH;
        filePath = filePath.replace("%20", " ");
        SAXBuilder sh = new SAXBuilder();
        try {
            Document dc = sh.build(new File(filePath));
            Element el = dc.getRootElement();
            List beansNode = el.getChildren();
            Element bean = null;
            boolean isupdate = false;
            String oldjdbc = "";
            block2: for (Object object : beansNode) {
                Element node1;
                List beanCnode;
                bean = (Element)object;
                if (bean.getAttributeValue("id").equals(datasource)) {
                    isupdate = true;
                    bean.setAttribute("id", datasource);
                    List beanNode = bean.getChildren();
                    Element proDriverNode = (Element)beanNode.get(0);
                    Element ProurlNode = (Element)beanNode.get(1);
                    Element ProuserNode = (Element)beanNode.get(2);
                    Element ProPwdNode = (Element)beanNode.get(3);
                    Element ProMaxActiveNode = (Element)beanNode.get(4);
                    Element ProMaxIdleNode = (Element)beanNode.get(5);
                    Element ProMinIdleNode = (Element)beanNode.get(6);
                    Element ProMaxWaitNode = (Element)beanNode.get(7);
                    Element ProIdleTimeNode = (Element)beanNode.get(10);
                    proDriverNode.getChild("value").setText(driver);
                    ProurlNode.getChild("value").setText(url);
                    ProuserNode.getChild("value").setText(user);
                    ProPwdNode.getChild("value").setText(pwd);
                    ProMaxActiveNode.getChild("value").setText(MaxActive);
                    ProMaxIdleNode.getChild("value").setText(MaxIdle);
                    ProMinIdleNode.getChild("value").setText(MinIdle);
                    ProMaxWaitNode.getChild("value").setText(MaxWait);
                    ProIdleTimeNode.getChild("value").setText(IdleTime);
                }
                if (!isupdate) continue;
                if (bean.getAttributeValue("class").equals("org.springframework.jdbc.core.JdbcTemplate")) {
                    beanCnode = bean.getChildren();
                    for (Object node : beanCnode) {
                        node1 = (Element)node;
                        if (!node1.getAttributeValue("ref").equals(datasource)) continue;
                        oldjdbc = bean.getAttributeValue("id");
                        bean.setAttribute("id", jdbcTemp);
                        break;
                    }
                }
                if (!bean.getAttributeValue("class").equals("CoreFS.SA04.CoreDBProxy")) continue;
                beanCnode = bean.getChildren();
                for (Object node : beanCnode) {
                    node1 = (Element)node;
                    if (!node1.getAttributeValue("ref").equals(oldjdbc)) continue;
                    bean.setAttribute("id", Dao);
                    node1.setAttribute("ref", jdbcTemp);
                    continue block2;
                }
            }
            Format format = Format.getPrettyFormat();
            format.setEncoding("utf-8");
            XMLOutputter outputter = new XMLOutputter();
            outputter.setFormat(format);
            outputter.output(dc, (OutputStream)new FileOutputStream(filePath));
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
            cro.setV_errCode(-1);
            cro.setV_errMsg(e.getMessage());
        }
        return cro;
    }

    public CoreReturnObject AddConnect(String datasource, String jdbcTemp, String dao, String driver, String url, String user, String pwd, String MaxActive, String MaxIdle, String MinIdle, String MaxWait, String IdleTime) {
        CoreReturnObject cro = new CoreReturnObject();
        String filePath = CoreGlobalConstants.SPRINGCONFIG_LOACLXMLCONFIGPATH;
        filePath = filePath.replace("%20", " ");
        SAXBuilder sh = new SAXBuilder();
        sh.setFeature("www.springframework.org", false);
        try {
            Document dc = sh.build(new File(filePath));
            Element el = dc.getRootElement();
            this.addDatasource(el, datasource, driver, url, user, pwd, MaxActive, MaxIdle, MinIdle, MaxWait, IdleTime);
            this.addJdbcTemp(el, jdbcTemp, datasource);
            this.addDao(el, dao, jdbcTemp);
            Format format = Format.getPrettyFormat();
            format.setEncoding("utf-8");
            XMLOutputter outputter = new XMLOutputter();
            outputter.setFormat(format);
            outputter.output(dc, (OutputStream)new FileOutputStream(filePath));
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
            cro.setV_errCode(-1);
            cro.setV_errMsg(e.getMessage());
        }
        return cro;
    }

    private void addDatasource(Element root, String datasource, String driver, String url, String user, String pwd, String MaxActive, String MaxIdle, String MinIdle, String MaxWait, String IdleTime) {
        Element el = new Element("bean");
        el.setAttribute("id", datasource);
        el.setAttribute("class", "org.apache.commons.dbcp.BasicDataSource");
        el.setAttribute("destroy-method", "close");
        Element driverClassName = new Element("property");
        driverClassName.setAttribute("name", "driverClassName");
        Element clsvalue = new Element("value");
        clsvalue.setText(driver);
        driverClassName.addContent((Content)clsvalue);
        el.addContent((Content)driverClassName);
        Element dataurl = new Element("property");
        dataurl.setAttribute("name", "url");
        Element urlvalue = new Element("value");
        urlvalue.setText(url);
        dataurl.addContent((Content)urlvalue);
        el.addContent((Content)dataurl);
        Element datauser = new Element("property");
        datauser.setAttribute("name", "user");
        Element uservalue = new Element("value");
        uservalue.setText(user);
        datauser.addContent((Content)uservalue);
        el.addContent((Content)datauser);
        Element password = new Element("property");
        password.setAttribute("name", "password");
        Element pwdvalue = new Element("value");
        pwdvalue.setText(pwd);
        password.addContent((Content)pwdvalue);
        el.addContent((Content)password);
        Element maxActive = new Element("property");
        maxActive.setAttribute("name", "maxActive");
        Element actvalue = new Element("value");
        actvalue.setText(MaxActive);
        maxActive.addContent((Content)actvalue);
        el.addContent((Content)maxActive);
        Element maxIdle = new Element("property");
        maxIdle.setAttribute("name", "maxIdle");
        Element madvalue = new Element("value");
        madvalue.setText(MaxIdle);
        maxIdle.addContent((Content)madvalue);
        el.addContent((Content)maxIdle);
        Element minIdle = new Element("property");
        minIdle.setAttribute("name", "minIdle");
        Element minvalue = new Element("value");
        minvalue.setText(MinIdle);
        minIdle.addContent((Content)minvalue);
        el.addContent((Content)minIdle);
        Element maxWait = new Element("property");
        maxWait.setAttribute("name", "maxWait");
        Element maxvalue = new Element("value");
        maxvalue.setText(MaxWait);
        maxWait.addContent((Content)maxvalue);
        el.addContent((Content)maxWait);
        Element defaultAutoCommit = new Element("property");
        defaultAutoCommit.setAttribute("name", "defaultAutoCommit");
        Element commitvalue = new Element("value");
        commitvalue.setText("true");
        defaultAutoCommit.addContent((Content)commitvalue);
        el.addContent((Content)defaultAutoCommit);
        Element removeAbandoned = new Element("property");
        removeAbandoned.setAttribute("name", "removeAbandoned");
        Element abavalue = new Element("value");
        abavalue.setText("true");
        removeAbandoned.addContent((Content)abavalue);
        el.addContent((Content)removeAbandoned);
        Element removeAbandonedTimeout = new Element("property");
        removeAbandonedTimeout.setAttribute("name", "removeAbandonedTimeout");
        Element removevalue = new Element("value");
        removevalue.setText(IdleTime);
        removeAbandonedTimeout.addContent((Content)removevalue);
        el.addContent((Content)removeAbandonedTimeout);
        Element logAbandoned = new Element("property");
        logAbandoned.setAttribute("name", "logAbandoned");
        Element logvalue = new Element("value");
        logvalue.setText("true");
        logAbandoned.addContent((Content)logvalue);
        el.addContent((Content)logAbandoned);
        Element initialSize = new Element("property");
        initialSize.setAttribute("name", "initialSize");
        Element initvalue = new Element("value");
        initvalue.setText("5");
        initialSize.addContent((Content)initvalue);
        el.addContent((Content)initialSize);
        root.addContent((Content)el);
    }

    private void addJdbcTemp(Element root, String jdbcTemp, String datasource) {
        Element el = new Element("bean");
        el.setAttribute("id", jdbcTemp);
        el.setAttribute("class", "org.springframework.jdbc.core.JdbcTemplate");
        Element nel = new Element("property");
        nel.setAttribute("name", "dataSource");
        nel.setAttribute("ref", datasource);
        Element nel2 = new Element("property");
        nel2.setAttribute("name", "nativeJdbcExtractor");
        nel2.setAttribute("ref", "nativeJdbcExtractor");
        el.addContent((Content)nel);
        el.addContent((Content)nel2);
        root.addContent((Content)el);
    }

    private void addDao(Element root, String daoName, String jdbcTemp) {
        Element el = new Element("bean");
        el.setAttribute("id", daoName);
        el.setAttribute("class", "CoreFS.SA04.CoreDBProxy");
        Element nel = new Element("property");
        nel.setAttribute("name", "jdbcTemplate");
        nel.setAttribute("ref", jdbcTemp);
        Element nel2 = new Element("property");
        nel2.setAttribute("name", "lobHandler");
        nel2.setAttribute("ref", "oracleLobHandler");
        el.addContent((Content)nel);
        el.addContent((Content)nel2);
        root.addContent((Content)el);
    }

    public static void main(String[] args) {
        FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext("config/springjndiConfig.xml");
        BasicDataSource dataSource = (BasicDataSource)context.getBean("dataSource");
        dataSource.setUrl("ssssssss");
        ClassPathXmlApplicationContext contex1t = new ClassPathXmlApplicationContext("config/springjndiConfig.xml");
    }
}

