/*
 * Decompiled with CFR 0.152.
 */
package CoreFS.SD03;

import CoreFS.SA01.CoreException;

public class CoreFilePageBean {
    private int allRow;
    private int totalPage;
    private int currentPage;
    private int pageSize;
    private int totSize;
    private String path;
    private int startPos;
    private int endPos;
    private boolean isFirstPage;
    private boolean isLastPage;
    private boolean hasPreviousPage;
    private boolean hasNextPage;

    public CoreFilePageBean(String path, int pageSize) {
        this.path = path;
        this.pageSize = pageSize;
    }

    public CoreFilePageBean() {
    }

    public void init() {
        this.isFirstPage = this.isFirstPage();
        this.isLastPage = this.isLastPage();
        this.hasPreviousPage = this.isHasPreviousPage();
        this.hasNextPage = this.isHasNextPage();
    }

    public boolean isFirstPage() {
        return this.currentPage == 1;
    }

    public boolean isLastPage() {
        return this.currentPage == this.totalPage;
    }

    public boolean isHasPreviousPage() {
        return this.currentPage > 1;
    }

    public boolean isHasNextPage() {
        return this.currentPage < this.totalPage;
    }

    public int getAllRow() {
        return this.allRow;
    }

    public void setAllRow(int allRow) {
        this.allRow = allRow;
    }

    public int getTotalPage() {
        this.totalPage = this.totSize / this.pageSize + 1;
        return this.totalPage;
    }

    public void setTotalPage(int totalPage) {
        this.totalPage = totalPage;
    }

    public int getCurrentPage() {
        this.currentPage = this.currentPage >= 1 ? this.currentPage : 1;
        return this.currentPage;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getTotSize() {
        return this.totSize;
    }

    public void setTotSize(int totSize) {
        this.totSize = totSize;
    }

    public int getStartPos() {
        this.startPos = (this.currentPage - 1) * this.pageSize;
        this.startPos = this.startPos < 0 ? 0 : this.startPos;
        return this.startPos;
    }

    public void setStartPos(int startPos) {
        this.startPos = startPos;
    }

    public int getEndPos() {
        this.endPos = this.currentPage * this.pageSize - 1;
        this.endPos = this.endPos > this.totSize ? this.totSize : this.endPos;
        return this.endPos;
    }

    public void setEndPos(int endPos) {
        this.endPos = endPos;
    }

    public boolean goable() {
        boolean goable = true;
        if (this.currentPage > this.totalPage || this.currentPage < 1) {
            goable = false;
            throw new CoreException("\u5f53\u524d\u9875\u5927\u4e8e\u6700\u5927\u9875 \u6216\u8005\u5f53\u524d\u9875\u4e3a < 1");
        }
        if (this.startPos < 0 || this.startPos > this.endPos) {
            goable = false;
            throw new CoreException("\u5f53\u524d\u5f00\u59cb\u4f4d\u7f6e<0 \u6216\u8005\u5f53\u524d\u5f00\u59cb\u4f4d\u7f6e\u8d85\u8fc7\u7ed3\u675f\u4f4d\u7f6e");
        }
        if (this.endPos < 0 || this.endPos > this.totSize) {
            goable = false;
            throw new CoreException("\u5f53\u524d\u7ed3\u675f\u4f4d\u7f6e<0 \u6216\u8005\u5f53\u524d\u4f4d\u7f6e\u8d85\u8fc7\u6700\u5927\u957f\u5ea6");
        }
        return goable;
    }
}

