/*
 * Decompiled with CFR 0.152.
 */
package CoreFS.SD03;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DayRollingFileAppender
extends FileAppender {
    private final String datePattern = "'.'yyyy-MM-dd";
    private int maxBackupIndex = 2;
    private String scheduledFilename;
    private long nextCheck = System.currentTimeMillis() - 1L;
    Date now = new Date();
    SimpleDateFormat sdf;

    public DayRollingFileAppender() {
    }

    public DayRollingFileAppender(Layout layout, String filename, int maxBackupIndex) throws IOException {
        super(layout, filename, true);
        this.maxBackupIndex = maxBackupIndex;
        this.activateOptions();
    }

    public void activateOptions() {
        super.activateOptions();
        if (this.fileName != null) {
            this.now.setTime(System.currentTimeMillis());
            this.sdf = new SimpleDateFormat("'.'yyyy-MM-dd");
            File file = new File(this.fileName);
            this.scheduledFilename = String.valueOf(this.fileName) + this.sdf.format(new Date(file.lastModified()));
        } else {
            LogLog.error((String)("File is not set for appender [" + this.name + "]."));
        }
        if (this.maxBackupIndex <= 0) {
            LogLog.error((String)("maxBackupIndex reset to default value[2],orignal value is:" + this.maxBackupIndex));
            this.maxBackupIndex = 2;
        }
    }

    void rollOver() throws IOException {
        File file;
        boolean result;
        String datedFilename = String.valueOf(this.fileName) + this.sdf.format(this.now);
        if (this.scheduledFilename.equals(datedFilename)) {
            return;
        }
        this.closeFile();
        File target = new File(this.scheduledFilename);
        if (target.exists()) {
            target.delete();
        }
        if (result = (file = new File(this.fileName)).renameTo(target)) {
            LogLog.debug((String)(String.valueOf(this.fileName) + " -> " + this.scheduledFilename));
        } else {
            LogLog.error((String)("Failed to rename [" + this.fileName + "] to [" + this.scheduledFilename + "]."));
        }
        if (this.maxBackupIndex > 0) {
            File folder = new File(file.getParent());
            List<String> maxBackupIndexDates = this.getMaxBackupIndexDates();
            File[] fileArray = folder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File ff = fileArray[n2];
                if (ff.getName().startsWith(file.getName()) && !ff.getName().equals(file.getName())) {
                    String markedDate = ff.getName().substring(file.getName().length());
                    if (!maxBackupIndexDates.contains(markedDate)) {
                        result = ff.delete();
                    }
                    if (result) {
                        LogLog.debug((String)(String.valueOf(ff.getName()) + " ->deleted "));
                    } else {
                        LogLog.error((String)("Failed to deleted old DayRollingFileAppender file :" + ff.getName()));
                    }
                }
                ++n2;
            }
        }
        try {
            this.setFile(this.fileName, false, this.bufferedIO, this.bufferSize);
        }
        catch (IOException e) {
            this.errorHandler.error("setFile(" + this.fileName + ", false) call failed.");
        }
        this.scheduledFilename = datedFilename;
    }

    protected void subAppend(LoggingEvent event) {
        long n = System.currentTimeMillis();
        if (n >= this.nextCheck) {
            this.now.setTime(n);
            this.nextCheck = this.getNextDayCheckPoint(this.now);
            try {
                this.rollOver();
            }
            catch (IOException ioe) {
                LogLog.error((String)"rollOver() failed.", (Throwable)ioe);
            }
        }
        super.subAppend(event);
    }

    long getNextDayCheckPoint(Date now) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.add(5, 1);
        return calendar.getTimeInMillis();
    }

    List<String> getMaxBackupIndexDates() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.maxBackupIndex > 0) {
            int i = 1;
            while (i <= this.maxBackupIndex) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(this.now);
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                calendar.add(5, -i);
                result.add(this.sdf.format(calendar.getTime()));
                ++i;
            }
        }
        return result;
    }

    public int getMaxBackupIndex() {
        return this.maxBackupIndex;
    }

    public void setMaxBackupIndex(int maxBackupIndex) {
        this.maxBackupIndex = maxBackupIndex;
    }

    public String getDatePattern() {
        return "'.'yyyy-MM-dd";
    }
}

