/*
 * Decompiled with CFR 0.152.
 */
package CoreFS.SD05;

import CoreFS.SD05.SchedulerService;
import java.text.ParseException;
import java.util.Date;
import java.util.UUID;
import org.quartz.CronExpression;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="schedulerService")
public class SchedulerServiceImpl
implements SchedulerService {
    private Scheduler scheduler = null;
    private JobDetail jobDetail = null;

    @Autowired
    public void setJobDetail(@Qualifier(value="jobDetail") JobDetail jobDetail) {
        this.jobDetail = jobDetail;
    }

    @Autowired
    public void setScheduler(@Qualifier(value="quartzScheduler") Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void schedule(String cronExpression) {
        this.schedule(null, cronExpression);
    }

    public void schedule(String name, String cronExpression) {
        try {
            this.schedule(name, new CronExpression(cronExpression));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public void schedule(CronExpression cronExpression) {
        this.schedule(null, cronExpression);
    }

    public void schedule(String name, CronExpression cronExpression) {
        if (name == null || name.trim().equals("")) {
            name = UUID.randomUUID().toString();
        }
        try {
            CronTrigger cronTrigger = (CronTrigger)this.scheduler.getTrigger(name, "DEFAULT");
            if (cronTrigger == null) {
                this.scheduler.addJob(this.jobDetail, true);
                cronTrigger = new CronTrigger(name, "DEFAULT", this.jobDetail.getName(), "DEFAULT");
                cronTrigger.setCronExpression(cronExpression);
                this.scheduler.scheduleJob((Trigger)cronTrigger);
                this.scheduler.rescheduleJob(name, "DEFAULT", (Trigger)cronTrigger);
            }
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    public void schedule(Date startTime) {
        this.schedule(startTime, null);
    }

    public void schedule(String name, Date startTime) {
        this.schedule(name, startTime, null);
    }

    public void schedule(Date startTime, Date endTime) {
        this.schedule(startTime, endTime, 0);
    }

    public void schedule(String name, Date startTime, Date endTime) {
        this.schedule(name, startTime, endTime, 0);
    }

    public void schedule(Date startTime, Date endTime, int repeatCount) {
        this.schedule(null, startTime, endTime, 0);
    }

    public void schedule(String name, Date startTime, Date endTime, int repeatCount) {
        this.schedule(name, startTime, endTime, 0, 0L);
    }

    public void schedule(Date startTime, Date endTime, int repeatCount, long repeatInterval) {
        this.schedule(null, startTime, endTime, repeatCount, repeatInterval);
    }

    public void schedule(String name, Date startTime, Date endTime, int repeatCount, long repeatInterval) {
        if (name == null || name.trim().equals("")) {
            name = UUID.randomUUID().toString();
        }
        try {
            this.scheduler.addJob(this.jobDetail, true);
            SimpleTrigger SimpleTrigger2 = new SimpleTrigger(name, "DEFAULT", this.jobDetail.getName(), "DEFAULT", startTime, endTime, repeatCount, repeatInterval);
            this.scheduler.scheduleJob((Trigger)SimpleTrigger2);
            this.scheduler.rescheduleJob(name, "DEFAULT", (Trigger)SimpleTrigger2);
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeJob(String jobName) {
        try {
            this.scheduler.pauseTrigger(jobName, "DEFAULT");
            this.scheduler.unscheduleJob(jobName, "DEFAULT");
            this.scheduler.deleteJob(jobName, "DEFAULT");
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
    }
}

