// **********************************************************************
//
// Copyright (c) 2003-2010 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************

// Ice version 3.4.1

package Glacier2;

// <auto-generated>
//
// Generated from file `Session.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>


/**
 * An object for managing the set of object identity constraints on a
 * {@link Session}. 
 * 
 * @see Session
 * @see SessionControl
 * 
 **/
public final class IdentitySetPrxHelper extends Ice.ObjectPrxHelperBase implements IdentitySetPrx
{
    /**
     * Add a sequence of Ice identities to this set of constraints. Order is
     * not preserved and duplicates are implicitly removed.
     * 
     * @param additions The sequence of Ice identities to be added.
     * 
     **/
    public void
    add(Ice.Identity[] additions)
    {
        add(additions, null, false);
    }

    /**
     * Add a sequence of Ice identities to this set of constraints. Order is
     * not preserved and duplicates are implicitly removed.
     * 
     * @param additions The sequence of Ice identities to be added.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void
    add(Ice.Identity[] additions, java.util.Map<String, String> __ctx)
    {
        add(additions, __ctx, true);
    }

    private void
    add(Ice.Identity[] additions, java.util.Map<String, String> __ctx, boolean __explicitCtx)
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __delBase = __getDelegate(false);
                _IdentitySetDel __del = (_IdentitySetDel)__delBase;
                __del.add(additions, __ctx);
                return;
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __add_name = "add";

    /**
     * Add a sequence of Ice identities to this set of constraints. Order is
     * not preserved and duplicates are implicitly removed.
     * 
     * @param __cb The callback object for the operation.
     * @param additions The sequence of Ice identities to be added.
     * 
     **/
    public Ice.AsyncResult begin_add(Ice.Identity[] additions)
    {
        return begin_add(additions, null, false, null);
    }

    /**
     * Add a sequence of Ice identities to this set of constraints. Order is
     * not preserved and duplicates are implicitly removed.
     * 
     * @param __cb The callback object for the operation.
     * @param additions The sequence of Ice identities to be added.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_add(Ice.Identity[] additions, java.util.Map<String, String> __ctx)
    {
        return begin_add(additions, __ctx, true, null);
    }

    /**
     * Add a sequence of Ice identities to this set of constraints. Order is
     * not preserved and duplicates are implicitly removed.
     * 
     * @param __cb The callback object for the operation.
     * @param additions The sequence of Ice identities to be added.
     * 
     **/
    public Ice.AsyncResult begin_add(Ice.Identity[] additions, Ice.Callback __cb)
    {
        return begin_add(additions, null, false, __cb);
    }

    /**
     * Add a sequence of Ice identities to this set of constraints. Order is
     * not preserved and duplicates are implicitly removed.
     * 
     * @param __cb The callback object for the operation.
     * @param additions The sequence of Ice identities to be added.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_add(Ice.Identity[] additions, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_add(additions, __ctx, true, __cb);
    }

    /**
     * Add a sequence of Ice identities to this set of constraints. Order is
     * not preserved and duplicates are implicitly removed.
     * 
     * @param __cb The callback object for the operation.
     * @param additions The sequence of Ice identities to be added.
     * 
     **/
    public Ice.AsyncResult begin_add(Ice.Identity[] additions, Callback_IdentitySet_add __cb)
    {
        return begin_add(additions, null, false, __cb);
    }

    /**
     * Add a sequence of Ice identities to this set of constraints. Order is
     * not preserved and duplicates are implicitly removed.
     * 
     * @param __cb The callback object for the operation.
     * @param additions The sequence of Ice identities to be added.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_add(Ice.Identity[] additions, java.util.Map<String, String> __ctx, Callback_IdentitySet_add __cb)
    {
        return begin_add(additions, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_add(Ice.Identity[] additions, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __add_name, __cb);
        try
        {
            __result.__prepare(__add_name, Ice.OperationMode.Idempotent, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            Ice.IdentitySeqHelper.write(__os, additions);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     **/
    public void end_add(Ice.AsyncResult __result)
    {
        __end(__result, __add_name);
    }

    /**
     * Returns a sequence of identities describing the constraints in this
     * set.
     * 
     * @return The sequence of Ice identities for this set. 
     * 
     **/
    public Ice.Identity[]
    get()
    {
        return get(null, false);
    }

    /**
     * Returns a sequence of identities describing the constraints in this
     * set.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The sequence of Ice identities for this set. 
     * 
     **/
    public Ice.Identity[]
    get(java.util.Map<String, String> __ctx)
    {
        return get(__ctx, true);
    }

    private Ice.Identity[]
    get(java.util.Map<String, String> __ctx, boolean __explicitCtx)
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("get");
                __delBase = __getDelegate(false);
                _IdentitySetDel __del = (_IdentitySetDel)__delBase;
                return __del.get(__ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __get_name = "get";

    /**
     * Returns a sequence of identities describing the constraints in this
     * set.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_get()
    {
        return begin_get(null, false, null);
    }

    /**
     * Returns a sequence of identities describing the constraints in this
     * set.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_get(java.util.Map<String, String> __ctx)
    {
        return begin_get(__ctx, true, null);
    }

    /**
     * Returns a sequence of identities describing the constraints in this
     * set.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_get(Ice.Callback __cb)
    {
        return begin_get(null, false, __cb);
    }

    /**
     * Returns a sequence of identities describing the constraints in this
     * set.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_get(java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_get(__ctx, true, __cb);
    }

    /**
     * Returns a sequence of identities describing the constraints in this
     * set.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_get(Callback_IdentitySet_get __cb)
    {
        return begin_get(null, false, __cb);
    }

    /**
     * Returns a sequence of identities describing the constraints in this
     * set.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_get(java.util.Map<String, String> __ctx, Callback_IdentitySet_get __cb)
    {
        return begin_get(__ctx, true, __cb);
    }

    private Ice.AsyncResult begin_get(java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__get_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __get_name, __cb);
        try
        {
            __result.__prepare(__get_name, Ice.OperationMode.Idempotent, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) The sequence of Ice identities for this set. 
     * 
     **/
    public Ice.Identity[] end_get(Ice.AsyncResult __result)
    {
        Ice.AsyncResult.__check(__result, this, __get_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        Ice.Identity[] __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = Ice.IdentitySeqHelper.read(__is);
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Remove a sequence of identities from this set of constraints. No
     * errors are returned if an entry is not found.
     * 
     * @param deletions The sequence of Ice identities to be removed.
     * 
     **/
    public void
    remove(Ice.Identity[] deletions)
    {
        remove(deletions, null, false);
    }

    /**
     * Remove a sequence of identities from this set of constraints. No
     * errors are returned if an entry is not found.
     * 
     * @param deletions The sequence of Ice identities to be removed.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void
    remove(Ice.Identity[] deletions, java.util.Map<String, String> __ctx)
    {
        remove(deletions, __ctx, true);
    }

    private void
    remove(Ice.Identity[] deletions, java.util.Map<String, String> __ctx, boolean __explicitCtx)
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __delBase = __getDelegate(false);
                _IdentitySetDel __del = (_IdentitySetDel)__delBase;
                __del.remove(deletions, __ctx);
                return;
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __remove_name = "remove";

    /**
     * Remove a sequence of identities from this set of constraints. No
     * errors are returned if an entry is not found.
     * 
     * @param __cb The callback object for the operation.
     * @param deletions The sequence of Ice identities to be removed.
     * 
     **/
    public Ice.AsyncResult begin_remove(Ice.Identity[] deletions)
    {
        return begin_remove(deletions, null, false, null);
    }

    /**
     * Remove a sequence of identities from this set of constraints. No
     * errors are returned if an entry is not found.
     * 
     * @param __cb The callback object for the operation.
     * @param deletions The sequence of Ice identities to be removed.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_remove(Ice.Identity[] deletions, java.util.Map<String, String> __ctx)
    {
        return begin_remove(deletions, __ctx, true, null);
    }

    /**
     * Remove a sequence of identities from this set of constraints. No
     * errors are returned if an entry is not found.
     * 
     * @param __cb The callback object for the operation.
     * @param deletions The sequence of Ice identities to be removed.
     * 
     **/
    public Ice.AsyncResult begin_remove(Ice.Identity[] deletions, Ice.Callback __cb)
    {
        return begin_remove(deletions, null, false, __cb);
    }

    /**
     * Remove a sequence of identities from this set of constraints. No
     * errors are returned if an entry is not found.
     * 
     * @param __cb The callback object for the operation.
     * @param deletions The sequence of Ice identities to be removed.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_remove(Ice.Identity[] deletions, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_remove(deletions, __ctx, true, __cb);
    }

    /**
     * Remove a sequence of identities from this set of constraints. No
     * errors are returned if an entry is not found.
     * 
     * @param __cb The callback object for the operation.
     * @param deletions The sequence of Ice identities to be removed.
     * 
     **/
    public Ice.AsyncResult begin_remove(Ice.Identity[] deletions, Callback_IdentitySet_remove __cb)
    {
        return begin_remove(deletions, null, false, __cb);
    }

    /**
     * Remove a sequence of identities from this set of constraints. No
     * errors are returned if an entry is not found.
     * 
     * @param __cb The callback object for the operation.
     * @param deletions The sequence of Ice identities to be removed.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_remove(Ice.Identity[] deletions, java.util.Map<String, String> __ctx, Callback_IdentitySet_remove __cb)
    {
        return begin_remove(deletions, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_remove(Ice.Identity[] deletions, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __remove_name, __cb);
        try
        {
            __result.__prepare(__remove_name, Ice.OperationMode.Idempotent, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            Ice.IdentitySeqHelper.write(__os, deletions);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     **/
    public void end_remove(Ice.AsyncResult __result)
    {
        __end(__result, __remove_name);
    }

    public static IdentitySetPrx
    checkedCast(Ice.ObjectPrx __obj)
    {
        IdentitySetPrx __d = null;
        if(__obj != null)
        {
            try
            {
                __d = (IdentitySetPrx)__obj;
            }
            catch(ClassCastException ex)
            {
                if(__obj.ice_isA("::Glacier2::IdentitySet"))
                {
                    IdentitySetPrxHelper __h = new IdentitySetPrxHelper();
                    __h.__copyFrom(__obj);
                    __d = __h;
                }
            }
        }
        return __d;
    }

    public static IdentitySetPrx
    checkedCast(Ice.ObjectPrx __obj, java.util.Map<String, String> __ctx)
    {
        IdentitySetPrx __d = null;
        if(__obj != null)
        {
            try
            {
                __d = (IdentitySetPrx)__obj;
            }
            catch(ClassCastException ex)
            {
                if(__obj.ice_isA("::Glacier2::IdentitySet", __ctx))
                {
                    IdentitySetPrxHelper __h = new IdentitySetPrxHelper();
                    __h.__copyFrom(__obj);
                    __d = __h;
                }
            }
        }
        return __d;
    }

    public static IdentitySetPrx
    checkedCast(Ice.ObjectPrx __obj, String __facet)
    {
        IdentitySetPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            try
            {
                if(__bb.ice_isA("::Glacier2::IdentitySet"))
                {
                    IdentitySetPrxHelper __h = new IdentitySetPrxHelper();
                    __h.__copyFrom(__bb);
                    __d = __h;
                }
            }
            catch(Ice.FacetNotExistException ex)
            {
            }
        }
        return __d;
    }

    public static IdentitySetPrx
    checkedCast(Ice.ObjectPrx __obj, String __facet, java.util.Map<String, String> __ctx)
    {
        IdentitySetPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            try
            {
                if(__bb.ice_isA("::Glacier2::IdentitySet", __ctx))
                {
                    IdentitySetPrxHelper __h = new IdentitySetPrxHelper();
                    __h.__copyFrom(__bb);
                    __d = __h;
                }
            }
            catch(Ice.FacetNotExistException ex)
            {
            }
        }
        return __d;
    }

    public static IdentitySetPrx
    uncheckedCast(Ice.ObjectPrx __obj)
    {
        IdentitySetPrx __d = null;
        if(__obj != null)
        {
            try
            {
                __d = (IdentitySetPrx)__obj;
            }
            catch(ClassCastException ex)
            {
                IdentitySetPrxHelper __h = new IdentitySetPrxHelper();
                __h.__copyFrom(__obj);
                __d = __h;
            }
        }
        return __d;
    }

    public static IdentitySetPrx
    uncheckedCast(Ice.ObjectPrx __obj, String __facet)
    {
        IdentitySetPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            IdentitySetPrxHelper __h = new IdentitySetPrxHelper();
            __h.__copyFrom(__bb);
            __d = __h;
        }
        return __d;
    }

    protected Ice._ObjectDelM
    __createDelegateM()
    {
        return new _IdentitySetDelM();
    }

    protected Ice._ObjectDelD
    __createDelegateD()
    {
        return new _IdentitySetDelD();
    }

    public static void
    __write(IceInternal.BasicStream __os, IdentitySetPrx v)
    {
        __os.writeProxy(v);
    }

    public static IdentitySetPrx
    __read(IceInternal.BasicStream __is)
    {
        Ice.ObjectPrx proxy = __is.readProxy();
        if(proxy != null)
        {
            IdentitySetPrxHelper result = new IdentitySetPrxHelper();
            result.__copyFrom(proxy);
            return result;
        }
        return null;
    }
}
