// **********************************************************************
//
// Copyright (c) 2003-2010 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************

// Ice version 3.4.1

package Glacier2;

// <auto-generated>
//
// Generated from file `PermissionsVerifier.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>


/**
 * The Glacier2 permissions verifier. This is called through the
 * process of establishing a session.
 * 
 * @see Router
 * 
 **/
public interface PermissionsVerifierPrx extends Ice.ObjectPrx
{
    /**
     * Check whether a user has permission to access the router.
     * 
     * @param userId The user id for which to check permission.
     * 
     * @param password The user's password.
     * 
     * @param reason The reason why access was denied.
     * 
     * @return True if access is granted, or false otherwise.
     * 
     **/
    public boolean checkPermissions(String userId, String password, Ice.StringHolder reason);

    /**
     * Check whether a user has permission to access the router.
     * 
     * @param userId The user id for which to check permission.
     * 
     * @param password The user's password.
     * 
     * @param reason The reason why access was denied.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return True if access is granted, or false otherwise.
     * 
     **/
    public boolean checkPermissions(String userId, String password, Ice.StringHolder reason, java.util.Map<String, String> __ctx);

    /**
     * Check whether a user has permission to access the router.
     * 
     * @param userId The user id for which to check permission.
     * 
     * @param password The user's password.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_checkPermissions(String userId, String password);

    /**
     * Check whether a user has permission to access the router.
     * 
     * @param userId The user id for which to check permission.
     * 
     * @param password The user's password.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_checkPermissions(String userId, String password, java.util.Map<String, String> __ctx);

    /**
     * Check whether a user has permission to access the router.
     * 
     * @param userId The user id for which to check permission.
     * 
     * @param password The user's password.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_checkPermissions(String userId, String password, Ice.Callback __cb);

    /**
     * Check whether a user has permission to access the router.
     * 
     * @param userId The user id for which to check permission.
     * 
     * @param password The user's password.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_checkPermissions(String userId, String password, java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Check whether a user has permission to access the router.
     * 
     * @param userId The user id for which to check permission.
     * 
     * @param password The user's password.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_checkPermissions(String userId, String password, Callback_PermissionsVerifier_checkPermissions __cb);

    /**
     * Check whether a user has permission to access the router.
     * 
     * @param userId The user id for which to check permission.
     * 
     * @param password The user's password.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_checkPermissions(String userId, String password, java.util.Map<String, String> __ctx, Callback_PermissionsVerifier_checkPermissions __cb);

    /**
     * Check whether a user has permission to access the router.
     * 
     * @param reason The reason why access was denied.
     * 
     * @param __result The asynchronous result object.
     * @return True if access is granted, or false otherwise.
     * 
     **/
    public boolean end_checkPermissions(Ice.StringHolder reason, Ice.AsyncResult __result);

    /**
     * Check whether a user has permission to access the router.
     * 
     * @param __cb The callback object for the operation.
     * @param userId The user id for which to check permission.
     * 
     * @param password The user's password.
     * 
     **/
    public boolean checkPermissions_async(AMI_PermissionsVerifier_checkPermissions __cb, String userId, String password);

    /**
     * Check whether a user has permission to access the router.
     * 
     * @param __cb The callback object for the operation.
     * @param userId The user id for which to check permission.
     * 
     * @param password The user's password.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public boolean checkPermissions_async(AMI_PermissionsVerifier_checkPermissions __cb, String userId, String password, java.util.Map<String, String> __ctx);
}
