// **********************************************************************
//
// Copyright (c) 2003-2010 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************

// Ice version 3.4.1

package Glacier2;

// <auto-generated>
//
// Generated from file `Router.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>


/**
 * The Glacier2 specialization of the {@link Ice.Router}
 * interface.
 * 
 **/
public final class RouterPrxHelper extends Ice.ObjectPrxHelperBase implements RouterPrx
{
    /**
     * Create a per-client session with the router. If a
     * {@link SessionManager} has been installed, a proxy to a {@link Session}
     * object is returned to the client. Otherwise, null is returned
     * and only an internal session (i.e., not visible to the client)
     * is created.
     * 
     * If a session proxy is returned, it must be configured to route
     * through the router that created it. This will happen automatically
     * if the router is configured as the client's default router at the
     * time the session proxy is created in the client process, otherwise
     * the client must configure the session proxy explicitly.
     * 
     * @see Session
     * @see SessionManager
     * @see PermissionsVerifier
     * 
     * @return A proxy for the newly created session, or null if no
     * {@link SessionManager} has been installed.
     * 
     * @param userId The user id for which to check the password.
     * 
     * @param password The password for the given user id.
     * 
     * @throws PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     * 
     * @throws CannotCreateSessionException Raised if the session
     * cannot be created.
     * 
     **/
    public SessionPrx
    createSession(String userId, String password)
        throws CannotCreateSessionException,
               PermissionDeniedException
    {
        return createSession(userId, password, null, false);
    }

    /**
     * Create a per-client session with the router. If a
     * {@link SessionManager} has been installed, a proxy to a {@link Session}
     * object is returned to the client. Otherwise, null is returned
     * and only an internal session (i.e., not visible to the client)
     * is created.
     * 
     * If a session proxy is returned, it must be configured to route
     * through the router that created it. This will happen automatically
     * if the router is configured as the client's default router at the
     * time the session proxy is created in the client process, otherwise
     * the client must configure the session proxy explicitly.
     * 
     * @see Session
     * @see SessionManager
     * @see PermissionsVerifier
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return A proxy for the newly created session, or null if no
     * {@link SessionManager} has been installed.
     * 
     * @param userId The user id for which to check the password.
     * 
     * @param password The password for the given user id.
     * 
     * @throws PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     * 
     * @throws CannotCreateSessionException Raised if the session
     * cannot be created.
     * 
     **/
    public SessionPrx
    createSession(String userId, String password, java.util.Map<String, String> __ctx)
        throws CannotCreateSessionException,
               PermissionDeniedException
    {
        return createSession(userId, password, __ctx, true);
    }

    private SessionPrx
    createSession(String userId, String password, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws CannotCreateSessionException,
               PermissionDeniedException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("createSession");
                __delBase = __getDelegate(false);
                _RouterDel __del = (_RouterDel)__delBase;
                return __del.createSession(userId, password, __ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __createSession_name = "createSession";

    /**
     * Create a per-client session with the router. If a
     * {@link SessionManager} has been installed, a proxy to a {@link Session}
     * object is returned to the client. Otherwise, null is returned
     * and only an internal session (i.e., not visible to the client)
     * is created.
     * 
     * If a session proxy is returned, it must be configured to route
     * through the router that created it. This will happen automatically
     * if the router is configured as the client's default router at the
     * time the session proxy is created in the client process, otherwise
     * the client must configure the session proxy explicitly.
     * 
     * @param __cb The callback object for the operation.
     * @param userId The user id for which to check the password.
     * 
     * @param password The password for the given user id.
     * 
     **/
    public Ice.AsyncResult begin_createSession(String userId, String password)
    {
        return begin_createSession(userId, password, null, false, null);
    }

    /**
     * Create a per-client session with the router. If a
     * {@link SessionManager} has been installed, a proxy to a {@link Session}
     * object is returned to the client. Otherwise, null is returned
     * and only an internal session (i.e., not visible to the client)
     * is created.
     * 
     * If a session proxy is returned, it must be configured to route
     * through the router that created it. This will happen automatically
     * if the router is configured as the client's default router at the
     * time the session proxy is created in the client process, otherwise
     * the client must configure the session proxy explicitly.
     * 
     * @param __cb The callback object for the operation.
     * @param userId The user id for which to check the password.
     * 
     * @param password The password for the given user id.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_createSession(String userId, String password, java.util.Map<String, String> __ctx)
    {
        return begin_createSession(userId, password, __ctx, true, null);
    }

    /**
     * Create a per-client session with the router. If a
     * {@link SessionManager} has been installed, a proxy to a {@link Session}
     * object is returned to the client. Otherwise, null is returned
     * and only an internal session (i.e., not visible to the client)
     * is created.
     * 
     * If a session proxy is returned, it must be configured to route
     * through the router that created it. This will happen automatically
     * if the router is configured as the client's default router at the
     * time the session proxy is created in the client process, otherwise
     * the client must configure the session proxy explicitly.
     * 
     * @param __cb The callback object for the operation.
     * @param userId The user id for which to check the password.
     * 
     * @param password The password for the given user id.
     * 
     **/
    public Ice.AsyncResult begin_createSession(String userId, String password, Ice.Callback __cb)
    {
        return begin_createSession(userId, password, null, false, __cb);
    }

    /**
     * Create a per-client session with the router. If a
     * {@link SessionManager} has been installed, a proxy to a {@link Session}
     * object is returned to the client. Otherwise, null is returned
     * and only an internal session (i.e., not visible to the client)
     * is created.
     * 
     * If a session proxy is returned, it must be configured to route
     * through the router that created it. This will happen automatically
     * if the router is configured as the client's default router at the
     * time the session proxy is created in the client process, otherwise
     * the client must configure the session proxy explicitly.
     * 
     * @param __cb The callback object for the operation.
     * @param userId The user id for which to check the password.
     * 
     * @param password The password for the given user id.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_createSession(String userId, String password, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_createSession(userId, password, __ctx, true, __cb);
    }

    /**
     * Create a per-client session with the router. If a
     * {@link SessionManager} has been installed, a proxy to a {@link Session}
     * object is returned to the client. Otherwise, null is returned
     * and only an internal session (i.e., not visible to the client)
     * is created.
     * 
     * If a session proxy is returned, it must be configured to route
     * through the router that created it. This will happen automatically
     * if the router is configured as the client's default router at the
     * time the session proxy is created in the client process, otherwise
     * the client must configure the session proxy explicitly.
     * 
     * @param __cb The callback object for the operation.
     * @param userId The user id for which to check the password.
     * 
     * @param password The password for the given user id.
     * 
     **/
    public Ice.AsyncResult begin_createSession(String userId, String password, Callback_Router_createSession __cb)
    {
        return begin_createSession(userId, password, null, false, __cb);
    }

    /**
     * Create a per-client session with the router. If a
     * {@link SessionManager} has been installed, a proxy to a {@link Session}
     * object is returned to the client. Otherwise, null is returned
     * and only an internal session (i.e., not visible to the client)
     * is created.
     * 
     * If a session proxy is returned, it must be configured to route
     * through the router that created it. This will happen automatically
     * if the router is configured as the client's default router at the
     * time the session proxy is created in the client process, otherwise
     * the client must configure the session proxy explicitly.
     * 
     * @param __cb The callback object for the operation.
     * @param userId The user id for which to check the password.
     * 
     * @param password The password for the given user id.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_createSession(String userId, String password, java.util.Map<String, String> __ctx, Callback_Router_createSession __cb)
    {
        return begin_createSession(userId, password, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_createSession(String userId, String password, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__createSession_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __createSession_name, __cb);
        try
        {
            __result.__prepare(__createSession_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.writeString(userId);
            __os.writeString(password);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) A proxy for the newly created session, or null if no
     * {@link SessionManager} has been installed.
     * 
     **/
    public SessionPrx end_createSession(Ice.AsyncResult __result)
        throws CannotCreateSessionException,
               PermissionDeniedException
    {
        Ice.AsyncResult.__check(__result, this, __createSession_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(CannotCreateSessionException __ex)
            {
                throw __ex;
            }
            catch(PermissionDeniedException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        SessionPrx __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = SessionPrxHelper.__read(__is);
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Create a per-client session with the router. The user is
     * authenticated through the SSL certificates that have been
     * associated with the connection. If a {@link SessionManager} has been
     * installed, a proxy to a {@link Session} object is returned to the
     * client. Otherwise, null is returned and only an internal
     * session (i.e., not visible to the client) is created.
     * 
     * If a session proxy is returned, it must be configured to route
     * through the router that created it. This will happen automatically
     * if the router is configured as the client's default router at the
     * time the session proxy is created in the client process, otherwise
     * the client must configure the session proxy explicitly.
     * 
     * @see Session
     * @see SessionManager
     * @see PermissionsVerifier
     * 
     * @return A proxy for the newly created session, or null if no
     * {@link SessionManager} has been installed.
     * 
     * @throws PermissionDeniedException Raised if the user cannot be
     * authenticated or if the user is not allowed access.
     * 
     * @throws CannotCreateSessionException Raised if the session
     * cannot be created.
     * 
     **/
    public SessionPrx
    createSessionFromSecureConnection()
        throws CannotCreateSessionException,
               PermissionDeniedException
    {
        return createSessionFromSecureConnection(null, false);
    }

    /**
     * Create a per-client session with the router. The user is
     * authenticated through the SSL certificates that have been
     * associated with the connection. If a {@link SessionManager} has been
     * installed, a proxy to a {@link Session} object is returned to the
     * client. Otherwise, null is returned and only an internal
     * session (i.e., not visible to the client) is created.
     * 
     * If a session proxy is returned, it must be configured to route
     * through the router that created it. This will happen automatically
     * if the router is configured as the client's default router at the
     * time the session proxy is created in the client process, otherwise
     * the client must configure the session proxy explicitly.
     * 
     * @see Session
     * @see SessionManager
     * @see PermissionsVerifier
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return A proxy for the newly created session, or null if no
     * {@link SessionManager} has been installed.
     * 
     * @throws PermissionDeniedException Raised if the user cannot be
     * authenticated or if the user is not allowed access.
     * 
     * @throws CannotCreateSessionException Raised if the session
     * cannot be created.
     * 
     **/
    public SessionPrx
    createSessionFromSecureConnection(java.util.Map<String, String> __ctx)
        throws CannotCreateSessionException,
               PermissionDeniedException
    {
        return createSessionFromSecureConnection(__ctx, true);
    }

    private SessionPrx
    createSessionFromSecureConnection(java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws CannotCreateSessionException,
               PermissionDeniedException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("createSessionFromSecureConnection");
                __delBase = __getDelegate(false);
                _RouterDel __del = (_RouterDel)__delBase;
                return __del.createSessionFromSecureConnection(__ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __createSessionFromSecureConnection_name = "createSessionFromSecureConnection";

    /**
     * Create a per-client session with the router. The user is
     * authenticated through the SSL certificates that have been
     * associated with the connection. If a {@link SessionManager} has been
     * installed, a proxy to a {@link Session} object is returned to the
     * client. Otherwise, null is returned and only an internal
     * session (i.e., not visible to the client) is created.
     * 
     * If a session proxy is returned, it must be configured to route
     * through the router that created it. This will happen automatically
     * if the router is configured as the client's default router at the
     * time the session proxy is created in the client process, otherwise
     * the client must configure the session proxy explicitly.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_createSessionFromSecureConnection()
    {
        return begin_createSessionFromSecureConnection(null, false, null);
    }

    /**
     * Create a per-client session with the router. The user is
     * authenticated through the SSL certificates that have been
     * associated with the connection. If a {@link SessionManager} has been
     * installed, a proxy to a {@link Session} object is returned to the
     * client. Otherwise, null is returned and only an internal
     * session (i.e., not visible to the client) is created.
     * 
     * If a session proxy is returned, it must be configured to route
     * through the router that created it. This will happen automatically
     * if the router is configured as the client's default router at the
     * time the session proxy is created in the client process, otherwise
     * the client must configure the session proxy explicitly.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_createSessionFromSecureConnection(java.util.Map<String, String> __ctx)
    {
        return begin_createSessionFromSecureConnection(__ctx, true, null);
    }

    /**
     * Create a per-client session with the router. The user is
     * authenticated through the SSL certificates that have been
     * associated with the connection. If a {@link SessionManager} has been
     * installed, a proxy to a {@link Session} object is returned to the
     * client. Otherwise, null is returned and only an internal
     * session (i.e., not visible to the client) is created.
     * 
     * If a session proxy is returned, it must be configured to route
     * through the router that created it. This will happen automatically
     * if the router is configured as the client's default router at the
     * time the session proxy is created in the client process, otherwise
     * the client must configure the session proxy explicitly.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_createSessionFromSecureConnection(Ice.Callback __cb)
    {
        return begin_createSessionFromSecureConnection(null, false, __cb);
    }

    /**
     * Create a per-client session with the router. The user is
     * authenticated through the SSL certificates that have been
     * associated with the connection. If a {@link SessionManager} has been
     * installed, a proxy to a {@link Session} object is returned to the
     * client. Otherwise, null is returned and only an internal
     * session (i.e., not visible to the client) is created.
     * 
     * If a session proxy is returned, it must be configured to route
     * through the router that created it. This will happen automatically
     * if the router is configured as the client's default router at the
     * time the session proxy is created in the client process, otherwise
     * the client must configure the session proxy explicitly.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_createSessionFromSecureConnection(java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_createSessionFromSecureConnection(__ctx, true, __cb);
    }

    /**
     * Create a per-client session with the router. The user is
     * authenticated through the SSL certificates that have been
     * associated with the connection. If a {@link SessionManager} has been
     * installed, a proxy to a {@link Session} object is returned to the
     * client. Otherwise, null is returned and only an internal
     * session (i.e., not visible to the client) is created.
     * 
     * If a session proxy is returned, it must be configured to route
     * through the router that created it. This will happen automatically
     * if the router is configured as the client's default router at the
     * time the session proxy is created in the client process, otherwise
     * the client must configure the session proxy explicitly.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_createSessionFromSecureConnection(Callback_Router_createSessionFromSecureConnection __cb)
    {
        return begin_createSessionFromSecureConnection(null, false, __cb);
    }

    /**
     * Create a per-client session with the router. The user is
     * authenticated through the SSL certificates that have been
     * associated with the connection. If a {@link SessionManager} has been
     * installed, a proxy to a {@link Session} object is returned to the
     * client. Otherwise, null is returned and only an internal
     * session (i.e., not visible to the client) is created.
     * 
     * If a session proxy is returned, it must be configured to route
     * through the router that created it. This will happen automatically
     * if the router is configured as the client's default router at the
     * time the session proxy is created in the client process, otherwise
     * the client must configure the session proxy explicitly.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_createSessionFromSecureConnection(java.util.Map<String, String> __ctx, Callback_Router_createSessionFromSecureConnection __cb)
    {
        return begin_createSessionFromSecureConnection(__ctx, true, __cb);
    }

    private Ice.AsyncResult begin_createSessionFromSecureConnection(java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__createSessionFromSecureConnection_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __createSessionFromSecureConnection_name, __cb);
        try
        {
            __result.__prepare(__createSessionFromSecureConnection_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) A proxy for the newly created session, or null if no
     * {@link SessionManager} has been installed.
     * 
     **/
    public SessionPrx end_createSessionFromSecureConnection(Ice.AsyncResult __result)
        throws CannotCreateSessionException,
               PermissionDeniedException
    {
        Ice.AsyncResult.__check(__result, this, __createSessionFromSecureConnection_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(CannotCreateSessionException __ex)
            {
                throw __ex;
            }
            catch(PermissionDeniedException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        SessionPrx __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = SessionPrxHelper.__read(__is);
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Destroy the calling client's session with this router.
     * 
     * @throws SessionNotExistException Raised if no session exists
     * for the calling client.
     * 
     **/
    public void
    destroySession()
        throws SessionNotExistException
    {
        destroySession(null, false);
    }

    /**
     * Destroy the calling client's session with this router.
     * 
     * @throws SessionNotExistException Raised if no session exists
     * for the calling client.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void
    destroySession(java.util.Map<String, String> __ctx)
        throws SessionNotExistException
    {
        destroySession(__ctx, true);
    }

    private void
    destroySession(java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws SessionNotExistException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("destroySession");
                __delBase = __getDelegate(false);
                _RouterDel __del = (_RouterDel)__delBase;
                __del.destroySession(__ctx);
                return;
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __destroySession_name = "destroySession";

    /**
     * Destroy the calling client's session with this router.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_destroySession()
    {
        return begin_destroySession(null, false, null);
    }

    /**
     * Destroy the calling client's session with this router.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_destroySession(java.util.Map<String, String> __ctx)
    {
        return begin_destroySession(__ctx, true, null);
    }

    /**
     * Destroy the calling client's session with this router.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_destroySession(Ice.Callback __cb)
    {
        return begin_destroySession(null, false, __cb);
    }

    /**
     * Destroy the calling client's session with this router.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_destroySession(java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_destroySession(__ctx, true, __cb);
    }

    /**
     * Destroy the calling client's session with this router.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_destroySession(Callback_Router_destroySession __cb)
    {
        return begin_destroySession(null, false, __cb);
    }

    /**
     * Destroy the calling client's session with this router.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_destroySession(java.util.Map<String, String> __ctx, Callback_Router_destroySession __cb)
    {
        return begin_destroySession(__ctx, true, __cb);
    }

    private Ice.AsyncResult begin_destroySession(java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__destroySession_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __destroySession_name, __cb);
        try
        {
            __result.__prepare(__destroySession_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     **/
    public void end_destroySession(Ice.AsyncResult __result)
        throws SessionNotExistException
    {
        Ice.AsyncResult.__check(__result, this, __destroySession_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(SessionNotExistException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        IceInternal.BasicStream __is = __result.__is();
        __is.skipEmptyEncaps();
    }

    /**
     * Destroy the calling client's session with this router.
     * 
     * @param __cb The callback object for the operation.
     **/
    public boolean
    destroySession_async(AMI_Router_destroySession __cb)
    {
        Ice.AsyncResult __r;
        try
        {
            __checkTwowayOnly(__destroySession_name);
            __r = begin_destroySession(null, false, __cb);
        }
        catch(Ice.TwowayOnlyException ex)
        {
            __r = new IceInternal.OutgoingAsync(this, __destroySession_name, __cb);
            __r.__exceptionAsync(ex);
        }
        return __r.sentSynchronously();
    }

    /**
     * Destroy the calling client's session with this router.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public boolean
    destroySession_async(AMI_Router_destroySession __cb, java.util.Map<String, String> __ctx)
    {
        Ice.AsyncResult __r;
        try
        {
            __checkTwowayOnly(__destroySession_name);
            __r = begin_destroySession(__ctx, true, __cb);
        }
        catch(Ice.TwowayOnlyException ex)
        {
            __r = new IceInternal.OutgoingAsync(this, __destroySession_name, __cb);
            __r.__exceptionAsync(ex);
        }
        return __r.sentSynchronously();
    }

    /**
     * This category must be used in the identities of all of the client's
     * callback objects. This is necessary in order for the router to
     * forward callback requests to the intended client. If the Glacier2
     * server endpoints are not set, the returned category is an empty 
     * string.
     * 
     * @return The category.
     * 
     **/
    public String
    getCategoryForClient()
    {
        return getCategoryForClient(null, false);
    }

    /**
     * This category must be used in the identities of all of the client's
     * callback objects. This is necessary in order for the router to
     * forward callback requests to the intended client. If the Glacier2
     * server endpoints are not set, the returned category is an empty 
     * string.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The category.
     * 
     **/
    public String
    getCategoryForClient(java.util.Map<String, String> __ctx)
    {
        return getCategoryForClient(__ctx, true);
    }

    private String
    getCategoryForClient(java.util.Map<String, String> __ctx, boolean __explicitCtx)
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("getCategoryForClient");
                __delBase = __getDelegate(false);
                _RouterDel __del = (_RouterDel)__delBase;
                return __del.getCategoryForClient(__ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __getCategoryForClient_name = "getCategoryForClient";

    /**
     * This category must be used in the identities of all of the client's
     * callback objects. This is necessary in order for the router to
     * forward callback requests to the intended client. If the Glacier2
     * server endpoints are not set, the returned category is an empty 
     * string.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getCategoryForClient()
    {
        return begin_getCategoryForClient(null, false, null);
    }

    /**
     * This category must be used in the identities of all of the client's
     * callback objects. This is necessary in order for the router to
     * forward callback requests to the intended client. If the Glacier2
     * server endpoints are not set, the returned category is an empty 
     * string.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getCategoryForClient(java.util.Map<String, String> __ctx)
    {
        return begin_getCategoryForClient(__ctx, true, null);
    }

    /**
     * This category must be used in the identities of all of the client's
     * callback objects. This is necessary in order for the router to
     * forward callback requests to the intended client. If the Glacier2
     * server endpoints are not set, the returned category is an empty 
     * string.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getCategoryForClient(Ice.Callback __cb)
    {
        return begin_getCategoryForClient(null, false, __cb);
    }

    /**
     * This category must be used in the identities of all of the client's
     * callback objects. This is necessary in order for the router to
     * forward callback requests to the intended client. If the Glacier2
     * server endpoints are not set, the returned category is an empty 
     * string.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getCategoryForClient(java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_getCategoryForClient(__ctx, true, __cb);
    }

    /**
     * This category must be used in the identities of all of the client's
     * callback objects. This is necessary in order for the router to
     * forward callback requests to the intended client. If the Glacier2
     * server endpoints are not set, the returned category is an empty 
     * string.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getCategoryForClient(Callback_Router_getCategoryForClient __cb)
    {
        return begin_getCategoryForClient(null, false, __cb);
    }

    /**
     * This category must be used in the identities of all of the client's
     * callback objects. This is necessary in order for the router to
     * forward callback requests to the intended client. If the Glacier2
     * server endpoints are not set, the returned category is an empty 
     * string.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getCategoryForClient(java.util.Map<String, String> __ctx, Callback_Router_getCategoryForClient __cb)
    {
        return begin_getCategoryForClient(__ctx, true, __cb);
    }

    private Ice.AsyncResult begin_getCategoryForClient(java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__getCategoryForClient_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __getCategoryForClient_name, __cb);
        try
        {
            __result.__prepare(__getCategoryForClient_name, Ice.OperationMode.Idempotent, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) The category.
     * 
     **/
    public String end_getCategoryForClient(Ice.AsyncResult __result)
    {
        Ice.AsyncResult.__check(__result, this, __getCategoryForClient_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        String __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = __is.readString();
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Get the value of the session timeout. Sessions are destroyed
     * if they see no activity for this period of time.
     * 
     * @return The timeout (in seconds).
     * 
     **/
    public long
    getSessionTimeout()
    {
        return getSessionTimeout(null, false);
    }

    /**
     * Get the value of the session timeout. Sessions are destroyed
     * if they see no activity for this period of time.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The timeout (in seconds).
     * 
     **/
    public long
    getSessionTimeout(java.util.Map<String, String> __ctx)
    {
        return getSessionTimeout(__ctx, true);
    }

    private long
    getSessionTimeout(java.util.Map<String, String> __ctx, boolean __explicitCtx)
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("getSessionTimeout");
                __delBase = __getDelegate(false);
                _RouterDel __del = (_RouterDel)__delBase;
                return __del.getSessionTimeout(__ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __getSessionTimeout_name = "getSessionTimeout";

    /**
     * Get the value of the session timeout. Sessions are destroyed
     * if they see no activity for this period of time.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getSessionTimeout()
    {
        return begin_getSessionTimeout(null, false, null);
    }

    /**
     * Get the value of the session timeout. Sessions are destroyed
     * if they see no activity for this period of time.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getSessionTimeout(java.util.Map<String, String> __ctx)
    {
        return begin_getSessionTimeout(__ctx, true, null);
    }

    /**
     * Get the value of the session timeout. Sessions are destroyed
     * if they see no activity for this period of time.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getSessionTimeout(Ice.Callback __cb)
    {
        return begin_getSessionTimeout(null, false, __cb);
    }

    /**
     * Get the value of the session timeout. Sessions are destroyed
     * if they see no activity for this period of time.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getSessionTimeout(java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_getSessionTimeout(__ctx, true, __cb);
    }

    /**
     * Get the value of the session timeout. Sessions are destroyed
     * if they see no activity for this period of time.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getSessionTimeout(Callback_Router_getSessionTimeout __cb)
    {
        return begin_getSessionTimeout(null, false, __cb);
    }

    /**
     * Get the value of the session timeout. Sessions are destroyed
     * if they see no activity for this period of time.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getSessionTimeout(java.util.Map<String, String> __ctx, Callback_Router_getSessionTimeout __cb)
    {
        return begin_getSessionTimeout(__ctx, true, __cb);
    }

    private Ice.AsyncResult begin_getSessionTimeout(java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__getSessionTimeout_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __getSessionTimeout_name, __cb);
        try
        {
            __result.__prepare(__getSessionTimeout_name, Ice.OperationMode.Idempotent, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) The timeout (in seconds).
     * 
     **/
    public long end_getSessionTimeout(Ice.AsyncResult __result)
    {
        Ice.AsyncResult.__check(__result, this, __getSessionTimeout_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        long __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = __is.readLong();
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Keep the calling client's session with this router alive.
     * 
     * @throws SessionNotExistException Raised if no session exists
     * for the calling client.
     * 
     **/
    public void
    refreshSession()
        throws SessionNotExistException
    {
        refreshSession(null, false);
    }

    /**
     * Keep the calling client's session with this router alive.
     * 
     * @throws SessionNotExistException Raised if no session exists
     * for the calling client.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void
    refreshSession(java.util.Map<String, String> __ctx)
        throws SessionNotExistException
    {
        refreshSession(__ctx, true);
    }

    private void
    refreshSession(java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws SessionNotExistException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("refreshSession");
                __delBase = __getDelegate(false);
                _RouterDel __del = (_RouterDel)__delBase;
                __del.refreshSession(__ctx);
                return;
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __refreshSession_name = "refreshSession";

    /**
     * Keep the calling client's session with this router alive.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_refreshSession()
    {
        return begin_refreshSession(null, false, null);
    }

    /**
     * Keep the calling client's session with this router alive.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_refreshSession(java.util.Map<String, String> __ctx)
    {
        return begin_refreshSession(__ctx, true, null);
    }

    /**
     * Keep the calling client's session with this router alive.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_refreshSession(Ice.Callback __cb)
    {
        return begin_refreshSession(null, false, __cb);
    }

    /**
     * Keep the calling client's session with this router alive.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_refreshSession(java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_refreshSession(__ctx, true, __cb);
    }

    /**
     * Keep the calling client's session with this router alive.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_refreshSession(Callback_Router_refreshSession __cb)
    {
        return begin_refreshSession(null, false, __cb);
    }

    /**
     * Keep the calling client's session with this router alive.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_refreshSession(java.util.Map<String, String> __ctx, Callback_Router_refreshSession __cb)
    {
        return begin_refreshSession(__ctx, true, __cb);
    }

    private Ice.AsyncResult begin_refreshSession(java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__refreshSession_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __refreshSession_name, __cb);
        try
        {
            __result.__prepare(__refreshSession_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     **/
    public void end_refreshSession(Ice.AsyncResult __result)
        throws SessionNotExistException
    {
        Ice.AsyncResult.__check(__result, this, __refreshSession_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(SessionNotExistException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        IceInternal.BasicStream __is = __result.__is();
        __is.skipEmptyEncaps();
    }

    /**
     * Keep the calling client's session with this router alive.
     * 
     * @param __cb The callback object for the operation.
     **/
    public boolean
    refreshSession_async(AMI_Router_refreshSession __cb)
    {
        Ice.AsyncResult __r;
        try
        {
            __checkTwowayOnly(__refreshSession_name);
            __r = begin_refreshSession(null, false, __cb);
        }
        catch(Ice.TwowayOnlyException ex)
        {
            __r = new IceInternal.OutgoingAsync(this, __refreshSession_name, __cb);
            __r.__exceptionAsync(ex);
        }
        return __r.sentSynchronously();
    }

    /**
     * Keep the calling client's session with this router alive.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public boolean
    refreshSession_async(AMI_Router_refreshSession __cb, java.util.Map<String, String> __ctx)
    {
        Ice.AsyncResult __r;
        try
        {
            __checkTwowayOnly(__refreshSession_name);
            __r = begin_refreshSession(__ctx, true, __cb);
        }
        catch(Ice.TwowayOnlyException ex)
        {
            __r = new IceInternal.OutgoingAsync(this, __refreshSession_name, __cb);
            __r.__exceptionAsync(ex);
        }
        return __r.sentSynchronously();
    }

    /**
     * Add new proxy information to the router's routing table.
     * 
     * @param proxies The proxies to add.
     * 
     * @return Proxies discarded by the router.
     * 
     **/
    public Ice.ObjectPrx[]
    addProxies(Ice.ObjectPrx[] proxies)
    {
        return addProxies(proxies, null, false);
    }

    /**
     * Add new proxy information to the router's routing table.
     * 
     * @param proxies The proxies to add.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return Proxies discarded by the router.
     * 
     **/
    public Ice.ObjectPrx[]
    addProxies(Ice.ObjectPrx[] proxies, java.util.Map<String, String> __ctx)
    {
        return addProxies(proxies, __ctx, true);
    }

    private Ice.ObjectPrx[]
    addProxies(Ice.ObjectPrx[] proxies, java.util.Map<String, String> __ctx, boolean __explicitCtx)
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("addProxies");
                __delBase = __getDelegate(false);
                _RouterDel __del = (_RouterDel)__delBase;
                return __del.addProxies(proxies, __ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __addProxies_name = "addProxies";

    /**
     * Add new proxy information to the router's routing table.
     * 
     * @param __cb The callback object for the operation.
     * @param proxies The proxies to add.
     * 
     **/
    public Ice.AsyncResult begin_addProxies(Ice.ObjectPrx[] proxies)
    {
        return begin_addProxies(proxies, null, false, null);
    }

    /**
     * Add new proxy information to the router's routing table.
     * 
     * @param __cb The callback object for the operation.
     * @param proxies The proxies to add.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_addProxies(Ice.ObjectPrx[] proxies, java.util.Map<String, String> __ctx)
    {
        return begin_addProxies(proxies, __ctx, true, null);
    }

    /**
     * Add new proxy information to the router's routing table.
     * 
     * @param __cb The callback object for the operation.
     * @param proxies The proxies to add.
     * 
     **/
    public Ice.AsyncResult begin_addProxies(Ice.ObjectPrx[] proxies, Ice.Callback __cb)
    {
        return begin_addProxies(proxies, null, false, __cb);
    }

    /**
     * Add new proxy information to the router's routing table.
     * 
     * @param __cb The callback object for the operation.
     * @param proxies The proxies to add.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_addProxies(Ice.ObjectPrx[] proxies, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_addProxies(proxies, __ctx, true, __cb);
    }

    /**
     * Add new proxy information to the router's routing table.
     * 
     * @param __cb The callback object for the operation.
     * @param proxies The proxies to add.
     * 
     **/
    public Ice.AsyncResult begin_addProxies(Ice.ObjectPrx[] proxies, Ice.Callback_Router_addProxies __cb)
    {
        return begin_addProxies(proxies, null, false, __cb);
    }

    /**
     * Add new proxy information to the router's routing table.
     * 
     * @param __cb The callback object for the operation.
     * @param proxies The proxies to add.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_addProxies(Ice.ObjectPrx[] proxies, java.util.Map<String, String> __ctx, Ice.Callback_Router_addProxies __cb)
    {
        return begin_addProxies(proxies, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_addProxies(Ice.ObjectPrx[] proxies, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__addProxies_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __addProxies_name, __cb);
        try
        {
            __result.__prepare(__addProxies_name, Ice.OperationMode.Idempotent, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            Ice.ObjectProxySeqHelper.write(__os, proxies);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) Proxies discarded by the router.
     * 
     **/
    public Ice.ObjectPrx[] end_addProxies(Ice.AsyncResult __result)
    {
        Ice.AsyncResult.__check(__result, this, __addProxies_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        Ice.ObjectPrx[] __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = Ice.ObjectProxySeqHelper.read(__is);
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Add new proxy information to the router's routing table.
     * 
     * @param __cb The callback object for the operation.
     * @param proxies The proxies to add.
     * 
     **/
    public boolean
    addProxies_async(Ice.AMI_Router_addProxies __cb, Ice.ObjectPrx[] proxies)
    {
        Ice.AsyncResult __r;
        try
        {
            __checkTwowayOnly(__addProxies_name);
            __r = begin_addProxies(proxies, null, false, __cb);
        }
        catch(Ice.TwowayOnlyException ex)
        {
            __r = new IceInternal.OutgoingAsync(this, __addProxies_name, __cb);
            __r.__exceptionAsync(ex);
        }
        return __r.sentSynchronously();
    }

    /**
     * Add new proxy information to the router's routing table.
     * 
     * @param __cb The callback object for the operation.
     * @param proxies The proxies to add.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public boolean
    addProxies_async(Ice.AMI_Router_addProxies __cb, Ice.ObjectPrx[] proxies, java.util.Map<String, String> __ctx)
    {
        Ice.AsyncResult __r;
        try
        {
            __checkTwowayOnly(__addProxies_name);
            __r = begin_addProxies(proxies, __ctx, true, __cb);
        }
        catch(Ice.TwowayOnlyException ex)
        {
            __r = new IceInternal.OutgoingAsync(this, __addProxies_name, __cb);
            __r.__exceptionAsync(ex);
        }
        return __r.sentSynchronously();
    }

    /**
     * Add new proxy information to the router's routing table.
     * 
     * <p class="Deprecated">This operation is deprecated, and only used for old
     * Ice clients (older than version 3.1).
     * 
     * @param proxy The proxy to add.
     * 
     * @deprecated addProxy() is deprecated, use addProxies() instead.
     **/
    public void
    addProxy(Ice.ObjectPrx proxy)
    {
        addProxy(proxy, null, false);
    }

    /**
     * Add new proxy information to the router's routing table.
     * 
     * <p class="Deprecated">This operation is deprecated, and only used for old
     * Ice clients (older than version 3.1).
     * 
     * @param proxy The proxy to add.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @deprecated addProxy() is deprecated, use addProxies() instead.
     **/
    public void
    addProxy(Ice.ObjectPrx proxy, java.util.Map<String, String> __ctx)
    {
        addProxy(proxy, __ctx, true);
    }

    private void
    addProxy(Ice.ObjectPrx proxy, java.util.Map<String, String> __ctx, boolean __explicitCtx)
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __delBase = __getDelegate(false);
                _RouterDel __del = (_RouterDel)__delBase;
                __del.addProxy(proxy, __ctx);
                return;
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __addProxy_name = "addProxy";

    /**
     * Add new proxy information to the router's routing table.
     * 
     * <p class="Deprecated">This operation is deprecated, and only used for old
     * Ice clients (older than version 3.1).
     * 
     * @param __cb The callback object for the operation.
     * @param proxy The proxy to add.
     * 
     * @deprecated addProxy() is deprecated, use addProxies() instead.
     **/
    public Ice.AsyncResult begin_addProxy(Ice.ObjectPrx proxy)
    {
        return begin_addProxy(proxy, null, false, null);
    }

    /**
     * Add new proxy information to the router's routing table.
     * 
     * <p class="Deprecated">This operation is deprecated, and only used for old
     * Ice clients (older than version 3.1).
     * 
     * @param __cb The callback object for the operation.
     * @param proxy The proxy to add.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @deprecated addProxy() is deprecated, use addProxies() instead.
     **/
    public Ice.AsyncResult begin_addProxy(Ice.ObjectPrx proxy, java.util.Map<String, String> __ctx)
    {
        return begin_addProxy(proxy, __ctx, true, null);
    }

    /**
     * Add new proxy information to the router's routing table.
     * 
     * <p class="Deprecated">This operation is deprecated, and only used for old
     * Ice clients (older than version 3.1).
     * 
     * @param __cb The callback object for the operation.
     * @param proxy The proxy to add.
     * 
     * @deprecated addProxy() is deprecated, use addProxies() instead.
     **/
    public Ice.AsyncResult begin_addProxy(Ice.ObjectPrx proxy, Ice.Callback __cb)
    {
        return begin_addProxy(proxy, null, false, __cb);
    }

    /**
     * Add new proxy information to the router's routing table.
     * 
     * <p class="Deprecated">This operation is deprecated, and only used for old
     * Ice clients (older than version 3.1).
     * 
     * @param __cb The callback object for the operation.
     * @param proxy The proxy to add.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @deprecated addProxy() is deprecated, use addProxies() instead.
     **/
    public Ice.AsyncResult begin_addProxy(Ice.ObjectPrx proxy, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_addProxy(proxy, __ctx, true, __cb);
    }

    /**
     * Add new proxy information to the router's routing table.
     * 
     * <p class="Deprecated">This operation is deprecated, and only used for old
     * Ice clients (older than version 3.1).
     * 
     * @param __cb The callback object for the operation.
     * @param proxy The proxy to add.
     * 
     * @deprecated addProxy() is deprecated, use addProxies() instead.
     **/
    public Ice.AsyncResult begin_addProxy(Ice.ObjectPrx proxy, Ice.Callback_Router_addProxy __cb)
    {
        return begin_addProxy(proxy, null, false, __cb);
    }

    /**
     * Add new proxy information to the router's routing table.
     * 
     * <p class="Deprecated">This operation is deprecated, and only used for old
     * Ice clients (older than version 3.1).
     * 
     * @param __cb The callback object for the operation.
     * @param proxy The proxy to add.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @deprecated addProxy() is deprecated, use addProxies() instead.
     **/
    public Ice.AsyncResult begin_addProxy(Ice.ObjectPrx proxy, java.util.Map<String, String> __ctx, Ice.Callback_Router_addProxy __cb)
    {
        return begin_addProxy(proxy, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_addProxy(Ice.ObjectPrx proxy, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __addProxy_name, __cb);
        try
        {
            __result.__prepare(__addProxy_name, Ice.OperationMode.Idempotent, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.writeProxy(proxy);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     **/
    public void end_addProxy(Ice.AsyncResult __result)
    {
        __end(__result, __addProxy_name);
    }

    /**
     * Get the router's client proxy, i.e., the proxy to use for
     * forwarding requests from the client to the router.
     * 
     * @return The router's client proxy.
     * 
     **/
    public Ice.ObjectPrx
    getClientProxy()
    {
        return getClientProxy(null, false);
    }

    /**
     * Get the router's client proxy, i.e., the proxy to use for
     * forwarding requests from the client to the router.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The router's client proxy.
     * 
     **/
    public Ice.ObjectPrx
    getClientProxy(java.util.Map<String, String> __ctx)
    {
        return getClientProxy(__ctx, true);
    }

    private Ice.ObjectPrx
    getClientProxy(java.util.Map<String, String> __ctx, boolean __explicitCtx)
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("getClientProxy");
                __delBase = __getDelegate(false);
                _RouterDel __del = (_RouterDel)__delBase;
                return __del.getClientProxy(__ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __getClientProxy_name = "getClientProxy";

    /**
     * Get the router's client proxy, i.e., the proxy to use for
     * forwarding requests from the client to the router.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getClientProxy()
    {
        return begin_getClientProxy(null, false, null);
    }

    /**
     * Get the router's client proxy, i.e., the proxy to use for
     * forwarding requests from the client to the router.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getClientProxy(java.util.Map<String, String> __ctx)
    {
        return begin_getClientProxy(__ctx, true, null);
    }

    /**
     * Get the router's client proxy, i.e., the proxy to use for
     * forwarding requests from the client to the router.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getClientProxy(Ice.Callback __cb)
    {
        return begin_getClientProxy(null, false, __cb);
    }

    /**
     * Get the router's client proxy, i.e., the proxy to use for
     * forwarding requests from the client to the router.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getClientProxy(java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_getClientProxy(__ctx, true, __cb);
    }

    /**
     * Get the router's client proxy, i.e., the proxy to use for
     * forwarding requests from the client to the router.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getClientProxy(Ice.Callback_Router_getClientProxy __cb)
    {
        return begin_getClientProxy(null, false, __cb);
    }

    /**
     * Get the router's client proxy, i.e., the proxy to use for
     * forwarding requests from the client to the router.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getClientProxy(java.util.Map<String, String> __ctx, Ice.Callback_Router_getClientProxy __cb)
    {
        return begin_getClientProxy(__ctx, true, __cb);
    }

    private Ice.AsyncResult begin_getClientProxy(java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__getClientProxy_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __getClientProxy_name, __cb);
        try
        {
            __result.__prepare(__getClientProxy_name, Ice.OperationMode.Idempotent, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) The router's client proxy.
     * 
     **/
    public Ice.ObjectPrx end_getClientProxy(Ice.AsyncResult __result)
    {
        Ice.AsyncResult.__check(__result, this, __getClientProxy_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        Ice.ObjectPrx __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = __is.readProxy();
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Get the router's client proxy, i.e., the proxy to use for
     * forwarding requests from the client to the router.
     * 
     * @param __cb The callback object for the operation.
     **/
    public boolean
    getClientProxy_async(Ice.AMI_Router_getClientProxy __cb)
    {
        Ice.AsyncResult __r;
        try
        {
            __checkTwowayOnly(__getClientProxy_name);
            __r = begin_getClientProxy(null, false, __cb);
        }
        catch(Ice.TwowayOnlyException ex)
        {
            __r = new IceInternal.OutgoingAsync(this, __getClientProxy_name, __cb);
            __r.__exceptionAsync(ex);
        }
        return __r.sentSynchronously();
    }

    /**
     * Get the router's client proxy, i.e., the proxy to use for
     * forwarding requests from the client to the router.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public boolean
    getClientProxy_async(Ice.AMI_Router_getClientProxy __cb, java.util.Map<String, String> __ctx)
    {
        Ice.AsyncResult __r;
        try
        {
            __checkTwowayOnly(__getClientProxy_name);
            __r = begin_getClientProxy(__ctx, true, __cb);
        }
        catch(Ice.TwowayOnlyException ex)
        {
            __r = new IceInternal.OutgoingAsync(this, __getClientProxy_name, __cb);
            __r.__exceptionAsync(ex);
        }
        return __r.sentSynchronously();
    }

    /**
     * Get the router's server proxy, i.e., the proxy to use for
     * forwarding requests from the server to the router.
     * 
     * @return The router's server proxy.
     * 
     **/
    public Ice.ObjectPrx
    getServerProxy()
    {
        return getServerProxy(null, false);
    }

    /**
     * Get the router's server proxy, i.e., the proxy to use for
     * forwarding requests from the server to the router.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The router's server proxy.
     * 
     **/
    public Ice.ObjectPrx
    getServerProxy(java.util.Map<String, String> __ctx)
    {
        return getServerProxy(__ctx, true);
    }

    private Ice.ObjectPrx
    getServerProxy(java.util.Map<String, String> __ctx, boolean __explicitCtx)
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("getServerProxy");
                __delBase = __getDelegate(false);
                _RouterDel __del = (_RouterDel)__delBase;
                return __del.getServerProxy(__ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __getServerProxy_name = "getServerProxy";

    /**
     * Get the router's server proxy, i.e., the proxy to use for
     * forwarding requests from the server to the router.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getServerProxy()
    {
        return begin_getServerProxy(null, false, null);
    }

    /**
     * Get the router's server proxy, i.e., the proxy to use for
     * forwarding requests from the server to the router.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getServerProxy(java.util.Map<String, String> __ctx)
    {
        return begin_getServerProxy(__ctx, true, null);
    }

    /**
     * Get the router's server proxy, i.e., the proxy to use for
     * forwarding requests from the server to the router.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getServerProxy(Ice.Callback __cb)
    {
        return begin_getServerProxy(null, false, __cb);
    }

    /**
     * Get the router's server proxy, i.e., the proxy to use for
     * forwarding requests from the server to the router.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getServerProxy(java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_getServerProxy(__ctx, true, __cb);
    }

    /**
     * Get the router's server proxy, i.e., the proxy to use for
     * forwarding requests from the server to the router.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getServerProxy(Ice.Callback_Router_getServerProxy __cb)
    {
        return begin_getServerProxy(null, false, __cb);
    }

    /**
     * Get the router's server proxy, i.e., the proxy to use for
     * forwarding requests from the server to the router.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getServerProxy(java.util.Map<String, String> __ctx, Ice.Callback_Router_getServerProxy __cb)
    {
        return begin_getServerProxy(__ctx, true, __cb);
    }

    private Ice.AsyncResult begin_getServerProxy(java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__getServerProxy_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __getServerProxy_name, __cb);
        try
        {
            __result.__prepare(__getServerProxy_name, Ice.OperationMode.Idempotent, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) The router's server proxy.
     * 
     **/
    public Ice.ObjectPrx end_getServerProxy(Ice.AsyncResult __result)
    {
        Ice.AsyncResult.__check(__result, this, __getServerProxy_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        Ice.ObjectPrx __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = __is.readProxy();
        __is.endReadEncaps();
        return __ret;
    }

    public static RouterPrx
    checkedCast(Ice.ObjectPrx __obj)
    {
        RouterPrx __d = null;
        if(__obj != null)
        {
            try
            {
                __d = (RouterPrx)__obj;
            }
            catch(ClassCastException ex)
            {
                if(__obj.ice_isA("::Glacier2::Router"))
                {
                    RouterPrxHelper __h = new RouterPrxHelper();
                    __h.__copyFrom(__obj);
                    __d = __h;
                }
            }
        }
        return __d;
    }

    public static RouterPrx
    checkedCast(Ice.ObjectPrx __obj, java.util.Map<String, String> __ctx)
    {
        RouterPrx __d = null;
        if(__obj != null)
        {
            try
            {
                __d = (RouterPrx)__obj;
            }
            catch(ClassCastException ex)
            {
                if(__obj.ice_isA("::Glacier2::Router", __ctx))
                {
                    RouterPrxHelper __h = new RouterPrxHelper();
                    __h.__copyFrom(__obj);
                    __d = __h;
                }
            }
        }
        return __d;
    }

    public static RouterPrx
    checkedCast(Ice.ObjectPrx __obj, String __facet)
    {
        RouterPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            try
            {
                if(__bb.ice_isA("::Glacier2::Router"))
                {
                    RouterPrxHelper __h = new RouterPrxHelper();
                    __h.__copyFrom(__bb);
                    __d = __h;
                }
            }
            catch(Ice.FacetNotExistException ex)
            {
            }
        }
        return __d;
    }

    public static RouterPrx
    checkedCast(Ice.ObjectPrx __obj, String __facet, java.util.Map<String, String> __ctx)
    {
        RouterPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            try
            {
                if(__bb.ice_isA("::Glacier2::Router", __ctx))
                {
                    RouterPrxHelper __h = new RouterPrxHelper();
                    __h.__copyFrom(__bb);
                    __d = __h;
                }
            }
            catch(Ice.FacetNotExistException ex)
            {
            }
        }
        return __d;
    }

    public static RouterPrx
    uncheckedCast(Ice.ObjectPrx __obj)
    {
        RouterPrx __d = null;
        if(__obj != null)
        {
            try
            {
                __d = (RouterPrx)__obj;
            }
            catch(ClassCastException ex)
            {
                RouterPrxHelper __h = new RouterPrxHelper();
                __h.__copyFrom(__obj);
                __d = __h;
            }
        }
        return __d;
    }

    public static RouterPrx
    uncheckedCast(Ice.ObjectPrx __obj, String __facet)
    {
        RouterPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            RouterPrxHelper __h = new RouterPrxHelper();
            __h.__copyFrom(__bb);
            __d = __h;
        }
        return __d;
    }

    protected Ice._ObjectDelM
    __createDelegateM()
    {
        return new _RouterDelM();
    }

    protected Ice._ObjectDelD
    __createDelegateD()
    {
        return new _RouterDelD();
    }

    public static void
    __write(IceInternal.BasicStream __os, RouterPrx v)
    {
        __os.writeProxy(v);
    }

    public static RouterPrx
    __read(IceInternal.BasicStream __is)
    {
        Ice.ObjectPrx proxy = __is.readProxy();
        if(proxy != null)
        {
            RouterPrxHelper result = new RouterPrxHelper();
            result.__copyFrom(proxy);
            return result;
        }
        return null;
    }
}
