// **********************************************************************
//
// Copyright (c) 2003-2010 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************

// Ice version 3.4.1

package Glacier2;

// <auto-generated>
//
// Generated from file `PermissionsVerifier.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>


/**
 * The SSL Glacier2 permissions verifier. This is called through the
 * process of establishing a session.
 * 
 * @see Router
 * 
 **/
public final class SSLPermissionsVerifierPrxHelper extends Ice.ObjectPrxHelperBase implements SSLPermissionsVerifierPrx
{
    /**
     * Check whether a user has permission to access the router.
     * 
     * @param info The SSL information.
     * 
     * @param reason The reason why access was denied.
     * 
     * @return True if access is granted, or false otherwise.
     * 
     * @see SSLInfo
     * 
     **/
    public boolean
    authorize(SSLInfo info, Ice.StringHolder reason)
    {
        return authorize(info, reason, null, false);
    }

    /**
     * Check whether a user has permission to access the router.
     * 
     * @param info The SSL information.
     * 
     * @param reason The reason why access was denied.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return True if access is granted, or false otherwise.
     * 
     * @see SSLInfo
     * 
     **/
    public boolean
    authorize(SSLInfo info, Ice.StringHolder reason, java.util.Map<String, String> __ctx)
    {
        return authorize(info, reason, __ctx, true);
    }

    private boolean
    authorize(SSLInfo info, Ice.StringHolder reason, java.util.Map<String, String> __ctx, boolean __explicitCtx)
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("authorize");
                __delBase = __getDelegate(false);
                _SSLPermissionsVerifierDel __del = (_SSLPermissionsVerifierDel)__delBase;
                return __del.authorize(info, reason, __ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __authorize_name = "authorize";

    /**
     * Check whether a user has permission to access the router.
     * 
     * @param __cb The callback object for the operation.
     * @param info The SSL information.
     * 
     **/
    public Ice.AsyncResult begin_authorize(SSLInfo info)
    {
        return begin_authorize(info, null, false, null);
    }

    /**
     * Check whether a user has permission to access the router.
     * 
     * @param __cb The callback object for the operation.
     * @param info The SSL information.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_authorize(SSLInfo info, java.util.Map<String, String> __ctx)
    {
        return begin_authorize(info, __ctx, true, null);
    }

    /**
     * Check whether a user has permission to access the router.
     * 
     * @param __cb The callback object for the operation.
     * @param info The SSL information.
     * 
     **/
    public Ice.AsyncResult begin_authorize(SSLInfo info, Ice.Callback __cb)
    {
        return begin_authorize(info, null, false, __cb);
    }

    /**
     * Check whether a user has permission to access the router.
     * 
     * @param __cb The callback object for the operation.
     * @param info The SSL information.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_authorize(SSLInfo info, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_authorize(info, __ctx, true, __cb);
    }

    /**
     * Check whether a user has permission to access the router.
     * 
     * @param __cb The callback object for the operation.
     * @param info The SSL information.
     * 
     **/
    public Ice.AsyncResult begin_authorize(SSLInfo info, Callback_SSLPermissionsVerifier_authorize __cb)
    {
        return begin_authorize(info, null, false, __cb);
    }

    /**
     * Check whether a user has permission to access the router.
     * 
     * @param __cb The callback object for the operation.
     * @param info The SSL information.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_authorize(SSLInfo info, java.util.Map<String, String> __ctx, Callback_SSLPermissionsVerifier_authorize __cb)
    {
        return begin_authorize(info, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_authorize(SSLInfo info, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__authorize_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __authorize_name, __cb);
        try
        {
            __result.__prepare(__authorize_name, Ice.OperationMode.Idempotent, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            info.__write(__os);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) True if access is granted, or false otherwise.
     * 
     * @param reason The reason why access was denied.
     * 
     **/
    public boolean end_authorize(Ice.StringHolder reason, Ice.AsyncResult __result)
    {
        Ice.AsyncResult.__check(__result, this, __authorize_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        boolean __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        reason.value = __is.readString();
        __ret = __is.readBool();
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Check whether a user has permission to access the router.
     * 
     * @param __cb The callback object for the operation.
     * @param info The SSL information.
     * 
     **/
    public boolean
    authorize_async(AMI_SSLPermissionsVerifier_authorize __cb, SSLInfo info)
    {
        Ice.AsyncResult __r;
        try
        {
            __checkTwowayOnly(__authorize_name);
            __r = begin_authorize(info, null, false, __cb);
        }
        catch(Ice.TwowayOnlyException ex)
        {
            __r = new IceInternal.OutgoingAsync(this, __authorize_name, __cb);
            __r.__exceptionAsync(ex);
        }
        return __r.sentSynchronously();
    }

    /**
     * Check whether a user has permission to access the router.
     * 
     * @param __cb The callback object for the operation.
     * @param info The SSL information.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public boolean
    authorize_async(AMI_SSLPermissionsVerifier_authorize __cb, SSLInfo info, java.util.Map<String, String> __ctx)
    {
        Ice.AsyncResult __r;
        try
        {
            __checkTwowayOnly(__authorize_name);
            __r = begin_authorize(info, __ctx, true, __cb);
        }
        catch(Ice.TwowayOnlyException ex)
        {
            __r = new IceInternal.OutgoingAsync(this, __authorize_name, __cb);
            __r.__exceptionAsync(ex);
        }
        return __r.sentSynchronously();
    }

    public static SSLPermissionsVerifierPrx
    checkedCast(Ice.ObjectPrx __obj)
    {
        SSLPermissionsVerifierPrx __d = null;
        if(__obj != null)
        {
            try
            {
                __d = (SSLPermissionsVerifierPrx)__obj;
            }
            catch(ClassCastException ex)
            {
                if(__obj.ice_isA("::Glacier2::SSLPermissionsVerifier"))
                {
                    SSLPermissionsVerifierPrxHelper __h = new SSLPermissionsVerifierPrxHelper();
                    __h.__copyFrom(__obj);
                    __d = __h;
                }
            }
        }
        return __d;
    }

    public static SSLPermissionsVerifierPrx
    checkedCast(Ice.ObjectPrx __obj, java.util.Map<String, String> __ctx)
    {
        SSLPermissionsVerifierPrx __d = null;
        if(__obj != null)
        {
            try
            {
                __d = (SSLPermissionsVerifierPrx)__obj;
            }
            catch(ClassCastException ex)
            {
                if(__obj.ice_isA("::Glacier2::SSLPermissionsVerifier", __ctx))
                {
                    SSLPermissionsVerifierPrxHelper __h = new SSLPermissionsVerifierPrxHelper();
                    __h.__copyFrom(__obj);
                    __d = __h;
                }
            }
        }
        return __d;
    }

    public static SSLPermissionsVerifierPrx
    checkedCast(Ice.ObjectPrx __obj, String __facet)
    {
        SSLPermissionsVerifierPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            try
            {
                if(__bb.ice_isA("::Glacier2::SSLPermissionsVerifier"))
                {
                    SSLPermissionsVerifierPrxHelper __h = new SSLPermissionsVerifierPrxHelper();
                    __h.__copyFrom(__bb);
                    __d = __h;
                }
            }
            catch(Ice.FacetNotExistException ex)
            {
            }
        }
        return __d;
    }

    public static SSLPermissionsVerifierPrx
    checkedCast(Ice.ObjectPrx __obj, String __facet, java.util.Map<String, String> __ctx)
    {
        SSLPermissionsVerifierPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            try
            {
                if(__bb.ice_isA("::Glacier2::SSLPermissionsVerifier", __ctx))
                {
                    SSLPermissionsVerifierPrxHelper __h = new SSLPermissionsVerifierPrxHelper();
                    __h.__copyFrom(__bb);
                    __d = __h;
                }
            }
            catch(Ice.FacetNotExistException ex)
            {
            }
        }
        return __d;
    }

    public static SSLPermissionsVerifierPrx
    uncheckedCast(Ice.ObjectPrx __obj)
    {
        SSLPermissionsVerifierPrx __d = null;
        if(__obj != null)
        {
            try
            {
                __d = (SSLPermissionsVerifierPrx)__obj;
            }
            catch(ClassCastException ex)
            {
                SSLPermissionsVerifierPrxHelper __h = new SSLPermissionsVerifierPrxHelper();
                __h.__copyFrom(__obj);
                __d = __h;
            }
        }
        return __d;
    }

    public static SSLPermissionsVerifierPrx
    uncheckedCast(Ice.ObjectPrx __obj, String __facet)
    {
        SSLPermissionsVerifierPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            SSLPermissionsVerifierPrxHelper __h = new SSLPermissionsVerifierPrxHelper();
            __h.__copyFrom(__bb);
            __d = __h;
        }
        return __d;
    }

    protected Ice._ObjectDelM
    __createDelegateM()
    {
        return new _SSLPermissionsVerifierDelM();
    }

    protected Ice._ObjectDelD
    __createDelegateD()
    {
        return new _SSLPermissionsVerifierDelD();
    }

    public static void
    __write(IceInternal.BasicStream __os, SSLPermissionsVerifierPrx v)
    {
        __os.writeProxy(v);
    }

    public static SSLPermissionsVerifierPrx
    __read(IceInternal.BasicStream __is)
    {
        Ice.ObjectPrx proxy = __is.readProxy();
        if(proxy != null)
        {
            SSLPermissionsVerifierPrxHelper result = new SSLPermissionsVerifierPrxHelper();
            result.__copyFrom(proxy);
            return result;
        }
        return null;
    }
}
