// **********************************************************************
//
// Copyright (c) 2003-2010 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************

// Ice version 3.4.1

package Glacier2;

// <auto-generated>
//
// Generated from file `Session.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>


/**
 * The session manager for SSL authenticated users that is
 * responsible for managing {@link Session} objects. New session objects are
 * created by the {@link Router} object calling on an application-provided
 * session manager. If no session manager is provided by the
 * application, no client-visible sessions are passed to the client.
 * 
 * @see Router
 * @see Session
 * 
 **/
public final class SSLSessionManagerPrxHelper extends Ice.ObjectPrxHelperBase implements SSLSessionManagerPrx
{
    /**
     * Create a new session.
     * 
     * @param info The SSL info.
     * 
     * @param control A proxy to the session control object.
     * 
     * @return A proxy to the newly created session.
     * 
     * @throws CannotCreateSessionException Raised if the session
     * cannot be created.
     * 
     **/
    public SessionPrx
    create(SSLInfo info, SessionControlPrx control)
        throws CannotCreateSessionException
    {
        return create(info, control, null, false);
    }

    /**
     * Create a new session.
     * 
     * @param info The SSL info.
     * 
     * @param control A proxy to the session control object.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return A proxy to the newly created session.
     * 
     * @throws CannotCreateSessionException Raised if the session
     * cannot be created.
     * 
     **/
    public SessionPrx
    create(SSLInfo info, SessionControlPrx control, java.util.Map<String, String> __ctx)
        throws CannotCreateSessionException
    {
        return create(info, control, __ctx, true);
    }

    private SessionPrx
    create(SSLInfo info, SessionControlPrx control, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws CannotCreateSessionException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("create");
                __delBase = __getDelegate(false);
                _SSLSessionManagerDel __del = (_SSLSessionManagerDel)__delBase;
                return __del.create(info, control, __ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __create_name = "create";

    /**
     * Create a new session.
     * 
     * @param __cb The callback object for the operation.
     * @param info The SSL info.
     * 
     * @param control A proxy to the session control object.
     * 
     **/
    public Ice.AsyncResult begin_create(SSLInfo info, SessionControlPrx control)
    {
        return begin_create(info, control, null, false, null);
    }

    /**
     * Create a new session.
     * 
     * @param __cb The callback object for the operation.
     * @param info The SSL info.
     * 
     * @param control A proxy to the session control object.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_create(SSLInfo info, SessionControlPrx control, java.util.Map<String, String> __ctx)
    {
        return begin_create(info, control, __ctx, true, null);
    }

    /**
     * Create a new session.
     * 
     * @param __cb The callback object for the operation.
     * @param info The SSL info.
     * 
     * @param control A proxy to the session control object.
     * 
     **/
    public Ice.AsyncResult begin_create(SSLInfo info, SessionControlPrx control, Ice.Callback __cb)
    {
        return begin_create(info, control, null, false, __cb);
    }

    /**
     * Create a new session.
     * 
     * @param __cb The callback object for the operation.
     * @param info The SSL info.
     * 
     * @param control A proxy to the session control object.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_create(SSLInfo info, SessionControlPrx control, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_create(info, control, __ctx, true, __cb);
    }

    /**
     * Create a new session.
     * 
     * @param __cb The callback object for the operation.
     * @param info The SSL info.
     * 
     * @param control A proxy to the session control object.
     * 
     **/
    public Ice.AsyncResult begin_create(SSLInfo info, SessionControlPrx control, Callback_SSLSessionManager_create __cb)
    {
        return begin_create(info, control, null, false, __cb);
    }

    /**
     * Create a new session.
     * 
     * @param __cb The callback object for the operation.
     * @param info The SSL info.
     * 
     * @param control A proxy to the session control object.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_create(SSLInfo info, SessionControlPrx control, java.util.Map<String, String> __ctx, Callback_SSLSessionManager_create __cb)
    {
        return begin_create(info, control, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_create(SSLInfo info, SessionControlPrx control, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__create_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __create_name, __cb);
        try
        {
            __result.__prepare(__create_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            info.__write(__os);
            SessionControlPrxHelper.__write(__os, control);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) A proxy to the newly created session.
     * 
     **/
    public SessionPrx end_create(Ice.AsyncResult __result)
        throws CannotCreateSessionException
    {
        Ice.AsyncResult.__check(__result, this, __create_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(CannotCreateSessionException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        SessionPrx __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = SessionPrxHelper.__read(__is);
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Create a new session.
     * 
     * @param __cb The callback object for the operation.
     * @param info The SSL info.
     * 
     * @param control A proxy to the session control object.
     * 
     **/
    public boolean
    create_async(AMI_SSLSessionManager_create __cb, SSLInfo info, SessionControlPrx control)
    {
        Ice.AsyncResult __r;
        try
        {
            __checkTwowayOnly(__create_name);
            __r = begin_create(info, control, null, false, __cb);
        }
        catch(Ice.TwowayOnlyException ex)
        {
            __r = new IceInternal.OutgoingAsync(this, __create_name, __cb);
            __r.__exceptionAsync(ex);
        }
        return __r.sentSynchronously();
    }

    /**
     * Create a new session.
     * 
     * @param __cb The callback object for the operation.
     * @param info The SSL info.
     * 
     * @param control A proxy to the session control object.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public boolean
    create_async(AMI_SSLSessionManager_create __cb, SSLInfo info, SessionControlPrx control, java.util.Map<String, String> __ctx)
    {
        Ice.AsyncResult __r;
        try
        {
            __checkTwowayOnly(__create_name);
            __r = begin_create(info, control, __ctx, true, __cb);
        }
        catch(Ice.TwowayOnlyException ex)
        {
            __r = new IceInternal.OutgoingAsync(this, __create_name, __cb);
            __r.__exceptionAsync(ex);
        }
        return __r.sentSynchronously();
    }

    public static SSLSessionManagerPrx
    checkedCast(Ice.ObjectPrx __obj)
    {
        SSLSessionManagerPrx __d = null;
        if(__obj != null)
        {
            try
            {
                __d = (SSLSessionManagerPrx)__obj;
            }
            catch(ClassCastException ex)
            {
                if(__obj.ice_isA("::Glacier2::SSLSessionManager"))
                {
                    SSLSessionManagerPrxHelper __h = new SSLSessionManagerPrxHelper();
                    __h.__copyFrom(__obj);
                    __d = __h;
                }
            }
        }
        return __d;
    }

    public static SSLSessionManagerPrx
    checkedCast(Ice.ObjectPrx __obj, java.util.Map<String, String> __ctx)
    {
        SSLSessionManagerPrx __d = null;
        if(__obj != null)
        {
            try
            {
                __d = (SSLSessionManagerPrx)__obj;
            }
            catch(ClassCastException ex)
            {
                if(__obj.ice_isA("::Glacier2::SSLSessionManager", __ctx))
                {
                    SSLSessionManagerPrxHelper __h = new SSLSessionManagerPrxHelper();
                    __h.__copyFrom(__obj);
                    __d = __h;
                }
            }
        }
        return __d;
    }

    public static SSLSessionManagerPrx
    checkedCast(Ice.ObjectPrx __obj, String __facet)
    {
        SSLSessionManagerPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            try
            {
                if(__bb.ice_isA("::Glacier2::SSLSessionManager"))
                {
                    SSLSessionManagerPrxHelper __h = new SSLSessionManagerPrxHelper();
                    __h.__copyFrom(__bb);
                    __d = __h;
                }
            }
            catch(Ice.FacetNotExistException ex)
            {
            }
        }
        return __d;
    }

    public static SSLSessionManagerPrx
    checkedCast(Ice.ObjectPrx __obj, String __facet, java.util.Map<String, String> __ctx)
    {
        SSLSessionManagerPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            try
            {
                if(__bb.ice_isA("::Glacier2::SSLSessionManager", __ctx))
                {
                    SSLSessionManagerPrxHelper __h = new SSLSessionManagerPrxHelper();
                    __h.__copyFrom(__bb);
                    __d = __h;
                }
            }
            catch(Ice.FacetNotExistException ex)
            {
            }
        }
        return __d;
    }

    public static SSLSessionManagerPrx
    uncheckedCast(Ice.ObjectPrx __obj)
    {
        SSLSessionManagerPrx __d = null;
        if(__obj != null)
        {
            try
            {
                __d = (SSLSessionManagerPrx)__obj;
            }
            catch(ClassCastException ex)
            {
                SSLSessionManagerPrxHelper __h = new SSLSessionManagerPrxHelper();
                __h.__copyFrom(__obj);
                __d = __h;
            }
        }
        return __d;
    }

    public static SSLSessionManagerPrx
    uncheckedCast(Ice.ObjectPrx __obj, String __facet)
    {
        SSLSessionManagerPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            SSLSessionManagerPrxHelper __h = new SSLSessionManagerPrxHelper();
            __h.__copyFrom(__bb);
            __d = __h;
        }
        return __d;
    }

    protected Ice._ObjectDelM
    __createDelegateM()
    {
        return new _SSLSessionManagerDelM();
    }

    protected Ice._ObjectDelD
    __createDelegateD()
    {
        return new _SSLSessionManagerDelD();
    }

    public static void
    __write(IceInternal.BasicStream __os, SSLSessionManagerPrx v)
    {
        __os.writeProxy(v);
    }

    public static SSLSessionManagerPrx
    __read(IceInternal.BasicStream __is)
    {
        Ice.ObjectPrx proxy = __is.readProxy();
        if(proxy != null)
        {
            SSLSessionManagerPrxHelper result = new SSLSessionManagerPrxHelper();
            result.__copyFrom(proxy);
            return result;
        }
        return null;
    }
}
