// **********************************************************************
//
// Copyright (c) 2003-2010 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************

// Ice version 3.4.1

package Ice;

// <auto-generated>
//
// Generated from file `Communicator.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>


/**
 * The central object in Ice. One or more communicators can be
 * instantiated for an Ice application. Communicator instantiation
 * is language-specific, and not specified in Slice code.
 * 
 * @see Logger
 * @see Stats
 * @see ObjectAdapter
 * @see Properties
 * @see ObjectFactory
 * 
 **/
public interface _CommunicatorOperationsNC
{
    /**
     * Destroy the communicator. This operation calls {@link #shutdown}
     * implicitly.  Calling {@link #destroy} cleans up memory, and shuts down
     * this communicator's client functionality and destroys all object
     * adapters. Subsequent calls to {@link #destroy} are ignored.
     * 
     * @see #shutdown
     * @see ObjectAdapter#destroy
     * 
     **/
    void destroy();

    /**
     * Shuts down this communicator's server functionality, which
     * includes the deactivation of all object adapters. (Attempts to use
     * a deactivated object adapter raise {@link ObjectAdapterDeactivatedException}.)
     * Subsequent calls to {@link #shutdown} are ignored.</p>
     * 
     * <p class="Note"> After {@link #shutdown} returns, no new requests are
     * processed. However, requests that have been started before
     * {@link #shutdown} was called might still be active. You can use
     * {@link #waitForShutdown} to wait for the completion of all
     * requests.
     * 
     * @see #destroy
     * @see #waitForShutdown
     * @see ObjectAdapter#deactivate
     * 
     **/
    void shutdown();

    /**
     * Wait until the application has called {@link #shutdown} (or {@link #destroy}).
     * On the server side, this operation blocks the calling thread
     * until all currently-executing operations have completed.
     * On the client side, the operation simply block until another
     * thread has called {@link #shutdown} or {@link #destroy}.
     * 
     * <p>A typical use of this operation is to call it
     * from the main thread, which then waits until some other thread
     * calls {@link #shutdown}. After shut-down is complete, the main thread
     * returns and can do some cleanup work before it finally calls
     * {@link #destroy} to shut down the client functionality, and then
     * exits the application.
     * 
     * @see #shutdown
     * @see #destroy
     * @see ObjectAdapter#waitForDeactivate
     * 
     **/
    void waitForShutdown();

    /**
     * Check whether communicator has been shut down.
     * 
     * @return True if the communicator has been shut down; false otherwise.
     * 
     * @see #shutdown
     * 
     **/
    boolean isShutdown();

    /**
     * Convert a stringified proxy into a proxy. For example,
     * <tt>MyCategory/MyObject:tcp -h some_host -p
     * 10000</tt> creates a proxy that refers to the Ice object
     * having an identity with a name "MyObject" and a category
     * "MyCategory", with the server running on host "some_host", port
     * 10000. If the stringified proxy does not parse correctly, the
     * operation throws one of {@link ProxyParseException},
     * {@link EndpointParseException}, or {@link IdentityParseException}.
     * An appendix in the Ice manual provides a detailed description
     * of the syntax supported by stringified proxies.
     * 
     * @param str The stringified proxy to convert into a proxy.
     * 
     * @return The proxy, or nil if <tt>str</tt> is an empty string.
     * 
     * @see #proxyToString
     * 
     **/
    Ice.ObjectPrx stringToProxy(String str);

    /**
     * Convert a proxy into a string.
     * 
     * @param obj The proxy to convert into a stringified proxy.
     * 
     * @return The stringified proxy, or an empty string if
     * <tt>obj</tt> is nil.
     * 
     * @see #stringToProxy
     * 
     **/
    String proxyToString(Ice.ObjectPrx obj);

    /**
     * Convert a set of proxy properties into a proxy. The "base"
     * name supplied in the <tt>property</tt> argument refers to a
     * property containing a stringified proxy, such as
     * <tt>MyProxy=id:tcp -h localhost -p 10000</tt>. Additional
     * properties configure local settings for the proxy, such as
     * <tt>MyProxy.PreferSecure=1</tt>. The "Properties"
     * appendix in the Ice manual describes each of the supported
     * proxy properties.
     * 
     * @param property The base property name.
     * 
     * @return The proxy.
     * 
     **/
    Ice.ObjectPrx propertyToProxy(String property);

    /**
     * Convert a proxy to a set of proxy properties.
     * 
     * @param proxy The proxy.
     * 
     * @param property The base property name.
     * 
     * @return The property set.
     * 
     **/
    java.util.Map<java.lang.String, java.lang.String> proxyToProperty(Ice.ObjectPrx proxy, String property);

    /**
     * Convert a string into an identity. If the string does not parse
     * correctly, the operation throws {@link IdentityParseException}.
     * 
     * @param str The string to convert into an identity.
     * 
     * @return The identity.
     * 
     * @see #identityToString
     * 
     **/
    Identity stringToIdentity(String str);

    /**
     * Convert an identity into a string.
     * 
     * @param ident The identity to convert into a string.
     * 
     * @return The "stringified" identity.
     * 
     * @see #stringToIdentity
     * 
     **/
    String identityToString(Identity ident);

    /**
     * Create a new object adapter. The endpoints for the object
     * adapter are taken from the property <tt><em>name</em>.Endpoints</tt>.</p>
     * 
     * <p>It is legal to create an object adapter with the empty string as
     * its name. Such an object adapter is accessible via bidirectional
     * connections or by collocated invocations that originate from the
     * same communicator as is used by the adapter.</p>
     * 
     * <p>Attempts to create a named object adapter for which no configuration
     * can be found raise {@link InitializationException}.
     * 
     * @param name The object adapter name.
     * 
     * @return The new object adapter.
     * 
     * @see #createObjectAdapterWithEndpoints
     * @see ObjectAdapter
     * @see Properties
     * 
     **/
    ObjectAdapter createObjectAdapter(String name);

    /**
     * Create a new object adapter with endpoints. This operation sets
     * the property <tt><em>name</em>.Endpoints</tt>,
     * and then calls {@link createObjectAdapter}. It is provided as a
     * convenience function.</p>
     * 
     * <p>Calling this operation with an empty name will result in a
     * UUID being generated for the name.
     * 
     * @param name The object adapter name.
     * 
     * @param endpoints The endpoints for the object adapter.
     * 
     * @return The new object adapter.
     * 
     * @see #createObjectAdapter
     * @see ObjectAdapter
     * @see Properties
     * 
     **/
    ObjectAdapter createObjectAdapterWithEndpoints(String name, String endpoints);

    /**
     * Create a new object adapter with a router. This operation
     * creates a routed object adapter.</p>
     * 
     * <p>Calling this operation with an empty name will result in a
     * UUID being generated for the name.
     * 
     * @param name The object adapter name.
     * 
     * @param rtr The router.
     * 
     * @return The new object adapter.
     * 
     * @see #createObjectAdapter
     * @see ObjectAdapter
     * @see Properties
     * 
     **/
    ObjectAdapter createObjectAdapterWithRouter(String name, RouterPrx rtr);

    /**
     * Add a servant factory to this communicator. Installing a
     * factory with an id for which a factory is already registered
     * throws {@link AlreadyRegisteredException}.</p>
     * 
     * <p>When unmarshaling an Ice object, the Ice run-time reads the
     * most-derived type id off the wire and attempts to create an
     * instance of the type using a factory. If no instance is created,
     * either because no factory was found, or because all factories
     * returned nil, the object is sliced to the next most-derived type
     * and the process repeats. If no factory is found that can create an
     * instance, the Ice run-time throws {@link NoObjectFactoryException}.</p>
     * 
     * <p>The following order is used to locate a factory for a type:</p>
     * 
     * <ol>
     * 
     * <li>The Ice run-time looks for a factory registered
     * specifically for the type.</li>
     * 
     * <li>If no instance has been created, the Ice run-time looks
     * for the default factory, which is registered with an empty type id.
     * </li>
     * 
     * <li>If no instance has been created by any of the preceding
     * steps, the Ice run-time looks for a factory that may have been
     * statically generated by the language mapping for non-abstract classes.
     * </li>
     * 
     * </ol>
     * <p>
     * 
     * @param factory The factory to add.
     * 
     * @param id The type id for which the factory can create instances, or
     * an empty string for the default factory.
     * 
     * @see #findObjectFactory
     * @see ObjectFactory
     * 
     **/
    void addObjectFactory(ObjectFactory factory, String id);

    /**
     * Find a servant factory registered with this communicator.
     * 
     * @param id The type id for which the factory can create instances,
     * or an empty string for the default factory.
     * 
     * @return The servant factory, or null if no servant factory was
     * found for the given id.
     * 
     * @see #addObjectFactory
     * @see ObjectFactory
     * 
     **/
    ObjectFactory findObjectFactory(String id);

    /**
     * Get the implicit context associated with this communicator.
     * 
     * @return The implicit context associated with this communicator; 
     * returns null when the property Ice.ImplicitContext is not set 
     * or is set to None.
     * 
     **/
    ImplicitContext getImplicitContext();

    /**
     * Get the properties for this communicator.
     * 
     * @return This communicator's properties.
     * 
     * @see Properties
     * 
     **/
    Properties getProperties();

    /**
     * Get the logger for this communicator.
     * 
     * @return This communicator's logger.
     * 
     * @see Logger
     * 
     **/
    Logger getLogger();

    /**
     * Get the statistics callback object for this communicator.
     * 
     * @return This communicator's statistics callback object.
     * 
     * @see Stats
     * 
     **/
    Stats getStats();

    /**
     * Get the default router this communicator.
     * 
     * @return The default router for this communicator.
     * 
     * @see #setDefaultRouter
     * @see Router
     * 
     **/
    RouterPrx getDefaultRouter();

    /**
     * Set a default router for this communicator. All newly
     * created proxies will use this default router. To disable the
     * default router, null can be used. Note that this
     * operation has no effect on existing proxies.</p>
     * 
     * <p class="Note">You can also set a router for an individual proxy
     * by calling the operation <tt>ice_router</tt> on the proxy.
     * 
     * @param rtr The default router to use for this communicator.
     * 
     * @see #getDefaultRouter
     * @see #createObjectAdapterWithRouter
     * @see Router
     * 
     **/
    void setDefaultRouter(RouterPrx rtr);

    /**
     * Get the default locator this communicator.
     * 
     * @return The default locator for this communicator.
     * 
     * @see #setDefaultLocator
     * @see Locator
     * 
     **/
    LocatorPrx getDefaultLocator();

    /**
     * Set a default Ice locator for this communicator. All newly
     * created proxy and object adapters will use this default
     * locator. To disable the default locator, null can be used.
     * Note that this operation has no effect on existing proxies or
     * object adapters.</p>
     * 
     * <p class="Note"> You can also set a locator for an individual proxy
     * by calling the operation <tt>ice_locator</tt> on the proxy, or for an
     * object adapter by calling the operation {@link setLocator} on the
     * object adapter.
     * 
     * @param loc The default locator to use for this communicator.
     * 
     * @see #getDefaultLocator
     * @see Locator
     * @see ObjectAdapter#setLocator
     * 
     **/
    void setDefaultLocator(LocatorPrx loc);

    /**
     * Get the plug-in manager for this communicator.
     * 
     * @return This communicator's plug-in manager.
     * 
     * @see PluginManager
     * 
     **/
    PluginManager getPluginManager();

    /**
     * Flush any pending batch requests for this communicator.
     * This causes all batch requests that were sent via proxies
     * obtained via this communicator to be sent to the server.
     * 
     **/
    void flushBatchRequests();

    /**
     * Get a proxy to the main facet of the Admin object. When Ice.Admin.DelayCreation
     * is greater than 0, it is necessary to call getAdmin() after the communicator is 
     * initialized to create the Admin object. Otherwise, the Admin object is created
     * automatically after all the plug-ins are initialized.
     * 
     * @return The main ("") facet of the Admin object; a null proxy if no
     * Admin object is configured.
     * 
     **/
    Ice.ObjectPrx getAdmin();

    /**
     * Add a new facet to the Admin object.
     * Adding a servant with a facet that is already registered 
     * throws {@link AlreadyRegisteredException}.
     * 
     * @param servant The servant that implements the new Admin facet.
     * @param facet The new Admin facet.
     * 
     **/
    void addAdminFacet(Ice.Object servant, String facet);

    /**
     * Remove the following facet to the Admin object.
     * Removing a facet that was not previously registered throws 
     * {@link NotRegisteredException}.
     * 
     * @param facet The Admin facet.
     * @return The servant associated with this Admin facet
     * 
     **/
    Ice.Object removeAdminFacet(String facet);
}
