// **********************************************************************
//
// Copyright (c) 2003-2010 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************

// Ice version 3.4.1

package IceBox;

// <auto-generated>
//
// Generated from file `IceBox.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>


/**
 * Administers a set of {@link Service} instances.
 * 
 * @see Service
 * 
 **/
public final class ServiceManagerPrxHelper extends Ice.ObjectPrxHelperBase implements ServiceManagerPrx
{
    /**
     * Registers a new observer with the ServiceManager.
     * 
     * @param observer The new observer
     * 
     **/
    public void
    addObserver(ServiceObserverPrx observer)
    {
        addObserver(observer, null, false);
    }

    /**
     * Registers a new observer with the ServiceManager.
     * 
     * @param observer The new observer
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void
    addObserver(ServiceObserverPrx observer, java.util.Map<String, String> __ctx)
    {
        addObserver(observer, __ctx, true);
    }

    private void
    addObserver(ServiceObserverPrx observer, java.util.Map<String, String> __ctx, boolean __explicitCtx)
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __delBase = __getDelegate(false);
                _ServiceManagerDel __del = (_ServiceManagerDel)__delBase;
                __del.addObserver(observer, __ctx);
                return;
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __addObserver_name = "addObserver";

    /**
     * Registers a new observer with the ServiceManager.
     * 
     * @param __cb The callback object for the operation.
     * @param observer The new observer
     * 
     **/
    public Ice.AsyncResult begin_addObserver(ServiceObserverPrx observer)
    {
        return begin_addObserver(observer, null, false, null);
    }

    /**
     * Registers a new observer with the ServiceManager.
     * 
     * @param __cb The callback object for the operation.
     * @param observer The new observer
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_addObserver(ServiceObserverPrx observer, java.util.Map<String, String> __ctx)
    {
        return begin_addObserver(observer, __ctx, true, null);
    }

    /**
     * Registers a new observer with the ServiceManager.
     * 
     * @param __cb The callback object for the operation.
     * @param observer The new observer
     * 
     **/
    public Ice.AsyncResult begin_addObserver(ServiceObserverPrx observer, Ice.Callback __cb)
    {
        return begin_addObserver(observer, null, false, __cb);
    }

    /**
     * Registers a new observer with the ServiceManager.
     * 
     * @param __cb The callback object for the operation.
     * @param observer The new observer
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_addObserver(ServiceObserverPrx observer, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_addObserver(observer, __ctx, true, __cb);
    }

    /**
     * Registers a new observer with the ServiceManager.
     * 
     * @param __cb The callback object for the operation.
     * @param observer The new observer
     * 
     **/
    public Ice.AsyncResult begin_addObserver(ServiceObserverPrx observer, Callback_ServiceManager_addObserver __cb)
    {
        return begin_addObserver(observer, null, false, __cb);
    }

    /**
     * Registers a new observer with the ServiceManager.
     * 
     * @param __cb The callback object for the operation.
     * @param observer The new observer
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_addObserver(ServiceObserverPrx observer, java.util.Map<String, String> __ctx, Callback_ServiceManager_addObserver __cb)
    {
        return begin_addObserver(observer, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_addObserver(ServiceObserverPrx observer, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __addObserver_name, __cb);
        try
        {
            __result.__prepare(__addObserver_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            ServiceObserverPrxHelper.__write(__os, observer);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     **/
    public void end_addObserver(Ice.AsyncResult __result)
    {
        __end(__result, __addObserver_name);
    }

    /**
     * Registers a new observer with the ServiceManager.
     * 
     * @param __cb The callback object for the operation.
     * @param observer The new observer
     * 
     **/
    public boolean
    addObserver_async(AMI_ServiceManager_addObserver __cb, ServiceObserverPrx observer)
    {
        Ice.AsyncResult __r = begin_addObserver(observer, null, false, __cb);
        return __r.sentSynchronously();
    }

    /**
     * Registers a new observer with the ServiceManager.
     * 
     * @param __cb The callback object for the operation.
     * @param observer The new observer
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public boolean
    addObserver_async(AMI_ServiceManager_addObserver __cb, ServiceObserverPrx observer, java.util.Map<String, String> __ctx)
    {
        Ice.AsyncResult __r = begin_addObserver(observer, __ctx, true, __cb);
        return __r.sentSynchronously();
    }

    /**
     * Returns the checksums for the IceBox Slice definitions.
     * 
     * @return A dictionary mapping Slice type ids to their checksums.
     * 
     **/
    public java.util.Map<java.lang.String, java.lang.String>
    getSliceChecksums()
    {
        return getSliceChecksums(null, false);
    }

    /**
     * Returns the checksums for the IceBox Slice definitions.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return A dictionary mapping Slice type ids to their checksums.
     * 
     **/
    public java.util.Map<java.lang.String, java.lang.String>
    getSliceChecksums(java.util.Map<String, String> __ctx)
    {
        return getSliceChecksums(__ctx, true);
    }

    private java.util.Map<java.lang.String, java.lang.String>
    getSliceChecksums(java.util.Map<String, String> __ctx, boolean __explicitCtx)
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("getSliceChecksums");
                __delBase = __getDelegate(false);
                _ServiceManagerDel __del = (_ServiceManagerDel)__delBase;
                return __del.getSliceChecksums(__ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __getSliceChecksums_name = "getSliceChecksums";

    /**
     * Returns the checksums for the IceBox Slice definitions.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getSliceChecksums()
    {
        return begin_getSliceChecksums(null, false, null);
    }

    /**
     * Returns the checksums for the IceBox Slice definitions.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getSliceChecksums(java.util.Map<String, String> __ctx)
    {
        return begin_getSliceChecksums(__ctx, true, null);
    }

    /**
     * Returns the checksums for the IceBox Slice definitions.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getSliceChecksums(Ice.Callback __cb)
    {
        return begin_getSliceChecksums(null, false, __cb);
    }

    /**
     * Returns the checksums for the IceBox Slice definitions.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getSliceChecksums(java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_getSliceChecksums(__ctx, true, __cb);
    }

    /**
     * Returns the checksums for the IceBox Slice definitions.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getSliceChecksums(Callback_ServiceManager_getSliceChecksums __cb)
    {
        return begin_getSliceChecksums(null, false, __cb);
    }

    /**
     * Returns the checksums for the IceBox Slice definitions.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getSliceChecksums(java.util.Map<String, String> __ctx, Callback_ServiceManager_getSliceChecksums __cb)
    {
        return begin_getSliceChecksums(__ctx, true, __cb);
    }

    private Ice.AsyncResult begin_getSliceChecksums(java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__getSliceChecksums_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __getSliceChecksums_name, __cb);
        try
        {
            __result.__prepare(__getSliceChecksums_name, Ice.OperationMode.Idempotent, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) A dictionary mapping Slice type ids to their checksums.
     * 
     **/
    public java.util.Map<java.lang.String, java.lang.String> end_getSliceChecksums(Ice.AsyncResult __result)
    {
        Ice.AsyncResult.__check(__result, this, __getSliceChecksums_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        java.util.Map<java.lang.String, java.lang.String> __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = Ice.SliceChecksumDictHelper.read(__is);
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Shut down all services. This causes {@link Service#stop} to be
     * invoked on all configured services.
     * 
     **/
    public void
    shutdown()
    {
        shutdown(null, false);
    }

    /**
     * Shut down all services. This causes {@link Service#stop} to be
     * invoked on all configured services.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void
    shutdown(java.util.Map<String, String> __ctx)
    {
        shutdown(__ctx, true);
    }

    private void
    shutdown(java.util.Map<String, String> __ctx, boolean __explicitCtx)
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __delBase = __getDelegate(false);
                _ServiceManagerDel __del = (_ServiceManagerDel)__delBase;
                __del.shutdown(__ctx);
                return;
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __shutdown_name = "shutdown";

    /**
     * Shut down all services. This causes {@link Service#stop} to be
     * invoked on all configured services.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_shutdown()
    {
        return begin_shutdown(null, false, null);
    }

    /**
     * Shut down all services. This causes {@link Service#stop} to be
     * invoked on all configured services.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_shutdown(java.util.Map<String, String> __ctx)
    {
        return begin_shutdown(__ctx, true, null);
    }

    /**
     * Shut down all services. This causes {@link Service#stop} to be
     * invoked on all configured services.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_shutdown(Ice.Callback __cb)
    {
        return begin_shutdown(null, false, __cb);
    }

    /**
     * Shut down all services. This causes {@link Service#stop} to be
     * invoked on all configured services.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_shutdown(java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_shutdown(__ctx, true, __cb);
    }

    /**
     * Shut down all services. This causes {@link Service#stop} to be
     * invoked on all configured services.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_shutdown(Callback_ServiceManager_shutdown __cb)
    {
        return begin_shutdown(null, false, __cb);
    }

    /**
     * Shut down all services. This causes {@link Service#stop} to be
     * invoked on all configured services.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_shutdown(java.util.Map<String, String> __ctx, Callback_ServiceManager_shutdown __cb)
    {
        return begin_shutdown(__ctx, true, __cb);
    }

    private Ice.AsyncResult begin_shutdown(java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __shutdown_name, __cb);
        try
        {
            __result.__prepare(__shutdown_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     **/
    public void end_shutdown(Ice.AsyncResult __result)
    {
        __end(__result, __shutdown_name);
    }

    /**
     * Start an individual service.
     * 
     * @param service The service name.
     * 
     **/
    public void
    startService(String service)
        throws AlreadyStartedException,
               NoSuchServiceException
    {
        startService(service, null, false);
    }

    /**
     * Start an individual service.
     * 
     * @param service The service name.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void
    startService(String service, java.util.Map<String, String> __ctx)
        throws AlreadyStartedException,
               NoSuchServiceException
    {
        startService(service, __ctx, true);
    }

    private void
    startService(String service, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws AlreadyStartedException,
               NoSuchServiceException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("startService");
                __delBase = __getDelegate(false);
                _ServiceManagerDel __del = (_ServiceManagerDel)__delBase;
                __del.startService(service, __ctx);
                return;
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __startService_name = "startService";

    /**
     * Start an individual service.
     * 
     * @param __cb The callback object for the operation.
     * @param service The service name.
     * 
     **/
    public Ice.AsyncResult begin_startService(String service)
    {
        return begin_startService(service, null, false, null);
    }

    /**
     * Start an individual service.
     * 
     * @param __cb The callback object for the operation.
     * @param service The service name.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_startService(String service, java.util.Map<String, String> __ctx)
    {
        return begin_startService(service, __ctx, true, null);
    }

    /**
     * Start an individual service.
     * 
     * @param __cb The callback object for the operation.
     * @param service The service name.
     * 
     **/
    public Ice.AsyncResult begin_startService(String service, Ice.Callback __cb)
    {
        return begin_startService(service, null, false, __cb);
    }

    /**
     * Start an individual service.
     * 
     * @param __cb The callback object for the operation.
     * @param service The service name.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_startService(String service, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_startService(service, __ctx, true, __cb);
    }

    /**
     * Start an individual service.
     * 
     * @param __cb The callback object for the operation.
     * @param service The service name.
     * 
     **/
    public Ice.AsyncResult begin_startService(String service, Callback_ServiceManager_startService __cb)
    {
        return begin_startService(service, null, false, __cb);
    }

    /**
     * Start an individual service.
     * 
     * @param __cb The callback object for the operation.
     * @param service The service name.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_startService(String service, java.util.Map<String, String> __ctx, Callback_ServiceManager_startService __cb)
    {
        return begin_startService(service, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_startService(String service, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__startService_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __startService_name, __cb);
        try
        {
            __result.__prepare(__startService_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.writeString(service);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     **/
    public void end_startService(Ice.AsyncResult __result)
        throws AlreadyStartedException,
               NoSuchServiceException
    {
        Ice.AsyncResult.__check(__result, this, __startService_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(AlreadyStartedException __ex)
            {
                throw __ex;
            }
            catch(NoSuchServiceException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        IceInternal.BasicStream __is = __result.__is();
        __is.skipEmptyEncaps();
    }

    /**
     * Start an individual service.
     * 
     * @param __cb The callback object for the operation.
     * @param service The service name.
     * 
     **/
    public boolean
    startService_async(AMI_ServiceManager_startService __cb, String service)
    {
        Ice.AsyncResult __r;
        try
        {
            __checkTwowayOnly(__startService_name);
            __r = begin_startService(service, null, false, __cb);
        }
        catch(Ice.TwowayOnlyException ex)
        {
            __r = new IceInternal.OutgoingAsync(this, __startService_name, __cb);
            __r.__exceptionAsync(ex);
        }
        return __r.sentSynchronously();
    }

    /**
     * Start an individual service.
     * 
     * @param __cb The callback object for the operation.
     * @param service The service name.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public boolean
    startService_async(AMI_ServiceManager_startService __cb, String service, java.util.Map<String, String> __ctx)
    {
        Ice.AsyncResult __r;
        try
        {
            __checkTwowayOnly(__startService_name);
            __r = begin_startService(service, __ctx, true, __cb);
        }
        catch(Ice.TwowayOnlyException ex)
        {
            __r = new IceInternal.OutgoingAsync(this, __startService_name, __cb);
            __r.__exceptionAsync(ex);
        }
        return __r.sentSynchronously();
    }

    /**
     * Stop an individual service.
     * 
     * @param service The service name.
     * 
     **/
    public void
    stopService(String service)
        throws AlreadyStoppedException,
               NoSuchServiceException
    {
        stopService(service, null, false);
    }

    /**
     * Stop an individual service.
     * 
     * @param service The service name.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void
    stopService(String service, java.util.Map<String, String> __ctx)
        throws AlreadyStoppedException,
               NoSuchServiceException
    {
        stopService(service, __ctx, true);
    }

    private void
    stopService(String service, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws AlreadyStoppedException,
               NoSuchServiceException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("stopService");
                __delBase = __getDelegate(false);
                _ServiceManagerDel __del = (_ServiceManagerDel)__delBase;
                __del.stopService(service, __ctx);
                return;
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __stopService_name = "stopService";

    /**
     * Stop an individual service.
     * 
     * @param __cb The callback object for the operation.
     * @param service The service name.
     * 
     **/
    public Ice.AsyncResult begin_stopService(String service)
    {
        return begin_stopService(service, null, false, null);
    }

    /**
     * Stop an individual service.
     * 
     * @param __cb The callback object for the operation.
     * @param service The service name.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_stopService(String service, java.util.Map<String, String> __ctx)
    {
        return begin_stopService(service, __ctx, true, null);
    }

    /**
     * Stop an individual service.
     * 
     * @param __cb The callback object for the operation.
     * @param service The service name.
     * 
     **/
    public Ice.AsyncResult begin_stopService(String service, Ice.Callback __cb)
    {
        return begin_stopService(service, null, false, __cb);
    }

    /**
     * Stop an individual service.
     * 
     * @param __cb The callback object for the operation.
     * @param service The service name.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_stopService(String service, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_stopService(service, __ctx, true, __cb);
    }

    /**
     * Stop an individual service.
     * 
     * @param __cb The callback object for the operation.
     * @param service The service name.
     * 
     **/
    public Ice.AsyncResult begin_stopService(String service, Callback_ServiceManager_stopService __cb)
    {
        return begin_stopService(service, null, false, __cb);
    }

    /**
     * Stop an individual service.
     * 
     * @param __cb The callback object for the operation.
     * @param service The service name.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_stopService(String service, java.util.Map<String, String> __ctx, Callback_ServiceManager_stopService __cb)
    {
        return begin_stopService(service, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_stopService(String service, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__stopService_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __stopService_name, __cb);
        try
        {
            __result.__prepare(__stopService_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.writeString(service);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     **/
    public void end_stopService(Ice.AsyncResult __result)
        throws AlreadyStoppedException,
               NoSuchServiceException
    {
        Ice.AsyncResult.__check(__result, this, __stopService_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(AlreadyStoppedException __ex)
            {
                throw __ex;
            }
            catch(NoSuchServiceException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        IceInternal.BasicStream __is = __result.__is();
        __is.skipEmptyEncaps();
    }

    /**
     * Stop an individual service.
     * 
     * @param __cb The callback object for the operation.
     * @param service The service name.
     * 
     **/
    public boolean
    stopService_async(AMI_ServiceManager_stopService __cb, String service)
    {
        Ice.AsyncResult __r;
        try
        {
            __checkTwowayOnly(__stopService_name);
            __r = begin_stopService(service, null, false, __cb);
        }
        catch(Ice.TwowayOnlyException ex)
        {
            __r = new IceInternal.OutgoingAsync(this, __stopService_name, __cb);
            __r.__exceptionAsync(ex);
        }
        return __r.sentSynchronously();
    }

    /**
     * Stop an individual service.
     * 
     * @param __cb The callback object for the operation.
     * @param service The service name.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public boolean
    stopService_async(AMI_ServiceManager_stopService __cb, String service, java.util.Map<String, String> __ctx)
    {
        Ice.AsyncResult __r;
        try
        {
            __checkTwowayOnly(__stopService_name);
            __r = begin_stopService(service, __ctx, true, __cb);
        }
        catch(Ice.TwowayOnlyException ex)
        {
            __r = new IceInternal.OutgoingAsync(this, __stopService_name, __cb);
            __r.__exceptionAsync(ex);
        }
        return __r.sentSynchronously();
    }

    public static ServiceManagerPrx
    checkedCast(Ice.ObjectPrx __obj)
    {
        ServiceManagerPrx __d = null;
        if(__obj != null)
        {
            try
            {
                __d = (ServiceManagerPrx)__obj;
            }
            catch(ClassCastException ex)
            {
                if(__obj.ice_isA("::IceBox::ServiceManager"))
                {
                    ServiceManagerPrxHelper __h = new ServiceManagerPrxHelper();
                    __h.__copyFrom(__obj);
                    __d = __h;
                }
            }
        }
        return __d;
    }

    public static ServiceManagerPrx
    checkedCast(Ice.ObjectPrx __obj, java.util.Map<String, String> __ctx)
    {
        ServiceManagerPrx __d = null;
        if(__obj != null)
        {
            try
            {
                __d = (ServiceManagerPrx)__obj;
            }
            catch(ClassCastException ex)
            {
                if(__obj.ice_isA("::IceBox::ServiceManager", __ctx))
                {
                    ServiceManagerPrxHelper __h = new ServiceManagerPrxHelper();
                    __h.__copyFrom(__obj);
                    __d = __h;
                }
            }
        }
        return __d;
    }

    public static ServiceManagerPrx
    checkedCast(Ice.ObjectPrx __obj, String __facet)
    {
        ServiceManagerPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            try
            {
                if(__bb.ice_isA("::IceBox::ServiceManager"))
                {
                    ServiceManagerPrxHelper __h = new ServiceManagerPrxHelper();
                    __h.__copyFrom(__bb);
                    __d = __h;
                }
            }
            catch(Ice.FacetNotExistException ex)
            {
            }
        }
        return __d;
    }

    public static ServiceManagerPrx
    checkedCast(Ice.ObjectPrx __obj, String __facet, java.util.Map<String, String> __ctx)
    {
        ServiceManagerPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            try
            {
                if(__bb.ice_isA("::IceBox::ServiceManager", __ctx))
                {
                    ServiceManagerPrxHelper __h = new ServiceManagerPrxHelper();
                    __h.__copyFrom(__bb);
                    __d = __h;
                }
            }
            catch(Ice.FacetNotExistException ex)
            {
            }
        }
        return __d;
    }

    public static ServiceManagerPrx
    uncheckedCast(Ice.ObjectPrx __obj)
    {
        ServiceManagerPrx __d = null;
        if(__obj != null)
        {
            try
            {
                __d = (ServiceManagerPrx)__obj;
            }
            catch(ClassCastException ex)
            {
                ServiceManagerPrxHelper __h = new ServiceManagerPrxHelper();
                __h.__copyFrom(__obj);
                __d = __h;
            }
        }
        return __d;
    }

    public static ServiceManagerPrx
    uncheckedCast(Ice.ObjectPrx __obj, String __facet)
    {
        ServiceManagerPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            ServiceManagerPrxHelper __h = new ServiceManagerPrxHelper();
            __h.__copyFrom(__bb);
            __d = __h;
        }
        return __d;
    }

    protected Ice._ObjectDelM
    __createDelegateM()
    {
        return new _ServiceManagerDelM();
    }

    protected Ice._ObjectDelD
    __createDelegateD()
    {
        return new _ServiceManagerDelD();
    }

    public static void
    __write(IceInternal.BasicStream __os, ServiceManagerPrx v)
    {
        __os.writeProxy(v);
    }

    public static ServiceManagerPrx
    __read(IceInternal.BasicStream __is)
    {
        Ice.ObjectPrx proxy = __is.readProxy();
        if(proxy != null)
        {
            ServiceManagerPrxHelper result = new ServiceManagerPrxHelper();
            result.__copyFrom(proxy);
            return result;
        }
        return null;
    }
}
