// **********************************************************************
//
// Copyright (c) 2003-2010 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************

// Ice version 3.4.1

package IceGrid;

// <auto-generated>
//
// Generated from file `Admin.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>


/**
 * The IceGrid administrative interface. </p>
 * <p class="Warning">Allowing access to this interface
 * is a security risk! Please see the IceGrid documentation
 * for further information.
 * 
 **/
public final class AdminPrxHelper extends Ice.ObjectPrxHelperBase implements AdminPrx
{
    /**
     * Add an application to IceGrid.
     * 
     * @param descriptor The application descriptor.
     * 
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * 
     * @throws DeploymentException Raised if application deployment
     * failed.
     * 
     **/
    public void
    addApplication(ApplicationDescriptor descriptor)
        throws AccessDeniedException,
               DeploymentException
    {
        addApplication(descriptor, null, false);
    }

    /**
     * Add an application to IceGrid.
     * 
     * @param descriptor The application descriptor.
     * 
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * 
     * @throws DeploymentException Raised if application deployment
     * failed.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void
    addApplication(ApplicationDescriptor descriptor, java.util.Map<String, String> __ctx)
        throws AccessDeniedException,
               DeploymentException
    {
        addApplication(descriptor, __ctx, true);
    }

    private void
    addApplication(ApplicationDescriptor descriptor, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws AccessDeniedException,
               DeploymentException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("addApplication");
                __delBase = __getDelegate(false);
                _AdminDel __del = (_AdminDel)__delBase;
                __del.addApplication(descriptor, __ctx);
                return;
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __addApplication_name = "addApplication";

    /**
     * Add an application to IceGrid.
     * 
     * @param __cb The callback object for the operation.
     * @param descriptor The application descriptor.
     * 
     **/
    public Ice.AsyncResult begin_addApplication(ApplicationDescriptor descriptor)
    {
        return begin_addApplication(descriptor, null, false, null);
    }

    /**
     * Add an application to IceGrid.
     * 
     * @param __cb The callback object for the operation.
     * @param descriptor The application descriptor.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_addApplication(ApplicationDescriptor descriptor, java.util.Map<String, String> __ctx)
    {
        return begin_addApplication(descriptor, __ctx, true, null);
    }

    /**
     * Add an application to IceGrid.
     * 
     * @param __cb The callback object for the operation.
     * @param descriptor The application descriptor.
     * 
     **/
    public Ice.AsyncResult begin_addApplication(ApplicationDescriptor descriptor, Ice.Callback __cb)
    {
        return begin_addApplication(descriptor, null, false, __cb);
    }

    /**
     * Add an application to IceGrid.
     * 
     * @param __cb The callback object for the operation.
     * @param descriptor The application descriptor.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_addApplication(ApplicationDescriptor descriptor, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_addApplication(descriptor, __ctx, true, __cb);
    }

    /**
     * Add an application to IceGrid.
     * 
     * @param __cb The callback object for the operation.
     * @param descriptor The application descriptor.
     * 
     **/
    public Ice.AsyncResult begin_addApplication(ApplicationDescriptor descriptor, Callback_Admin_addApplication __cb)
    {
        return begin_addApplication(descriptor, null, false, __cb);
    }

    /**
     * Add an application to IceGrid.
     * 
     * @param __cb The callback object for the operation.
     * @param descriptor The application descriptor.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_addApplication(ApplicationDescriptor descriptor, java.util.Map<String, String> __ctx, Callback_Admin_addApplication __cb)
    {
        return begin_addApplication(descriptor, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_addApplication(ApplicationDescriptor descriptor, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__addApplication_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __addApplication_name, __cb);
        try
        {
            __result.__prepare(__addApplication_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            descriptor.__write(__os);
            __os.writePendingObjects();
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     **/
    public void end_addApplication(Ice.AsyncResult __result)
        throws AccessDeniedException,
               DeploymentException
    {
        Ice.AsyncResult.__check(__result, this, __addApplication_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(AccessDeniedException __ex)
            {
                throw __ex;
            }
            catch(DeploymentException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        IceInternal.BasicStream __is = __result.__is();
        __is.skipEmptyEncaps();
    }

    /**
     * Add an application to IceGrid.
     * 
     * @param __cb The callback object for the operation.
     * @param descriptor The application descriptor.
     * 
     **/
    public boolean
    addApplication_async(AMI_Admin_addApplication __cb, ApplicationDescriptor descriptor)
    {
        Ice.AsyncResult __r;
        try
        {
            __checkTwowayOnly(__addApplication_name);
            __r = begin_addApplication(descriptor, null, false, __cb);
        }
        catch(Ice.TwowayOnlyException ex)
        {
            __r = new IceInternal.OutgoingAsync(this, __addApplication_name, __cb);
            __r.__exceptionAsync(ex);
        }
        return __r.sentSynchronously();
    }

    /**
     * Add an application to IceGrid.
     * 
     * @param __cb The callback object for the operation.
     * @param descriptor The application descriptor.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public boolean
    addApplication_async(AMI_Admin_addApplication __cb, ApplicationDescriptor descriptor, java.util.Map<String, String> __ctx)
    {
        Ice.AsyncResult __r;
        try
        {
            __checkTwowayOnly(__addApplication_name);
            __r = begin_addApplication(descriptor, __ctx, true, __cb);
        }
        catch(Ice.TwowayOnlyException ex)
        {
            __r = new IceInternal.OutgoingAsync(this, __addApplication_name, __cb);
            __r.__exceptionAsync(ex);
        }
        return __r.sentSynchronously();
    }

    /**
     * Add an object to the object registry. IceGrid will get the
     * object type by calling <tt>ice_id</tt> on the given proxy. The object
     * must be reachable.
     * 
     * @param obj The object to be added to the registry.
     * 
     * @throws ObjectExistsException Raised if the object is already
     * registered.
     * 
     * @throws DeploymentException Raised if the object can't be
     * added. This might be raised if the invocation on the proxy to
     * get the object type failed.
     * 
     **/
    public void
    addObject(Ice.ObjectPrx obj)
        throws DeploymentException,
               ObjectExistsException
    {
        addObject(obj, null, false);
    }

    /**
     * Add an object to the object registry. IceGrid will get the
     * object type by calling <tt>ice_id</tt> on the given proxy. The object
     * must be reachable.
     * 
     * @param obj The object to be added to the registry.
     * 
     * @throws ObjectExistsException Raised if the object is already
     * registered.
     * 
     * @throws DeploymentException Raised if the object can't be
     * added. This might be raised if the invocation on the proxy to
     * get the object type failed.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void
    addObject(Ice.ObjectPrx obj, java.util.Map<String, String> __ctx)
        throws DeploymentException,
               ObjectExistsException
    {
        addObject(obj, __ctx, true);
    }

    private void
    addObject(Ice.ObjectPrx obj, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws DeploymentException,
               ObjectExistsException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("addObject");
                __delBase = __getDelegate(false);
                _AdminDel __del = (_AdminDel)__delBase;
                __del.addObject(obj, __ctx);
                return;
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __addObject_name = "addObject";

    /**
     * Add an object to the object registry. IceGrid will get the
     * object type by calling <tt>ice_id</tt> on the given proxy. The object
     * must be reachable.
     * 
     * @param __cb The callback object for the operation.
     * @param obj The object to be added to the registry.
     * 
     **/
    public Ice.AsyncResult begin_addObject(Ice.ObjectPrx obj)
    {
        return begin_addObject(obj, null, false, null);
    }

    /**
     * Add an object to the object registry. IceGrid will get the
     * object type by calling <tt>ice_id</tt> on the given proxy. The object
     * must be reachable.
     * 
     * @param __cb The callback object for the operation.
     * @param obj The object to be added to the registry.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_addObject(Ice.ObjectPrx obj, java.util.Map<String, String> __ctx)
    {
        return begin_addObject(obj, __ctx, true, null);
    }

    /**
     * Add an object to the object registry. IceGrid will get the
     * object type by calling <tt>ice_id</tt> on the given proxy. The object
     * must be reachable.
     * 
     * @param __cb The callback object for the operation.
     * @param obj The object to be added to the registry.
     * 
     **/
    public Ice.AsyncResult begin_addObject(Ice.ObjectPrx obj, Ice.Callback __cb)
    {
        return begin_addObject(obj, null, false, __cb);
    }

    /**
     * Add an object to the object registry. IceGrid will get the
     * object type by calling <tt>ice_id</tt> on the given proxy. The object
     * must be reachable.
     * 
     * @param __cb The callback object for the operation.
     * @param obj The object to be added to the registry.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_addObject(Ice.ObjectPrx obj, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_addObject(obj, __ctx, true, __cb);
    }

    /**
     * Add an object to the object registry. IceGrid will get the
     * object type by calling <tt>ice_id</tt> on the given proxy. The object
     * must be reachable.
     * 
     * @param __cb The callback object for the operation.
     * @param obj The object to be added to the registry.
     * 
     **/
    public Ice.AsyncResult begin_addObject(Ice.ObjectPrx obj, Callback_Admin_addObject __cb)
    {
        return begin_addObject(obj, null, false, __cb);
    }

    /**
     * Add an object to the object registry. IceGrid will get the
     * object type by calling <tt>ice_id</tt> on the given proxy. The object
     * must be reachable.
     * 
     * @param __cb The callback object for the operation.
     * @param obj The object to be added to the registry.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_addObject(Ice.ObjectPrx obj, java.util.Map<String, String> __ctx, Callback_Admin_addObject __cb)
    {
        return begin_addObject(obj, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_addObject(Ice.ObjectPrx obj, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__addObject_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __addObject_name, __cb);
        try
        {
            __result.__prepare(__addObject_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.writeProxy(obj);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     **/
    public void end_addObject(Ice.AsyncResult __result)
        throws DeploymentException,
               ObjectExistsException
    {
        Ice.AsyncResult.__check(__result, this, __addObject_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(DeploymentException __ex)
            {
                throw __ex;
            }
            catch(ObjectExistsException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        IceInternal.BasicStream __is = __result.__is();
        __is.skipEmptyEncaps();
    }

    /**
     * Add an object to the object registry. IceGrid will get the
     * object type by calling <tt>ice_id</tt> on the given proxy. The object
     * must be reachable.
     * 
     * @param __cb The callback object for the operation.
     * @param obj The object to be added to the registry.
     * 
     **/
    public boolean
    addObject_async(AMI_Admin_addObject __cb, Ice.ObjectPrx obj)
    {
        Ice.AsyncResult __r;
        try
        {
            __checkTwowayOnly(__addObject_name);
            __r = begin_addObject(obj, null, false, __cb);
        }
        catch(Ice.TwowayOnlyException ex)
        {
            __r = new IceInternal.OutgoingAsync(this, __addObject_name, __cb);
            __r.__exceptionAsync(ex);
        }
        return __r.sentSynchronously();
    }

    /**
     * Add an object to the object registry. IceGrid will get the
     * object type by calling <tt>ice_id</tt> on the given proxy. The object
     * must be reachable.
     * 
     * @param __cb The callback object for the operation.
     * @param obj The object to be added to the registry.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public boolean
    addObject_async(AMI_Admin_addObject __cb, Ice.ObjectPrx obj, java.util.Map<String, String> __ctx)
    {
        Ice.AsyncResult __r;
        try
        {
            __checkTwowayOnly(__addObject_name);
            __r = begin_addObject(obj, __ctx, true, __cb);
        }
        catch(Ice.TwowayOnlyException ex)
        {
            __r = new IceInternal.OutgoingAsync(this, __addObject_name, __cb);
            __r.__exceptionAsync(ex);
        }
        return __r.sentSynchronously();
    }

    /**
     * Add an object to the object registry and explicitly specify
     * its type.
     * 
     * @param obj The object to be added to the registry.
     * 
     * @param type The object type.
     * 
     * @throws ObjectExistsException Raised if the object is already
     * registered.
     * 
     **/
    public void
    addObjectWithType(Ice.ObjectPrx obj, String type)
        throws DeploymentException,
               ObjectExistsException
    {
        addObjectWithType(obj, type, null, false);
    }

    /**
     * Add an object to the object registry and explicitly specify
     * its type.
     * 
     * @param obj The object to be added to the registry.
     * 
     * @param type The object type.
     * 
     * @throws ObjectExistsException Raised if the object is already
     * registered.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void
    addObjectWithType(Ice.ObjectPrx obj, String type, java.util.Map<String, String> __ctx)
        throws DeploymentException,
               ObjectExistsException
    {
        addObjectWithType(obj, type, __ctx, true);
    }

    private void
    addObjectWithType(Ice.ObjectPrx obj, String type, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws DeploymentException,
               ObjectExistsException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("addObjectWithType");
                __delBase = __getDelegate(false);
                _AdminDel __del = (_AdminDel)__delBase;
                __del.addObjectWithType(obj, type, __ctx);
                return;
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __addObjectWithType_name = "addObjectWithType";

    /**
     * Add an object to the object registry and explicitly specify
     * its type.
     * 
     * @param __cb The callback object for the operation.
     * @param obj The object to be added to the registry.
     * 
     * @param type The object type.
     * 
     **/
    public Ice.AsyncResult begin_addObjectWithType(Ice.ObjectPrx obj, String type)
    {
        return begin_addObjectWithType(obj, type, null, false, null);
    }

    /**
     * Add an object to the object registry and explicitly specify
     * its type.
     * 
     * @param __cb The callback object for the operation.
     * @param obj The object to be added to the registry.
     * 
     * @param type The object type.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_addObjectWithType(Ice.ObjectPrx obj, String type, java.util.Map<String, String> __ctx)
    {
        return begin_addObjectWithType(obj, type, __ctx, true, null);
    }

    /**
     * Add an object to the object registry and explicitly specify
     * its type.
     * 
     * @param __cb The callback object for the operation.
     * @param obj The object to be added to the registry.
     * 
     * @param type The object type.
     * 
     **/
    public Ice.AsyncResult begin_addObjectWithType(Ice.ObjectPrx obj, String type, Ice.Callback __cb)
    {
        return begin_addObjectWithType(obj, type, null, false, __cb);
    }

    /**
     * Add an object to the object registry and explicitly specify
     * its type.
     * 
     * @param __cb The callback object for the operation.
     * @param obj The object to be added to the registry.
     * 
     * @param type The object type.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_addObjectWithType(Ice.ObjectPrx obj, String type, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_addObjectWithType(obj, type, __ctx, true, __cb);
    }

    /**
     * Add an object to the object registry and explicitly specify
     * its type.
     * 
     * @param __cb The callback object for the operation.
     * @param obj The object to be added to the registry.
     * 
     * @param type The object type.
     * 
     **/
    public Ice.AsyncResult begin_addObjectWithType(Ice.ObjectPrx obj, String type, Callback_Admin_addObjectWithType __cb)
    {
        return begin_addObjectWithType(obj, type, null, false, __cb);
    }

    /**
     * Add an object to the object registry and explicitly specify
     * its type.
     * 
     * @param __cb The callback object for the operation.
     * @param obj The object to be added to the registry.
     * 
     * @param type The object type.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_addObjectWithType(Ice.ObjectPrx obj, String type, java.util.Map<String, String> __ctx, Callback_Admin_addObjectWithType __cb)
    {
        return begin_addObjectWithType(obj, type, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_addObjectWithType(Ice.ObjectPrx obj, String type, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__addObjectWithType_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __addObjectWithType_name, __cb);
        try
        {
            __result.__prepare(__addObjectWithType_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.writeProxy(obj);
            __os.writeString(type);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     **/
    public void end_addObjectWithType(Ice.AsyncResult __result)
        throws DeploymentException,
               ObjectExistsException
    {
        Ice.AsyncResult.__check(__result, this, __addObjectWithType_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(DeploymentException __ex)
            {
                throw __ex;
            }
            catch(ObjectExistsException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        IceInternal.BasicStream __is = __result.__is();
        __is.skipEmptyEncaps();
    }

    /**
     * Add an object to the object registry and explicitly specify
     * its type.
     * 
     * @param __cb The callback object for the operation.
     * @param obj The object to be added to the registry.
     * 
     * @param type The object type.
     * 
     **/
    public boolean
    addObjectWithType_async(AMI_Admin_addObjectWithType __cb, Ice.ObjectPrx obj, String type)
    {
        Ice.AsyncResult __r;
        try
        {
            __checkTwowayOnly(__addObjectWithType_name);
            __r = begin_addObjectWithType(obj, type, null, false, __cb);
        }
        catch(Ice.TwowayOnlyException ex)
        {
            __r = new IceInternal.OutgoingAsync(this, __addObjectWithType_name, __cb);
            __r.__exceptionAsync(ex);
        }
        return __r.sentSynchronously();
    }

    /**
     * Add an object to the object registry and explicitly specify
     * its type.
     * 
     * @param __cb The callback object for the operation.
     * @param obj The object to be added to the registry.
     * 
     * @param type The object type.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public boolean
    addObjectWithType_async(AMI_Admin_addObjectWithType __cb, Ice.ObjectPrx obj, String type, java.util.Map<String, String> __ctx)
    {
        Ice.AsyncResult __r;
        try
        {
            __checkTwowayOnly(__addObjectWithType_name);
            __r = begin_addObjectWithType(obj, type, __ctx, true, __cb);
        }
        catch(Ice.TwowayOnlyException ex)
        {
            __r = new IceInternal.OutgoingAsync(this, __addObjectWithType_name, __cb);
            __r.__exceptionAsync(ex);
        }
        return __r.sentSynchronously();
    }

    /**
     * Enable or disable a server. A disabled server can't be started
     * on demand or administratively. The enable state of the server
     * is not persistent: if the node is shut down and restarted, the
     * server will be enabled by default.
     * 
     * @param id The server id.
     * 
     * @param enabled True to enable the server, false to disable it.
     * 
     * @throws ServerNotExistException Raised if the server doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     **/
    public void
    enableServer(String id, boolean enabled)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException
    {
        enableServer(id, enabled, null, false);
    }

    /**
     * Enable or disable a server. A disabled server can't be started
     * on demand or administratively. The enable state of the server
     * is not persistent: if the node is shut down and restarted, the
     * server will be enabled by default.
     * 
     * @param id The server id.
     * 
     * @param enabled True to enable the server, false to disable it.
     * 
     * @throws ServerNotExistException Raised if the server doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void
    enableServer(String id, boolean enabled, java.util.Map<String, String> __ctx)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException
    {
        enableServer(id, enabled, __ctx, true);
    }

    private void
    enableServer(String id, boolean enabled, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("enableServer");
                __delBase = __getDelegate(false);
                _AdminDel __del = (_AdminDel)__delBase;
                __del.enableServer(id, enabled, __ctx);
                return;
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __enableServer_name = "enableServer";

    /**
     * Enable or disable a server. A disabled server can't be started
     * on demand or administratively. The enable state of the server
     * is not persistent: if the node is shut down and restarted, the
     * server will be enabled by default.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param enabled True to enable the server, false to disable it.
     * 
     **/
    public Ice.AsyncResult begin_enableServer(String id, boolean enabled)
    {
        return begin_enableServer(id, enabled, null, false, null);
    }

    /**
     * Enable or disable a server. A disabled server can't be started
     * on demand or administratively. The enable state of the server
     * is not persistent: if the node is shut down and restarted, the
     * server will be enabled by default.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param enabled True to enable the server, false to disable it.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_enableServer(String id, boolean enabled, java.util.Map<String, String> __ctx)
    {
        return begin_enableServer(id, enabled, __ctx, true, null);
    }

    /**
     * Enable or disable a server. A disabled server can't be started
     * on demand or administratively. The enable state of the server
     * is not persistent: if the node is shut down and restarted, the
     * server will be enabled by default.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param enabled True to enable the server, false to disable it.
     * 
     **/
    public Ice.AsyncResult begin_enableServer(String id, boolean enabled, Ice.Callback __cb)
    {
        return begin_enableServer(id, enabled, null, false, __cb);
    }

    /**
     * Enable or disable a server. A disabled server can't be started
     * on demand or administratively. The enable state of the server
     * is not persistent: if the node is shut down and restarted, the
     * server will be enabled by default.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param enabled True to enable the server, false to disable it.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_enableServer(String id, boolean enabled, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_enableServer(id, enabled, __ctx, true, __cb);
    }

    /**
     * Enable or disable a server. A disabled server can't be started
     * on demand or administratively. The enable state of the server
     * is not persistent: if the node is shut down and restarted, the
     * server will be enabled by default.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param enabled True to enable the server, false to disable it.
     * 
     **/
    public Ice.AsyncResult begin_enableServer(String id, boolean enabled, Callback_Admin_enableServer __cb)
    {
        return begin_enableServer(id, enabled, null, false, __cb);
    }

    /**
     * Enable or disable a server. A disabled server can't be started
     * on demand or administratively. The enable state of the server
     * is not persistent: if the node is shut down and restarted, the
     * server will be enabled by default.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param enabled True to enable the server, false to disable it.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_enableServer(String id, boolean enabled, java.util.Map<String, String> __ctx, Callback_Admin_enableServer __cb)
    {
        return begin_enableServer(id, enabled, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_enableServer(String id, boolean enabled, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__enableServer_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __enableServer_name, __cb);
        try
        {
            __result.__prepare(__enableServer_name, Ice.OperationMode.Idempotent, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.writeString(id);
            __os.writeBool(enabled);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     **/
    public void end_enableServer(Ice.AsyncResult __result)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException
    {
        Ice.AsyncResult.__check(__result, this, __enableServer_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(DeploymentException __ex)
            {
                throw __ex;
            }
            catch(NodeUnreachableException __ex)
            {
                throw __ex;
            }
            catch(ServerNotExistException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        IceInternal.BasicStream __is = __result.__is();
        __is.skipEmptyEncaps();
    }

    /**
     * Enable or disable a server. A disabled server can't be started
     * on demand or administratively. The enable state of the server
     * is not persistent: if the node is shut down and restarted, the
     * server will be enabled by default.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param enabled True to enable the server, false to disable it.
     * 
     **/
    public boolean
    enableServer_async(AMI_Admin_enableServer __cb, String id, boolean enabled)
    {
        Ice.AsyncResult __r;
        try
        {
            __checkTwowayOnly(__enableServer_name);
            __r = begin_enableServer(id, enabled, null, false, __cb);
        }
        catch(Ice.TwowayOnlyException ex)
        {
            __r = new IceInternal.OutgoingAsync(this, __enableServer_name, __cb);
            __r.__exceptionAsync(ex);
        }
        return __r.sentSynchronously();
    }

    /**
     * Enable or disable a server. A disabled server can't be started
     * on demand or administratively. The enable state of the server
     * is not persistent: if the node is shut down and restarted, the
     * server will be enabled by default.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param enabled True to enable the server, false to disable it.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public boolean
    enableServer_async(AMI_Admin_enableServer __cb, String id, boolean enabled, java.util.Map<String, String> __ctx)
    {
        Ice.AsyncResult __r;
        try
        {
            __checkTwowayOnly(__enableServer_name);
            __r = begin_enableServer(id, enabled, __ctx, true, __cb);
        }
        catch(Ice.TwowayOnlyException ex)
        {
            __r = new IceInternal.OutgoingAsync(this, __enableServer_name, __cb);
            __r.__exceptionAsync(ex);
        }
        return __r.sentSynchronously();
    }

    /**
     * Get the adapter information for the replica group or adapter
     * with the given id.
     * 
     * @param id The adapter id.
     * 
     * @return A sequence of adapter information structures. If the
     * given id refers to an adapter, this sequence will contain only
     * one element. If the given id refers to a replica group, the
     * sequence will contain the adapter information of each member of
     * the replica group.
     * 
     * @throws AdapterNotExistException Raised if the adapter or
     * replica group doesn't exist.
     * 
     **/
    public AdapterInfo[]
    getAdapterInfo(String id)
        throws AdapterNotExistException
    {
        return getAdapterInfo(id, null, false);
    }

    /**
     * Get the adapter information for the replica group or adapter
     * with the given id.
     * 
     * @param id The adapter id.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return A sequence of adapter information structures. If the
     * given id refers to an adapter, this sequence will contain only
     * one element. If the given id refers to a replica group, the
     * sequence will contain the adapter information of each member of
     * the replica group.
     * 
     * @throws AdapterNotExistException Raised if the adapter or
     * replica group doesn't exist.
     * 
     **/
    public AdapterInfo[]
    getAdapterInfo(String id, java.util.Map<String, String> __ctx)
        throws AdapterNotExistException
    {
        return getAdapterInfo(id, __ctx, true);
    }

    private AdapterInfo[]
    getAdapterInfo(String id, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws AdapterNotExistException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("getAdapterInfo");
                __delBase = __getDelegate(false);
                _AdminDel __del = (_AdminDel)__delBase;
                return __del.getAdapterInfo(id, __ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __getAdapterInfo_name = "getAdapterInfo";

    /**
     * Get the adapter information for the replica group or adapter
     * with the given id.
     * 
     * @param __cb The callback object for the operation.
     * @param id The adapter id.
     * 
     **/
    public Ice.AsyncResult begin_getAdapterInfo(String id)
    {
        return begin_getAdapterInfo(id, null, false, null);
    }

    /**
     * Get the adapter information for the replica group or adapter
     * with the given id.
     * 
     * @param __cb The callback object for the operation.
     * @param id The adapter id.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getAdapterInfo(String id, java.util.Map<String, String> __ctx)
    {
        return begin_getAdapterInfo(id, __ctx, true, null);
    }

    /**
     * Get the adapter information for the replica group or adapter
     * with the given id.
     * 
     * @param __cb The callback object for the operation.
     * @param id The adapter id.
     * 
     **/
    public Ice.AsyncResult begin_getAdapterInfo(String id, Ice.Callback __cb)
    {
        return begin_getAdapterInfo(id, null, false, __cb);
    }

    /**
     * Get the adapter information for the replica group or adapter
     * with the given id.
     * 
     * @param __cb The callback object for the operation.
     * @param id The adapter id.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getAdapterInfo(String id, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_getAdapterInfo(id, __ctx, true, __cb);
    }

    /**
     * Get the adapter information for the replica group or adapter
     * with the given id.
     * 
     * @param __cb The callback object for the operation.
     * @param id The adapter id.
     * 
     **/
    public Ice.AsyncResult begin_getAdapterInfo(String id, Callback_Admin_getAdapterInfo __cb)
    {
        return begin_getAdapterInfo(id, null, false, __cb);
    }

    /**
     * Get the adapter information for the replica group or adapter
     * with the given id.
     * 
     * @param __cb The callback object for the operation.
     * @param id The adapter id.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getAdapterInfo(String id, java.util.Map<String, String> __ctx, Callback_Admin_getAdapterInfo __cb)
    {
        return begin_getAdapterInfo(id, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_getAdapterInfo(String id, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__getAdapterInfo_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __getAdapterInfo_name, __cb);
        try
        {
            __result.__prepare(__getAdapterInfo_name, Ice.OperationMode.Idempotent, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.writeString(id);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) A sequence of adapter information structures. If the
     * given id refers to an adapter, this sequence will contain only
     * one element. If the given id refers to a replica group, the
     * sequence will contain the adapter information of each member of
     * the replica group.
     * 
     **/
    public AdapterInfo[] end_getAdapterInfo(Ice.AsyncResult __result)
        throws AdapterNotExistException
    {
        Ice.AsyncResult.__check(__result, this, __getAdapterInfo_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(AdapterNotExistException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        AdapterInfo[] __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = AdapterInfoSeqHelper.read(__is);
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Get all the adapter ids registered with IceGrid.
     * 
     * @return The adapter ids.
     * 
     **/
    public String[]
    getAllAdapterIds()
    {
        return getAllAdapterIds(null, false);
    }

    /**
     * Get all the adapter ids registered with IceGrid.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The adapter ids.
     * 
     **/
    public String[]
    getAllAdapterIds(java.util.Map<String, String> __ctx)
    {
        return getAllAdapterIds(__ctx, true);
    }

    private String[]
    getAllAdapterIds(java.util.Map<String, String> __ctx, boolean __explicitCtx)
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("getAllAdapterIds");
                __delBase = __getDelegate(false);
                _AdminDel __del = (_AdminDel)__delBase;
                return __del.getAllAdapterIds(__ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __getAllAdapterIds_name = "getAllAdapterIds";

    /**
     * Get all the adapter ids registered with IceGrid.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getAllAdapterIds()
    {
        return begin_getAllAdapterIds(null, false, null);
    }

    /**
     * Get all the adapter ids registered with IceGrid.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getAllAdapterIds(java.util.Map<String, String> __ctx)
    {
        return begin_getAllAdapterIds(__ctx, true, null);
    }

    /**
     * Get all the adapter ids registered with IceGrid.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getAllAdapterIds(Ice.Callback __cb)
    {
        return begin_getAllAdapterIds(null, false, __cb);
    }

    /**
     * Get all the adapter ids registered with IceGrid.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getAllAdapterIds(java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_getAllAdapterIds(__ctx, true, __cb);
    }

    /**
     * Get all the adapter ids registered with IceGrid.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getAllAdapterIds(Callback_Admin_getAllAdapterIds __cb)
    {
        return begin_getAllAdapterIds(null, false, __cb);
    }

    /**
     * Get all the adapter ids registered with IceGrid.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getAllAdapterIds(java.util.Map<String, String> __ctx, Callback_Admin_getAllAdapterIds __cb)
    {
        return begin_getAllAdapterIds(__ctx, true, __cb);
    }

    private Ice.AsyncResult begin_getAllAdapterIds(java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__getAllAdapterIds_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __getAllAdapterIds_name, __cb);
        try
        {
            __result.__prepare(__getAllAdapterIds_name, Ice.OperationMode.Idempotent, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) The adapter ids.
     * 
     **/
    public String[] end_getAllAdapterIds(Ice.AsyncResult __result)
    {
        Ice.AsyncResult.__check(__result, this, __getAllAdapterIds_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        String[] __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = Ice.StringSeqHelper.read(__is);
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Get all the IceGrid applications currently registered.
     * 
     * @return The application names.
     * 
     **/
    public String[]
    getAllApplicationNames()
    {
        return getAllApplicationNames(null, false);
    }

    /**
     * Get all the IceGrid applications currently registered.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The application names.
     * 
     **/
    public String[]
    getAllApplicationNames(java.util.Map<String, String> __ctx)
    {
        return getAllApplicationNames(__ctx, true);
    }

    private String[]
    getAllApplicationNames(java.util.Map<String, String> __ctx, boolean __explicitCtx)
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("getAllApplicationNames");
                __delBase = __getDelegate(false);
                _AdminDel __del = (_AdminDel)__delBase;
                return __del.getAllApplicationNames(__ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __getAllApplicationNames_name = "getAllApplicationNames";

    /**
     * Get all the IceGrid applications currently registered.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getAllApplicationNames()
    {
        return begin_getAllApplicationNames(null, false, null);
    }

    /**
     * Get all the IceGrid applications currently registered.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getAllApplicationNames(java.util.Map<String, String> __ctx)
    {
        return begin_getAllApplicationNames(__ctx, true, null);
    }

    /**
     * Get all the IceGrid applications currently registered.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getAllApplicationNames(Ice.Callback __cb)
    {
        return begin_getAllApplicationNames(null, false, __cb);
    }

    /**
     * Get all the IceGrid applications currently registered.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getAllApplicationNames(java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_getAllApplicationNames(__ctx, true, __cb);
    }

    /**
     * Get all the IceGrid applications currently registered.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getAllApplicationNames(Callback_Admin_getAllApplicationNames __cb)
    {
        return begin_getAllApplicationNames(null, false, __cb);
    }

    /**
     * Get all the IceGrid applications currently registered.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getAllApplicationNames(java.util.Map<String, String> __ctx, Callback_Admin_getAllApplicationNames __cb)
    {
        return begin_getAllApplicationNames(__ctx, true, __cb);
    }

    private Ice.AsyncResult begin_getAllApplicationNames(java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__getAllApplicationNames_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __getAllApplicationNames_name, __cb);
        try
        {
            __result.__prepare(__getAllApplicationNames_name, Ice.OperationMode.Idempotent, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) The application names.
     * 
     **/
    public String[] end_getAllApplicationNames(Ice.AsyncResult __result)
    {
        Ice.AsyncResult.__check(__result, this, __getAllApplicationNames_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        String[] __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = Ice.StringSeqHelper.read(__is);
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Get all the IceGrid nodes currently registered.
     * 
     * @return The node names.
     * 
     **/
    public String[]
    getAllNodeNames()
    {
        return getAllNodeNames(null, false);
    }

    /**
     * Get all the IceGrid nodes currently registered.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The node names.
     * 
     **/
    public String[]
    getAllNodeNames(java.util.Map<String, String> __ctx)
    {
        return getAllNodeNames(__ctx, true);
    }

    private String[]
    getAllNodeNames(java.util.Map<String, String> __ctx, boolean __explicitCtx)
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("getAllNodeNames");
                __delBase = __getDelegate(false);
                _AdminDel __del = (_AdminDel)__delBase;
                return __del.getAllNodeNames(__ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __getAllNodeNames_name = "getAllNodeNames";

    /**
     * Get all the IceGrid nodes currently registered.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getAllNodeNames()
    {
        return begin_getAllNodeNames(null, false, null);
    }

    /**
     * Get all the IceGrid nodes currently registered.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getAllNodeNames(java.util.Map<String, String> __ctx)
    {
        return begin_getAllNodeNames(__ctx, true, null);
    }

    /**
     * Get all the IceGrid nodes currently registered.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getAllNodeNames(Ice.Callback __cb)
    {
        return begin_getAllNodeNames(null, false, __cb);
    }

    /**
     * Get all the IceGrid nodes currently registered.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getAllNodeNames(java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_getAllNodeNames(__ctx, true, __cb);
    }

    /**
     * Get all the IceGrid nodes currently registered.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getAllNodeNames(Callback_Admin_getAllNodeNames __cb)
    {
        return begin_getAllNodeNames(null, false, __cb);
    }

    /**
     * Get all the IceGrid nodes currently registered.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getAllNodeNames(java.util.Map<String, String> __ctx, Callback_Admin_getAllNodeNames __cb)
    {
        return begin_getAllNodeNames(__ctx, true, __cb);
    }

    private Ice.AsyncResult begin_getAllNodeNames(java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__getAllNodeNames_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __getAllNodeNames_name, __cb);
        try
        {
            __result.__prepare(__getAllNodeNames_name, Ice.OperationMode.Idempotent, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) The node names.
     * 
     **/
    public String[] end_getAllNodeNames(Ice.AsyncResult __result)
    {
        Ice.AsyncResult.__check(__result, this, __getAllNodeNames_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        String[] __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = Ice.StringSeqHelper.read(__is);
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Get the object info of all the registered objects whose stringified
     * identities match the given expression.
     * 
     * @param expr The expression to match against the stringified
     * identities of registered objects. The expression may contain
     * a trailing wildcard (<tt>*</tt>) character.
     * 
     * @return All the object infos with a stringified identity
     * matching the given expression.
     * 
     **/
    public ObjectInfo[]
    getAllObjectInfos(String expr)
    {
        return getAllObjectInfos(expr, null, false);
    }

    /**
     * Get the object info of all the registered objects whose stringified
     * identities match the given expression.
     * 
     * @param expr The expression to match against the stringified
     * identities of registered objects. The expression may contain
     * a trailing wildcard (<tt>*</tt>) character.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return All the object infos with a stringified identity
     * matching the given expression.
     * 
     **/
    public ObjectInfo[]
    getAllObjectInfos(String expr, java.util.Map<String, String> __ctx)
    {
        return getAllObjectInfos(expr, __ctx, true);
    }

    private ObjectInfo[]
    getAllObjectInfos(String expr, java.util.Map<String, String> __ctx, boolean __explicitCtx)
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("getAllObjectInfos");
                __delBase = __getDelegate(false);
                _AdminDel __del = (_AdminDel)__delBase;
                return __del.getAllObjectInfos(expr, __ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __getAllObjectInfos_name = "getAllObjectInfos";

    /**
     * Get the object info of all the registered objects whose stringified
     * identities match the given expression.
     * 
     * @param __cb The callback object for the operation.
     * @param expr The expression to match against the stringified
     * identities of registered objects. The expression may contain
     * a trailing wildcard (<tt>*</tt>) character.
     * 
     **/
    public Ice.AsyncResult begin_getAllObjectInfos(String expr)
    {
        return begin_getAllObjectInfos(expr, null, false, null);
    }

    /**
     * Get the object info of all the registered objects whose stringified
     * identities match the given expression.
     * 
     * @param __cb The callback object for the operation.
     * @param expr The expression to match against the stringified
     * identities of registered objects. The expression may contain
     * a trailing wildcard (<tt>*</tt>) character.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getAllObjectInfos(String expr, java.util.Map<String, String> __ctx)
    {
        return begin_getAllObjectInfos(expr, __ctx, true, null);
    }

    /**
     * Get the object info of all the registered objects whose stringified
     * identities match the given expression.
     * 
     * @param __cb The callback object for the operation.
     * @param expr The expression to match against the stringified
     * identities of registered objects. The expression may contain
     * a trailing wildcard (<tt>*</tt>) character.
     * 
     **/
    public Ice.AsyncResult begin_getAllObjectInfos(String expr, Ice.Callback __cb)
    {
        return begin_getAllObjectInfos(expr, null, false, __cb);
    }

    /**
     * Get the object info of all the registered objects whose stringified
     * identities match the given expression.
     * 
     * @param __cb The callback object for the operation.
     * @param expr The expression to match against the stringified
     * identities of registered objects. The expression may contain
     * a trailing wildcard (<tt>*</tt>) character.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getAllObjectInfos(String expr, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_getAllObjectInfos(expr, __ctx, true, __cb);
    }

    /**
     * Get the object info of all the registered objects whose stringified
     * identities match the given expression.
     * 
     * @param __cb The callback object for the operation.
     * @param expr The expression to match against the stringified
     * identities of registered objects. The expression may contain
     * a trailing wildcard (<tt>*</tt>) character.
     * 
     **/
    public Ice.AsyncResult begin_getAllObjectInfos(String expr, Callback_Admin_getAllObjectInfos __cb)
    {
        return begin_getAllObjectInfos(expr, null, false, __cb);
    }

    /**
     * Get the object info of all the registered objects whose stringified
     * identities match the given expression.
     * 
     * @param __cb The callback object for the operation.
     * @param expr The expression to match against the stringified
     * identities of registered objects. The expression may contain
     * a trailing wildcard (<tt>*</tt>) character.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getAllObjectInfos(String expr, java.util.Map<String, String> __ctx, Callback_Admin_getAllObjectInfos __cb)
    {
        return begin_getAllObjectInfos(expr, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_getAllObjectInfos(String expr, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__getAllObjectInfos_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __getAllObjectInfos_name, __cb);
        try
        {
            __result.__prepare(__getAllObjectInfos_name, Ice.OperationMode.Idempotent, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.writeString(expr);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) All the object infos with a stringified identity
     * matching the given expression.
     * 
     **/
    public ObjectInfo[] end_getAllObjectInfos(Ice.AsyncResult __result)
    {
        Ice.AsyncResult.__check(__result, this, __getAllObjectInfos_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        ObjectInfo[] __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = ObjectInfoSeqHelper.read(__is);
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Get all the IceGrid registrys currently registered.
     * 
     * @return The registry names.
     * 
     **/
    public String[]
    getAllRegistryNames()
    {
        return getAllRegistryNames(null, false);
    }

    /**
     * Get all the IceGrid registrys currently registered.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The registry names.
     * 
     **/
    public String[]
    getAllRegistryNames(java.util.Map<String, String> __ctx)
    {
        return getAllRegistryNames(__ctx, true);
    }

    private String[]
    getAllRegistryNames(java.util.Map<String, String> __ctx, boolean __explicitCtx)
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("getAllRegistryNames");
                __delBase = __getDelegate(false);
                _AdminDel __del = (_AdminDel)__delBase;
                return __del.getAllRegistryNames(__ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __getAllRegistryNames_name = "getAllRegistryNames";

    /**
     * Get all the IceGrid registrys currently registered.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getAllRegistryNames()
    {
        return begin_getAllRegistryNames(null, false, null);
    }

    /**
     * Get all the IceGrid registrys currently registered.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getAllRegistryNames(java.util.Map<String, String> __ctx)
    {
        return begin_getAllRegistryNames(__ctx, true, null);
    }

    /**
     * Get all the IceGrid registrys currently registered.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getAllRegistryNames(Ice.Callback __cb)
    {
        return begin_getAllRegistryNames(null, false, __cb);
    }

    /**
     * Get all the IceGrid registrys currently registered.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getAllRegistryNames(java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_getAllRegistryNames(__ctx, true, __cb);
    }

    /**
     * Get all the IceGrid registrys currently registered.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getAllRegistryNames(Callback_Admin_getAllRegistryNames __cb)
    {
        return begin_getAllRegistryNames(null, false, __cb);
    }

    /**
     * Get all the IceGrid registrys currently registered.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getAllRegistryNames(java.util.Map<String, String> __ctx, Callback_Admin_getAllRegistryNames __cb)
    {
        return begin_getAllRegistryNames(__ctx, true, __cb);
    }

    private Ice.AsyncResult begin_getAllRegistryNames(java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__getAllRegistryNames_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __getAllRegistryNames_name, __cb);
        try
        {
            __result.__prepare(__getAllRegistryNames_name, Ice.OperationMode.Idempotent, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) The registry names.
     * 
     **/
    public String[] end_getAllRegistryNames(Ice.AsyncResult __result)
    {
        Ice.AsyncResult.__check(__result, this, __getAllRegistryNames_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        String[] __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = Ice.StringSeqHelper.read(__is);
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Get all the server ids registered with IceGrid.
     * 
     * @return The server ids.
     * 
     **/
    public String[]
    getAllServerIds()
    {
        return getAllServerIds(null, false);
    }

    /**
     * Get all the server ids registered with IceGrid.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The server ids.
     * 
     **/
    public String[]
    getAllServerIds(java.util.Map<String, String> __ctx)
    {
        return getAllServerIds(__ctx, true);
    }

    private String[]
    getAllServerIds(java.util.Map<String, String> __ctx, boolean __explicitCtx)
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("getAllServerIds");
                __delBase = __getDelegate(false);
                _AdminDel __del = (_AdminDel)__delBase;
                return __del.getAllServerIds(__ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __getAllServerIds_name = "getAllServerIds";

    /**
     * Get all the server ids registered with IceGrid.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getAllServerIds()
    {
        return begin_getAllServerIds(null, false, null);
    }

    /**
     * Get all the server ids registered with IceGrid.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getAllServerIds(java.util.Map<String, String> __ctx)
    {
        return begin_getAllServerIds(__ctx, true, null);
    }

    /**
     * Get all the server ids registered with IceGrid.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getAllServerIds(Ice.Callback __cb)
    {
        return begin_getAllServerIds(null, false, __cb);
    }

    /**
     * Get all the server ids registered with IceGrid.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getAllServerIds(java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_getAllServerIds(__ctx, true, __cb);
    }

    /**
     * Get all the server ids registered with IceGrid.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getAllServerIds(Callback_Admin_getAllServerIds __cb)
    {
        return begin_getAllServerIds(null, false, __cb);
    }

    /**
     * Get all the server ids registered with IceGrid.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getAllServerIds(java.util.Map<String, String> __ctx, Callback_Admin_getAllServerIds __cb)
    {
        return begin_getAllServerIds(__ctx, true, __cb);
    }

    private Ice.AsyncResult begin_getAllServerIds(java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__getAllServerIds_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __getAllServerIds_name, __cb);
        try
        {
            __result.__prepare(__getAllServerIds_name, Ice.OperationMode.Idempotent, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) The server ids.
     * 
     **/
    public String[] end_getAllServerIds(Ice.AsyncResult __result)
    {
        Ice.AsyncResult.__check(__result, this, __getAllServerIds_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        String[] __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = Ice.StringSeqHelper.read(__is);
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Get an application descriptor.
     * 
     * @param name The application name.
     * 
     * @return The application descriptor.
     * 
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * 
     **/
    public ApplicationInfo
    getApplicationInfo(String name)
        throws ApplicationNotExistException
    {
        return getApplicationInfo(name, null, false);
    }

    /**
     * Get an application descriptor.
     * 
     * @param name The application name.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The application descriptor.
     * 
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * 
     **/
    public ApplicationInfo
    getApplicationInfo(String name, java.util.Map<String, String> __ctx)
        throws ApplicationNotExistException
    {
        return getApplicationInfo(name, __ctx, true);
    }

    private ApplicationInfo
    getApplicationInfo(String name, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws ApplicationNotExistException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("getApplicationInfo");
                __delBase = __getDelegate(false);
                _AdminDel __del = (_AdminDel)__delBase;
                return __del.getApplicationInfo(name, __ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __getApplicationInfo_name = "getApplicationInfo";

    /**
     * Get an application descriptor.
     * 
     * @param __cb The callback object for the operation.
     * @param name The application name.
     * 
     **/
    public Ice.AsyncResult begin_getApplicationInfo(String name)
    {
        return begin_getApplicationInfo(name, null, false, null);
    }

    /**
     * Get an application descriptor.
     * 
     * @param __cb The callback object for the operation.
     * @param name The application name.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getApplicationInfo(String name, java.util.Map<String, String> __ctx)
    {
        return begin_getApplicationInfo(name, __ctx, true, null);
    }

    /**
     * Get an application descriptor.
     * 
     * @param __cb The callback object for the operation.
     * @param name The application name.
     * 
     **/
    public Ice.AsyncResult begin_getApplicationInfo(String name, Ice.Callback __cb)
    {
        return begin_getApplicationInfo(name, null, false, __cb);
    }

    /**
     * Get an application descriptor.
     * 
     * @param __cb The callback object for the operation.
     * @param name The application name.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getApplicationInfo(String name, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_getApplicationInfo(name, __ctx, true, __cb);
    }

    /**
     * Get an application descriptor.
     * 
     * @param __cb The callback object for the operation.
     * @param name The application name.
     * 
     **/
    public Ice.AsyncResult begin_getApplicationInfo(String name, Callback_Admin_getApplicationInfo __cb)
    {
        return begin_getApplicationInfo(name, null, false, __cb);
    }

    /**
     * Get an application descriptor.
     * 
     * @param __cb The callback object for the operation.
     * @param name The application name.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getApplicationInfo(String name, java.util.Map<String, String> __ctx, Callback_Admin_getApplicationInfo __cb)
    {
        return begin_getApplicationInfo(name, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_getApplicationInfo(String name, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__getApplicationInfo_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __getApplicationInfo_name, __cb);
        try
        {
            __result.__prepare(__getApplicationInfo_name, Ice.OperationMode.Idempotent, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.writeString(name);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) The application descriptor.
     * 
     **/
    public ApplicationInfo end_getApplicationInfo(Ice.AsyncResult __result)
        throws ApplicationNotExistException
    {
        Ice.AsyncResult.__check(__result, this, __getApplicationInfo_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(ApplicationNotExistException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        ApplicationInfo __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = new ApplicationInfo();
        __ret.__read(__is);
        __is.readPendingObjects();
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Get the default application descriptor.
     * 
     * @throws DeploymentException Raised if the default application
     * descriptor can't be accessed or is invalid.
     * 
     **/
    public ApplicationDescriptor
    getDefaultApplicationDescriptor()
        throws DeploymentException
    {
        return getDefaultApplicationDescriptor(null, false);
    }

    /**
     * Get the default application descriptor.
     * 
     * @throws DeploymentException Raised if the default application
     * descriptor can't be accessed or is invalid.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public ApplicationDescriptor
    getDefaultApplicationDescriptor(java.util.Map<String, String> __ctx)
        throws DeploymentException
    {
        return getDefaultApplicationDescriptor(__ctx, true);
    }

    private ApplicationDescriptor
    getDefaultApplicationDescriptor(java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws DeploymentException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("getDefaultApplicationDescriptor");
                __delBase = __getDelegate(false);
                _AdminDel __del = (_AdminDel)__delBase;
                return __del.getDefaultApplicationDescriptor(__ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __getDefaultApplicationDescriptor_name = "getDefaultApplicationDescriptor";

    /**
     * Get the default application descriptor.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getDefaultApplicationDescriptor()
    {
        return begin_getDefaultApplicationDescriptor(null, false, null);
    }

    /**
     * Get the default application descriptor.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getDefaultApplicationDescriptor(java.util.Map<String, String> __ctx)
    {
        return begin_getDefaultApplicationDescriptor(__ctx, true, null);
    }

    /**
     * Get the default application descriptor.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getDefaultApplicationDescriptor(Ice.Callback __cb)
    {
        return begin_getDefaultApplicationDescriptor(null, false, __cb);
    }

    /**
     * Get the default application descriptor.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getDefaultApplicationDescriptor(java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_getDefaultApplicationDescriptor(__ctx, true, __cb);
    }

    /**
     * Get the default application descriptor.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getDefaultApplicationDescriptor(Callback_Admin_getDefaultApplicationDescriptor __cb)
    {
        return begin_getDefaultApplicationDescriptor(null, false, __cb);
    }

    /**
     * Get the default application descriptor.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getDefaultApplicationDescriptor(java.util.Map<String, String> __ctx, Callback_Admin_getDefaultApplicationDescriptor __cb)
    {
        return begin_getDefaultApplicationDescriptor(__ctx, true, __cb);
    }

    private Ice.AsyncResult begin_getDefaultApplicationDescriptor(java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__getDefaultApplicationDescriptor_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __getDefaultApplicationDescriptor_name, __cb);
        try
        {
            __result.__prepare(__getDefaultApplicationDescriptor_name, Ice.OperationMode.Idempotent, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     **/
    public ApplicationDescriptor end_getDefaultApplicationDescriptor(Ice.AsyncResult __result)
        throws DeploymentException
    {
        Ice.AsyncResult.__check(__result, this, __getDefaultApplicationDescriptor_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(DeploymentException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        ApplicationDescriptor __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = new ApplicationDescriptor();
        __ret.__read(__is);
        __is.readPendingObjects();
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Get the hostname of this node.
     * 
     * @param name The node name.
     * 
     * @return The node hostname.
     * 
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     **/
    public String
    getNodeHostname(String name)
        throws NodeNotExistException,
               NodeUnreachableException
    {
        return getNodeHostname(name, null, false);
    }

    /**
     * Get the hostname of this node.
     * 
     * @param name The node name.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The node hostname.
     * 
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     **/
    public String
    getNodeHostname(String name, java.util.Map<String, String> __ctx)
        throws NodeNotExistException,
               NodeUnreachableException
    {
        return getNodeHostname(name, __ctx, true);
    }

    private String
    getNodeHostname(String name, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws NodeNotExistException,
               NodeUnreachableException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("getNodeHostname");
                __delBase = __getDelegate(false);
                _AdminDel __del = (_AdminDel)__delBase;
                return __del.getNodeHostname(name, __ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __getNodeHostname_name = "getNodeHostname";

    /**
     * Get the hostname of this node.
     * 
     * @param __cb The callback object for the operation.
     * @param name The node name.
     * 
     **/
    public Ice.AsyncResult begin_getNodeHostname(String name)
    {
        return begin_getNodeHostname(name, null, false, null);
    }

    /**
     * Get the hostname of this node.
     * 
     * @param __cb The callback object for the operation.
     * @param name The node name.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getNodeHostname(String name, java.util.Map<String, String> __ctx)
    {
        return begin_getNodeHostname(name, __ctx, true, null);
    }

    /**
     * Get the hostname of this node.
     * 
     * @param __cb The callback object for the operation.
     * @param name The node name.
     * 
     **/
    public Ice.AsyncResult begin_getNodeHostname(String name, Ice.Callback __cb)
    {
        return begin_getNodeHostname(name, null, false, __cb);
    }

    /**
     * Get the hostname of this node.
     * 
     * @param __cb The callback object for the operation.
     * @param name The node name.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getNodeHostname(String name, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_getNodeHostname(name, __ctx, true, __cb);
    }

    /**
     * Get the hostname of this node.
     * 
     * @param __cb The callback object for the operation.
     * @param name The node name.
     * 
     **/
    public Ice.AsyncResult begin_getNodeHostname(String name, Callback_Admin_getNodeHostname __cb)
    {
        return begin_getNodeHostname(name, null, false, __cb);
    }

    /**
     * Get the hostname of this node.
     * 
     * @param __cb The callback object for the operation.
     * @param name The node name.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getNodeHostname(String name, java.util.Map<String, String> __ctx, Callback_Admin_getNodeHostname __cb)
    {
        return begin_getNodeHostname(name, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_getNodeHostname(String name, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__getNodeHostname_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __getNodeHostname_name, __cb);
        try
        {
            __result.__prepare(__getNodeHostname_name, Ice.OperationMode.Idempotent, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.writeString(name);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) The node hostname.
     * 
     **/
    public String end_getNodeHostname(Ice.AsyncResult __result)
        throws NodeNotExistException,
               NodeUnreachableException
    {
        Ice.AsyncResult.__check(__result, this, __getNodeHostname_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(NodeNotExistException __ex)
            {
                throw __ex;
            }
            catch(NodeUnreachableException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        String __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = __is.readString();
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Get the node information for the node with the given name.
     * 
     * @param name The node name.
     * 
     * @return The node information.
     * 
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     **/
    public NodeInfo
    getNodeInfo(String name)
        throws NodeNotExistException,
               NodeUnreachableException
    {
        return getNodeInfo(name, null, false);
    }

    /**
     * Get the node information for the node with the given name.
     * 
     * @param name The node name.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The node information.
     * 
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     **/
    public NodeInfo
    getNodeInfo(String name, java.util.Map<String, String> __ctx)
        throws NodeNotExistException,
               NodeUnreachableException
    {
        return getNodeInfo(name, __ctx, true);
    }

    private NodeInfo
    getNodeInfo(String name, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws NodeNotExistException,
               NodeUnreachableException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("getNodeInfo");
                __delBase = __getDelegate(false);
                _AdminDel __del = (_AdminDel)__delBase;
                return __del.getNodeInfo(name, __ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __getNodeInfo_name = "getNodeInfo";

    /**
     * Get the node information for the node with the given name.
     * 
     * @param __cb The callback object for the operation.
     * @param name The node name.
     * 
     **/
    public Ice.AsyncResult begin_getNodeInfo(String name)
    {
        return begin_getNodeInfo(name, null, false, null);
    }

    /**
     * Get the node information for the node with the given name.
     * 
     * @param __cb The callback object for the operation.
     * @param name The node name.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getNodeInfo(String name, java.util.Map<String, String> __ctx)
    {
        return begin_getNodeInfo(name, __ctx, true, null);
    }

    /**
     * Get the node information for the node with the given name.
     * 
     * @param __cb The callback object for the operation.
     * @param name The node name.
     * 
     **/
    public Ice.AsyncResult begin_getNodeInfo(String name, Ice.Callback __cb)
    {
        return begin_getNodeInfo(name, null, false, __cb);
    }

    /**
     * Get the node information for the node with the given name.
     * 
     * @param __cb The callback object for the operation.
     * @param name The node name.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getNodeInfo(String name, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_getNodeInfo(name, __ctx, true, __cb);
    }

    /**
     * Get the node information for the node with the given name.
     * 
     * @param __cb The callback object for the operation.
     * @param name The node name.
     * 
     **/
    public Ice.AsyncResult begin_getNodeInfo(String name, Callback_Admin_getNodeInfo __cb)
    {
        return begin_getNodeInfo(name, null, false, __cb);
    }

    /**
     * Get the node information for the node with the given name.
     * 
     * @param __cb The callback object for the operation.
     * @param name The node name.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getNodeInfo(String name, java.util.Map<String, String> __ctx, Callback_Admin_getNodeInfo __cb)
    {
        return begin_getNodeInfo(name, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_getNodeInfo(String name, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__getNodeInfo_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __getNodeInfo_name, __cb);
        try
        {
            __result.__prepare(__getNodeInfo_name, Ice.OperationMode.Idempotent, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.writeString(name);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) The node information.
     * 
     **/
    public NodeInfo end_getNodeInfo(Ice.AsyncResult __result)
        throws NodeNotExistException,
               NodeUnreachableException
    {
        Ice.AsyncResult.__check(__result, this, __getNodeInfo_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(NodeNotExistException __ex)
            {
                throw __ex;
            }
            catch(NodeUnreachableException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        NodeInfo __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = new NodeInfo();
        __ret.__read(__is);
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Get the load averages of the node.
     * 
     * @param name The node name.
     * 
     * @return The node load information.
     * 
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     **/
    public LoadInfo
    getNodeLoad(String name)
        throws NodeNotExistException,
               NodeUnreachableException
    {
        return getNodeLoad(name, null, false);
    }

    /**
     * Get the load averages of the node.
     * 
     * @param name The node name.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The node load information.
     * 
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     **/
    public LoadInfo
    getNodeLoad(String name, java.util.Map<String, String> __ctx)
        throws NodeNotExistException,
               NodeUnreachableException
    {
        return getNodeLoad(name, __ctx, true);
    }

    private LoadInfo
    getNodeLoad(String name, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws NodeNotExistException,
               NodeUnreachableException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("getNodeLoad");
                __delBase = __getDelegate(false);
                _AdminDel __del = (_AdminDel)__delBase;
                return __del.getNodeLoad(name, __ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __getNodeLoad_name = "getNodeLoad";

    /**
     * Get the load averages of the node.
     * 
     * @param __cb The callback object for the operation.
     * @param name The node name.
     * 
     **/
    public Ice.AsyncResult begin_getNodeLoad(String name)
    {
        return begin_getNodeLoad(name, null, false, null);
    }

    /**
     * Get the load averages of the node.
     * 
     * @param __cb The callback object for the operation.
     * @param name The node name.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getNodeLoad(String name, java.util.Map<String, String> __ctx)
    {
        return begin_getNodeLoad(name, __ctx, true, null);
    }

    /**
     * Get the load averages of the node.
     * 
     * @param __cb The callback object for the operation.
     * @param name The node name.
     * 
     **/
    public Ice.AsyncResult begin_getNodeLoad(String name, Ice.Callback __cb)
    {
        return begin_getNodeLoad(name, null, false, __cb);
    }

    /**
     * Get the load averages of the node.
     * 
     * @param __cb The callback object for the operation.
     * @param name The node name.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getNodeLoad(String name, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_getNodeLoad(name, __ctx, true, __cb);
    }

    /**
     * Get the load averages of the node.
     * 
     * @param __cb The callback object for the operation.
     * @param name The node name.
     * 
     **/
    public Ice.AsyncResult begin_getNodeLoad(String name, Callback_Admin_getNodeLoad __cb)
    {
        return begin_getNodeLoad(name, null, false, __cb);
    }

    /**
     * Get the load averages of the node.
     * 
     * @param __cb The callback object for the operation.
     * @param name The node name.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getNodeLoad(String name, java.util.Map<String, String> __ctx, Callback_Admin_getNodeLoad __cb)
    {
        return begin_getNodeLoad(name, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_getNodeLoad(String name, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__getNodeLoad_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __getNodeLoad_name, __cb);
        try
        {
            __result.__prepare(__getNodeLoad_name, Ice.OperationMode.Idempotent, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.writeString(name);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) The node load information.
     * 
     **/
    public LoadInfo end_getNodeLoad(Ice.AsyncResult __result)
        throws NodeNotExistException,
               NodeUnreachableException
    {
        Ice.AsyncResult.__check(__result, this, __getNodeLoad_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(NodeNotExistException __ex)
            {
                throw __ex;
            }
            catch(NodeUnreachableException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        LoadInfo __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = new LoadInfo();
        __ret.__read(__is);
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Get the load averages of the node.
     * 
     * @param __cb The callback object for the operation.
     * @param name The node name.
     * 
     **/
    public boolean
    getNodeLoad_async(AMI_Admin_getNodeLoad __cb, String name)
    {
        Ice.AsyncResult __r;
        try
        {
            __checkTwowayOnly(__getNodeLoad_name);
            __r = begin_getNodeLoad(name, null, false, __cb);
        }
        catch(Ice.TwowayOnlyException ex)
        {
            __r = new IceInternal.OutgoingAsync(this, __getNodeLoad_name, __cb);
            __r.__exceptionAsync(ex);
        }
        return __r.sentSynchronously();
    }

    /**
     * Get the load averages of the node.
     * 
     * @param __cb The callback object for the operation.
     * @param name The node name.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public boolean
    getNodeLoad_async(AMI_Admin_getNodeLoad __cb, String name, java.util.Map<String, String> __ctx)
    {
        Ice.AsyncResult __r;
        try
        {
            __checkTwowayOnly(__getNodeLoad_name);
            __r = begin_getNodeLoad(name, __ctx, true, __cb);
        }
        catch(Ice.TwowayOnlyException ex)
        {
            __r = new IceInternal.OutgoingAsync(this, __getNodeLoad_name, __cb);
            __r.__exceptionAsync(ex);
        }
        return __r.sentSynchronously();
    }

    /**
     * Get the number of physical processor sockets for the machine
     * running the node with the given name. 
     * 
     * Note that this method will return 0 on operating systems where
     * this can't be automatically determined and where the
     * IceGrid.Node.ProcessorSocketCount property for the node is not
     * set.
     * 
     * @param name The node name.
     * 
     * @return The number of processor sockets or 0 if the number of
     * sockets can't determined.
     * 
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     **/
    public int
    getNodeProcessorSocketCount(String name)
        throws NodeNotExistException,
               NodeUnreachableException
    {
        return getNodeProcessorSocketCount(name, null, false);
    }

    /**
     * Get the number of physical processor sockets for the machine
     * running the node with the given name. 
     * 
     * Note that this method will return 0 on operating systems where
     * this can't be automatically determined and where the
     * IceGrid.Node.ProcessorSocketCount property for the node is not
     * set.
     * 
     * @param name The node name.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The number of processor sockets or 0 if the number of
     * sockets can't determined.
     * 
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     **/
    public int
    getNodeProcessorSocketCount(String name, java.util.Map<String, String> __ctx)
        throws NodeNotExistException,
               NodeUnreachableException
    {
        return getNodeProcessorSocketCount(name, __ctx, true);
    }

    private int
    getNodeProcessorSocketCount(String name, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws NodeNotExistException,
               NodeUnreachableException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("getNodeProcessorSocketCount");
                __delBase = __getDelegate(false);
                _AdminDel __del = (_AdminDel)__delBase;
                return __del.getNodeProcessorSocketCount(name, __ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __getNodeProcessorSocketCount_name = "getNodeProcessorSocketCount";

    /**
     * Get the number of physical processor sockets for the machine
     * running the node with the given name. 
     * 
     * Note that this method will return 0 on operating systems where
     * this can't be automatically determined and where the
     * IceGrid.Node.ProcessorSocketCount property for the node is not
     * set.
     * 
     * @param __cb The callback object for the operation.
     * @param name The node name.
     * 
     **/
    public Ice.AsyncResult begin_getNodeProcessorSocketCount(String name)
    {
        return begin_getNodeProcessorSocketCount(name, null, false, null);
    }

    /**
     * Get the number of physical processor sockets for the machine
     * running the node with the given name. 
     * 
     * Note that this method will return 0 on operating systems where
     * this can't be automatically determined and where the
     * IceGrid.Node.ProcessorSocketCount property for the node is not
     * set.
     * 
     * @param __cb The callback object for the operation.
     * @param name The node name.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getNodeProcessorSocketCount(String name, java.util.Map<String, String> __ctx)
    {
        return begin_getNodeProcessorSocketCount(name, __ctx, true, null);
    }

    /**
     * Get the number of physical processor sockets for the machine
     * running the node with the given name. 
     * 
     * Note that this method will return 0 on operating systems where
     * this can't be automatically determined and where the
     * IceGrid.Node.ProcessorSocketCount property for the node is not
     * set.
     * 
     * @param __cb The callback object for the operation.
     * @param name The node name.
     * 
     **/
    public Ice.AsyncResult begin_getNodeProcessorSocketCount(String name, Ice.Callback __cb)
    {
        return begin_getNodeProcessorSocketCount(name, null, false, __cb);
    }

    /**
     * Get the number of physical processor sockets for the machine
     * running the node with the given name. 
     * 
     * Note that this method will return 0 on operating systems where
     * this can't be automatically determined and where the
     * IceGrid.Node.ProcessorSocketCount property for the node is not
     * set.
     * 
     * @param __cb The callback object for the operation.
     * @param name The node name.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getNodeProcessorSocketCount(String name, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_getNodeProcessorSocketCount(name, __ctx, true, __cb);
    }

    /**
     * Get the number of physical processor sockets for the machine
     * running the node with the given name. 
     * 
     * Note that this method will return 0 on operating systems where
     * this can't be automatically determined and where the
     * IceGrid.Node.ProcessorSocketCount property for the node is not
     * set.
     * 
     * @param __cb The callback object for the operation.
     * @param name The node name.
     * 
     **/
    public Ice.AsyncResult begin_getNodeProcessorSocketCount(String name, Callback_Admin_getNodeProcessorSocketCount __cb)
    {
        return begin_getNodeProcessorSocketCount(name, null, false, __cb);
    }

    /**
     * Get the number of physical processor sockets for the machine
     * running the node with the given name. 
     * 
     * Note that this method will return 0 on operating systems where
     * this can't be automatically determined and where the
     * IceGrid.Node.ProcessorSocketCount property for the node is not
     * set.
     * 
     * @param __cb The callback object for the operation.
     * @param name The node name.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getNodeProcessorSocketCount(String name, java.util.Map<String, String> __ctx, Callback_Admin_getNodeProcessorSocketCount __cb)
    {
        return begin_getNodeProcessorSocketCount(name, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_getNodeProcessorSocketCount(String name, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__getNodeProcessorSocketCount_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __getNodeProcessorSocketCount_name, __cb);
        try
        {
            __result.__prepare(__getNodeProcessorSocketCount_name, Ice.OperationMode.Idempotent, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.writeString(name);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) The number of processor sockets or 0 if the number of
     * sockets can't determined.
     * 
     **/
    public int end_getNodeProcessorSocketCount(Ice.AsyncResult __result)
        throws NodeNotExistException,
               NodeUnreachableException
    {
        Ice.AsyncResult.__check(__result, this, __getNodeProcessorSocketCount_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(NodeNotExistException __ex)
            {
                throw __ex;
            }
            catch(NodeUnreachableException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        int __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = __is.readInt();
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Get the object info for the object with the given identity.
     * 
     * @param id The identity of the object.
     * 
     * @return The object info.
     * 
     * @throws ObjectNotRegisteredException Raised if the object isn't
     * registered with the registry.
     * 
     **/
    public ObjectInfo
    getObjectInfo(Ice.Identity id)
        throws ObjectNotRegisteredException
    {
        return getObjectInfo(id, null, false);
    }

    /**
     * Get the object info for the object with the given identity.
     * 
     * @param id The identity of the object.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The object info.
     * 
     * @throws ObjectNotRegisteredException Raised if the object isn't
     * registered with the registry.
     * 
     **/
    public ObjectInfo
    getObjectInfo(Ice.Identity id, java.util.Map<String, String> __ctx)
        throws ObjectNotRegisteredException
    {
        return getObjectInfo(id, __ctx, true);
    }

    private ObjectInfo
    getObjectInfo(Ice.Identity id, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws ObjectNotRegisteredException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("getObjectInfo");
                __delBase = __getDelegate(false);
                _AdminDel __del = (_AdminDel)__delBase;
                return __del.getObjectInfo(id, __ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __getObjectInfo_name = "getObjectInfo";

    /**
     * Get the object info for the object with the given identity.
     * 
     * @param __cb The callback object for the operation.
     * @param id The identity of the object.
     * 
     **/
    public Ice.AsyncResult begin_getObjectInfo(Ice.Identity id)
    {
        return begin_getObjectInfo(id, null, false, null);
    }

    /**
     * Get the object info for the object with the given identity.
     * 
     * @param __cb The callback object for the operation.
     * @param id The identity of the object.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getObjectInfo(Ice.Identity id, java.util.Map<String, String> __ctx)
    {
        return begin_getObjectInfo(id, __ctx, true, null);
    }

    /**
     * Get the object info for the object with the given identity.
     * 
     * @param __cb The callback object for the operation.
     * @param id The identity of the object.
     * 
     **/
    public Ice.AsyncResult begin_getObjectInfo(Ice.Identity id, Ice.Callback __cb)
    {
        return begin_getObjectInfo(id, null, false, __cb);
    }

    /**
     * Get the object info for the object with the given identity.
     * 
     * @param __cb The callback object for the operation.
     * @param id The identity of the object.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getObjectInfo(Ice.Identity id, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_getObjectInfo(id, __ctx, true, __cb);
    }

    /**
     * Get the object info for the object with the given identity.
     * 
     * @param __cb The callback object for the operation.
     * @param id The identity of the object.
     * 
     **/
    public Ice.AsyncResult begin_getObjectInfo(Ice.Identity id, Callback_Admin_getObjectInfo __cb)
    {
        return begin_getObjectInfo(id, null, false, __cb);
    }

    /**
     * Get the object info for the object with the given identity.
     * 
     * @param __cb The callback object for the operation.
     * @param id The identity of the object.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getObjectInfo(Ice.Identity id, java.util.Map<String, String> __ctx, Callback_Admin_getObjectInfo __cb)
    {
        return begin_getObjectInfo(id, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_getObjectInfo(Ice.Identity id, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__getObjectInfo_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __getObjectInfo_name, __cb);
        try
        {
            __result.__prepare(__getObjectInfo_name, Ice.OperationMode.Idempotent, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            id.__write(__os);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) The object info.
     * 
     **/
    public ObjectInfo end_getObjectInfo(Ice.AsyncResult __result)
        throws ObjectNotRegisteredException
    {
        Ice.AsyncResult.__check(__result, this, __getObjectInfo_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(ObjectNotRegisteredException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        ObjectInfo __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = new ObjectInfo();
        __ret.__read(__is);
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Get the object info of all the registered objects with the
     * given type.
     * 
     * @param type The type of the object.
     * 
     * @return The object infos.
     * 
     **/
    public ObjectInfo[]
    getObjectInfosByType(String type)
    {
        return getObjectInfosByType(type, null, false);
    }

    /**
     * Get the object info of all the registered objects with the
     * given type.
     * 
     * @param type The type of the object.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The object infos.
     * 
     **/
    public ObjectInfo[]
    getObjectInfosByType(String type, java.util.Map<String, String> __ctx)
    {
        return getObjectInfosByType(type, __ctx, true);
    }

    private ObjectInfo[]
    getObjectInfosByType(String type, java.util.Map<String, String> __ctx, boolean __explicitCtx)
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("getObjectInfosByType");
                __delBase = __getDelegate(false);
                _AdminDel __del = (_AdminDel)__delBase;
                return __del.getObjectInfosByType(type, __ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __getObjectInfosByType_name = "getObjectInfosByType";

    /**
     * Get the object info of all the registered objects with the
     * given type.
     * 
     * @param __cb The callback object for the operation.
     * @param type The type of the object.
     * 
     **/
    public Ice.AsyncResult begin_getObjectInfosByType(String type)
    {
        return begin_getObjectInfosByType(type, null, false, null);
    }

    /**
     * Get the object info of all the registered objects with the
     * given type.
     * 
     * @param __cb The callback object for the operation.
     * @param type The type of the object.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getObjectInfosByType(String type, java.util.Map<String, String> __ctx)
    {
        return begin_getObjectInfosByType(type, __ctx, true, null);
    }

    /**
     * Get the object info of all the registered objects with the
     * given type.
     * 
     * @param __cb The callback object for the operation.
     * @param type The type of the object.
     * 
     **/
    public Ice.AsyncResult begin_getObjectInfosByType(String type, Ice.Callback __cb)
    {
        return begin_getObjectInfosByType(type, null, false, __cb);
    }

    /**
     * Get the object info of all the registered objects with the
     * given type.
     * 
     * @param __cb The callback object for the operation.
     * @param type The type of the object.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getObjectInfosByType(String type, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_getObjectInfosByType(type, __ctx, true, __cb);
    }

    /**
     * Get the object info of all the registered objects with the
     * given type.
     * 
     * @param __cb The callback object for the operation.
     * @param type The type of the object.
     * 
     **/
    public Ice.AsyncResult begin_getObjectInfosByType(String type, Callback_Admin_getObjectInfosByType __cb)
    {
        return begin_getObjectInfosByType(type, null, false, __cb);
    }

    /**
     * Get the object info of all the registered objects with the
     * given type.
     * 
     * @param __cb The callback object for the operation.
     * @param type The type of the object.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getObjectInfosByType(String type, java.util.Map<String, String> __ctx, Callback_Admin_getObjectInfosByType __cb)
    {
        return begin_getObjectInfosByType(type, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_getObjectInfosByType(String type, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__getObjectInfosByType_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __getObjectInfosByType_name, __cb);
        try
        {
            __result.__prepare(__getObjectInfosByType_name, Ice.OperationMode.Idempotent, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.writeString(type);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) The object infos.
     * 
     **/
    public ObjectInfo[] end_getObjectInfosByType(Ice.AsyncResult __result)
    {
        Ice.AsyncResult.__check(__result, this, __getObjectInfosByType_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        ObjectInfo[] __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = ObjectInfoSeqHelper.read(__is);
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Get the registry information for the registry with the given name.
     * 
     * @param name The registry name.
     * 
     * @return The registry information.
     * 
     * @throws RegistryNotExistException Raised if the registry doesn't exist.
     * 
     * @throws RegistryUnreachableException Raised if the registry could not be
     * reached.
     * 
     **/
    public RegistryInfo
    getRegistryInfo(String name)
        throws RegistryNotExistException,
               RegistryUnreachableException
    {
        return getRegistryInfo(name, null, false);
    }

    /**
     * Get the registry information for the registry with the given name.
     * 
     * @param name The registry name.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The registry information.
     * 
     * @throws RegistryNotExistException Raised if the registry doesn't exist.
     * 
     * @throws RegistryUnreachableException Raised if the registry could not be
     * reached.
     * 
     **/
    public RegistryInfo
    getRegistryInfo(String name, java.util.Map<String, String> __ctx)
        throws RegistryNotExistException,
               RegistryUnreachableException
    {
        return getRegistryInfo(name, __ctx, true);
    }

    private RegistryInfo
    getRegistryInfo(String name, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws RegistryNotExistException,
               RegistryUnreachableException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("getRegistryInfo");
                __delBase = __getDelegate(false);
                _AdminDel __del = (_AdminDel)__delBase;
                return __del.getRegistryInfo(name, __ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __getRegistryInfo_name = "getRegistryInfo";

    /**
     * Get the registry information for the registry with the given name.
     * 
     * @param __cb The callback object for the operation.
     * @param name The registry name.
     * 
     **/
    public Ice.AsyncResult begin_getRegistryInfo(String name)
    {
        return begin_getRegistryInfo(name, null, false, null);
    }

    /**
     * Get the registry information for the registry with the given name.
     * 
     * @param __cb The callback object for the operation.
     * @param name The registry name.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getRegistryInfo(String name, java.util.Map<String, String> __ctx)
    {
        return begin_getRegistryInfo(name, __ctx, true, null);
    }

    /**
     * Get the registry information for the registry with the given name.
     * 
     * @param __cb The callback object for the operation.
     * @param name The registry name.
     * 
     **/
    public Ice.AsyncResult begin_getRegistryInfo(String name, Ice.Callback __cb)
    {
        return begin_getRegistryInfo(name, null, false, __cb);
    }

    /**
     * Get the registry information for the registry with the given name.
     * 
     * @param __cb The callback object for the operation.
     * @param name The registry name.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getRegistryInfo(String name, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_getRegistryInfo(name, __ctx, true, __cb);
    }

    /**
     * Get the registry information for the registry with the given name.
     * 
     * @param __cb The callback object for the operation.
     * @param name The registry name.
     * 
     **/
    public Ice.AsyncResult begin_getRegistryInfo(String name, Callback_Admin_getRegistryInfo __cb)
    {
        return begin_getRegistryInfo(name, null, false, __cb);
    }

    /**
     * Get the registry information for the registry with the given name.
     * 
     * @param __cb The callback object for the operation.
     * @param name The registry name.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getRegistryInfo(String name, java.util.Map<String, String> __ctx, Callback_Admin_getRegistryInfo __cb)
    {
        return begin_getRegistryInfo(name, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_getRegistryInfo(String name, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__getRegistryInfo_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __getRegistryInfo_name, __cb);
        try
        {
            __result.__prepare(__getRegistryInfo_name, Ice.OperationMode.Idempotent, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.writeString(name);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) The registry information.
     * 
     **/
    public RegistryInfo end_getRegistryInfo(Ice.AsyncResult __result)
        throws RegistryNotExistException,
               RegistryUnreachableException
    {
        Ice.AsyncResult.__check(__result, this, __getRegistryInfo_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(RegistryNotExistException __ex)
            {
                throw __ex;
            }
            catch(RegistryUnreachableException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        RegistryInfo __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = new RegistryInfo();
        __ret.__read(__is);
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Get a proxy to the server's admin object.
     * 
     * @param id The server id.
     * 
     * @return A proxy to the server's admin object
     * 
     * @throws ServerNotExistException Raised if the server doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     **/
    public Ice.ObjectPrx
    getServerAdmin(String id)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException
    {
        return getServerAdmin(id, null, false);
    }

    /**
     * Get a proxy to the server's admin object.
     * 
     * @param id The server id.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return A proxy to the server's admin object
     * 
     * @throws ServerNotExistException Raised if the server doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     **/
    public Ice.ObjectPrx
    getServerAdmin(String id, java.util.Map<String, String> __ctx)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException
    {
        return getServerAdmin(id, __ctx, true);
    }

    private Ice.ObjectPrx
    getServerAdmin(String id, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("getServerAdmin");
                __delBase = __getDelegate(false);
                _AdminDel __del = (_AdminDel)__delBase;
                return __del.getServerAdmin(id, __ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __getServerAdmin_name = "getServerAdmin";

    /**
     * Get a proxy to the server's admin object.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     **/
    public Ice.AsyncResult begin_getServerAdmin(String id)
    {
        return begin_getServerAdmin(id, null, false, null);
    }

    /**
     * Get a proxy to the server's admin object.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getServerAdmin(String id, java.util.Map<String, String> __ctx)
    {
        return begin_getServerAdmin(id, __ctx, true, null);
    }

    /**
     * Get a proxy to the server's admin object.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     **/
    public Ice.AsyncResult begin_getServerAdmin(String id, Ice.Callback __cb)
    {
        return begin_getServerAdmin(id, null, false, __cb);
    }

    /**
     * Get a proxy to the server's admin object.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getServerAdmin(String id, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_getServerAdmin(id, __ctx, true, __cb);
    }

    /**
     * Get a proxy to the server's admin object.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     **/
    public Ice.AsyncResult begin_getServerAdmin(String id, Callback_Admin_getServerAdmin __cb)
    {
        return begin_getServerAdmin(id, null, false, __cb);
    }

    /**
     * Get a proxy to the server's admin object.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getServerAdmin(String id, java.util.Map<String, String> __ctx, Callback_Admin_getServerAdmin __cb)
    {
        return begin_getServerAdmin(id, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_getServerAdmin(String id, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__getServerAdmin_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __getServerAdmin_name, __cb);
        try
        {
            __result.__prepare(__getServerAdmin_name, Ice.OperationMode.Idempotent, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.writeString(id);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) A proxy to the server's admin object
     * 
     **/
    public Ice.ObjectPrx end_getServerAdmin(Ice.AsyncResult __result)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException
    {
        Ice.AsyncResult.__check(__result, this, __getServerAdmin_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(DeploymentException __ex)
            {
                throw __ex;
            }
            catch(NodeUnreachableException __ex)
            {
                throw __ex;
            }
            catch(ServerNotExistException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        Ice.ObjectPrx __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = __is.readProxy();
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Get the category for server admin objects. You can manufacture a server admin
     * proxy from the admin proxy by changing its identity: use the server ID as name
     * and the returned category as category.
     * 
     * @return The category for server admin objects.
     * 
     **/
    public String
    getServerAdminCategory()
    {
        return getServerAdminCategory(null, false);
    }

    /**
     * Get the category for server admin objects. You can manufacture a server admin
     * proxy from the admin proxy by changing its identity: use the server ID as name
     * and the returned category as category.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The category for server admin objects.
     * 
     **/
    public String
    getServerAdminCategory(java.util.Map<String, String> __ctx)
    {
        return getServerAdminCategory(__ctx, true);
    }

    private String
    getServerAdminCategory(java.util.Map<String, String> __ctx, boolean __explicitCtx)
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("getServerAdminCategory");
                __delBase = __getDelegate(false);
                _AdminDel __del = (_AdminDel)__delBase;
                return __del.getServerAdminCategory(__ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __getServerAdminCategory_name = "getServerAdminCategory";

    /**
     * Get the category for server admin objects. You can manufacture a server admin
     * proxy from the admin proxy by changing its identity: use the server ID as name
     * and the returned category as category.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getServerAdminCategory()
    {
        return begin_getServerAdminCategory(null, false, null);
    }

    /**
     * Get the category for server admin objects. You can manufacture a server admin
     * proxy from the admin proxy by changing its identity: use the server ID as name
     * and the returned category as category.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getServerAdminCategory(java.util.Map<String, String> __ctx)
    {
        return begin_getServerAdminCategory(__ctx, true, null);
    }

    /**
     * Get the category for server admin objects. You can manufacture a server admin
     * proxy from the admin proxy by changing its identity: use the server ID as name
     * and the returned category as category.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getServerAdminCategory(Ice.Callback __cb)
    {
        return begin_getServerAdminCategory(null, false, __cb);
    }

    /**
     * Get the category for server admin objects. You can manufacture a server admin
     * proxy from the admin proxy by changing its identity: use the server ID as name
     * and the returned category as category.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getServerAdminCategory(java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_getServerAdminCategory(__ctx, true, __cb);
    }

    /**
     * Get the category for server admin objects. You can manufacture a server admin
     * proxy from the admin proxy by changing its identity: use the server ID as name
     * and the returned category as category.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getServerAdminCategory(Callback_Admin_getServerAdminCategory __cb)
    {
        return begin_getServerAdminCategory(null, false, __cb);
    }

    /**
     * Get the category for server admin objects. You can manufacture a server admin
     * proxy from the admin proxy by changing its identity: use the server ID as name
     * and the returned category as category.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getServerAdminCategory(java.util.Map<String, String> __ctx, Callback_Admin_getServerAdminCategory __cb)
    {
        return begin_getServerAdminCategory(__ctx, true, __cb);
    }

    private Ice.AsyncResult begin_getServerAdminCategory(java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__getServerAdminCategory_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __getServerAdminCategory_name, __cb);
        try
        {
            __result.__prepare(__getServerAdminCategory_name, Ice.OperationMode.Idempotent, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) The category for server admin objects.
     * 
     **/
    public String end_getServerAdminCategory(Ice.AsyncResult __result)
    {
        Ice.AsyncResult.__check(__result, this, __getServerAdminCategory_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        String __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = __is.readString();
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Get the server information for the server with the given id.
     * 
     * @param id The server id.
     * 
     * @throws ServerNotExistException Raised if the server doesn't exist.
     * 
     * @return The server information.
     * 
     **/
    public ServerInfo
    getServerInfo(String id)
        throws ServerNotExistException
    {
        return getServerInfo(id, null, false);
    }

    /**
     * Get the server information for the server with the given id.
     * 
     * @param id The server id.
     * 
     * @throws ServerNotExistException Raised if the server doesn't exist.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The server information.
     * 
     **/
    public ServerInfo
    getServerInfo(String id, java.util.Map<String, String> __ctx)
        throws ServerNotExistException
    {
        return getServerInfo(id, __ctx, true);
    }

    private ServerInfo
    getServerInfo(String id, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws ServerNotExistException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("getServerInfo");
                __delBase = __getDelegate(false);
                _AdminDel __del = (_AdminDel)__delBase;
                return __del.getServerInfo(id, __ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __getServerInfo_name = "getServerInfo";

    /**
     * Get the server information for the server with the given id.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     **/
    public Ice.AsyncResult begin_getServerInfo(String id)
    {
        return begin_getServerInfo(id, null, false, null);
    }

    /**
     * Get the server information for the server with the given id.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getServerInfo(String id, java.util.Map<String, String> __ctx)
    {
        return begin_getServerInfo(id, __ctx, true, null);
    }

    /**
     * Get the server information for the server with the given id.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     **/
    public Ice.AsyncResult begin_getServerInfo(String id, Ice.Callback __cb)
    {
        return begin_getServerInfo(id, null, false, __cb);
    }

    /**
     * Get the server information for the server with the given id.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getServerInfo(String id, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_getServerInfo(id, __ctx, true, __cb);
    }

    /**
     * Get the server information for the server with the given id.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     **/
    public Ice.AsyncResult begin_getServerInfo(String id, Callback_Admin_getServerInfo __cb)
    {
        return begin_getServerInfo(id, null, false, __cb);
    }

    /**
     * Get the server information for the server with the given id.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getServerInfo(String id, java.util.Map<String, String> __ctx, Callback_Admin_getServerInfo __cb)
    {
        return begin_getServerInfo(id, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_getServerInfo(String id, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__getServerInfo_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __getServerInfo_name, __cb);
        try
        {
            __result.__prepare(__getServerInfo_name, Ice.OperationMode.Idempotent, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.writeString(id);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) The server information.
     * 
     **/
    public ServerInfo end_getServerInfo(Ice.AsyncResult __result)
        throws ServerNotExistException
    {
        Ice.AsyncResult.__check(__result, this, __getServerInfo_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(ServerNotExistException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        ServerInfo __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = new ServerInfo();
        __ret.__read(__is);
        __is.readPendingObjects();
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Get a server's system process id. The process id is operating
     * system dependent.
     * 
     * @param id The server id.
     * 
     * @return The server's process id.
     * 
     * @throws ServerNotExistException Raised if the server doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     **/
    public int
    getServerPid(String id)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException
    {
        return getServerPid(id, null, false);
    }

    /**
     * Get a server's system process id. The process id is operating
     * system dependent.
     * 
     * @param id The server id.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The server's process id.
     * 
     * @throws ServerNotExistException Raised if the server doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     **/
    public int
    getServerPid(String id, java.util.Map<String, String> __ctx)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException
    {
        return getServerPid(id, __ctx, true);
    }

    private int
    getServerPid(String id, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("getServerPid");
                __delBase = __getDelegate(false);
                _AdminDel __del = (_AdminDel)__delBase;
                return __del.getServerPid(id, __ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __getServerPid_name = "getServerPid";

    /**
     * Get a server's system process id. The process id is operating
     * system dependent.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     **/
    public Ice.AsyncResult begin_getServerPid(String id)
    {
        return begin_getServerPid(id, null, false, null);
    }

    /**
     * Get a server's system process id. The process id is operating
     * system dependent.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getServerPid(String id, java.util.Map<String, String> __ctx)
    {
        return begin_getServerPid(id, __ctx, true, null);
    }

    /**
     * Get a server's system process id. The process id is operating
     * system dependent.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     **/
    public Ice.AsyncResult begin_getServerPid(String id, Ice.Callback __cb)
    {
        return begin_getServerPid(id, null, false, __cb);
    }

    /**
     * Get a server's system process id. The process id is operating
     * system dependent.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getServerPid(String id, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_getServerPid(id, __ctx, true, __cb);
    }

    /**
     * Get a server's system process id. The process id is operating
     * system dependent.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     **/
    public Ice.AsyncResult begin_getServerPid(String id, Callback_Admin_getServerPid __cb)
    {
        return begin_getServerPid(id, null, false, __cb);
    }

    /**
     * Get a server's system process id. The process id is operating
     * system dependent.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getServerPid(String id, java.util.Map<String, String> __ctx, Callback_Admin_getServerPid __cb)
    {
        return begin_getServerPid(id, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_getServerPid(String id, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__getServerPid_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __getServerPid_name, __cb);
        try
        {
            __result.__prepare(__getServerPid_name, Ice.OperationMode.Idempotent, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.writeString(id);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) The server's process id.
     * 
     **/
    public int end_getServerPid(Ice.AsyncResult __result)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException
    {
        Ice.AsyncResult.__check(__result, this, __getServerPid_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(DeploymentException __ex)
            {
                throw __ex;
            }
            catch(NodeUnreachableException __ex)
            {
                throw __ex;
            }
            catch(ServerNotExistException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        int __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = __is.readInt();
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Get a server's state.
     * 
     * @param id The server id.
     * 
     * @return The server state.
     * 
     * @throws ServerNotExistException Raised if the server doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     **/
    public ServerState
    getServerState(String id)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException
    {
        return getServerState(id, null, false);
    }

    /**
     * Get a server's state.
     * 
     * @param id The server id.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The server state.
     * 
     * @throws ServerNotExistException Raised if the server doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     **/
    public ServerState
    getServerState(String id, java.util.Map<String, String> __ctx)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException
    {
        return getServerState(id, __ctx, true);
    }

    private ServerState
    getServerState(String id, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("getServerState");
                __delBase = __getDelegate(false);
                _AdminDel __del = (_AdminDel)__delBase;
                return __del.getServerState(id, __ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __getServerState_name = "getServerState";

    /**
     * Get a server's state.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     **/
    public Ice.AsyncResult begin_getServerState(String id)
    {
        return begin_getServerState(id, null, false, null);
    }

    /**
     * Get a server's state.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getServerState(String id, java.util.Map<String, String> __ctx)
    {
        return begin_getServerState(id, __ctx, true, null);
    }

    /**
     * Get a server's state.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     **/
    public Ice.AsyncResult begin_getServerState(String id, Ice.Callback __cb)
    {
        return begin_getServerState(id, null, false, __cb);
    }

    /**
     * Get a server's state.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getServerState(String id, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_getServerState(id, __ctx, true, __cb);
    }

    /**
     * Get a server's state.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     **/
    public Ice.AsyncResult begin_getServerState(String id, Callback_Admin_getServerState __cb)
    {
        return begin_getServerState(id, null, false, __cb);
    }

    /**
     * Get a server's state.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getServerState(String id, java.util.Map<String, String> __ctx, Callback_Admin_getServerState __cb)
    {
        return begin_getServerState(id, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_getServerState(String id, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__getServerState_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __getServerState_name, __cb);
        try
        {
            __result.__prepare(__getServerState_name, Ice.OperationMode.Idempotent, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.writeString(id);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) The server state.
     * 
     **/
    public ServerState end_getServerState(Ice.AsyncResult __result)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException
    {
        Ice.AsyncResult.__check(__result, this, __getServerState_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(DeploymentException __ex)
            {
                throw __ex;
            }
            catch(NodeUnreachableException __ex)
            {
                throw __ex;
            }
            catch(ServerNotExistException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        ServerState __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = ServerState.__read(__is);
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Returns the checksums for the IceGrid Slice definitions.
     * 
     * @return A dictionary mapping Slice type ids to their checksums.
     * 
     **/
    public java.util.Map<java.lang.String, java.lang.String>
    getSliceChecksums()
    {
        return getSliceChecksums(null, false);
    }

    /**
     * Returns the checksums for the IceGrid Slice definitions.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return A dictionary mapping Slice type ids to their checksums.
     * 
     **/
    public java.util.Map<java.lang.String, java.lang.String>
    getSliceChecksums(java.util.Map<String, String> __ctx)
    {
        return getSliceChecksums(__ctx, true);
    }

    private java.util.Map<java.lang.String, java.lang.String>
    getSliceChecksums(java.util.Map<String, String> __ctx, boolean __explicitCtx)
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("getSliceChecksums");
                __delBase = __getDelegate(false);
                _AdminDel __del = (_AdminDel)__delBase;
                return __del.getSliceChecksums(__ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __getSliceChecksums_name = "getSliceChecksums";

    /**
     * Returns the checksums for the IceGrid Slice definitions.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getSliceChecksums()
    {
        return begin_getSliceChecksums(null, false, null);
    }

    /**
     * Returns the checksums for the IceGrid Slice definitions.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getSliceChecksums(java.util.Map<String, String> __ctx)
    {
        return begin_getSliceChecksums(__ctx, true, null);
    }

    /**
     * Returns the checksums for the IceGrid Slice definitions.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getSliceChecksums(Ice.Callback __cb)
    {
        return begin_getSliceChecksums(null, false, __cb);
    }

    /**
     * Returns the checksums for the IceGrid Slice definitions.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getSliceChecksums(java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_getSliceChecksums(__ctx, true, __cb);
    }

    /**
     * Returns the checksums for the IceGrid Slice definitions.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getSliceChecksums(Callback_Admin_getSliceChecksums __cb)
    {
        return begin_getSliceChecksums(null, false, __cb);
    }

    /**
     * Returns the checksums for the IceGrid Slice definitions.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getSliceChecksums(java.util.Map<String, String> __ctx, Callback_Admin_getSliceChecksums __cb)
    {
        return begin_getSliceChecksums(__ctx, true, __cb);
    }

    private Ice.AsyncResult begin_getSliceChecksums(java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__getSliceChecksums_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __getSliceChecksums_name, __cb);
        try
        {
            __result.__prepare(__getSliceChecksums_name, Ice.OperationMode.Idempotent, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) A dictionary mapping Slice type ids to their checksums.
     * 
     **/
    public java.util.Map<java.lang.String, java.lang.String> end_getSliceChecksums(Ice.AsyncResult __result)
    {
        Ice.AsyncResult.__check(__result, this, __getSliceChecksums_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        java.util.Map<java.lang.String, java.lang.String> __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = Ice.SliceChecksumDictHelper.read(__is);
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Instantiate a server template from an application on the given
     * node.
     * 
     * @param application The application name.
     * 
     * @param node The name of the node where the server will be
     * deployed.
     * 
     * @param desc The descriptor of the server instance to deploy.
     * 
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * 
     * @throws DeploymentException Raised if server instantiation
     * failed.
     * 
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * 
     **/
    public void
    instantiateServer(String application, String node, ServerInstanceDescriptor desc)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException
    {
        instantiateServer(application, node, desc, null, false);
    }

    /**
     * Instantiate a server template from an application on the given
     * node.
     * 
     * @param application The application name.
     * 
     * @param node The name of the node where the server will be
     * deployed.
     * 
     * @param desc The descriptor of the server instance to deploy.
     * 
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * 
     * @throws DeploymentException Raised if server instantiation
     * failed.
     * 
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void
    instantiateServer(String application, String node, ServerInstanceDescriptor desc, java.util.Map<String, String> __ctx)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException
    {
        instantiateServer(application, node, desc, __ctx, true);
    }

    private void
    instantiateServer(String application, String node, ServerInstanceDescriptor desc, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("instantiateServer");
                __delBase = __getDelegate(false);
                _AdminDel __del = (_AdminDel)__delBase;
                __del.instantiateServer(application, node, desc, __ctx);
                return;
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __instantiateServer_name = "instantiateServer";

    /**
     * Instantiate a server template from an application on the given
     * node.
     * 
     * @param __cb The callback object for the operation.
     * @param application The application name.
     * 
     * @param node The name of the node where the server will be
     * deployed.
     * 
     * @param desc The descriptor of the server instance to deploy.
     * 
     **/
    public Ice.AsyncResult begin_instantiateServer(String application, String node, ServerInstanceDescriptor desc)
    {
        return begin_instantiateServer(application, node, desc, null, false, null);
    }

    /**
     * Instantiate a server template from an application on the given
     * node.
     * 
     * @param __cb The callback object for the operation.
     * @param application The application name.
     * 
     * @param node The name of the node where the server will be
     * deployed.
     * 
     * @param desc The descriptor of the server instance to deploy.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_instantiateServer(String application, String node, ServerInstanceDescriptor desc, java.util.Map<String, String> __ctx)
    {
        return begin_instantiateServer(application, node, desc, __ctx, true, null);
    }

    /**
     * Instantiate a server template from an application on the given
     * node.
     * 
     * @param __cb The callback object for the operation.
     * @param application The application name.
     * 
     * @param node The name of the node where the server will be
     * deployed.
     * 
     * @param desc The descriptor of the server instance to deploy.
     * 
     **/
    public Ice.AsyncResult begin_instantiateServer(String application, String node, ServerInstanceDescriptor desc, Ice.Callback __cb)
    {
        return begin_instantiateServer(application, node, desc, null, false, __cb);
    }

    /**
     * Instantiate a server template from an application on the given
     * node.
     * 
     * @param __cb The callback object for the operation.
     * @param application The application name.
     * 
     * @param node The name of the node where the server will be
     * deployed.
     * 
     * @param desc The descriptor of the server instance to deploy.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_instantiateServer(String application, String node, ServerInstanceDescriptor desc, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_instantiateServer(application, node, desc, __ctx, true, __cb);
    }

    /**
     * Instantiate a server template from an application on the given
     * node.
     * 
     * @param __cb The callback object for the operation.
     * @param application The application name.
     * 
     * @param node The name of the node where the server will be
     * deployed.
     * 
     * @param desc The descriptor of the server instance to deploy.
     * 
     **/
    public Ice.AsyncResult begin_instantiateServer(String application, String node, ServerInstanceDescriptor desc, Callback_Admin_instantiateServer __cb)
    {
        return begin_instantiateServer(application, node, desc, null, false, __cb);
    }

    /**
     * Instantiate a server template from an application on the given
     * node.
     * 
     * @param __cb The callback object for the operation.
     * @param application The application name.
     * 
     * @param node The name of the node where the server will be
     * deployed.
     * 
     * @param desc The descriptor of the server instance to deploy.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_instantiateServer(String application, String node, ServerInstanceDescriptor desc, java.util.Map<String, String> __ctx, Callback_Admin_instantiateServer __cb)
    {
        return begin_instantiateServer(application, node, desc, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_instantiateServer(String application, String node, ServerInstanceDescriptor desc, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__instantiateServer_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __instantiateServer_name, __cb);
        try
        {
            __result.__prepare(__instantiateServer_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.writeString(application);
            __os.writeString(node);
            desc.__write(__os);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     **/
    public void end_instantiateServer(Ice.AsyncResult __result)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException
    {
        Ice.AsyncResult.__check(__result, this, __instantiateServer_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(AccessDeniedException __ex)
            {
                throw __ex;
            }
            catch(ApplicationNotExistException __ex)
            {
                throw __ex;
            }
            catch(DeploymentException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        IceInternal.BasicStream __is = __result.__is();
        __is.skipEmptyEncaps();
    }

    /**
     * Check if the server is enabled or disabled.
     * 
     * @param id The server id.
     * 
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     **/
    public boolean
    isServerEnabled(String id)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException
    {
        return isServerEnabled(id, null, false);
    }

    /**
     * Check if the server is enabled or disabled.
     * 
     * @param id The server id.
     * 
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public boolean
    isServerEnabled(String id, java.util.Map<String, String> __ctx)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException
    {
        return isServerEnabled(id, __ctx, true);
    }

    private boolean
    isServerEnabled(String id, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("isServerEnabled");
                __delBase = __getDelegate(false);
                _AdminDel __del = (_AdminDel)__delBase;
                return __del.isServerEnabled(id, __ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __isServerEnabled_name = "isServerEnabled";

    /**
     * Check if the server is enabled or disabled.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     **/
    public Ice.AsyncResult begin_isServerEnabled(String id)
    {
        return begin_isServerEnabled(id, null, false, null);
    }

    /**
     * Check if the server is enabled or disabled.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_isServerEnabled(String id, java.util.Map<String, String> __ctx)
    {
        return begin_isServerEnabled(id, __ctx, true, null);
    }

    /**
     * Check if the server is enabled or disabled.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     **/
    public Ice.AsyncResult begin_isServerEnabled(String id, Ice.Callback __cb)
    {
        return begin_isServerEnabled(id, null, false, __cb);
    }

    /**
     * Check if the server is enabled or disabled.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_isServerEnabled(String id, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_isServerEnabled(id, __ctx, true, __cb);
    }

    /**
     * Check if the server is enabled or disabled.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     **/
    public Ice.AsyncResult begin_isServerEnabled(String id, Callback_Admin_isServerEnabled __cb)
    {
        return begin_isServerEnabled(id, null, false, __cb);
    }

    /**
     * Check if the server is enabled or disabled.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_isServerEnabled(String id, java.util.Map<String, String> __ctx, Callback_Admin_isServerEnabled __cb)
    {
        return begin_isServerEnabled(id, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_isServerEnabled(String id, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__isServerEnabled_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __isServerEnabled_name, __cb);
        try
        {
            __result.__prepare(__isServerEnabled_name, Ice.OperationMode.Idempotent, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.writeString(id);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     **/
    public boolean end_isServerEnabled(Ice.AsyncResult __result)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException
    {
        Ice.AsyncResult.__check(__result, this, __isServerEnabled_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(DeploymentException __ex)
            {
                throw __ex;
            }
            catch(NodeUnreachableException __ex)
            {
                throw __ex;
            }
            catch(ServerNotExistException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        boolean __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = __is.readBool();
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Patch the given application data.
     * 
     * @param name The application name.
     * 
     * @param shutdown If true, the servers depending on the data to
     * patch will be shut down if necessary.
     * 
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * 
     * @throws PatchException Raised if the patch failed.
     * 
     **/
    public void
    patchApplication(String name, boolean shutdown)
        throws ApplicationNotExistException,
               PatchException
    {
        patchApplication(name, shutdown, null, false);
    }

    /**
     * Patch the given application data.
     * 
     * @param name The application name.
     * 
     * @param shutdown If true, the servers depending on the data to
     * patch will be shut down if necessary.
     * 
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * 
     * @throws PatchException Raised if the patch failed.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void
    patchApplication(String name, boolean shutdown, java.util.Map<String, String> __ctx)
        throws ApplicationNotExistException,
               PatchException
    {
        patchApplication(name, shutdown, __ctx, true);
    }

    private void
    patchApplication(String name, boolean shutdown, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws ApplicationNotExistException,
               PatchException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("patchApplication");
                __delBase = __getDelegate(false);
                _AdminDel __del = (_AdminDel)__delBase;
                __del.patchApplication(name, shutdown, __ctx);
                return;
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __patchApplication_name = "patchApplication";

    /**
     * Patch the given application data.
     * 
     * @param __cb The callback object for the operation.
     * @param name The application name.
     * 
     * @param shutdown If true, the servers depending on the data to
     * patch will be shut down if necessary.
     * 
     **/
    public Ice.AsyncResult begin_patchApplication(String name, boolean shutdown)
    {
        return begin_patchApplication(name, shutdown, null, false, null);
    }

    /**
     * Patch the given application data.
     * 
     * @param __cb The callback object for the operation.
     * @param name The application name.
     * 
     * @param shutdown If true, the servers depending on the data to
     * patch will be shut down if necessary.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_patchApplication(String name, boolean shutdown, java.util.Map<String, String> __ctx)
    {
        return begin_patchApplication(name, shutdown, __ctx, true, null);
    }

    /**
     * Patch the given application data.
     * 
     * @param __cb The callback object for the operation.
     * @param name The application name.
     * 
     * @param shutdown If true, the servers depending on the data to
     * patch will be shut down if necessary.
     * 
     **/
    public Ice.AsyncResult begin_patchApplication(String name, boolean shutdown, Ice.Callback __cb)
    {
        return begin_patchApplication(name, shutdown, null, false, __cb);
    }

    /**
     * Patch the given application data.
     * 
     * @param __cb The callback object for the operation.
     * @param name The application name.
     * 
     * @param shutdown If true, the servers depending on the data to
     * patch will be shut down if necessary.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_patchApplication(String name, boolean shutdown, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_patchApplication(name, shutdown, __ctx, true, __cb);
    }

    /**
     * Patch the given application data.
     * 
     * @param __cb The callback object for the operation.
     * @param name The application name.
     * 
     * @param shutdown If true, the servers depending on the data to
     * patch will be shut down if necessary.
     * 
     **/
    public Ice.AsyncResult begin_patchApplication(String name, boolean shutdown, Callback_Admin_patchApplication __cb)
    {
        return begin_patchApplication(name, shutdown, null, false, __cb);
    }

    /**
     * Patch the given application data.
     * 
     * @param __cb The callback object for the operation.
     * @param name The application name.
     * 
     * @param shutdown If true, the servers depending on the data to
     * patch will be shut down if necessary.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_patchApplication(String name, boolean shutdown, java.util.Map<String, String> __ctx, Callback_Admin_patchApplication __cb)
    {
        return begin_patchApplication(name, shutdown, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_patchApplication(String name, boolean shutdown, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__patchApplication_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __patchApplication_name, __cb);
        try
        {
            __result.__prepare(__patchApplication_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.writeString(name);
            __os.writeBool(shutdown);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     **/
    public void end_patchApplication(Ice.AsyncResult __result)
        throws ApplicationNotExistException,
               PatchException
    {
        Ice.AsyncResult.__check(__result, this, __patchApplication_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(ApplicationNotExistException __ex)
            {
                throw __ex;
            }
            catch(PatchException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        IceInternal.BasicStream __is = __result.__is();
        __is.skipEmptyEncaps();
    }

    /**
     * Patch the given application data.
     * 
     * @param __cb The callback object for the operation.
     * @param name The application name.
     * 
     * @param shutdown If true, the servers depending on the data to
     * patch will be shut down if necessary.
     * 
     **/
    public boolean
    patchApplication_async(AMI_Admin_patchApplication __cb, String name, boolean shutdown)
    {
        Ice.AsyncResult __r;
        try
        {
            __checkTwowayOnly(__patchApplication_name);
            __r = begin_patchApplication(name, shutdown, null, false, __cb);
        }
        catch(Ice.TwowayOnlyException ex)
        {
            __r = new IceInternal.OutgoingAsync(this, __patchApplication_name, __cb);
            __r.__exceptionAsync(ex);
        }
        return __r.sentSynchronously();
    }

    /**
     * Patch the given application data.
     * 
     * @param __cb The callback object for the operation.
     * @param name The application name.
     * 
     * @param shutdown If true, the servers depending on the data to
     * patch will be shut down if necessary.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public boolean
    patchApplication_async(AMI_Admin_patchApplication __cb, String name, boolean shutdown, java.util.Map<String, String> __ctx)
    {
        Ice.AsyncResult __r;
        try
        {
            __checkTwowayOnly(__patchApplication_name);
            __r = begin_patchApplication(name, shutdown, __ctx, true, __cb);
        }
        catch(Ice.TwowayOnlyException ex)
        {
            __r = new IceInternal.OutgoingAsync(this, __patchApplication_name, __cb);
            __r.__exceptionAsync(ex);
        }
        return __r.sentSynchronously();
    }

    /**
     * Patch a server.
     * 
     * @param id The server id.
     * 
     * @param shutdown If true, servers depending on the data to patch
     * will be shut down if necessary.
     * 
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     * @throws PatchException Raised if the patch failed.
     * 
     **/
    public void
    patchServer(String id, boolean shutdown)
        throws DeploymentException,
               NodeUnreachableException,
               PatchException,
               ServerNotExistException
    {
        patchServer(id, shutdown, null, false);
    }

    /**
     * Patch a server.
     * 
     * @param id The server id.
     * 
     * @param shutdown If true, servers depending on the data to patch
     * will be shut down if necessary.
     * 
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     * @throws PatchException Raised if the patch failed.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void
    patchServer(String id, boolean shutdown, java.util.Map<String, String> __ctx)
        throws DeploymentException,
               NodeUnreachableException,
               PatchException,
               ServerNotExistException
    {
        patchServer(id, shutdown, __ctx, true);
    }

    private void
    patchServer(String id, boolean shutdown, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws DeploymentException,
               NodeUnreachableException,
               PatchException,
               ServerNotExistException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("patchServer");
                __delBase = __getDelegate(false);
                _AdminDel __del = (_AdminDel)__delBase;
                __del.patchServer(id, shutdown, __ctx);
                return;
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __patchServer_name = "patchServer";

    /**
     * Patch a server.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param shutdown If true, servers depending on the data to patch
     * will be shut down if necessary.
     * 
     **/
    public Ice.AsyncResult begin_patchServer(String id, boolean shutdown)
    {
        return begin_patchServer(id, shutdown, null, false, null);
    }

    /**
     * Patch a server.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param shutdown If true, servers depending on the data to patch
     * will be shut down if necessary.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_patchServer(String id, boolean shutdown, java.util.Map<String, String> __ctx)
    {
        return begin_patchServer(id, shutdown, __ctx, true, null);
    }

    /**
     * Patch a server.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param shutdown If true, servers depending on the data to patch
     * will be shut down if necessary.
     * 
     **/
    public Ice.AsyncResult begin_patchServer(String id, boolean shutdown, Ice.Callback __cb)
    {
        return begin_patchServer(id, shutdown, null, false, __cb);
    }

    /**
     * Patch a server.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param shutdown If true, servers depending on the data to patch
     * will be shut down if necessary.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_patchServer(String id, boolean shutdown, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_patchServer(id, shutdown, __ctx, true, __cb);
    }

    /**
     * Patch a server.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param shutdown If true, servers depending on the data to patch
     * will be shut down if necessary.
     * 
     **/
    public Ice.AsyncResult begin_patchServer(String id, boolean shutdown, Callback_Admin_patchServer __cb)
    {
        return begin_patchServer(id, shutdown, null, false, __cb);
    }

    /**
     * Patch a server.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param shutdown If true, servers depending on the data to patch
     * will be shut down if necessary.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_patchServer(String id, boolean shutdown, java.util.Map<String, String> __ctx, Callback_Admin_patchServer __cb)
    {
        return begin_patchServer(id, shutdown, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_patchServer(String id, boolean shutdown, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__patchServer_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __patchServer_name, __cb);
        try
        {
            __result.__prepare(__patchServer_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.writeString(id);
            __os.writeBool(shutdown);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     **/
    public void end_patchServer(Ice.AsyncResult __result)
        throws DeploymentException,
               NodeUnreachableException,
               PatchException,
               ServerNotExistException
    {
        Ice.AsyncResult.__check(__result, this, __patchServer_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(DeploymentException __ex)
            {
                throw __ex;
            }
            catch(NodeUnreachableException __ex)
            {
                throw __ex;
            }
            catch(PatchException __ex)
            {
                throw __ex;
            }
            catch(ServerNotExistException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        IceInternal.BasicStream __is = __result.__is();
        __is.skipEmptyEncaps();
    }

    /**
     * Patch a server.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param shutdown If true, servers depending on the data to patch
     * will be shut down if necessary.
     * 
     **/
    public boolean
    patchServer_async(AMI_Admin_patchServer __cb, String id, boolean shutdown)
    {
        Ice.AsyncResult __r;
        try
        {
            __checkTwowayOnly(__patchServer_name);
            __r = begin_patchServer(id, shutdown, null, false, __cb);
        }
        catch(Ice.TwowayOnlyException ex)
        {
            __r = new IceInternal.OutgoingAsync(this, __patchServer_name, __cb);
            __r.__exceptionAsync(ex);
        }
        return __r.sentSynchronously();
    }

    /**
     * Patch a server.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param shutdown If true, servers depending on the data to patch
     * will be shut down if necessary.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public boolean
    patchServer_async(AMI_Admin_patchServer __cb, String id, boolean shutdown, java.util.Map<String, String> __ctx)
    {
        Ice.AsyncResult __r;
        try
        {
            __checkTwowayOnly(__patchServer_name);
            __r = begin_patchServer(id, shutdown, __ctx, true, __cb);
        }
        catch(Ice.TwowayOnlyException ex)
        {
            __r = new IceInternal.OutgoingAsync(this, __patchServer_name, __cb);
            __r.__exceptionAsync(ex);
        }
        return __r.sentSynchronously();
    }

    /**
     * Ping an IceGrid node to see if it is active.
     * 
     * @param name The node name.
     * 
     * @return true if the node ping succeeded, false otherwise.
     * 
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * 
     **/
    public boolean
    pingNode(String name)
        throws NodeNotExistException
    {
        return pingNode(name, null, false);
    }

    /**
     * Ping an IceGrid node to see if it is active.
     * 
     * @param name The node name.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return true if the node ping succeeded, false otherwise.
     * 
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * 
     **/
    public boolean
    pingNode(String name, java.util.Map<String, String> __ctx)
        throws NodeNotExistException
    {
        return pingNode(name, __ctx, true);
    }

    private boolean
    pingNode(String name, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws NodeNotExistException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("pingNode");
                __delBase = __getDelegate(false);
                _AdminDel __del = (_AdminDel)__delBase;
                return __del.pingNode(name, __ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __pingNode_name = "pingNode";

    /**
     * Ping an IceGrid node to see if it is active.
     * 
     * @param __cb The callback object for the operation.
     * @param name The node name.
     * 
     **/
    public Ice.AsyncResult begin_pingNode(String name)
    {
        return begin_pingNode(name, null, false, null);
    }

    /**
     * Ping an IceGrid node to see if it is active.
     * 
     * @param __cb The callback object for the operation.
     * @param name The node name.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_pingNode(String name, java.util.Map<String, String> __ctx)
    {
        return begin_pingNode(name, __ctx, true, null);
    }

    /**
     * Ping an IceGrid node to see if it is active.
     * 
     * @param __cb The callback object for the operation.
     * @param name The node name.
     * 
     **/
    public Ice.AsyncResult begin_pingNode(String name, Ice.Callback __cb)
    {
        return begin_pingNode(name, null, false, __cb);
    }

    /**
     * Ping an IceGrid node to see if it is active.
     * 
     * @param __cb The callback object for the operation.
     * @param name The node name.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_pingNode(String name, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_pingNode(name, __ctx, true, __cb);
    }

    /**
     * Ping an IceGrid node to see if it is active.
     * 
     * @param __cb The callback object for the operation.
     * @param name The node name.
     * 
     **/
    public Ice.AsyncResult begin_pingNode(String name, Callback_Admin_pingNode __cb)
    {
        return begin_pingNode(name, null, false, __cb);
    }

    /**
     * Ping an IceGrid node to see if it is active.
     * 
     * @param __cb The callback object for the operation.
     * @param name The node name.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_pingNode(String name, java.util.Map<String, String> __ctx, Callback_Admin_pingNode __cb)
    {
        return begin_pingNode(name, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_pingNode(String name, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__pingNode_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __pingNode_name, __cb);
        try
        {
            __result.__prepare(__pingNode_name, Ice.OperationMode.Idempotent, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.writeString(name);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) true if the node ping succeeded, false otherwise.
     * 
     **/
    public boolean end_pingNode(Ice.AsyncResult __result)
        throws NodeNotExistException
    {
        Ice.AsyncResult.__check(__result, this, __pingNode_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(NodeNotExistException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        boolean __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = __is.readBool();
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Ping an IceGrid registry to see if it is active.
     * 
     * @param name The registry name.
     * 
     * @return true if the registry ping succeeded, false otherwise.
     * 
     * @throws RegistryNotExistException Raised if the registry doesn't exist.
     * 
     **/
    public boolean
    pingRegistry(String name)
        throws RegistryNotExistException
    {
        return pingRegistry(name, null, false);
    }

    /**
     * Ping an IceGrid registry to see if it is active.
     * 
     * @param name The registry name.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return true if the registry ping succeeded, false otherwise.
     * 
     * @throws RegistryNotExistException Raised if the registry doesn't exist.
     * 
     **/
    public boolean
    pingRegistry(String name, java.util.Map<String, String> __ctx)
        throws RegistryNotExistException
    {
        return pingRegistry(name, __ctx, true);
    }

    private boolean
    pingRegistry(String name, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws RegistryNotExistException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("pingRegistry");
                __delBase = __getDelegate(false);
                _AdminDel __del = (_AdminDel)__delBase;
                return __del.pingRegistry(name, __ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __pingRegistry_name = "pingRegistry";

    /**
     * Ping an IceGrid registry to see if it is active.
     * 
     * @param __cb The callback object for the operation.
     * @param name The registry name.
     * 
     **/
    public Ice.AsyncResult begin_pingRegistry(String name)
    {
        return begin_pingRegistry(name, null, false, null);
    }

    /**
     * Ping an IceGrid registry to see if it is active.
     * 
     * @param __cb The callback object for the operation.
     * @param name The registry name.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_pingRegistry(String name, java.util.Map<String, String> __ctx)
    {
        return begin_pingRegistry(name, __ctx, true, null);
    }

    /**
     * Ping an IceGrid registry to see if it is active.
     * 
     * @param __cb The callback object for the operation.
     * @param name The registry name.
     * 
     **/
    public Ice.AsyncResult begin_pingRegistry(String name, Ice.Callback __cb)
    {
        return begin_pingRegistry(name, null, false, __cb);
    }

    /**
     * Ping an IceGrid registry to see if it is active.
     * 
     * @param __cb The callback object for the operation.
     * @param name The registry name.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_pingRegistry(String name, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_pingRegistry(name, __ctx, true, __cb);
    }

    /**
     * Ping an IceGrid registry to see if it is active.
     * 
     * @param __cb The callback object for the operation.
     * @param name The registry name.
     * 
     **/
    public Ice.AsyncResult begin_pingRegistry(String name, Callback_Admin_pingRegistry __cb)
    {
        return begin_pingRegistry(name, null, false, __cb);
    }

    /**
     * Ping an IceGrid registry to see if it is active.
     * 
     * @param __cb The callback object for the operation.
     * @param name The registry name.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_pingRegistry(String name, java.util.Map<String, String> __ctx, Callback_Admin_pingRegistry __cb)
    {
        return begin_pingRegistry(name, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_pingRegistry(String name, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__pingRegistry_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __pingRegistry_name, __cb);
        try
        {
            __result.__prepare(__pingRegistry_name, Ice.OperationMode.Idempotent, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.writeString(name);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) true if the registry ping succeeded, false otherwise.
     * 
     **/
    public boolean end_pingRegistry(Ice.AsyncResult __result)
        throws RegistryNotExistException
    {
        Ice.AsyncResult.__check(__result, this, __pingRegistry_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(RegistryNotExistException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        boolean __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = __is.readBool();
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Remove the adapter with the given id.
     * 
     * @param id The adapter id.
     * @throws AdapterNotExistException Raised if the adapter doesn't
     * exist.
     * 
     **/
    public void
    removeAdapter(String id)
        throws AdapterNotExistException,
               DeploymentException
    {
        removeAdapter(id, null, false);
    }

    /**
     * Remove the adapter with the given id.
     * 
     * @param id The adapter id.
     * @throws AdapterNotExistException Raised if the adapter doesn't
     * exist.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void
    removeAdapter(String id, java.util.Map<String, String> __ctx)
        throws AdapterNotExistException,
               DeploymentException
    {
        removeAdapter(id, __ctx, true);
    }

    private void
    removeAdapter(String id, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws AdapterNotExistException,
               DeploymentException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("removeAdapter");
                __delBase = __getDelegate(false);
                _AdminDel __del = (_AdminDel)__delBase;
                __del.removeAdapter(id, __ctx);
                return;
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __removeAdapter_name = "removeAdapter";

    /**
     * Remove the adapter with the given id.
     * 
     * @param __cb The callback object for the operation.
     * @param id The adapter id.
     **/
    public Ice.AsyncResult begin_removeAdapter(String id)
    {
        return begin_removeAdapter(id, null, false, null);
    }

    /**
     * Remove the adapter with the given id.
     * 
     * @param __cb The callback object for the operation.
     * @param id The adapter id.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_removeAdapter(String id, java.util.Map<String, String> __ctx)
    {
        return begin_removeAdapter(id, __ctx, true, null);
    }

    /**
     * Remove the adapter with the given id.
     * 
     * @param __cb The callback object for the operation.
     * @param id The adapter id.
     **/
    public Ice.AsyncResult begin_removeAdapter(String id, Ice.Callback __cb)
    {
        return begin_removeAdapter(id, null, false, __cb);
    }

    /**
     * Remove the adapter with the given id.
     * 
     * @param __cb The callback object for the operation.
     * @param id The adapter id.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_removeAdapter(String id, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_removeAdapter(id, __ctx, true, __cb);
    }

    /**
     * Remove the adapter with the given id.
     * 
     * @param __cb The callback object for the operation.
     * @param id The adapter id.
     **/
    public Ice.AsyncResult begin_removeAdapter(String id, Callback_Admin_removeAdapter __cb)
    {
        return begin_removeAdapter(id, null, false, __cb);
    }

    /**
     * Remove the adapter with the given id.
     * 
     * @param __cb The callback object for the operation.
     * @param id The adapter id.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_removeAdapter(String id, java.util.Map<String, String> __ctx, Callback_Admin_removeAdapter __cb)
    {
        return begin_removeAdapter(id, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_removeAdapter(String id, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__removeAdapter_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __removeAdapter_name, __cb);
        try
        {
            __result.__prepare(__removeAdapter_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.writeString(id);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     **/
    public void end_removeAdapter(Ice.AsyncResult __result)
        throws AdapterNotExistException,
               DeploymentException
    {
        Ice.AsyncResult.__check(__result, this, __removeAdapter_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(AdapterNotExistException __ex)
            {
                throw __ex;
            }
            catch(DeploymentException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        IceInternal.BasicStream __is = __result.__is();
        __is.skipEmptyEncaps();
    }

    /**
     * Remove the adapter with the given id.
     * 
     * @param __cb The callback object for the operation.
     * @param id The adapter id.
     **/
    public boolean
    removeAdapter_async(AMI_Admin_removeAdapter __cb, String id)
    {
        Ice.AsyncResult __r;
        try
        {
            __checkTwowayOnly(__removeAdapter_name);
            __r = begin_removeAdapter(id, null, false, __cb);
        }
        catch(Ice.TwowayOnlyException ex)
        {
            __r = new IceInternal.OutgoingAsync(this, __removeAdapter_name, __cb);
            __r.__exceptionAsync(ex);
        }
        return __r.sentSynchronously();
    }

    /**
     * Remove the adapter with the given id.
     * 
     * @param __cb The callback object for the operation.
     * @param id The adapter id.
     * @param __ctx The Context map to send with the invocation.
     **/
    public boolean
    removeAdapter_async(AMI_Admin_removeAdapter __cb, String id, java.util.Map<String, String> __ctx)
    {
        Ice.AsyncResult __r;
        try
        {
            __checkTwowayOnly(__removeAdapter_name);
            __r = begin_removeAdapter(id, __ctx, true, __cb);
        }
        catch(Ice.TwowayOnlyException ex)
        {
            __r = new IceInternal.OutgoingAsync(this, __removeAdapter_name, __cb);
            __r.__exceptionAsync(ex);
        }
        return __r.sentSynchronously();
    }

    /**
     * Remove an application from IceGrid.
     * 
     * @param name The application name.
     * 
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * 
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * 
     **/
    public void
    removeApplication(String name)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException
    {
        removeApplication(name, null, false);
    }

    /**
     * Remove an application from IceGrid.
     * 
     * @param name The application name.
     * 
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * 
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void
    removeApplication(String name, java.util.Map<String, String> __ctx)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException
    {
        removeApplication(name, __ctx, true);
    }

    private void
    removeApplication(String name, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("removeApplication");
                __delBase = __getDelegate(false);
                _AdminDel __del = (_AdminDel)__delBase;
                __del.removeApplication(name, __ctx);
                return;
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __removeApplication_name = "removeApplication";

    /**
     * Remove an application from IceGrid.
     * 
     * @param __cb The callback object for the operation.
     * @param name The application name.
     * 
     **/
    public Ice.AsyncResult begin_removeApplication(String name)
    {
        return begin_removeApplication(name, null, false, null);
    }

    /**
     * Remove an application from IceGrid.
     * 
     * @param __cb The callback object for the operation.
     * @param name The application name.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_removeApplication(String name, java.util.Map<String, String> __ctx)
    {
        return begin_removeApplication(name, __ctx, true, null);
    }

    /**
     * Remove an application from IceGrid.
     * 
     * @param __cb The callback object for the operation.
     * @param name The application name.
     * 
     **/
    public Ice.AsyncResult begin_removeApplication(String name, Ice.Callback __cb)
    {
        return begin_removeApplication(name, null, false, __cb);
    }

    /**
     * Remove an application from IceGrid.
     * 
     * @param __cb The callback object for the operation.
     * @param name The application name.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_removeApplication(String name, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_removeApplication(name, __ctx, true, __cb);
    }

    /**
     * Remove an application from IceGrid.
     * 
     * @param __cb The callback object for the operation.
     * @param name The application name.
     * 
     **/
    public Ice.AsyncResult begin_removeApplication(String name, Callback_Admin_removeApplication __cb)
    {
        return begin_removeApplication(name, null, false, __cb);
    }

    /**
     * Remove an application from IceGrid.
     * 
     * @param __cb The callback object for the operation.
     * @param name The application name.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_removeApplication(String name, java.util.Map<String, String> __ctx, Callback_Admin_removeApplication __cb)
    {
        return begin_removeApplication(name, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_removeApplication(String name, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__removeApplication_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __removeApplication_name, __cb);
        try
        {
            __result.__prepare(__removeApplication_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.writeString(name);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     **/
    public void end_removeApplication(Ice.AsyncResult __result)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException
    {
        Ice.AsyncResult.__check(__result, this, __removeApplication_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(AccessDeniedException __ex)
            {
                throw __ex;
            }
            catch(ApplicationNotExistException __ex)
            {
                throw __ex;
            }
            catch(DeploymentException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        IceInternal.BasicStream __is = __result.__is();
        __is.skipEmptyEncaps();
    }

    /**
     * Remove an application from IceGrid.
     * 
     * @param __cb The callback object for the operation.
     * @param name The application name.
     * 
     **/
    public boolean
    removeApplication_async(AMI_Admin_removeApplication __cb, String name)
    {
        Ice.AsyncResult __r;
        try
        {
            __checkTwowayOnly(__removeApplication_name);
            __r = begin_removeApplication(name, null, false, __cb);
        }
        catch(Ice.TwowayOnlyException ex)
        {
            __r = new IceInternal.OutgoingAsync(this, __removeApplication_name, __cb);
            __r.__exceptionAsync(ex);
        }
        return __r.sentSynchronously();
    }

    /**
     * Remove an application from IceGrid.
     * 
     * @param __cb The callback object for the operation.
     * @param name The application name.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public boolean
    removeApplication_async(AMI_Admin_removeApplication __cb, String name, java.util.Map<String, String> __ctx)
    {
        Ice.AsyncResult __r;
        try
        {
            __checkTwowayOnly(__removeApplication_name);
            __r = begin_removeApplication(name, __ctx, true, __cb);
        }
        catch(Ice.TwowayOnlyException ex)
        {
            __r = new IceInternal.OutgoingAsync(this, __removeApplication_name, __cb);
            __r.__exceptionAsync(ex);
        }
        return __r.sentSynchronously();
    }

    /**
     * Remove an object from the object registry. Only objects added
     * with this interface can be removed with this operation. Objects
     * added with deployment descriptors should be removed with the
     * deployment mechanism.
     * 
     * @param id The identity of the object to be removed from the
     * registry.
     * 
     * @throws ObjectNotRegisteredException Raised if the object isn't
     * registered with the registry.
     * 
     * @throws DeploymentException Raised if the object can't be
     * removed. This might happen if the object was added with a
     * deployment descriptor.
     * 
     **/
    public void
    removeObject(Ice.Identity id)
        throws DeploymentException,
               ObjectNotRegisteredException
    {
        removeObject(id, null, false);
    }

    /**
     * Remove an object from the object registry. Only objects added
     * with this interface can be removed with this operation. Objects
     * added with deployment descriptors should be removed with the
     * deployment mechanism.
     * 
     * @param id The identity of the object to be removed from the
     * registry.
     * 
     * @throws ObjectNotRegisteredException Raised if the object isn't
     * registered with the registry.
     * 
     * @throws DeploymentException Raised if the object can't be
     * removed. This might happen if the object was added with a
     * deployment descriptor.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void
    removeObject(Ice.Identity id, java.util.Map<String, String> __ctx)
        throws DeploymentException,
               ObjectNotRegisteredException
    {
        removeObject(id, __ctx, true);
    }

    private void
    removeObject(Ice.Identity id, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws DeploymentException,
               ObjectNotRegisteredException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("removeObject");
                __delBase = __getDelegate(false);
                _AdminDel __del = (_AdminDel)__delBase;
                __del.removeObject(id, __ctx);
                return;
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __removeObject_name = "removeObject";

    /**
     * Remove an object from the object registry. Only objects added
     * with this interface can be removed with this operation. Objects
     * added with deployment descriptors should be removed with the
     * deployment mechanism.
     * 
     * @param __cb The callback object for the operation.
     * @param id The identity of the object to be removed from the
     * registry.
     * 
     **/
    public Ice.AsyncResult begin_removeObject(Ice.Identity id)
    {
        return begin_removeObject(id, null, false, null);
    }

    /**
     * Remove an object from the object registry. Only objects added
     * with this interface can be removed with this operation. Objects
     * added with deployment descriptors should be removed with the
     * deployment mechanism.
     * 
     * @param __cb The callback object for the operation.
     * @param id The identity of the object to be removed from the
     * registry.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_removeObject(Ice.Identity id, java.util.Map<String, String> __ctx)
    {
        return begin_removeObject(id, __ctx, true, null);
    }

    /**
     * Remove an object from the object registry. Only objects added
     * with this interface can be removed with this operation. Objects
     * added with deployment descriptors should be removed with the
     * deployment mechanism.
     * 
     * @param __cb The callback object for the operation.
     * @param id The identity of the object to be removed from the
     * registry.
     * 
     **/
    public Ice.AsyncResult begin_removeObject(Ice.Identity id, Ice.Callback __cb)
    {
        return begin_removeObject(id, null, false, __cb);
    }

    /**
     * Remove an object from the object registry. Only objects added
     * with this interface can be removed with this operation. Objects
     * added with deployment descriptors should be removed with the
     * deployment mechanism.
     * 
     * @param __cb The callback object for the operation.
     * @param id The identity of the object to be removed from the
     * registry.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_removeObject(Ice.Identity id, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_removeObject(id, __ctx, true, __cb);
    }

    /**
     * Remove an object from the object registry. Only objects added
     * with this interface can be removed with this operation. Objects
     * added with deployment descriptors should be removed with the
     * deployment mechanism.
     * 
     * @param __cb The callback object for the operation.
     * @param id The identity of the object to be removed from the
     * registry.
     * 
     **/
    public Ice.AsyncResult begin_removeObject(Ice.Identity id, Callback_Admin_removeObject __cb)
    {
        return begin_removeObject(id, null, false, __cb);
    }

    /**
     * Remove an object from the object registry. Only objects added
     * with this interface can be removed with this operation. Objects
     * added with deployment descriptors should be removed with the
     * deployment mechanism.
     * 
     * @param __cb The callback object for the operation.
     * @param id The identity of the object to be removed from the
     * registry.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_removeObject(Ice.Identity id, java.util.Map<String, String> __ctx, Callback_Admin_removeObject __cb)
    {
        return begin_removeObject(id, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_removeObject(Ice.Identity id, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__removeObject_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __removeObject_name, __cb);
        try
        {
            __result.__prepare(__removeObject_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            id.__write(__os);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     **/
    public void end_removeObject(Ice.AsyncResult __result)
        throws DeploymentException,
               ObjectNotRegisteredException
    {
        Ice.AsyncResult.__check(__result, this, __removeObject_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(DeploymentException __ex)
            {
                throw __ex;
            }
            catch(ObjectNotRegisteredException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        IceInternal.BasicStream __is = __result.__is();
        __is.skipEmptyEncaps();
    }

    /**
     * Remove an object from the object registry. Only objects added
     * with this interface can be removed with this operation. Objects
     * added with deployment descriptors should be removed with the
     * deployment mechanism.
     * 
     * @param __cb The callback object for the operation.
     * @param id The identity of the object to be removed from the
     * registry.
     * 
     **/
    public boolean
    removeObject_async(AMI_Admin_removeObject __cb, Ice.Identity id)
    {
        Ice.AsyncResult __r;
        try
        {
            __checkTwowayOnly(__removeObject_name);
            __r = begin_removeObject(id, null, false, __cb);
        }
        catch(Ice.TwowayOnlyException ex)
        {
            __r = new IceInternal.OutgoingAsync(this, __removeObject_name, __cb);
            __r.__exceptionAsync(ex);
        }
        return __r.sentSynchronously();
    }

    /**
     * Remove an object from the object registry. Only objects added
     * with this interface can be removed with this operation. Objects
     * added with deployment descriptors should be removed with the
     * deployment mechanism.
     * 
     * @param __cb The callback object for the operation.
     * @param id The identity of the object to be removed from the
     * registry.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public boolean
    removeObject_async(AMI_Admin_removeObject __cb, Ice.Identity id, java.util.Map<String, String> __ctx)
    {
        Ice.AsyncResult __r;
        try
        {
            __checkTwowayOnly(__removeObject_name);
            __r = begin_removeObject(id, __ctx, true, __cb);
        }
        catch(Ice.TwowayOnlyException ex)
        {
            __r = new IceInternal.OutgoingAsync(this, __removeObject_name, __cb);
            __r.__exceptionAsync(ex);
        }
        return __r.sentSynchronously();
    }

    /**
     * Send signal to a server.
     * 
     * @param id The server id.
     * 
     * @param signal The signal, for example SIGTERM or 15.
     * 
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     * @throws BadSignalException Raised if the signal is not recognized 
     * by the target server.
     * 
     **/
    public void
    sendSignal(String id, String signal)
        throws BadSignalException,
               DeploymentException,
               NodeUnreachableException,
               ServerNotExistException
    {
        sendSignal(id, signal, null, false);
    }

    /**
     * Send signal to a server.
     * 
     * @param id The server id.
     * 
     * @param signal The signal, for example SIGTERM or 15.
     * 
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     * @throws BadSignalException Raised if the signal is not recognized 
     * by the target server.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void
    sendSignal(String id, String signal, java.util.Map<String, String> __ctx)
        throws BadSignalException,
               DeploymentException,
               NodeUnreachableException,
               ServerNotExistException
    {
        sendSignal(id, signal, __ctx, true);
    }

    private void
    sendSignal(String id, String signal, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws BadSignalException,
               DeploymentException,
               NodeUnreachableException,
               ServerNotExistException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("sendSignal");
                __delBase = __getDelegate(false);
                _AdminDel __del = (_AdminDel)__delBase;
                __del.sendSignal(id, signal, __ctx);
                return;
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __sendSignal_name = "sendSignal";

    /**
     * Send signal to a server.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param signal The signal, for example SIGTERM or 15.
     * 
     **/
    public Ice.AsyncResult begin_sendSignal(String id, String signal)
    {
        return begin_sendSignal(id, signal, null, false, null);
    }

    /**
     * Send signal to a server.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param signal The signal, for example SIGTERM or 15.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_sendSignal(String id, String signal, java.util.Map<String, String> __ctx)
    {
        return begin_sendSignal(id, signal, __ctx, true, null);
    }

    /**
     * Send signal to a server.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param signal The signal, for example SIGTERM or 15.
     * 
     **/
    public Ice.AsyncResult begin_sendSignal(String id, String signal, Ice.Callback __cb)
    {
        return begin_sendSignal(id, signal, null, false, __cb);
    }

    /**
     * Send signal to a server.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param signal The signal, for example SIGTERM or 15.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_sendSignal(String id, String signal, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_sendSignal(id, signal, __ctx, true, __cb);
    }

    /**
     * Send signal to a server.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param signal The signal, for example SIGTERM or 15.
     * 
     **/
    public Ice.AsyncResult begin_sendSignal(String id, String signal, Callback_Admin_sendSignal __cb)
    {
        return begin_sendSignal(id, signal, null, false, __cb);
    }

    /**
     * Send signal to a server.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param signal The signal, for example SIGTERM or 15.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_sendSignal(String id, String signal, java.util.Map<String, String> __ctx, Callback_Admin_sendSignal __cb)
    {
        return begin_sendSignal(id, signal, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_sendSignal(String id, String signal, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__sendSignal_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __sendSignal_name, __cb);
        try
        {
            __result.__prepare(__sendSignal_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.writeString(id);
            __os.writeString(signal);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     **/
    public void end_sendSignal(Ice.AsyncResult __result)
        throws BadSignalException,
               DeploymentException,
               NodeUnreachableException,
               ServerNotExistException
    {
        Ice.AsyncResult.__check(__result, this, __sendSignal_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(BadSignalException __ex)
            {
                throw __ex;
            }
            catch(DeploymentException __ex)
            {
                throw __ex;
            }
            catch(NodeUnreachableException __ex)
            {
                throw __ex;
            }
            catch(ServerNotExistException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        IceInternal.BasicStream __is = __result.__is();
        __is.skipEmptyEncaps();
    }

    /**
     * Send signal to a server.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param signal The signal, for example SIGTERM or 15.
     * 
     **/
    public boolean
    sendSignal_async(AMI_Admin_sendSignal __cb, String id, String signal)
    {
        Ice.AsyncResult __r;
        try
        {
            __checkTwowayOnly(__sendSignal_name);
            __r = begin_sendSignal(id, signal, null, false, __cb);
        }
        catch(Ice.TwowayOnlyException ex)
        {
            __r = new IceInternal.OutgoingAsync(this, __sendSignal_name, __cb);
            __r.__exceptionAsync(ex);
        }
        return __r.sentSynchronously();
    }

    /**
     * Send signal to a server.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param signal The signal, for example SIGTERM or 15.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public boolean
    sendSignal_async(AMI_Admin_sendSignal __cb, String id, String signal, java.util.Map<String, String> __ctx)
    {
        Ice.AsyncResult __r;
        try
        {
            __checkTwowayOnly(__sendSignal_name);
            __r = begin_sendSignal(id, signal, __ctx, true, __cb);
        }
        catch(Ice.TwowayOnlyException ex)
        {
            __r = new IceInternal.OutgoingAsync(this, __sendSignal_name, __cb);
            __r.__exceptionAsync(ex);
        }
        return __r.sentSynchronously();
    }

    /**
     * Shut down the IceGrid registry.
     * 
     **/
    public void
    shutdown()
    {
        shutdown(null, false);
    }

    /**
     * Shut down the IceGrid registry.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void
    shutdown(java.util.Map<String, String> __ctx)
    {
        shutdown(__ctx, true);
    }

    private void
    shutdown(java.util.Map<String, String> __ctx, boolean __explicitCtx)
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __delBase = __getDelegate(false);
                _AdminDel __del = (_AdminDel)__delBase;
                __del.shutdown(__ctx);
                return;
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __shutdown_name = "shutdown";

    /**
     * Shut down the IceGrid registry.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_shutdown()
    {
        return begin_shutdown(null, false, null);
    }

    /**
     * Shut down the IceGrid registry.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_shutdown(java.util.Map<String, String> __ctx)
    {
        return begin_shutdown(__ctx, true, null);
    }

    /**
     * Shut down the IceGrid registry.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_shutdown(Ice.Callback __cb)
    {
        return begin_shutdown(null, false, __cb);
    }

    /**
     * Shut down the IceGrid registry.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_shutdown(java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_shutdown(__ctx, true, __cb);
    }

    /**
     * Shut down the IceGrid registry.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_shutdown(Callback_Admin_shutdown __cb)
    {
        return begin_shutdown(null, false, __cb);
    }

    /**
     * Shut down the IceGrid registry.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_shutdown(java.util.Map<String, String> __ctx, Callback_Admin_shutdown __cb)
    {
        return begin_shutdown(__ctx, true, __cb);
    }

    private Ice.AsyncResult begin_shutdown(java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __shutdown_name, __cb);
        try
        {
            __result.__prepare(__shutdown_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     **/
    public void end_shutdown(Ice.AsyncResult __result)
    {
        __end(__result, __shutdown_name);
    }

    /**
     * Shutdown an IceGrid node.
     * 
     * @param name The node name.
     * 
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     **/
    public void
    shutdownNode(String name)
        throws NodeNotExistException,
               NodeUnreachableException
    {
        shutdownNode(name, null, false);
    }

    /**
     * Shutdown an IceGrid node.
     * 
     * @param name The node name.
     * 
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void
    shutdownNode(String name, java.util.Map<String, String> __ctx)
        throws NodeNotExistException,
               NodeUnreachableException
    {
        shutdownNode(name, __ctx, true);
    }

    private void
    shutdownNode(String name, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws NodeNotExistException,
               NodeUnreachableException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("shutdownNode");
                __delBase = __getDelegate(false);
                _AdminDel __del = (_AdminDel)__delBase;
                __del.shutdownNode(name, __ctx);
                return;
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __shutdownNode_name = "shutdownNode";

    /**
     * Shutdown an IceGrid node.
     * 
     * @param __cb The callback object for the operation.
     * @param name The node name.
     * 
     **/
    public Ice.AsyncResult begin_shutdownNode(String name)
    {
        return begin_shutdownNode(name, null, false, null);
    }

    /**
     * Shutdown an IceGrid node.
     * 
     * @param __cb The callback object for the operation.
     * @param name The node name.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_shutdownNode(String name, java.util.Map<String, String> __ctx)
    {
        return begin_shutdownNode(name, __ctx, true, null);
    }

    /**
     * Shutdown an IceGrid node.
     * 
     * @param __cb The callback object for the operation.
     * @param name The node name.
     * 
     **/
    public Ice.AsyncResult begin_shutdownNode(String name, Ice.Callback __cb)
    {
        return begin_shutdownNode(name, null, false, __cb);
    }

    /**
     * Shutdown an IceGrid node.
     * 
     * @param __cb The callback object for the operation.
     * @param name The node name.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_shutdownNode(String name, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_shutdownNode(name, __ctx, true, __cb);
    }

    /**
     * Shutdown an IceGrid node.
     * 
     * @param __cb The callback object for the operation.
     * @param name The node name.
     * 
     **/
    public Ice.AsyncResult begin_shutdownNode(String name, Callback_Admin_shutdownNode __cb)
    {
        return begin_shutdownNode(name, null, false, __cb);
    }

    /**
     * Shutdown an IceGrid node.
     * 
     * @param __cb The callback object for the operation.
     * @param name The node name.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_shutdownNode(String name, java.util.Map<String, String> __ctx, Callback_Admin_shutdownNode __cb)
    {
        return begin_shutdownNode(name, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_shutdownNode(String name, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__shutdownNode_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __shutdownNode_name, __cb);
        try
        {
            __result.__prepare(__shutdownNode_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.writeString(name);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     **/
    public void end_shutdownNode(Ice.AsyncResult __result)
        throws NodeNotExistException,
               NodeUnreachableException
    {
        Ice.AsyncResult.__check(__result, this, __shutdownNode_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(NodeNotExistException __ex)
            {
                throw __ex;
            }
            catch(NodeUnreachableException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        IceInternal.BasicStream __is = __result.__is();
        __is.skipEmptyEncaps();
    }

    /**
     * Shutdown an IceGrid node.
     * 
     * @param __cb The callback object for the operation.
     * @param name The node name.
     * 
     **/
    public boolean
    shutdownNode_async(AMI_Admin_shutdownNode __cb, String name)
    {
        Ice.AsyncResult __r;
        try
        {
            __checkTwowayOnly(__shutdownNode_name);
            __r = begin_shutdownNode(name, null, false, __cb);
        }
        catch(Ice.TwowayOnlyException ex)
        {
            __r = new IceInternal.OutgoingAsync(this, __shutdownNode_name, __cb);
            __r.__exceptionAsync(ex);
        }
        return __r.sentSynchronously();
    }

    /**
     * Shutdown an IceGrid node.
     * 
     * @param __cb The callback object for the operation.
     * @param name The node name.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public boolean
    shutdownNode_async(AMI_Admin_shutdownNode __cb, String name, java.util.Map<String, String> __ctx)
    {
        Ice.AsyncResult __r;
        try
        {
            __checkTwowayOnly(__shutdownNode_name);
            __r = begin_shutdownNode(name, __ctx, true, __cb);
        }
        catch(Ice.TwowayOnlyException ex)
        {
            __r = new IceInternal.OutgoingAsync(this, __shutdownNode_name, __cb);
            __r.__exceptionAsync(ex);
        }
        return __r.sentSynchronously();
    }

    /**
     * Shutdown an IceGrid registry.
     * 
     * @param name The registry name.
     * 
     * @throws RegistryNotExistException Raised if the registry doesn't exist.
     * 
     * @throws RegistryUnreachableException Raised if the registry could not be
     * reached.
     * 
     **/
    public void
    shutdownRegistry(String name)
        throws RegistryNotExistException,
               RegistryUnreachableException
    {
        shutdownRegistry(name, null, false);
    }

    /**
     * Shutdown an IceGrid registry.
     * 
     * @param name The registry name.
     * 
     * @throws RegistryNotExistException Raised if the registry doesn't exist.
     * 
     * @throws RegistryUnreachableException Raised if the registry could not be
     * reached.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void
    shutdownRegistry(String name, java.util.Map<String, String> __ctx)
        throws RegistryNotExistException,
               RegistryUnreachableException
    {
        shutdownRegistry(name, __ctx, true);
    }

    private void
    shutdownRegistry(String name, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws RegistryNotExistException,
               RegistryUnreachableException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("shutdownRegistry");
                __delBase = __getDelegate(false);
                _AdminDel __del = (_AdminDel)__delBase;
                __del.shutdownRegistry(name, __ctx);
                return;
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __shutdownRegistry_name = "shutdownRegistry";

    /**
     * Shutdown an IceGrid registry.
     * 
     * @param __cb The callback object for the operation.
     * @param name The registry name.
     * 
     **/
    public Ice.AsyncResult begin_shutdownRegistry(String name)
    {
        return begin_shutdownRegistry(name, null, false, null);
    }

    /**
     * Shutdown an IceGrid registry.
     * 
     * @param __cb The callback object for the operation.
     * @param name The registry name.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_shutdownRegistry(String name, java.util.Map<String, String> __ctx)
    {
        return begin_shutdownRegistry(name, __ctx, true, null);
    }

    /**
     * Shutdown an IceGrid registry.
     * 
     * @param __cb The callback object for the operation.
     * @param name The registry name.
     * 
     **/
    public Ice.AsyncResult begin_shutdownRegistry(String name, Ice.Callback __cb)
    {
        return begin_shutdownRegistry(name, null, false, __cb);
    }

    /**
     * Shutdown an IceGrid registry.
     * 
     * @param __cb The callback object for the operation.
     * @param name The registry name.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_shutdownRegistry(String name, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_shutdownRegistry(name, __ctx, true, __cb);
    }

    /**
     * Shutdown an IceGrid registry.
     * 
     * @param __cb The callback object for the operation.
     * @param name The registry name.
     * 
     **/
    public Ice.AsyncResult begin_shutdownRegistry(String name, Callback_Admin_shutdownRegistry __cb)
    {
        return begin_shutdownRegistry(name, null, false, __cb);
    }

    /**
     * Shutdown an IceGrid registry.
     * 
     * @param __cb The callback object for the operation.
     * @param name The registry name.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_shutdownRegistry(String name, java.util.Map<String, String> __ctx, Callback_Admin_shutdownRegistry __cb)
    {
        return begin_shutdownRegistry(name, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_shutdownRegistry(String name, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__shutdownRegistry_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __shutdownRegistry_name, __cb);
        try
        {
            __result.__prepare(__shutdownRegistry_name, Ice.OperationMode.Idempotent, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.writeString(name);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     **/
    public void end_shutdownRegistry(Ice.AsyncResult __result)
        throws RegistryNotExistException,
               RegistryUnreachableException
    {
        Ice.AsyncResult.__check(__result, this, __shutdownRegistry_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(RegistryNotExistException __ex)
            {
                throw __ex;
            }
            catch(RegistryUnreachableException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        IceInternal.BasicStream __is = __result.__is();
        __is.skipEmptyEncaps();
    }

    /**
     * Shutdown an IceGrid registry.
     * 
     * @param __cb The callback object for the operation.
     * @param name The registry name.
     * 
     **/
    public boolean
    shutdownRegistry_async(AMI_Admin_shutdownRegistry __cb, String name)
    {
        Ice.AsyncResult __r;
        try
        {
            __checkTwowayOnly(__shutdownRegistry_name);
            __r = begin_shutdownRegistry(name, null, false, __cb);
        }
        catch(Ice.TwowayOnlyException ex)
        {
            __r = new IceInternal.OutgoingAsync(this, __shutdownRegistry_name, __cb);
            __r.__exceptionAsync(ex);
        }
        return __r.sentSynchronously();
    }

    /**
     * Shutdown an IceGrid registry.
     * 
     * @param __cb The callback object for the operation.
     * @param name The registry name.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public boolean
    shutdownRegistry_async(AMI_Admin_shutdownRegistry __cb, String name, java.util.Map<String, String> __ctx)
    {
        Ice.AsyncResult __r;
        try
        {
            __checkTwowayOnly(__shutdownRegistry_name);
            __r = begin_shutdownRegistry(name, __ctx, true, __cb);
        }
        catch(Ice.TwowayOnlyException ex)
        {
            __r = new IceInternal.OutgoingAsync(this, __shutdownRegistry_name, __cb);
            __r.__exceptionAsync(ex);
        }
        return __r.sentSynchronously();
    }

    /**
     * Start a server and wait for its activation.
     * 
     * @param id The server id.
     * 
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     * 
     * @throws ServerStartException Raised if the server couldn't be
     * started.
     * 
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     **/
    public void
    startServer(String id)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException,
               ServerStartException
    {
        startServer(id, null, false);
    }

    /**
     * Start a server and wait for its activation.
     * 
     * @param id The server id.
     * 
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     * 
     * @throws ServerStartException Raised if the server couldn't be
     * started.
     * 
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void
    startServer(String id, java.util.Map<String, String> __ctx)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException,
               ServerStartException
    {
        startServer(id, __ctx, true);
    }

    private void
    startServer(String id, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException,
               ServerStartException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("startServer");
                __delBase = __getDelegate(false);
                _AdminDel __del = (_AdminDel)__delBase;
                __del.startServer(id, __ctx);
                return;
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __startServer_name = "startServer";

    /**
     * Start a server and wait for its activation.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     **/
    public Ice.AsyncResult begin_startServer(String id)
    {
        return begin_startServer(id, null, false, null);
    }

    /**
     * Start a server and wait for its activation.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_startServer(String id, java.util.Map<String, String> __ctx)
    {
        return begin_startServer(id, __ctx, true, null);
    }

    /**
     * Start a server and wait for its activation.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     **/
    public Ice.AsyncResult begin_startServer(String id, Ice.Callback __cb)
    {
        return begin_startServer(id, null, false, __cb);
    }

    /**
     * Start a server and wait for its activation.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_startServer(String id, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_startServer(id, __ctx, true, __cb);
    }

    /**
     * Start a server and wait for its activation.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     **/
    public Ice.AsyncResult begin_startServer(String id, Callback_Admin_startServer __cb)
    {
        return begin_startServer(id, null, false, __cb);
    }

    /**
     * Start a server and wait for its activation.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_startServer(String id, java.util.Map<String, String> __ctx, Callback_Admin_startServer __cb)
    {
        return begin_startServer(id, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_startServer(String id, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__startServer_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __startServer_name, __cb);
        try
        {
            __result.__prepare(__startServer_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.writeString(id);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     **/
    public void end_startServer(Ice.AsyncResult __result)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException,
               ServerStartException
    {
        Ice.AsyncResult.__check(__result, this, __startServer_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(DeploymentException __ex)
            {
                throw __ex;
            }
            catch(NodeUnreachableException __ex)
            {
                throw __ex;
            }
            catch(ServerNotExistException __ex)
            {
                throw __ex;
            }
            catch(ServerStartException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        IceInternal.BasicStream __is = __result.__is();
        __is.skipEmptyEncaps();
    }

    /**
     * Start a server and wait for its activation.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     **/
    public boolean
    startServer_async(AMI_Admin_startServer __cb, String id)
    {
        Ice.AsyncResult __r;
        try
        {
            __checkTwowayOnly(__startServer_name);
            __r = begin_startServer(id, null, false, __cb);
        }
        catch(Ice.TwowayOnlyException ex)
        {
            __r = new IceInternal.OutgoingAsync(this, __startServer_name, __cb);
            __r.__exceptionAsync(ex);
        }
        return __r.sentSynchronously();
    }

    /**
     * Start a server and wait for its activation.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public boolean
    startServer_async(AMI_Admin_startServer __cb, String id, java.util.Map<String, String> __ctx)
    {
        Ice.AsyncResult __r;
        try
        {
            __checkTwowayOnly(__startServer_name);
            __r = begin_startServer(id, __ctx, true, __cb);
        }
        catch(Ice.TwowayOnlyException ex)
        {
            __r = new IceInternal.OutgoingAsync(this, __startServer_name, __cb);
            __r.__exceptionAsync(ex);
        }
        return __r.sentSynchronously();
    }

    /**
     * Stop a server.
     * 
     * @param id The server id.
     * 
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     * 
     * @throws ServerStopException Raised if the server couldn't be
     * stopped.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     **/
    public void
    stopServer(String id)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException,
               ServerStopException
    {
        stopServer(id, null, false);
    }

    /**
     * Stop a server.
     * 
     * @param id The server id.
     * 
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     * 
     * @throws ServerStopException Raised if the server couldn't be
     * stopped.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void
    stopServer(String id, java.util.Map<String, String> __ctx)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException,
               ServerStopException
    {
        stopServer(id, __ctx, true);
    }

    private void
    stopServer(String id, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException,
               ServerStopException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("stopServer");
                __delBase = __getDelegate(false);
                _AdminDel __del = (_AdminDel)__delBase;
                __del.stopServer(id, __ctx);
                return;
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __stopServer_name = "stopServer";

    /**
     * Stop a server.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     **/
    public Ice.AsyncResult begin_stopServer(String id)
    {
        return begin_stopServer(id, null, false, null);
    }

    /**
     * Stop a server.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_stopServer(String id, java.util.Map<String, String> __ctx)
    {
        return begin_stopServer(id, __ctx, true, null);
    }

    /**
     * Stop a server.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     **/
    public Ice.AsyncResult begin_stopServer(String id, Ice.Callback __cb)
    {
        return begin_stopServer(id, null, false, __cb);
    }

    /**
     * Stop a server.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_stopServer(String id, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_stopServer(id, __ctx, true, __cb);
    }

    /**
     * Stop a server.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     **/
    public Ice.AsyncResult begin_stopServer(String id, Callback_Admin_stopServer __cb)
    {
        return begin_stopServer(id, null, false, __cb);
    }

    /**
     * Stop a server.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_stopServer(String id, java.util.Map<String, String> __ctx, Callback_Admin_stopServer __cb)
    {
        return begin_stopServer(id, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_stopServer(String id, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__stopServer_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __stopServer_name, __cb);
        try
        {
            __result.__prepare(__stopServer_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.writeString(id);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     **/
    public void end_stopServer(Ice.AsyncResult __result)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException,
               ServerStopException
    {
        Ice.AsyncResult.__check(__result, this, __stopServer_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(DeploymentException __ex)
            {
                throw __ex;
            }
            catch(NodeUnreachableException __ex)
            {
                throw __ex;
            }
            catch(ServerNotExistException __ex)
            {
                throw __ex;
            }
            catch(ServerStopException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        IceInternal.BasicStream __is = __result.__is();
        __is.skipEmptyEncaps();
    }

    /**
     * Stop a server.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     **/
    public boolean
    stopServer_async(AMI_Admin_stopServer __cb, String id)
    {
        Ice.AsyncResult __r;
        try
        {
            __checkTwowayOnly(__stopServer_name);
            __r = begin_stopServer(id, null, false, __cb);
        }
        catch(Ice.TwowayOnlyException ex)
        {
            __r = new IceInternal.OutgoingAsync(this, __stopServer_name, __cb);
            __r.__exceptionAsync(ex);
        }
        return __r.sentSynchronously();
    }

    /**
     * Stop a server.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public boolean
    stopServer_async(AMI_Admin_stopServer __cb, String id, java.util.Map<String, String> __ctx)
    {
        Ice.AsyncResult __r;
        try
        {
            __checkTwowayOnly(__stopServer_name);
            __r = begin_stopServer(id, __ctx, true, __cb);
        }
        catch(Ice.TwowayOnlyException ex)
        {
            __r = new IceInternal.OutgoingAsync(this, __stopServer_name, __cb);
            __r.__exceptionAsync(ex);
        }
        return __r.sentSynchronously();
    }

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor.
     * 
     * @param descriptor The application descriptor.
     * 
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * 
     * @throws DeploymentException Raised if application deployment
     * failed.
     * 
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * 
     **/
    public void
    syncApplication(ApplicationDescriptor descriptor)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException
    {
        syncApplication(descriptor, null, false);
    }

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor.
     * 
     * @param descriptor The application descriptor.
     * 
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * 
     * @throws DeploymentException Raised if application deployment
     * failed.
     * 
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void
    syncApplication(ApplicationDescriptor descriptor, java.util.Map<String, String> __ctx)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException
    {
        syncApplication(descriptor, __ctx, true);
    }

    private void
    syncApplication(ApplicationDescriptor descriptor, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("syncApplication");
                __delBase = __getDelegate(false);
                _AdminDel __del = (_AdminDel)__delBase;
                __del.syncApplication(descriptor, __ctx);
                return;
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __syncApplication_name = "syncApplication";

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor.
     * 
     * @param __cb The callback object for the operation.
     * @param descriptor The application descriptor.
     * 
     **/
    public Ice.AsyncResult begin_syncApplication(ApplicationDescriptor descriptor)
    {
        return begin_syncApplication(descriptor, null, false, null);
    }

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor.
     * 
     * @param __cb The callback object for the operation.
     * @param descriptor The application descriptor.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_syncApplication(ApplicationDescriptor descriptor, java.util.Map<String, String> __ctx)
    {
        return begin_syncApplication(descriptor, __ctx, true, null);
    }

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor.
     * 
     * @param __cb The callback object for the operation.
     * @param descriptor The application descriptor.
     * 
     **/
    public Ice.AsyncResult begin_syncApplication(ApplicationDescriptor descriptor, Ice.Callback __cb)
    {
        return begin_syncApplication(descriptor, null, false, __cb);
    }

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor.
     * 
     * @param __cb The callback object for the operation.
     * @param descriptor The application descriptor.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_syncApplication(ApplicationDescriptor descriptor, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_syncApplication(descriptor, __ctx, true, __cb);
    }

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor.
     * 
     * @param __cb The callback object for the operation.
     * @param descriptor The application descriptor.
     * 
     **/
    public Ice.AsyncResult begin_syncApplication(ApplicationDescriptor descriptor, Callback_Admin_syncApplication __cb)
    {
        return begin_syncApplication(descriptor, null, false, __cb);
    }

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor.
     * 
     * @param __cb The callback object for the operation.
     * @param descriptor The application descriptor.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_syncApplication(ApplicationDescriptor descriptor, java.util.Map<String, String> __ctx, Callback_Admin_syncApplication __cb)
    {
        return begin_syncApplication(descriptor, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_syncApplication(ApplicationDescriptor descriptor, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__syncApplication_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __syncApplication_name, __cb);
        try
        {
            __result.__prepare(__syncApplication_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            descriptor.__write(__os);
            __os.writePendingObjects();
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     **/
    public void end_syncApplication(Ice.AsyncResult __result)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException
    {
        Ice.AsyncResult.__check(__result, this, __syncApplication_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(AccessDeniedException __ex)
            {
                throw __ex;
            }
            catch(ApplicationNotExistException __ex)
            {
                throw __ex;
            }
            catch(DeploymentException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        IceInternal.BasicStream __is = __result.__is();
        __is.skipEmptyEncaps();
    }

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor.
     * 
     * @param __cb The callback object for the operation.
     * @param descriptor The application descriptor.
     * 
     **/
    public boolean
    syncApplication_async(AMI_Admin_syncApplication __cb, ApplicationDescriptor descriptor)
    {
        Ice.AsyncResult __r;
        try
        {
            __checkTwowayOnly(__syncApplication_name);
            __r = begin_syncApplication(descriptor, null, false, __cb);
        }
        catch(Ice.TwowayOnlyException ex)
        {
            __r = new IceInternal.OutgoingAsync(this, __syncApplication_name, __cb);
            __r.__exceptionAsync(ex);
        }
        return __r.sentSynchronously();
    }

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor.
     * 
     * @param __cb The callback object for the operation.
     * @param descriptor The application descriptor.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public boolean
    syncApplication_async(AMI_Admin_syncApplication __cb, ApplicationDescriptor descriptor, java.util.Map<String, String> __ctx)
    {
        Ice.AsyncResult __r;
        try
        {
            __checkTwowayOnly(__syncApplication_name);
            __r = begin_syncApplication(descriptor, __ctx, true, __cb);
        }
        catch(Ice.TwowayOnlyException ex)
        {
            __r = new IceInternal.OutgoingAsync(this, __syncApplication_name, __cb);
            __r.__exceptionAsync(ex);
        }
        return __r.sentSynchronously();
    }

    /**
     * Update a deployed application with the given update application
     * descriptor.
     * 
     * @param descriptor The update descriptor.
     * 
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * 
     * @throws DeploymentException Raised if application deployment
     * failed.
     * 
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * 
     **/
    public void
    updateApplication(ApplicationUpdateDescriptor descriptor)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException
    {
        updateApplication(descriptor, null, false);
    }

    /**
     * Update a deployed application with the given update application
     * descriptor.
     * 
     * @param descriptor The update descriptor.
     * 
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * 
     * @throws DeploymentException Raised if application deployment
     * failed.
     * 
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void
    updateApplication(ApplicationUpdateDescriptor descriptor, java.util.Map<String, String> __ctx)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException
    {
        updateApplication(descriptor, __ctx, true);
    }

    private void
    updateApplication(ApplicationUpdateDescriptor descriptor, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("updateApplication");
                __delBase = __getDelegate(false);
                _AdminDel __del = (_AdminDel)__delBase;
                __del.updateApplication(descriptor, __ctx);
                return;
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __updateApplication_name = "updateApplication";

    /**
     * Update a deployed application with the given update application
     * descriptor.
     * 
     * @param __cb The callback object for the operation.
     * @param descriptor The update descriptor.
     * 
     **/
    public Ice.AsyncResult begin_updateApplication(ApplicationUpdateDescriptor descriptor)
    {
        return begin_updateApplication(descriptor, null, false, null);
    }

    /**
     * Update a deployed application with the given update application
     * descriptor.
     * 
     * @param __cb The callback object for the operation.
     * @param descriptor The update descriptor.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_updateApplication(ApplicationUpdateDescriptor descriptor, java.util.Map<String, String> __ctx)
    {
        return begin_updateApplication(descriptor, __ctx, true, null);
    }

    /**
     * Update a deployed application with the given update application
     * descriptor.
     * 
     * @param __cb The callback object for the operation.
     * @param descriptor The update descriptor.
     * 
     **/
    public Ice.AsyncResult begin_updateApplication(ApplicationUpdateDescriptor descriptor, Ice.Callback __cb)
    {
        return begin_updateApplication(descriptor, null, false, __cb);
    }

    /**
     * Update a deployed application with the given update application
     * descriptor.
     * 
     * @param __cb The callback object for the operation.
     * @param descriptor The update descriptor.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_updateApplication(ApplicationUpdateDescriptor descriptor, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_updateApplication(descriptor, __ctx, true, __cb);
    }

    /**
     * Update a deployed application with the given update application
     * descriptor.
     * 
     * @param __cb The callback object for the operation.
     * @param descriptor The update descriptor.
     * 
     **/
    public Ice.AsyncResult begin_updateApplication(ApplicationUpdateDescriptor descriptor, Callback_Admin_updateApplication __cb)
    {
        return begin_updateApplication(descriptor, null, false, __cb);
    }

    /**
     * Update a deployed application with the given update application
     * descriptor.
     * 
     * @param __cb The callback object for the operation.
     * @param descriptor The update descriptor.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_updateApplication(ApplicationUpdateDescriptor descriptor, java.util.Map<String, String> __ctx, Callback_Admin_updateApplication __cb)
    {
        return begin_updateApplication(descriptor, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_updateApplication(ApplicationUpdateDescriptor descriptor, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__updateApplication_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __updateApplication_name, __cb);
        try
        {
            __result.__prepare(__updateApplication_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            descriptor.__write(__os);
            __os.writePendingObjects();
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     **/
    public void end_updateApplication(Ice.AsyncResult __result)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException
    {
        Ice.AsyncResult.__check(__result, this, __updateApplication_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(AccessDeniedException __ex)
            {
                throw __ex;
            }
            catch(ApplicationNotExistException __ex)
            {
                throw __ex;
            }
            catch(DeploymentException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        IceInternal.BasicStream __is = __result.__is();
        __is.skipEmptyEncaps();
    }

    /**
     * Update a deployed application with the given update application
     * descriptor.
     * 
     * @param __cb The callback object for the operation.
     * @param descriptor The update descriptor.
     * 
     **/
    public boolean
    updateApplication_async(AMI_Admin_updateApplication __cb, ApplicationUpdateDescriptor descriptor)
    {
        Ice.AsyncResult __r;
        try
        {
            __checkTwowayOnly(__updateApplication_name);
            __r = begin_updateApplication(descriptor, null, false, __cb);
        }
        catch(Ice.TwowayOnlyException ex)
        {
            __r = new IceInternal.OutgoingAsync(this, __updateApplication_name, __cb);
            __r.__exceptionAsync(ex);
        }
        return __r.sentSynchronously();
    }

    /**
     * Update a deployed application with the given update application
     * descriptor.
     * 
     * @param __cb The callback object for the operation.
     * @param descriptor The update descriptor.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public boolean
    updateApplication_async(AMI_Admin_updateApplication __cb, ApplicationUpdateDescriptor descriptor, java.util.Map<String, String> __ctx)
    {
        Ice.AsyncResult __r;
        try
        {
            __checkTwowayOnly(__updateApplication_name);
            __r = begin_updateApplication(descriptor, __ctx, true, __cb);
        }
        catch(Ice.TwowayOnlyException ex)
        {
            __r = new IceInternal.OutgoingAsync(this, __updateApplication_name, __cb);
            __r.__exceptionAsync(ex);
        }
        return __r.sentSynchronously();
    }

    /**
     * Update an object in the object registry. Only objects added
     * with this interface can be updated with this operation. Objects
     * added with deployment descriptors should be updated with the
     * deployment mechanism.
     * 
     * @param obj The object to be updated to the registry.
     * 
     * @throws ObjectNotRegisteredException Raised if the object isn't
     * registered with the registry.
     * 
     * @throws DeploymentException Raised if the object can't be
     * updated. This might happen if the object was added with a
     * deployment descriptor.
     * 
     **/
    public void
    updateObject(Ice.ObjectPrx obj)
        throws DeploymentException,
               ObjectNotRegisteredException
    {
        updateObject(obj, null, false);
    }

    /**
     * Update an object in the object registry. Only objects added
     * with this interface can be updated with this operation. Objects
     * added with deployment descriptors should be updated with the
     * deployment mechanism.
     * 
     * @param obj The object to be updated to the registry.
     * 
     * @throws ObjectNotRegisteredException Raised if the object isn't
     * registered with the registry.
     * 
     * @throws DeploymentException Raised if the object can't be
     * updated. This might happen if the object was added with a
     * deployment descriptor.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void
    updateObject(Ice.ObjectPrx obj, java.util.Map<String, String> __ctx)
        throws DeploymentException,
               ObjectNotRegisteredException
    {
        updateObject(obj, __ctx, true);
    }

    private void
    updateObject(Ice.ObjectPrx obj, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws DeploymentException,
               ObjectNotRegisteredException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("updateObject");
                __delBase = __getDelegate(false);
                _AdminDel __del = (_AdminDel)__delBase;
                __del.updateObject(obj, __ctx);
                return;
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __updateObject_name = "updateObject";

    /**
     * Update an object in the object registry. Only objects added
     * with this interface can be updated with this operation. Objects
     * added with deployment descriptors should be updated with the
     * deployment mechanism.
     * 
     * @param __cb The callback object for the operation.
     * @param obj The object to be updated to the registry.
     * 
     **/
    public Ice.AsyncResult begin_updateObject(Ice.ObjectPrx obj)
    {
        return begin_updateObject(obj, null, false, null);
    }

    /**
     * Update an object in the object registry. Only objects added
     * with this interface can be updated with this operation. Objects
     * added with deployment descriptors should be updated with the
     * deployment mechanism.
     * 
     * @param __cb The callback object for the operation.
     * @param obj The object to be updated to the registry.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_updateObject(Ice.ObjectPrx obj, java.util.Map<String, String> __ctx)
    {
        return begin_updateObject(obj, __ctx, true, null);
    }

    /**
     * Update an object in the object registry. Only objects added
     * with this interface can be updated with this operation. Objects
     * added with deployment descriptors should be updated with the
     * deployment mechanism.
     * 
     * @param __cb The callback object for the operation.
     * @param obj The object to be updated to the registry.
     * 
     **/
    public Ice.AsyncResult begin_updateObject(Ice.ObjectPrx obj, Ice.Callback __cb)
    {
        return begin_updateObject(obj, null, false, __cb);
    }

    /**
     * Update an object in the object registry. Only objects added
     * with this interface can be updated with this operation. Objects
     * added with deployment descriptors should be updated with the
     * deployment mechanism.
     * 
     * @param __cb The callback object for the operation.
     * @param obj The object to be updated to the registry.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_updateObject(Ice.ObjectPrx obj, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_updateObject(obj, __ctx, true, __cb);
    }

    /**
     * Update an object in the object registry. Only objects added
     * with this interface can be updated with this operation. Objects
     * added with deployment descriptors should be updated with the
     * deployment mechanism.
     * 
     * @param __cb The callback object for the operation.
     * @param obj The object to be updated to the registry.
     * 
     **/
    public Ice.AsyncResult begin_updateObject(Ice.ObjectPrx obj, Callback_Admin_updateObject __cb)
    {
        return begin_updateObject(obj, null, false, __cb);
    }

    /**
     * Update an object in the object registry. Only objects added
     * with this interface can be updated with this operation. Objects
     * added with deployment descriptors should be updated with the
     * deployment mechanism.
     * 
     * @param __cb The callback object for the operation.
     * @param obj The object to be updated to the registry.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_updateObject(Ice.ObjectPrx obj, java.util.Map<String, String> __ctx, Callback_Admin_updateObject __cb)
    {
        return begin_updateObject(obj, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_updateObject(Ice.ObjectPrx obj, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__updateObject_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __updateObject_name, __cb);
        try
        {
            __result.__prepare(__updateObject_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.writeProxy(obj);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     **/
    public void end_updateObject(Ice.AsyncResult __result)
        throws DeploymentException,
               ObjectNotRegisteredException
    {
        Ice.AsyncResult.__check(__result, this, __updateObject_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(DeploymentException __ex)
            {
                throw __ex;
            }
            catch(ObjectNotRegisteredException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        IceInternal.BasicStream __is = __result.__is();
        __is.skipEmptyEncaps();
    }

    /**
     * Write message on server stdout or stderr.
     * 
     * <p class="Deprecated">This operation is deprecated as of version 3.3.
     * 
     * @param id The server id.
     * 
     * @param message The message.
     * 
     * @param fd 1 for stdout, 2 for stderr.
     * 
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     * @deprecated writeMessage is deprecated, use instead the Process facet of the server Admin object.
     **/
    public void
    writeMessage(String id, String message, int fd)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException
    {
        writeMessage(id, message, fd, null, false);
    }

    /**
     * Write message on server stdout or stderr.
     * 
     * <p class="Deprecated">This operation is deprecated as of version 3.3.
     * 
     * @param id The server id.
     * 
     * @param message The message.
     * 
     * @param fd 1 for stdout, 2 for stderr.
     * 
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @deprecated writeMessage is deprecated, use instead the Process facet of the server Admin object.
     **/
    public void
    writeMessage(String id, String message, int fd, java.util.Map<String, String> __ctx)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException
    {
        writeMessage(id, message, fd, __ctx, true);
    }

    private void
    writeMessage(String id, String message, int fd, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("writeMessage");
                __delBase = __getDelegate(false);
                _AdminDel __del = (_AdminDel)__delBase;
                __del.writeMessage(id, message, fd, __ctx);
                return;
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __writeMessage_name = "writeMessage";

    /**
     * Write message on server stdout or stderr.
     * 
     * <p class="Deprecated">This operation is deprecated as of version 3.3.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param message The message.
     * 
     * @param fd 1 for stdout, 2 for stderr.
     * 
     * @deprecated writeMessage is deprecated, use instead the Process facet of the server Admin object.
     **/
    public Ice.AsyncResult begin_writeMessage(String id, String message, int fd)
    {
        return begin_writeMessage(id, message, fd, null, false, null);
    }

    /**
     * Write message on server stdout or stderr.
     * 
     * <p class="Deprecated">This operation is deprecated as of version 3.3.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param message The message.
     * 
     * @param fd 1 for stdout, 2 for stderr.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @deprecated writeMessage is deprecated, use instead the Process facet of the server Admin object.
     **/
    public Ice.AsyncResult begin_writeMessage(String id, String message, int fd, java.util.Map<String, String> __ctx)
    {
        return begin_writeMessage(id, message, fd, __ctx, true, null);
    }

    /**
     * Write message on server stdout or stderr.
     * 
     * <p class="Deprecated">This operation is deprecated as of version 3.3.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param message The message.
     * 
     * @param fd 1 for stdout, 2 for stderr.
     * 
     * @deprecated writeMessage is deprecated, use instead the Process facet of the server Admin object.
     **/
    public Ice.AsyncResult begin_writeMessage(String id, String message, int fd, Ice.Callback __cb)
    {
        return begin_writeMessage(id, message, fd, null, false, __cb);
    }

    /**
     * Write message on server stdout or stderr.
     * 
     * <p class="Deprecated">This operation is deprecated as of version 3.3.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param message The message.
     * 
     * @param fd 1 for stdout, 2 for stderr.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @deprecated writeMessage is deprecated, use instead the Process facet of the server Admin object.
     **/
    public Ice.AsyncResult begin_writeMessage(String id, String message, int fd, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_writeMessage(id, message, fd, __ctx, true, __cb);
    }

    /**
     * Write message on server stdout or stderr.
     * 
     * <p class="Deprecated">This operation is deprecated as of version 3.3.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param message The message.
     * 
     * @param fd 1 for stdout, 2 for stderr.
     * 
     * @deprecated writeMessage is deprecated, use instead the Process facet of the server Admin object.
     **/
    public Ice.AsyncResult begin_writeMessage(String id, String message, int fd, Callback_Admin_writeMessage __cb)
    {
        return begin_writeMessage(id, message, fd, null, false, __cb);
    }

    /**
     * Write message on server stdout or stderr.
     * 
     * <p class="Deprecated">This operation is deprecated as of version 3.3.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param message The message.
     * 
     * @param fd 1 for stdout, 2 for stderr.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @deprecated writeMessage is deprecated, use instead the Process facet of the server Admin object.
     **/
    public Ice.AsyncResult begin_writeMessage(String id, String message, int fd, java.util.Map<String, String> __ctx, Callback_Admin_writeMessage __cb)
    {
        return begin_writeMessage(id, message, fd, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_writeMessage(String id, String message, int fd, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__writeMessage_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __writeMessage_name, __cb);
        try
        {
            __result.__prepare(__writeMessage_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.writeString(id);
            __os.writeString(message);
            __os.writeInt(fd);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     **/
    public void end_writeMessage(Ice.AsyncResult __result)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException
    {
        Ice.AsyncResult.__check(__result, this, __writeMessage_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(DeploymentException __ex)
            {
                throw __ex;
            }
            catch(NodeUnreachableException __ex)
            {
                throw __ex;
            }
            catch(ServerNotExistException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        IceInternal.BasicStream __is = __result.__is();
        __is.skipEmptyEncaps();
    }

    /**
     * Write message on server stdout or stderr.
     * 
     * <p class="Deprecated">This operation is deprecated as of version 3.3.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param message The message.
     * 
     * @param fd 1 for stdout, 2 for stderr.
     * 
     * @deprecated writeMessage is deprecated, use instead the Process facet of the server Admin object.
     **/
    public boolean
    writeMessage_async(AMI_Admin_writeMessage __cb, String id, String message, int fd)
    {
        Ice.AsyncResult __r;
        try
        {
            __checkTwowayOnly(__writeMessage_name);
            __r = begin_writeMessage(id, message, fd, null, false, __cb);
        }
        catch(Ice.TwowayOnlyException ex)
        {
            __r = new IceInternal.OutgoingAsync(this, __writeMessage_name, __cb);
            __r.__exceptionAsync(ex);
        }
        return __r.sentSynchronously();
    }

    /**
     * Write message on server stdout or stderr.
     * 
     * <p class="Deprecated">This operation is deprecated as of version 3.3.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param message The message.
     * 
     * @param fd 1 for stdout, 2 for stderr.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @deprecated writeMessage is deprecated, use instead the Process facet of the server Admin object.
     **/
    public boolean
    writeMessage_async(AMI_Admin_writeMessage __cb, String id, String message, int fd, java.util.Map<String, String> __ctx)
    {
        Ice.AsyncResult __r;
        try
        {
            __checkTwowayOnly(__writeMessage_name);
            __r = begin_writeMessage(id, message, fd, __ctx, true, __cb);
        }
        catch(Ice.TwowayOnlyException ex)
        {
            __r = new IceInternal.OutgoingAsync(this, __writeMessage_name, __cb);
            __r.__exceptionAsync(ex);
        }
        return __r.sentSynchronously();
    }

    public static AdminPrx
    checkedCast(Ice.ObjectPrx __obj)
    {
        AdminPrx __d = null;
        if(__obj != null)
        {
            try
            {
                __d = (AdminPrx)__obj;
            }
            catch(ClassCastException ex)
            {
                if(__obj.ice_isA("::IceGrid::Admin"))
                {
                    AdminPrxHelper __h = new AdminPrxHelper();
                    __h.__copyFrom(__obj);
                    __d = __h;
                }
            }
        }
        return __d;
    }

    public static AdminPrx
    checkedCast(Ice.ObjectPrx __obj, java.util.Map<String, String> __ctx)
    {
        AdminPrx __d = null;
        if(__obj != null)
        {
            try
            {
                __d = (AdminPrx)__obj;
            }
            catch(ClassCastException ex)
            {
                if(__obj.ice_isA("::IceGrid::Admin", __ctx))
                {
                    AdminPrxHelper __h = new AdminPrxHelper();
                    __h.__copyFrom(__obj);
                    __d = __h;
                }
            }
        }
        return __d;
    }

    public static AdminPrx
    checkedCast(Ice.ObjectPrx __obj, String __facet)
    {
        AdminPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            try
            {
                if(__bb.ice_isA("::IceGrid::Admin"))
                {
                    AdminPrxHelper __h = new AdminPrxHelper();
                    __h.__copyFrom(__bb);
                    __d = __h;
                }
            }
            catch(Ice.FacetNotExistException ex)
            {
            }
        }
        return __d;
    }

    public static AdminPrx
    checkedCast(Ice.ObjectPrx __obj, String __facet, java.util.Map<String, String> __ctx)
    {
        AdminPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            try
            {
                if(__bb.ice_isA("::IceGrid::Admin", __ctx))
                {
                    AdminPrxHelper __h = new AdminPrxHelper();
                    __h.__copyFrom(__bb);
                    __d = __h;
                }
            }
            catch(Ice.FacetNotExistException ex)
            {
            }
        }
        return __d;
    }

    public static AdminPrx
    uncheckedCast(Ice.ObjectPrx __obj)
    {
        AdminPrx __d = null;
        if(__obj != null)
        {
            try
            {
                __d = (AdminPrx)__obj;
            }
            catch(ClassCastException ex)
            {
                AdminPrxHelper __h = new AdminPrxHelper();
                __h.__copyFrom(__obj);
                __d = __h;
            }
        }
        return __d;
    }

    public static AdminPrx
    uncheckedCast(Ice.ObjectPrx __obj, String __facet)
    {
        AdminPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            AdminPrxHelper __h = new AdminPrxHelper();
            __h.__copyFrom(__bb);
            __d = __h;
        }
        return __d;
    }

    protected Ice._ObjectDelM
    __createDelegateM()
    {
        return new _AdminDelM();
    }

    protected Ice._ObjectDelD
    __createDelegateD()
    {
        return new _AdminDelD();
    }

    public static void
    __write(IceInternal.BasicStream __os, AdminPrx v)
    {
        __os.writeProxy(v);
    }

    public static AdminPrx
    __read(IceInternal.BasicStream __is)
    {
        Ice.ObjectPrx proxy = __is.readProxy();
        if(proxy != null)
        {
            AdminPrxHelper result = new AdminPrxHelper();
            result.__copyFrom(proxy);
            return result;
        }
        return null;
    }
}
