// **********************************************************************
//
// Copyright (c) 2003-2010 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************

// Ice version 3.4.1

package IceGrid;

// <auto-generated>
//
// Generated from file `Admin.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>


/**
 * Used by administrative clients to view,
 * update, and receive observer updates from the IceGrid
 * registry. Admin sessions are created either with the {@link Registry}
 * object or the registry admin {@link Glacier2.SessionManager} object.
 * 
 * @see Registry
 * @see Glacier2.SessionManager
 * 
 **/
public final class AdminSessionPrxHelper extends Ice.ObjectPrxHelperBase implements AdminSessionPrx
{
    /**
     * Destroy the session. This is called automatically when the
     * {@link Router} is destroyed.
     * 
     **/
    public void
    destroy()
    {
        destroy(null, false);
    }

    /**
     * Destroy the session. This is called automatically when the
     * {@link Router} is destroyed.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void
    destroy(java.util.Map<String, String> __ctx)
    {
        destroy(__ctx, true);
    }

    private void
    destroy(java.util.Map<String, String> __ctx, boolean __explicitCtx)
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __delBase = __getDelegate(false);
                _AdminSessionDel __del = (_AdminSessionDel)__delBase;
                __del.destroy(__ctx);
                return;
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __destroy_name = "destroy";

    /**
     * Destroy the session. This is called automatically when the
     * {@link Router} is destroyed.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_destroy()
    {
        return begin_destroy(null, false, null);
    }

    /**
     * Destroy the session. This is called automatically when the
     * {@link Router} is destroyed.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_destroy(java.util.Map<String, String> __ctx)
    {
        return begin_destroy(__ctx, true, null);
    }

    /**
     * Destroy the session. This is called automatically when the
     * {@link Router} is destroyed.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_destroy(Ice.Callback __cb)
    {
        return begin_destroy(null, false, __cb);
    }

    /**
     * Destroy the session. This is called automatically when the
     * {@link Router} is destroyed.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_destroy(java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_destroy(__ctx, true, __cb);
    }

    /**
     * Destroy the session. This is called automatically when the
     * {@link Router} is destroyed.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_destroy(Glacier2.Callback_Session_destroy __cb)
    {
        return begin_destroy(null, false, __cb);
    }

    /**
     * Destroy the session. This is called automatically when the
     * {@link Router} is destroyed.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_destroy(java.util.Map<String, String> __ctx, Glacier2.Callback_Session_destroy __cb)
    {
        return begin_destroy(__ctx, true, __cb);
    }

    private Ice.AsyncResult begin_destroy(java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __destroy_name, __cb);
        try
        {
            __result.__prepare(__destroy_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     **/
    public void end_destroy(Ice.AsyncResult __result)
    {
        __end(__result, __destroy_name);
    }

    /**
     * Destroy the session. This is called automatically when the
     * {@link Router} is destroyed.
     * 
     * @param __cb The callback object for the operation.
     **/
    public boolean
    destroy_async(Glacier2.AMI_Session_destroy __cb)
    {
        Ice.AsyncResult __r = begin_destroy(null, false, __cb);
        return __r.sentSynchronously();
    }

    /**
     * Destroy the session. This is called automatically when the
     * {@link Router} is destroyed.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public boolean
    destroy_async(Glacier2.AMI_Session_destroy __cb, java.util.Map<String, String> __ctx)
    {
        Ice.AsyncResult __r = begin_destroy(__ctx, true, __cb);
        return __r.sentSynchronously();
    }

    /**
     * Finish updating the registry and release the exclusive lock.
     * 
     * @throws AccessDeniedException Raised if the session doesn't hold the
     * exclusive lock.
     * 
     **/
    public void
    finishUpdate()
        throws AccessDeniedException
    {
        finishUpdate(null, false);
    }

    /**
     * Finish updating the registry and release the exclusive lock.
     * 
     * @throws AccessDeniedException Raised if the session doesn't hold the
     * exclusive lock.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void
    finishUpdate(java.util.Map<String, String> __ctx)
        throws AccessDeniedException
    {
        finishUpdate(__ctx, true);
    }

    private void
    finishUpdate(java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws AccessDeniedException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("finishUpdate");
                __delBase = __getDelegate(false);
                _AdminSessionDel __del = (_AdminSessionDel)__delBase;
                __del.finishUpdate(__ctx);
                return;
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __finishUpdate_name = "finishUpdate";

    /**
     * Finish updating the registry and release the exclusive lock.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_finishUpdate()
    {
        return begin_finishUpdate(null, false, null);
    }

    /**
     * Finish updating the registry and release the exclusive lock.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_finishUpdate(java.util.Map<String, String> __ctx)
    {
        return begin_finishUpdate(__ctx, true, null);
    }

    /**
     * Finish updating the registry and release the exclusive lock.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_finishUpdate(Ice.Callback __cb)
    {
        return begin_finishUpdate(null, false, __cb);
    }

    /**
     * Finish updating the registry and release the exclusive lock.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_finishUpdate(java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_finishUpdate(__ctx, true, __cb);
    }

    /**
     * Finish updating the registry and release the exclusive lock.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_finishUpdate(Callback_AdminSession_finishUpdate __cb)
    {
        return begin_finishUpdate(null, false, __cb);
    }

    /**
     * Finish updating the registry and release the exclusive lock.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_finishUpdate(java.util.Map<String, String> __ctx, Callback_AdminSession_finishUpdate __cb)
    {
        return begin_finishUpdate(__ctx, true, __cb);
    }

    private Ice.AsyncResult begin_finishUpdate(java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__finishUpdate_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __finishUpdate_name, __cb);
        try
        {
            __result.__prepare(__finishUpdate_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     **/
    public void end_finishUpdate(Ice.AsyncResult __result)
        throws AccessDeniedException
    {
        Ice.AsyncResult.__check(__result, this, __finishUpdate_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(AccessDeniedException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        IceInternal.BasicStream __is = __result.__is();
        __is.skipEmptyEncaps();
    }

    /**
     * Get the admin interface. The admin object returned by this
     * operation can only be accessed by the session.
     * 
     * @return The admin interface proxy.
     * 
     **/
    public AdminPrx
    getAdmin()
    {
        return getAdmin(null, false);
    }

    /**
     * Get the admin interface. The admin object returned by this
     * operation can only be accessed by the session.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The admin interface proxy.
     * 
     **/
    public AdminPrx
    getAdmin(java.util.Map<String, String> __ctx)
    {
        return getAdmin(__ctx, true);
    }

    private AdminPrx
    getAdmin(java.util.Map<String, String> __ctx, boolean __explicitCtx)
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("getAdmin");
                __delBase = __getDelegate(false);
                _AdminSessionDel __del = (_AdminSessionDel)__delBase;
                return __del.getAdmin(__ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __getAdmin_name = "getAdmin";

    /**
     * Get the admin interface. The admin object returned by this
     * operation can only be accessed by the session.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getAdmin()
    {
        return begin_getAdmin(null, false, null);
    }

    /**
     * Get the admin interface. The admin object returned by this
     * operation can only be accessed by the session.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getAdmin(java.util.Map<String, String> __ctx)
    {
        return begin_getAdmin(__ctx, true, null);
    }

    /**
     * Get the admin interface. The admin object returned by this
     * operation can only be accessed by the session.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getAdmin(Ice.Callback __cb)
    {
        return begin_getAdmin(null, false, __cb);
    }

    /**
     * Get the admin interface. The admin object returned by this
     * operation can only be accessed by the session.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getAdmin(java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_getAdmin(__ctx, true, __cb);
    }

    /**
     * Get the admin interface. The admin object returned by this
     * operation can only be accessed by the session.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getAdmin(Callback_AdminSession_getAdmin __cb)
    {
        return begin_getAdmin(null, false, __cb);
    }

    /**
     * Get the admin interface. The admin object returned by this
     * operation can only be accessed by the session.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getAdmin(java.util.Map<String, String> __ctx, Callback_AdminSession_getAdmin __cb)
    {
        return begin_getAdmin(__ctx, true, __cb);
    }

    private Ice.AsyncResult begin_getAdmin(java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__getAdmin_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __getAdmin_name, __cb);
        try
        {
            __result.__prepare(__getAdmin_name, Ice.OperationMode.Idempotent, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) The admin interface proxy.
     * 
     **/
    public AdminPrx end_getAdmin(Ice.AsyncResult __result)
    {
        Ice.AsyncResult.__check(__result, this, __getAdmin_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        AdminPrx __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = AdminPrxHelper.__read(__is);
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Get a "template" proxy for admin callback objects.
     * An Admin client uses this proxy to set the category of its callback
     * objects, and the published endpoints of the object adapter hosting
     * the admin callback objects.
     * 
     * @return A template proxy. The returned proxy is null when the Admin
     * session was established using Glacier2.
     * 
     **/
    public Ice.ObjectPrx
    getAdminCallbackTemplate()
    {
        return getAdminCallbackTemplate(null, false);
    }

    /**
     * Get a "template" proxy for admin callback objects.
     * An Admin client uses this proxy to set the category of its callback
     * objects, and the published endpoints of the object adapter hosting
     * the admin callback objects.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return A template proxy. The returned proxy is null when the Admin
     * session was established using Glacier2.
     * 
     **/
    public Ice.ObjectPrx
    getAdminCallbackTemplate(java.util.Map<String, String> __ctx)
    {
        return getAdminCallbackTemplate(__ctx, true);
    }

    private Ice.ObjectPrx
    getAdminCallbackTemplate(java.util.Map<String, String> __ctx, boolean __explicitCtx)
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("getAdminCallbackTemplate");
                __delBase = __getDelegate(false);
                _AdminSessionDel __del = (_AdminSessionDel)__delBase;
                return __del.getAdminCallbackTemplate(__ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __getAdminCallbackTemplate_name = "getAdminCallbackTemplate";

    /**
     * Get a "template" proxy for admin callback objects.
     * An Admin client uses this proxy to set the category of its callback
     * objects, and the published endpoints of the object adapter hosting
     * the admin callback objects.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getAdminCallbackTemplate()
    {
        return begin_getAdminCallbackTemplate(null, false, null);
    }

    /**
     * Get a "template" proxy for admin callback objects.
     * An Admin client uses this proxy to set the category of its callback
     * objects, and the published endpoints of the object adapter hosting
     * the admin callback objects.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getAdminCallbackTemplate(java.util.Map<String, String> __ctx)
    {
        return begin_getAdminCallbackTemplate(__ctx, true, null);
    }

    /**
     * Get a "template" proxy for admin callback objects.
     * An Admin client uses this proxy to set the category of its callback
     * objects, and the published endpoints of the object adapter hosting
     * the admin callback objects.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getAdminCallbackTemplate(Ice.Callback __cb)
    {
        return begin_getAdminCallbackTemplate(null, false, __cb);
    }

    /**
     * Get a "template" proxy for admin callback objects.
     * An Admin client uses this proxy to set the category of its callback
     * objects, and the published endpoints of the object adapter hosting
     * the admin callback objects.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getAdminCallbackTemplate(java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_getAdminCallbackTemplate(__ctx, true, __cb);
    }

    /**
     * Get a "template" proxy for admin callback objects.
     * An Admin client uses this proxy to set the category of its callback
     * objects, and the published endpoints of the object adapter hosting
     * the admin callback objects.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getAdminCallbackTemplate(Callback_AdminSession_getAdminCallbackTemplate __cb)
    {
        return begin_getAdminCallbackTemplate(null, false, __cb);
    }

    /**
     * Get a "template" proxy for admin callback objects.
     * An Admin client uses this proxy to set the category of its callback
     * objects, and the published endpoints of the object adapter hosting
     * the admin callback objects.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getAdminCallbackTemplate(java.util.Map<String, String> __ctx, Callback_AdminSession_getAdminCallbackTemplate __cb)
    {
        return begin_getAdminCallbackTemplate(__ctx, true, __cb);
    }

    private Ice.AsyncResult begin_getAdminCallbackTemplate(java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__getAdminCallbackTemplate_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __getAdminCallbackTemplate_name, __cb);
        try
        {
            __result.__prepare(__getAdminCallbackTemplate_name, Ice.OperationMode.Idempotent, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) A template proxy. The returned proxy is null when the Admin
     * session was established using Glacier2.
     * 
     **/
    public Ice.ObjectPrx end_getAdminCallbackTemplate(Ice.AsyncResult __result)
    {
        Ice.AsyncResult.__check(__result, this, __getAdminCallbackTemplate_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        Ice.ObjectPrx __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = __is.readProxy();
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Get the name of the registry replica hosting this session.
     * 
     * @return The replica name of the registry.
     * 
     **/
    public String
    getReplicaName()
    {
        return getReplicaName(null, false);
    }

    /**
     * Get the name of the registry replica hosting this session.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The replica name of the registry.
     * 
     **/
    public String
    getReplicaName(java.util.Map<String, String> __ctx)
    {
        return getReplicaName(__ctx, true);
    }

    private String
    getReplicaName(java.util.Map<String, String> __ctx, boolean __explicitCtx)
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("getReplicaName");
                __delBase = __getDelegate(false);
                _AdminSessionDel __del = (_AdminSessionDel)__delBase;
                return __del.getReplicaName(__ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __getReplicaName_name = "getReplicaName";

    /**
     * Get the name of the registry replica hosting this session.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getReplicaName()
    {
        return begin_getReplicaName(null, false, null);
    }

    /**
     * Get the name of the registry replica hosting this session.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getReplicaName(java.util.Map<String, String> __ctx)
    {
        return begin_getReplicaName(__ctx, true, null);
    }

    /**
     * Get the name of the registry replica hosting this session.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getReplicaName(Ice.Callback __cb)
    {
        return begin_getReplicaName(null, false, __cb);
    }

    /**
     * Get the name of the registry replica hosting this session.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getReplicaName(java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_getReplicaName(__ctx, true, __cb);
    }

    /**
     * Get the name of the registry replica hosting this session.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getReplicaName(Callback_AdminSession_getReplicaName __cb)
    {
        return begin_getReplicaName(null, false, __cb);
    }

    /**
     * Get the name of the registry replica hosting this session.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getReplicaName(java.util.Map<String, String> __ctx, Callback_AdminSession_getReplicaName __cb)
    {
        return begin_getReplicaName(__ctx, true, __cb);
    }

    private Ice.AsyncResult begin_getReplicaName(java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__getReplicaName_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __getReplicaName_name, __cb);
        try
        {
            __result.__prepare(__getReplicaName_name, Ice.OperationMode.Idempotent, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) The replica name of the registry.
     * 
     **/
    public String end_getReplicaName(Ice.AsyncResult __result)
    {
        Ice.AsyncResult.__check(__result, this, __getReplicaName_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        String __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = __is.readString();
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     * 
     * @see Registry#getSessionTimeout
     * 
     **/
    public void
    keepAlive()
    {
        keepAlive(null, false);
    }

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     * 
     * @see Registry#getSessionTimeout
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void
    keepAlive(java.util.Map<String, String> __ctx)
    {
        keepAlive(__ctx, true);
    }

    private void
    keepAlive(java.util.Map<String, String> __ctx, boolean __explicitCtx)
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __delBase = __getDelegate(false);
                _AdminSessionDel __del = (_AdminSessionDel)__delBase;
                __del.keepAlive(__ctx);
                return;
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __keepAlive_name = "keepAlive";

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_keepAlive()
    {
        return begin_keepAlive(null, false, null);
    }

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_keepAlive(java.util.Map<String, String> __ctx)
    {
        return begin_keepAlive(__ctx, true, null);
    }

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_keepAlive(Ice.Callback __cb)
    {
        return begin_keepAlive(null, false, __cb);
    }

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_keepAlive(java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_keepAlive(__ctx, true, __cb);
    }

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_keepAlive(Callback_AdminSession_keepAlive __cb)
    {
        return begin_keepAlive(null, false, __cb);
    }

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_keepAlive(java.util.Map<String, String> __ctx, Callback_AdminSession_keepAlive __cb)
    {
        return begin_keepAlive(__ctx, true, __cb);
    }

    private Ice.AsyncResult begin_keepAlive(java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __keepAlive_name, __cb);
        try
        {
            __result.__prepare(__keepAlive_name, Ice.OperationMode.Idempotent, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     **/
    public void end_keepAlive(Ice.AsyncResult __result)
    {
        __end(__result, __keepAlive_name);
    }

    /**
     * Open the given node stderr file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param name The node name.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     * @return An iterator to read the file.
     * 
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     * 
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * 
     **/
    public FileIteratorPrx
    openNodeStdErr(String name, int count)
        throws FileNotAvailableException,
               NodeNotExistException,
               NodeUnreachableException
    {
        return openNodeStdErr(name, count, null, false);
    }

    /**
     * Open the given node stderr file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param name The node name.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return An iterator to read the file.
     * 
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     * 
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * 
     **/
    public FileIteratorPrx
    openNodeStdErr(String name, int count, java.util.Map<String, String> __ctx)
        throws FileNotAvailableException,
               NodeNotExistException,
               NodeUnreachableException
    {
        return openNodeStdErr(name, count, __ctx, true);
    }

    private FileIteratorPrx
    openNodeStdErr(String name, int count, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws FileNotAvailableException,
               NodeNotExistException,
               NodeUnreachableException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("openNodeStdErr");
                __delBase = __getDelegate(false);
                _AdminSessionDel __del = (_AdminSessionDel)__delBase;
                return __del.openNodeStdErr(name, count, __ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __openNodeStdErr_name = "openNodeStdErr";

    /**
     * Open the given node stderr file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param __cb The callback object for the operation.
     * @param name The node name.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     **/
    public Ice.AsyncResult begin_openNodeStdErr(String name, int count)
    {
        return begin_openNodeStdErr(name, count, null, false, null);
    }

    /**
     * Open the given node stderr file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param __cb The callback object for the operation.
     * @param name The node name.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_openNodeStdErr(String name, int count, java.util.Map<String, String> __ctx)
    {
        return begin_openNodeStdErr(name, count, __ctx, true, null);
    }

    /**
     * Open the given node stderr file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param __cb The callback object for the operation.
     * @param name The node name.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     **/
    public Ice.AsyncResult begin_openNodeStdErr(String name, int count, Ice.Callback __cb)
    {
        return begin_openNodeStdErr(name, count, null, false, __cb);
    }

    /**
     * Open the given node stderr file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param __cb The callback object for the operation.
     * @param name The node name.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_openNodeStdErr(String name, int count, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_openNodeStdErr(name, count, __ctx, true, __cb);
    }

    /**
     * Open the given node stderr file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param __cb The callback object for the operation.
     * @param name The node name.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     **/
    public Ice.AsyncResult begin_openNodeStdErr(String name, int count, Callback_AdminSession_openNodeStdErr __cb)
    {
        return begin_openNodeStdErr(name, count, null, false, __cb);
    }

    /**
     * Open the given node stderr file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param __cb The callback object for the operation.
     * @param name The node name.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_openNodeStdErr(String name, int count, java.util.Map<String, String> __ctx, Callback_AdminSession_openNodeStdErr __cb)
    {
        return begin_openNodeStdErr(name, count, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_openNodeStdErr(String name, int count, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__openNodeStdErr_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __openNodeStdErr_name, __cb);
        try
        {
            __result.__prepare(__openNodeStdErr_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.writeString(name);
            __os.writeInt(count);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) An iterator to read the file.
     * 
     **/
    public FileIteratorPrx end_openNodeStdErr(Ice.AsyncResult __result)
        throws FileNotAvailableException,
               NodeNotExistException,
               NodeUnreachableException
    {
        Ice.AsyncResult.__check(__result, this, __openNodeStdErr_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(FileNotAvailableException __ex)
            {
                throw __ex;
            }
            catch(NodeNotExistException __ex)
            {
                throw __ex;
            }
            catch(NodeUnreachableException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        FileIteratorPrx __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = FileIteratorPrxHelper.__read(__is);
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Open the given node stdout file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param name The node name.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     * @return An iterator to read the file.
     * 
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     * 
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * 
     **/
    public FileIteratorPrx
    openNodeStdOut(String name, int count)
        throws FileNotAvailableException,
               NodeNotExistException,
               NodeUnreachableException
    {
        return openNodeStdOut(name, count, null, false);
    }

    /**
     * Open the given node stdout file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param name The node name.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return An iterator to read the file.
     * 
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     * 
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * 
     **/
    public FileIteratorPrx
    openNodeStdOut(String name, int count, java.util.Map<String, String> __ctx)
        throws FileNotAvailableException,
               NodeNotExistException,
               NodeUnreachableException
    {
        return openNodeStdOut(name, count, __ctx, true);
    }

    private FileIteratorPrx
    openNodeStdOut(String name, int count, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws FileNotAvailableException,
               NodeNotExistException,
               NodeUnreachableException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("openNodeStdOut");
                __delBase = __getDelegate(false);
                _AdminSessionDel __del = (_AdminSessionDel)__delBase;
                return __del.openNodeStdOut(name, count, __ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __openNodeStdOut_name = "openNodeStdOut";

    /**
     * Open the given node stdout file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param __cb The callback object for the operation.
     * @param name The node name.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     **/
    public Ice.AsyncResult begin_openNodeStdOut(String name, int count)
    {
        return begin_openNodeStdOut(name, count, null, false, null);
    }

    /**
     * Open the given node stdout file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param __cb The callback object for the operation.
     * @param name The node name.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_openNodeStdOut(String name, int count, java.util.Map<String, String> __ctx)
    {
        return begin_openNodeStdOut(name, count, __ctx, true, null);
    }

    /**
     * Open the given node stdout file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param __cb The callback object for the operation.
     * @param name The node name.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     **/
    public Ice.AsyncResult begin_openNodeStdOut(String name, int count, Ice.Callback __cb)
    {
        return begin_openNodeStdOut(name, count, null, false, __cb);
    }

    /**
     * Open the given node stdout file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param __cb The callback object for the operation.
     * @param name The node name.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_openNodeStdOut(String name, int count, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_openNodeStdOut(name, count, __ctx, true, __cb);
    }

    /**
     * Open the given node stdout file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param __cb The callback object for the operation.
     * @param name The node name.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     **/
    public Ice.AsyncResult begin_openNodeStdOut(String name, int count, Callback_AdminSession_openNodeStdOut __cb)
    {
        return begin_openNodeStdOut(name, count, null, false, __cb);
    }

    /**
     * Open the given node stdout file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param __cb The callback object for the operation.
     * @param name The node name.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_openNodeStdOut(String name, int count, java.util.Map<String, String> __ctx, Callback_AdminSession_openNodeStdOut __cb)
    {
        return begin_openNodeStdOut(name, count, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_openNodeStdOut(String name, int count, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__openNodeStdOut_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __openNodeStdOut_name, __cb);
        try
        {
            __result.__prepare(__openNodeStdOut_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.writeString(name);
            __os.writeInt(count);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) An iterator to read the file.
     * 
     **/
    public FileIteratorPrx end_openNodeStdOut(Ice.AsyncResult __result)
        throws FileNotAvailableException,
               NodeNotExistException,
               NodeUnreachableException
    {
        Ice.AsyncResult.__check(__result, this, __openNodeStdOut_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(FileNotAvailableException __ex)
            {
                throw __ex;
            }
            catch(NodeNotExistException __ex)
            {
                throw __ex;
            }
            catch(NodeUnreachableException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        FileIteratorPrx __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = FileIteratorPrxHelper.__read(__is);
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Open the given registry stderr file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param name The registry name.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     * @return An iterator to read the file.
     * 
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     * 
     * @throws RegistryNotExistException Raised if the registry
     * doesn't exist.
     * 
     * @throws RegistryUnreachableException Raised if the registry
     * could not be reached.
     * 
     **/
    public FileIteratorPrx
    openRegistryStdErr(String name, int count)
        throws FileNotAvailableException,
               RegistryNotExistException,
               RegistryUnreachableException
    {
        return openRegistryStdErr(name, count, null, false);
    }

    /**
     * Open the given registry stderr file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param name The registry name.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return An iterator to read the file.
     * 
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     * 
     * @throws RegistryNotExistException Raised if the registry
     * doesn't exist.
     * 
     * @throws RegistryUnreachableException Raised if the registry
     * could not be reached.
     * 
     **/
    public FileIteratorPrx
    openRegistryStdErr(String name, int count, java.util.Map<String, String> __ctx)
        throws FileNotAvailableException,
               RegistryNotExistException,
               RegistryUnreachableException
    {
        return openRegistryStdErr(name, count, __ctx, true);
    }

    private FileIteratorPrx
    openRegistryStdErr(String name, int count, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws FileNotAvailableException,
               RegistryNotExistException,
               RegistryUnreachableException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("openRegistryStdErr");
                __delBase = __getDelegate(false);
                _AdminSessionDel __del = (_AdminSessionDel)__delBase;
                return __del.openRegistryStdErr(name, count, __ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __openRegistryStdErr_name = "openRegistryStdErr";

    /**
     * Open the given registry stderr file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param __cb The callback object for the operation.
     * @param name The registry name.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     **/
    public Ice.AsyncResult begin_openRegistryStdErr(String name, int count)
    {
        return begin_openRegistryStdErr(name, count, null, false, null);
    }

    /**
     * Open the given registry stderr file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param __cb The callback object for the operation.
     * @param name The registry name.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_openRegistryStdErr(String name, int count, java.util.Map<String, String> __ctx)
    {
        return begin_openRegistryStdErr(name, count, __ctx, true, null);
    }

    /**
     * Open the given registry stderr file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param __cb The callback object for the operation.
     * @param name The registry name.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     **/
    public Ice.AsyncResult begin_openRegistryStdErr(String name, int count, Ice.Callback __cb)
    {
        return begin_openRegistryStdErr(name, count, null, false, __cb);
    }

    /**
     * Open the given registry stderr file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param __cb The callback object for the operation.
     * @param name The registry name.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_openRegistryStdErr(String name, int count, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_openRegistryStdErr(name, count, __ctx, true, __cb);
    }

    /**
     * Open the given registry stderr file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param __cb The callback object for the operation.
     * @param name The registry name.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     **/
    public Ice.AsyncResult begin_openRegistryStdErr(String name, int count, Callback_AdminSession_openRegistryStdErr __cb)
    {
        return begin_openRegistryStdErr(name, count, null, false, __cb);
    }

    /**
     * Open the given registry stderr file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param __cb The callback object for the operation.
     * @param name The registry name.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_openRegistryStdErr(String name, int count, java.util.Map<String, String> __ctx, Callback_AdminSession_openRegistryStdErr __cb)
    {
        return begin_openRegistryStdErr(name, count, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_openRegistryStdErr(String name, int count, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__openRegistryStdErr_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __openRegistryStdErr_name, __cb);
        try
        {
            __result.__prepare(__openRegistryStdErr_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.writeString(name);
            __os.writeInt(count);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) An iterator to read the file.
     * 
     **/
    public FileIteratorPrx end_openRegistryStdErr(Ice.AsyncResult __result)
        throws FileNotAvailableException,
               RegistryNotExistException,
               RegistryUnreachableException
    {
        Ice.AsyncResult.__check(__result, this, __openRegistryStdErr_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(FileNotAvailableException __ex)
            {
                throw __ex;
            }
            catch(RegistryNotExistException __ex)
            {
                throw __ex;
            }
            catch(RegistryUnreachableException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        FileIteratorPrx __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = FileIteratorPrxHelper.__read(__is);
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Open the given registry stdout file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param name The registry name.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     * @return An iterator to read the file.
     * 
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     * 
     * @throws RegistryNotExistException Raised if the registry
     * doesn't exist.
     * 
     * @throws RegistryUnreachableException Raised if the registry
     * could not be reached.
     * 
     **/
    public FileIteratorPrx
    openRegistryStdOut(String name, int count)
        throws FileNotAvailableException,
               RegistryNotExistException,
               RegistryUnreachableException
    {
        return openRegistryStdOut(name, count, null, false);
    }

    /**
     * Open the given registry stdout file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param name The registry name.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return An iterator to read the file.
     * 
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     * 
     * @throws RegistryNotExistException Raised if the registry
     * doesn't exist.
     * 
     * @throws RegistryUnreachableException Raised if the registry
     * could not be reached.
     * 
     **/
    public FileIteratorPrx
    openRegistryStdOut(String name, int count, java.util.Map<String, String> __ctx)
        throws FileNotAvailableException,
               RegistryNotExistException,
               RegistryUnreachableException
    {
        return openRegistryStdOut(name, count, __ctx, true);
    }

    private FileIteratorPrx
    openRegistryStdOut(String name, int count, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws FileNotAvailableException,
               RegistryNotExistException,
               RegistryUnreachableException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("openRegistryStdOut");
                __delBase = __getDelegate(false);
                _AdminSessionDel __del = (_AdminSessionDel)__delBase;
                return __del.openRegistryStdOut(name, count, __ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __openRegistryStdOut_name = "openRegistryStdOut";

    /**
     * Open the given registry stdout file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param __cb The callback object for the operation.
     * @param name The registry name.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     **/
    public Ice.AsyncResult begin_openRegistryStdOut(String name, int count)
    {
        return begin_openRegistryStdOut(name, count, null, false, null);
    }

    /**
     * Open the given registry stdout file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param __cb The callback object for the operation.
     * @param name The registry name.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_openRegistryStdOut(String name, int count, java.util.Map<String, String> __ctx)
    {
        return begin_openRegistryStdOut(name, count, __ctx, true, null);
    }

    /**
     * Open the given registry stdout file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param __cb The callback object for the operation.
     * @param name The registry name.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     **/
    public Ice.AsyncResult begin_openRegistryStdOut(String name, int count, Ice.Callback __cb)
    {
        return begin_openRegistryStdOut(name, count, null, false, __cb);
    }

    /**
     * Open the given registry stdout file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param __cb The callback object for the operation.
     * @param name The registry name.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_openRegistryStdOut(String name, int count, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_openRegistryStdOut(name, count, __ctx, true, __cb);
    }

    /**
     * Open the given registry stdout file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param __cb The callback object for the operation.
     * @param name The registry name.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     **/
    public Ice.AsyncResult begin_openRegistryStdOut(String name, int count, Callback_AdminSession_openRegistryStdOut __cb)
    {
        return begin_openRegistryStdOut(name, count, null, false, __cb);
    }

    /**
     * Open the given registry stdout file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param __cb The callback object for the operation.
     * @param name The registry name.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_openRegistryStdOut(String name, int count, java.util.Map<String, String> __ctx, Callback_AdminSession_openRegistryStdOut __cb)
    {
        return begin_openRegistryStdOut(name, count, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_openRegistryStdOut(String name, int count, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__openRegistryStdOut_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __openRegistryStdOut_name, __cb);
        try
        {
            __result.__prepare(__openRegistryStdOut_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.writeString(name);
            __os.writeInt(count);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) An iterator to read the file.
     * 
     **/
    public FileIteratorPrx end_openRegistryStdOut(Ice.AsyncResult __result)
        throws FileNotAvailableException,
               RegistryNotExistException,
               RegistryUnreachableException
    {
        Ice.AsyncResult.__check(__result, this, __openRegistryStdOut_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(FileNotAvailableException __ex)
            {
                throw __ex;
            }
            catch(RegistryNotExistException __ex)
            {
                throw __ex;
            }
            catch(RegistryUnreachableException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        FileIteratorPrx __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = FileIteratorPrxHelper.__read(__is);
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Open the given server log file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param id The server id.
     * 
     * @param path The path of the log file. A log file can be opened
     * only if it's declared in the server or service deployment
     * descriptor.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     * @return An iterator to read the file.
     * 
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     * 
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     **/
    public FileIteratorPrx
    openServerLog(String id, String path, int count)
        throws DeploymentException,
               FileNotAvailableException,
               NodeUnreachableException,
               ServerNotExistException
    {
        return openServerLog(id, path, count, null, false);
    }

    /**
     * Open the given server log file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param id The server id.
     * 
     * @param path The path of the log file. A log file can be opened
     * only if it's declared in the server or service deployment
     * descriptor.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return An iterator to read the file.
     * 
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     * 
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     **/
    public FileIteratorPrx
    openServerLog(String id, String path, int count, java.util.Map<String, String> __ctx)
        throws DeploymentException,
               FileNotAvailableException,
               NodeUnreachableException,
               ServerNotExistException
    {
        return openServerLog(id, path, count, __ctx, true);
    }

    private FileIteratorPrx
    openServerLog(String id, String path, int count, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws DeploymentException,
               FileNotAvailableException,
               NodeUnreachableException,
               ServerNotExistException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("openServerLog");
                __delBase = __getDelegate(false);
                _AdminSessionDel __del = (_AdminSessionDel)__delBase;
                return __del.openServerLog(id, path, count, __ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __openServerLog_name = "openServerLog";

    /**
     * Open the given server log file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param path The path of the log file. A log file can be opened
     * only if it's declared in the server or service deployment
     * descriptor.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     **/
    public Ice.AsyncResult begin_openServerLog(String id, String path, int count)
    {
        return begin_openServerLog(id, path, count, null, false, null);
    }

    /**
     * Open the given server log file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param path The path of the log file. A log file can be opened
     * only if it's declared in the server or service deployment
     * descriptor.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_openServerLog(String id, String path, int count, java.util.Map<String, String> __ctx)
    {
        return begin_openServerLog(id, path, count, __ctx, true, null);
    }

    /**
     * Open the given server log file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param path The path of the log file. A log file can be opened
     * only if it's declared in the server or service deployment
     * descriptor.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     **/
    public Ice.AsyncResult begin_openServerLog(String id, String path, int count, Ice.Callback __cb)
    {
        return begin_openServerLog(id, path, count, null, false, __cb);
    }

    /**
     * Open the given server log file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param path The path of the log file. A log file can be opened
     * only if it's declared in the server or service deployment
     * descriptor.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_openServerLog(String id, String path, int count, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_openServerLog(id, path, count, __ctx, true, __cb);
    }

    /**
     * Open the given server log file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param path The path of the log file. A log file can be opened
     * only if it's declared in the server or service deployment
     * descriptor.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     **/
    public Ice.AsyncResult begin_openServerLog(String id, String path, int count, Callback_AdminSession_openServerLog __cb)
    {
        return begin_openServerLog(id, path, count, null, false, __cb);
    }

    /**
     * Open the given server log file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param path The path of the log file. A log file can be opened
     * only if it's declared in the server or service deployment
     * descriptor.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_openServerLog(String id, String path, int count, java.util.Map<String, String> __ctx, Callback_AdminSession_openServerLog __cb)
    {
        return begin_openServerLog(id, path, count, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_openServerLog(String id, String path, int count, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__openServerLog_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __openServerLog_name, __cb);
        try
        {
            __result.__prepare(__openServerLog_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.writeString(id);
            __os.writeString(path);
            __os.writeInt(count);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) An iterator to read the file.
     * 
     **/
    public FileIteratorPrx end_openServerLog(Ice.AsyncResult __result)
        throws DeploymentException,
               FileNotAvailableException,
               NodeUnreachableException,
               ServerNotExistException
    {
        Ice.AsyncResult.__check(__result, this, __openServerLog_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(DeploymentException __ex)
            {
                throw __ex;
            }
            catch(FileNotAvailableException __ex)
            {
                throw __ex;
            }
            catch(NodeUnreachableException __ex)
            {
                throw __ex;
            }
            catch(ServerNotExistException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        FileIteratorPrx __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = FileIteratorPrxHelper.__read(__is);
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Open the given server stderr file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param id The server id.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     * @return An iterator to read the file.
     * 
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     * 
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     **/
    public FileIteratorPrx
    openServerStdErr(String id, int count)
        throws DeploymentException,
               FileNotAvailableException,
               NodeUnreachableException,
               ServerNotExistException
    {
        return openServerStdErr(id, count, null, false);
    }

    /**
     * Open the given server stderr file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param id The server id.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return An iterator to read the file.
     * 
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     * 
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     **/
    public FileIteratorPrx
    openServerStdErr(String id, int count, java.util.Map<String, String> __ctx)
        throws DeploymentException,
               FileNotAvailableException,
               NodeUnreachableException,
               ServerNotExistException
    {
        return openServerStdErr(id, count, __ctx, true);
    }

    private FileIteratorPrx
    openServerStdErr(String id, int count, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws DeploymentException,
               FileNotAvailableException,
               NodeUnreachableException,
               ServerNotExistException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("openServerStdErr");
                __delBase = __getDelegate(false);
                _AdminSessionDel __del = (_AdminSessionDel)__delBase;
                return __del.openServerStdErr(id, count, __ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __openServerStdErr_name = "openServerStdErr";

    /**
     * Open the given server stderr file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     **/
    public Ice.AsyncResult begin_openServerStdErr(String id, int count)
    {
        return begin_openServerStdErr(id, count, null, false, null);
    }

    /**
     * Open the given server stderr file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_openServerStdErr(String id, int count, java.util.Map<String, String> __ctx)
    {
        return begin_openServerStdErr(id, count, __ctx, true, null);
    }

    /**
     * Open the given server stderr file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     **/
    public Ice.AsyncResult begin_openServerStdErr(String id, int count, Ice.Callback __cb)
    {
        return begin_openServerStdErr(id, count, null, false, __cb);
    }

    /**
     * Open the given server stderr file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_openServerStdErr(String id, int count, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_openServerStdErr(id, count, __ctx, true, __cb);
    }

    /**
     * Open the given server stderr file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     **/
    public Ice.AsyncResult begin_openServerStdErr(String id, int count, Callback_AdminSession_openServerStdErr __cb)
    {
        return begin_openServerStdErr(id, count, null, false, __cb);
    }

    /**
     * Open the given server stderr file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_openServerStdErr(String id, int count, java.util.Map<String, String> __ctx, Callback_AdminSession_openServerStdErr __cb)
    {
        return begin_openServerStdErr(id, count, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_openServerStdErr(String id, int count, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__openServerStdErr_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __openServerStdErr_name, __cb);
        try
        {
            __result.__prepare(__openServerStdErr_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.writeString(id);
            __os.writeInt(count);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) An iterator to read the file.
     * 
     **/
    public FileIteratorPrx end_openServerStdErr(Ice.AsyncResult __result)
        throws DeploymentException,
               FileNotAvailableException,
               NodeUnreachableException,
               ServerNotExistException
    {
        Ice.AsyncResult.__check(__result, this, __openServerStdErr_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(DeploymentException __ex)
            {
                throw __ex;
            }
            catch(FileNotAvailableException __ex)
            {
                throw __ex;
            }
            catch(NodeUnreachableException __ex)
            {
                throw __ex;
            }
            catch(ServerNotExistException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        FileIteratorPrx __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = FileIteratorPrxHelper.__read(__is);
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Open the given server stdout file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param id The server id.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     * @return An iterator to read the file.
     * 
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     * 
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     **/
    public FileIteratorPrx
    openServerStdOut(String id, int count)
        throws DeploymentException,
               FileNotAvailableException,
               NodeUnreachableException,
               ServerNotExistException
    {
        return openServerStdOut(id, count, null, false);
    }

    /**
     * Open the given server stdout file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param id The server id.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return An iterator to read the file.
     * 
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     * 
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     * 
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * 
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * 
     **/
    public FileIteratorPrx
    openServerStdOut(String id, int count, java.util.Map<String, String> __ctx)
        throws DeploymentException,
               FileNotAvailableException,
               NodeUnreachableException,
               ServerNotExistException
    {
        return openServerStdOut(id, count, __ctx, true);
    }

    private FileIteratorPrx
    openServerStdOut(String id, int count, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws DeploymentException,
               FileNotAvailableException,
               NodeUnreachableException,
               ServerNotExistException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("openServerStdOut");
                __delBase = __getDelegate(false);
                _AdminSessionDel __del = (_AdminSessionDel)__delBase;
                return __del.openServerStdOut(id, count, __ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __openServerStdOut_name = "openServerStdOut";

    /**
     * Open the given server stdout file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     **/
    public Ice.AsyncResult begin_openServerStdOut(String id, int count)
    {
        return begin_openServerStdOut(id, count, null, false, null);
    }

    /**
     * Open the given server stdout file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_openServerStdOut(String id, int count, java.util.Map<String, String> __ctx)
    {
        return begin_openServerStdOut(id, count, __ctx, true, null);
    }

    /**
     * Open the given server stdout file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     **/
    public Ice.AsyncResult begin_openServerStdOut(String id, int count, Ice.Callback __cb)
    {
        return begin_openServerStdOut(id, count, null, false, __cb);
    }

    /**
     * Open the given server stdout file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_openServerStdOut(String id, int count, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_openServerStdOut(id, count, __ctx, true, __cb);
    }

    /**
     * Open the given server stdout file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     **/
    public Ice.AsyncResult begin_openServerStdOut(String id, int count, Callback_AdminSession_openServerStdOut __cb)
    {
        return begin_openServerStdOut(id, count, null, false, __cb);
    }

    /**
     * Open the given server stdout file for reading. The file can be
     * read with the returned file iterator.
     * 
     * @param __cb The callback object for the operation.
     * @param id The server id.
     * 
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <tt>count</tt> lines.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_openServerStdOut(String id, int count, java.util.Map<String, String> __ctx, Callback_AdminSession_openServerStdOut __cb)
    {
        return begin_openServerStdOut(id, count, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_openServerStdOut(String id, int count, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__openServerStdOut_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __openServerStdOut_name, __cb);
        try
        {
            __result.__prepare(__openServerStdOut_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.writeString(id);
            __os.writeInt(count);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) An iterator to read the file.
     * 
     **/
    public FileIteratorPrx end_openServerStdOut(Ice.AsyncResult __result)
        throws DeploymentException,
               FileNotAvailableException,
               NodeUnreachableException,
               ServerNotExistException
    {
        Ice.AsyncResult.__check(__result, this, __openServerStdOut_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(DeploymentException __ex)
            {
                throw __ex;
            }
            catch(FileNotAvailableException __ex)
            {
                throw __ex;
            }
            catch(NodeUnreachableException __ex)
            {
                throw __ex;
            }
            catch(ServerNotExistException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        FileIteratorPrx __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = FileIteratorPrxHelper.__read(__is);
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Set the observer proxies that receive
     * notifications when the state of the registry
     * or nodes changes.
     * 
     * @param registryObs The registry observer.
     * 
     * @param nodeObs The node observer.
     * 
     * @param appObs The application observer.
     * 
     * @param adptObs The adapter observer.
     * 
     * @param objObs The object observer.
     * 
     * @throws ObserverAlreadyRegisteredException Raised if an
     * observer is already registered with this registry.
     * 
     **/
    public void
    setObservers(RegistryObserverPrx registryObs, NodeObserverPrx nodeObs, ApplicationObserverPrx appObs, AdapterObserverPrx adptObs, ObjectObserverPrx objObs)
        throws ObserverAlreadyRegisteredException
    {
        setObservers(registryObs, nodeObs, appObs, adptObs, objObs, null, false);
    }

    /**
     * Set the observer proxies that receive
     * notifications when the state of the registry
     * or nodes changes.
     * 
     * @param registryObs The registry observer.
     * 
     * @param nodeObs The node observer.
     * 
     * @param appObs The application observer.
     * 
     * @param adptObs The adapter observer.
     * 
     * @param objObs The object observer.
     * 
     * @throws ObserverAlreadyRegisteredException Raised if an
     * observer is already registered with this registry.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void
    setObservers(RegistryObserverPrx registryObs, NodeObserverPrx nodeObs, ApplicationObserverPrx appObs, AdapterObserverPrx adptObs, ObjectObserverPrx objObs, java.util.Map<String, String> __ctx)
        throws ObserverAlreadyRegisteredException
    {
        setObservers(registryObs, nodeObs, appObs, adptObs, objObs, __ctx, true);
    }

    private void
    setObservers(RegistryObserverPrx registryObs, NodeObserverPrx nodeObs, ApplicationObserverPrx appObs, AdapterObserverPrx adptObs, ObjectObserverPrx objObs, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws ObserverAlreadyRegisteredException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("setObservers");
                __delBase = __getDelegate(false);
                _AdminSessionDel __del = (_AdminSessionDel)__delBase;
                __del.setObservers(registryObs, nodeObs, appObs, adptObs, objObs, __ctx);
                return;
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __setObservers_name = "setObservers";

    /**
     * Set the observer proxies that receive
     * notifications when the state of the registry
     * or nodes changes.
     * 
     * @param __cb The callback object for the operation.
     * @param registryObs The registry observer.
     * 
     * @param nodeObs The node observer.
     * 
     * @param appObs The application observer.
     * 
     * @param adptObs The adapter observer.
     * 
     * @param objObs The object observer.
     * 
     **/
    public Ice.AsyncResult begin_setObservers(RegistryObserverPrx registryObs, NodeObserverPrx nodeObs, ApplicationObserverPrx appObs, AdapterObserverPrx adptObs, ObjectObserverPrx objObs)
    {
        return begin_setObservers(registryObs, nodeObs, appObs, adptObs, objObs, null, false, null);
    }

    /**
     * Set the observer proxies that receive
     * notifications when the state of the registry
     * or nodes changes.
     * 
     * @param __cb The callback object for the operation.
     * @param registryObs The registry observer.
     * 
     * @param nodeObs The node observer.
     * 
     * @param appObs The application observer.
     * 
     * @param adptObs The adapter observer.
     * 
     * @param objObs The object observer.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_setObservers(RegistryObserverPrx registryObs, NodeObserverPrx nodeObs, ApplicationObserverPrx appObs, AdapterObserverPrx adptObs, ObjectObserverPrx objObs, java.util.Map<String, String> __ctx)
    {
        return begin_setObservers(registryObs, nodeObs, appObs, adptObs, objObs, __ctx, true, null);
    }

    /**
     * Set the observer proxies that receive
     * notifications when the state of the registry
     * or nodes changes.
     * 
     * @param __cb The callback object for the operation.
     * @param registryObs The registry observer.
     * 
     * @param nodeObs The node observer.
     * 
     * @param appObs The application observer.
     * 
     * @param adptObs The adapter observer.
     * 
     * @param objObs The object observer.
     * 
     **/
    public Ice.AsyncResult begin_setObservers(RegistryObserverPrx registryObs, NodeObserverPrx nodeObs, ApplicationObserverPrx appObs, AdapterObserverPrx adptObs, ObjectObserverPrx objObs, Ice.Callback __cb)
    {
        return begin_setObservers(registryObs, nodeObs, appObs, adptObs, objObs, null, false, __cb);
    }

    /**
     * Set the observer proxies that receive
     * notifications when the state of the registry
     * or nodes changes.
     * 
     * @param __cb The callback object for the operation.
     * @param registryObs The registry observer.
     * 
     * @param nodeObs The node observer.
     * 
     * @param appObs The application observer.
     * 
     * @param adptObs The adapter observer.
     * 
     * @param objObs The object observer.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_setObservers(RegistryObserverPrx registryObs, NodeObserverPrx nodeObs, ApplicationObserverPrx appObs, AdapterObserverPrx adptObs, ObjectObserverPrx objObs, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_setObservers(registryObs, nodeObs, appObs, adptObs, objObs, __ctx, true, __cb);
    }

    /**
     * Set the observer proxies that receive
     * notifications when the state of the registry
     * or nodes changes.
     * 
     * @param __cb The callback object for the operation.
     * @param registryObs The registry observer.
     * 
     * @param nodeObs The node observer.
     * 
     * @param appObs The application observer.
     * 
     * @param adptObs The adapter observer.
     * 
     * @param objObs The object observer.
     * 
     **/
    public Ice.AsyncResult begin_setObservers(RegistryObserverPrx registryObs, NodeObserverPrx nodeObs, ApplicationObserverPrx appObs, AdapterObserverPrx adptObs, ObjectObserverPrx objObs, Callback_AdminSession_setObservers __cb)
    {
        return begin_setObservers(registryObs, nodeObs, appObs, adptObs, objObs, null, false, __cb);
    }

    /**
     * Set the observer proxies that receive
     * notifications when the state of the registry
     * or nodes changes.
     * 
     * @param __cb The callback object for the operation.
     * @param registryObs The registry observer.
     * 
     * @param nodeObs The node observer.
     * 
     * @param appObs The application observer.
     * 
     * @param adptObs The adapter observer.
     * 
     * @param objObs The object observer.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_setObservers(RegistryObserverPrx registryObs, NodeObserverPrx nodeObs, ApplicationObserverPrx appObs, AdapterObserverPrx adptObs, ObjectObserverPrx objObs, java.util.Map<String, String> __ctx, Callback_AdminSession_setObservers __cb)
    {
        return begin_setObservers(registryObs, nodeObs, appObs, adptObs, objObs, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_setObservers(RegistryObserverPrx registryObs, NodeObserverPrx nodeObs, ApplicationObserverPrx appObs, AdapterObserverPrx adptObs, ObjectObserverPrx objObs, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__setObservers_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __setObservers_name, __cb);
        try
        {
            __result.__prepare(__setObservers_name, Ice.OperationMode.Idempotent, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            RegistryObserverPrxHelper.__write(__os, registryObs);
            NodeObserverPrxHelper.__write(__os, nodeObs);
            ApplicationObserverPrxHelper.__write(__os, appObs);
            AdapterObserverPrxHelper.__write(__os, adptObs);
            ObjectObserverPrxHelper.__write(__os, objObs);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     **/
    public void end_setObservers(Ice.AsyncResult __result)
        throws ObserverAlreadyRegisteredException
    {
        Ice.AsyncResult.__check(__result, this, __setObservers_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(ObserverAlreadyRegisteredException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        IceInternal.BasicStream __is = __result.__is();
        __is.skipEmptyEncaps();
    }

    /**
     * Set the observer identities that receive
     * notifications the state of the registry
     * or nodes changes. This operation should be used by clients that
     * are using a bidirectional connection to communicate with the
     * session.
     * 
     * @param registryObs The registry observer identity.
     * 
     * @param nodeObs The node observer identity.
     * 
     * @param appObs The application observer.
     * 
     * @param adptObs The adapter observer.
     * 
     * @param objObs The object observer.
     * 
     * @throws ObserverAlreadyRegisteredException Raised if an
     * observer is already registered with this registry.
     * 
     **/
    public void
    setObserversByIdentity(Ice.Identity registryObs, Ice.Identity nodeObs, Ice.Identity appObs, Ice.Identity adptObs, Ice.Identity objObs)
        throws ObserverAlreadyRegisteredException
    {
        setObserversByIdentity(registryObs, nodeObs, appObs, adptObs, objObs, null, false);
    }

    /**
     * Set the observer identities that receive
     * notifications the state of the registry
     * or nodes changes. This operation should be used by clients that
     * are using a bidirectional connection to communicate with the
     * session.
     * 
     * @param registryObs The registry observer identity.
     * 
     * @param nodeObs The node observer identity.
     * 
     * @param appObs The application observer.
     * 
     * @param adptObs The adapter observer.
     * 
     * @param objObs The object observer.
     * 
     * @throws ObserverAlreadyRegisteredException Raised if an
     * observer is already registered with this registry.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void
    setObserversByIdentity(Ice.Identity registryObs, Ice.Identity nodeObs, Ice.Identity appObs, Ice.Identity adptObs, Ice.Identity objObs, java.util.Map<String, String> __ctx)
        throws ObserverAlreadyRegisteredException
    {
        setObserversByIdentity(registryObs, nodeObs, appObs, adptObs, objObs, __ctx, true);
    }

    private void
    setObserversByIdentity(Ice.Identity registryObs, Ice.Identity nodeObs, Ice.Identity appObs, Ice.Identity adptObs, Ice.Identity objObs, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws ObserverAlreadyRegisteredException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("setObserversByIdentity");
                __delBase = __getDelegate(false);
                _AdminSessionDel __del = (_AdminSessionDel)__delBase;
                __del.setObserversByIdentity(registryObs, nodeObs, appObs, adptObs, objObs, __ctx);
                return;
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __setObserversByIdentity_name = "setObserversByIdentity";

    /**
     * Set the observer identities that receive
     * notifications the state of the registry
     * or nodes changes. This operation should be used by clients that
     * are using a bidirectional connection to communicate with the
     * session.
     * 
     * @param __cb The callback object for the operation.
     * @param registryObs The registry observer identity.
     * 
     * @param nodeObs The node observer identity.
     * 
     * @param appObs The application observer.
     * 
     * @param adptObs The adapter observer.
     * 
     * @param objObs The object observer.
     * 
     **/
    public Ice.AsyncResult begin_setObserversByIdentity(Ice.Identity registryObs, Ice.Identity nodeObs, Ice.Identity appObs, Ice.Identity adptObs, Ice.Identity objObs)
    {
        return begin_setObserversByIdentity(registryObs, nodeObs, appObs, adptObs, objObs, null, false, null);
    }

    /**
     * Set the observer identities that receive
     * notifications the state of the registry
     * or nodes changes. This operation should be used by clients that
     * are using a bidirectional connection to communicate with the
     * session.
     * 
     * @param __cb The callback object for the operation.
     * @param registryObs The registry observer identity.
     * 
     * @param nodeObs The node observer identity.
     * 
     * @param appObs The application observer.
     * 
     * @param adptObs The adapter observer.
     * 
     * @param objObs The object observer.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_setObserversByIdentity(Ice.Identity registryObs, Ice.Identity nodeObs, Ice.Identity appObs, Ice.Identity adptObs, Ice.Identity objObs, java.util.Map<String, String> __ctx)
    {
        return begin_setObserversByIdentity(registryObs, nodeObs, appObs, adptObs, objObs, __ctx, true, null);
    }

    /**
     * Set the observer identities that receive
     * notifications the state of the registry
     * or nodes changes. This operation should be used by clients that
     * are using a bidirectional connection to communicate with the
     * session.
     * 
     * @param __cb The callback object for the operation.
     * @param registryObs The registry observer identity.
     * 
     * @param nodeObs The node observer identity.
     * 
     * @param appObs The application observer.
     * 
     * @param adptObs The adapter observer.
     * 
     * @param objObs The object observer.
     * 
     **/
    public Ice.AsyncResult begin_setObserversByIdentity(Ice.Identity registryObs, Ice.Identity nodeObs, Ice.Identity appObs, Ice.Identity adptObs, Ice.Identity objObs, Ice.Callback __cb)
    {
        return begin_setObserversByIdentity(registryObs, nodeObs, appObs, adptObs, objObs, null, false, __cb);
    }

    /**
     * Set the observer identities that receive
     * notifications the state of the registry
     * or nodes changes. This operation should be used by clients that
     * are using a bidirectional connection to communicate with the
     * session.
     * 
     * @param __cb The callback object for the operation.
     * @param registryObs The registry observer identity.
     * 
     * @param nodeObs The node observer identity.
     * 
     * @param appObs The application observer.
     * 
     * @param adptObs The adapter observer.
     * 
     * @param objObs The object observer.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_setObserversByIdentity(Ice.Identity registryObs, Ice.Identity nodeObs, Ice.Identity appObs, Ice.Identity adptObs, Ice.Identity objObs, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_setObserversByIdentity(registryObs, nodeObs, appObs, adptObs, objObs, __ctx, true, __cb);
    }

    /**
     * Set the observer identities that receive
     * notifications the state of the registry
     * or nodes changes. This operation should be used by clients that
     * are using a bidirectional connection to communicate with the
     * session.
     * 
     * @param __cb The callback object for the operation.
     * @param registryObs The registry observer identity.
     * 
     * @param nodeObs The node observer identity.
     * 
     * @param appObs The application observer.
     * 
     * @param adptObs The adapter observer.
     * 
     * @param objObs The object observer.
     * 
     **/
    public Ice.AsyncResult begin_setObserversByIdentity(Ice.Identity registryObs, Ice.Identity nodeObs, Ice.Identity appObs, Ice.Identity adptObs, Ice.Identity objObs, Callback_AdminSession_setObserversByIdentity __cb)
    {
        return begin_setObserversByIdentity(registryObs, nodeObs, appObs, adptObs, objObs, null, false, __cb);
    }

    /**
     * Set the observer identities that receive
     * notifications the state of the registry
     * or nodes changes. This operation should be used by clients that
     * are using a bidirectional connection to communicate with the
     * session.
     * 
     * @param __cb The callback object for the operation.
     * @param registryObs The registry observer identity.
     * 
     * @param nodeObs The node observer identity.
     * 
     * @param appObs The application observer.
     * 
     * @param adptObs The adapter observer.
     * 
     * @param objObs The object observer.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_setObserversByIdentity(Ice.Identity registryObs, Ice.Identity nodeObs, Ice.Identity appObs, Ice.Identity adptObs, Ice.Identity objObs, java.util.Map<String, String> __ctx, Callback_AdminSession_setObserversByIdentity __cb)
    {
        return begin_setObserversByIdentity(registryObs, nodeObs, appObs, adptObs, objObs, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_setObserversByIdentity(Ice.Identity registryObs, Ice.Identity nodeObs, Ice.Identity appObs, Ice.Identity adptObs, Ice.Identity objObs, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__setObserversByIdentity_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __setObserversByIdentity_name, __cb);
        try
        {
            __result.__prepare(__setObserversByIdentity_name, Ice.OperationMode.Idempotent, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            registryObs.__write(__os);
            nodeObs.__write(__os);
            appObs.__write(__os);
            adptObs.__write(__os);
            objObs.__write(__os);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     **/
    public void end_setObserversByIdentity(Ice.AsyncResult __result)
        throws ObserverAlreadyRegisteredException
    {
        Ice.AsyncResult.__check(__result, this, __setObserversByIdentity_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(ObserverAlreadyRegisteredException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        IceInternal.BasicStream __is = __result.__is();
        __is.skipEmptyEncaps();
    }

    /**
     * Acquires an exclusive lock to start updating the registry applications.
     * 
     * @return The current serial.
     * 
     * @throws AccessDeniedException Raised if the exclusive lock can't be
     * acquired. This might happen if the lock is currently acquired by
     * another session.
     * 
     **/
    public int
    startUpdate()
        throws AccessDeniedException
    {
        return startUpdate(null, false);
    }

    /**
     * Acquires an exclusive lock to start updating the registry applications.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The current serial.
     * 
     * @throws AccessDeniedException Raised if the exclusive lock can't be
     * acquired. This might happen if the lock is currently acquired by
     * another session.
     * 
     **/
    public int
    startUpdate(java.util.Map<String, String> __ctx)
        throws AccessDeniedException
    {
        return startUpdate(__ctx, true);
    }

    private int
    startUpdate(java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws AccessDeniedException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("startUpdate");
                __delBase = __getDelegate(false);
                _AdminSessionDel __del = (_AdminSessionDel)__delBase;
                return __del.startUpdate(__ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __startUpdate_name = "startUpdate";

    /**
     * Acquires an exclusive lock to start updating the registry applications.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_startUpdate()
    {
        return begin_startUpdate(null, false, null);
    }

    /**
     * Acquires an exclusive lock to start updating the registry applications.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_startUpdate(java.util.Map<String, String> __ctx)
    {
        return begin_startUpdate(__ctx, true, null);
    }

    /**
     * Acquires an exclusive lock to start updating the registry applications.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_startUpdate(Ice.Callback __cb)
    {
        return begin_startUpdate(null, false, __cb);
    }

    /**
     * Acquires an exclusive lock to start updating the registry applications.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_startUpdate(java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_startUpdate(__ctx, true, __cb);
    }

    /**
     * Acquires an exclusive lock to start updating the registry applications.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_startUpdate(Callback_AdminSession_startUpdate __cb)
    {
        return begin_startUpdate(null, false, __cb);
    }

    /**
     * Acquires an exclusive lock to start updating the registry applications.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_startUpdate(java.util.Map<String, String> __ctx, Callback_AdminSession_startUpdate __cb)
    {
        return begin_startUpdate(__ctx, true, __cb);
    }

    private Ice.AsyncResult begin_startUpdate(java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__startUpdate_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __startUpdate_name, __cb);
        try
        {
            __result.__prepare(__startUpdate_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) The current serial.
     * 
     **/
    public int end_startUpdate(Ice.AsyncResult __result)
        throws AccessDeniedException
    {
        Ice.AsyncResult.__check(__result, this, __startUpdate_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(AccessDeniedException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        int __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = __is.readInt();
        __is.endReadEncaps();
        return __ret;
    }

    public static AdminSessionPrx
    checkedCast(Ice.ObjectPrx __obj)
    {
        AdminSessionPrx __d = null;
        if(__obj != null)
        {
            try
            {
                __d = (AdminSessionPrx)__obj;
            }
            catch(ClassCastException ex)
            {
                if(__obj.ice_isA("::IceGrid::AdminSession"))
                {
                    AdminSessionPrxHelper __h = new AdminSessionPrxHelper();
                    __h.__copyFrom(__obj);
                    __d = __h;
                }
            }
        }
        return __d;
    }

    public static AdminSessionPrx
    checkedCast(Ice.ObjectPrx __obj, java.util.Map<String, String> __ctx)
    {
        AdminSessionPrx __d = null;
        if(__obj != null)
        {
            try
            {
                __d = (AdminSessionPrx)__obj;
            }
            catch(ClassCastException ex)
            {
                if(__obj.ice_isA("::IceGrid::AdminSession", __ctx))
                {
                    AdminSessionPrxHelper __h = new AdminSessionPrxHelper();
                    __h.__copyFrom(__obj);
                    __d = __h;
                }
            }
        }
        return __d;
    }

    public static AdminSessionPrx
    checkedCast(Ice.ObjectPrx __obj, String __facet)
    {
        AdminSessionPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            try
            {
                if(__bb.ice_isA("::IceGrid::AdminSession"))
                {
                    AdminSessionPrxHelper __h = new AdminSessionPrxHelper();
                    __h.__copyFrom(__bb);
                    __d = __h;
                }
            }
            catch(Ice.FacetNotExistException ex)
            {
            }
        }
        return __d;
    }

    public static AdminSessionPrx
    checkedCast(Ice.ObjectPrx __obj, String __facet, java.util.Map<String, String> __ctx)
    {
        AdminSessionPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            try
            {
                if(__bb.ice_isA("::IceGrid::AdminSession", __ctx))
                {
                    AdminSessionPrxHelper __h = new AdminSessionPrxHelper();
                    __h.__copyFrom(__bb);
                    __d = __h;
                }
            }
            catch(Ice.FacetNotExistException ex)
            {
            }
        }
        return __d;
    }

    public static AdminSessionPrx
    uncheckedCast(Ice.ObjectPrx __obj)
    {
        AdminSessionPrx __d = null;
        if(__obj != null)
        {
            try
            {
                __d = (AdminSessionPrx)__obj;
            }
            catch(ClassCastException ex)
            {
                AdminSessionPrxHelper __h = new AdminSessionPrxHelper();
                __h.__copyFrom(__obj);
                __d = __h;
            }
        }
        return __d;
    }

    public static AdminSessionPrx
    uncheckedCast(Ice.ObjectPrx __obj, String __facet)
    {
        AdminSessionPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            AdminSessionPrxHelper __h = new AdminSessionPrxHelper();
            __h.__copyFrom(__bb);
            __d = __h;
        }
        return __d;
    }

    protected Ice._ObjectDelM
    __createDelegateM()
    {
        return new _AdminSessionDelM();
    }

    protected Ice._ObjectDelD
    __createDelegateD()
    {
        return new _AdminSessionDelD();
    }

    public static void
    __write(IceInternal.BasicStream __os, AdminSessionPrx v)
    {
        __os.writeProxy(v);
    }

    public static AdminSessionPrx
    __read(IceInternal.BasicStream __is)
    {
        Ice.ObjectPrx proxy = __is.readProxy();
        if(proxy != null)
        {
            AdminSessionPrxHelper result = new AdminSessionPrxHelper();
            result.__copyFrom(proxy);
            return result;
        }
        return null;
    }
}
