// **********************************************************************
//
// Copyright (c) 2003-2010 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************

// Ice version 3.4.1

package IceGrid;

// <auto-generated>
//
// Generated from file `Observer.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>


/**
 * The database observer interface. Observers should implement this
 * interface to receive information about the state of the IceGrid
 * registry database.
 * 
 **/
public final class ApplicationObserverPrxHelper extends Ice.ObjectPrxHelperBase implements ApplicationObserverPrx
{
    /**
     * The <tt>applicationAdded</tt> operation is called to notify an observer
     * that an application was added.
     * 
     * @param serial The new serial number of the registry database.
     * 
     * @param desc The descriptor of the new application.
     * 
     **/
    public void
    applicationAdded(int serial, ApplicationInfo desc)
    {
        applicationAdded(serial, desc, null, false);
    }

    /**
     * The <tt>applicationAdded</tt> operation is called to notify an observer
     * that an application was added.
     * 
     * @param serial The new serial number of the registry database.
     * 
     * @param desc The descriptor of the new application.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void
    applicationAdded(int serial, ApplicationInfo desc, java.util.Map<String, String> __ctx)
    {
        applicationAdded(serial, desc, __ctx, true);
    }

    private void
    applicationAdded(int serial, ApplicationInfo desc, java.util.Map<String, String> __ctx, boolean __explicitCtx)
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __delBase = __getDelegate(false);
                _ApplicationObserverDel __del = (_ApplicationObserverDel)__delBase;
                __del.applicationAdded(serial, desc, __ctx);
                return;
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __applicationAdded_name = "applicationAdded";

    /**
     * The <tt>applicationAdded</tt> operation is called to notify an observer
     * that an application was added.
     * 
     * @param __cb The callback object for the operation.
     * @param serial The new serial number of the registry database.
     * 
     * @param desc The descriptor of the new application.
     * 
     **/
    public Ice.AsyncResult begin_applicationAdded(int serial, ApplicationInfo desc)
    {
        return begin_applicationAdded(serial, desc, null, false, null);
    }

    /**
     * The <tt>applicationAdded</tt> operation is called to notify an observer
     * that an application was added.
     * 
     * @param __cb The callback object for the operation.
     * @param serial The new serial number of the registry database.
     * 
     * @param desc The descriptor of the new application.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_applicationAdded(int serial, ApplicationInfo desc, java.util.Map<String, String> __ctx)
    {
        return begin_applicationAdded(serial, desc, __ctx, true, null);
    }

    /**
     * The <tt>applicationAdded</tt> operation is called to notify an observer
     * that an application was added.
     * 
     * @param __cb The callback object for the operation.
     * @param serial The new serial number of the registry database.
     * 
     * @param desc The descriptor of the new application.
     * 
     **/
    public Ice.AsyncResult begin_applicationAdded(int serial, ApplicationInfo desc, Ice.Callback __cb)
    {
        return begin_applicationAdded(serial, desc, null, false, __cb);
    }

    /**
     * The <tt>applicationAdded</tt> operation is called to notify an observer
     * that an application was added.
     * 
     * @param __cb The callback object for the operation.
     * @param serial The new serial number of the registry database.
     * 
     * @param desc The descriptor of the new application.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_applicationAdded(int serial, ApplicationInfo desc, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_applicationAdded(serial, desc, __ctx, true, __cb);
    }

    /**
     * The <tt>applicationAdded</tt> operation is called to notify an observer
     * that an application was added.
     * 
     * @param __cb The callback object for the operation.
     * @param serial The new serial number of the registry database.
     * 
     * @param desc The descriptor of the new application.
     * 
     **/
    public Ice.AsyncResult begin_applicationAdded(int serial, ApplicationInfo desc, Callback_ApplicationObserver_applicationAdded __cb)
    {
        return begin_applicationAdded(serial, desc, null, false, __cb);
    }

    /**
     * The <tt>applicationAdded</tt> operation is called to notify an observer
     * that an application was added.
     * 
     * @param __cb The callback object for the operation.
     * @param serial The new serial number of the registry database.
     * 
     * @param desc The descriptor of the new application.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_applicationAdded(int serial, ApplicationInfo desc, java.util.Map<String, String> __ctx, Callback_ApplicationObserver_applicationAdded __cb)
    {
        return begin_applicationAdded(serial, desc, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_applicationAdded(int serial, ApplicationInfo desc, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __applicationAdded_name, __cb);
        try
        {
            __result.__prepare(__applicationAdded_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.writeInt(serial);
            desc.__write(__os);
            __os.writePendingObjects();
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     **/
    public void end_applicationAdded(Ice.AsyncResult __result)
    {
        __end(__result, __applicationAdded_name);
    }

    /**
     * <tt>applicationInit</tt> is called after the registration
     * of an observer to indicate the state of the registry.
     * 
     * @param serial The current serial number of the registry
     * database. This serial number allows observers to make sure that
     * their internal state is synchronized with the registry.
     * 
     * @param applications The applications currently registered with
     * the registry.
     * 
     **/
    public void
    applicationInit(int serial, java.util.List<ApplicationInfo> applications)
    {
        applicationInit(serial, applications, null, false);
    }

    /**
     * <tt>applicationInit</tt> is called after the registration
     * of an observer to indicate the state of the registry.
     * 
     * @param serial The current serial number of the registry
     * database. This serial number allows observers to make sure that
     * their internal state is synchronized with the registry.
     * 
     * @param applications The applications currently registered with
     * the registry.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void
    applicationInit(int serial, java.util.List<ApplicationInfo> applications, java.util.Map<String, String> __ctx)
    {
        applicationInit(serial, applications, __ctx, true);
    }

    private void
    applicationInit(int serial, java.util.List<ApplicationInfo> applications, java.util.Map<String, String> __ctx, boolean __explicitCtx)
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __delBase = __getDelegate(false);
                _ApplicationObserverDel __del = (_ApplicationObserverDel)__delBase;
                __del.applicationInit(serial, applications, __ctx);
                return;
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __applicationInit_name = "applicationInit";

    /**
     * <tt>applicationInit</tt> is called after the registration
     * of an observer to indicate the state of the registry.
     * 
     * @param __cb The callback object for the operation.
     * @param serial The current serial number of the registry
     * database. This serial number allows observers to make sure that
     * their internal state is synchronized with the registry.
     * 
     * @param applications The applications currently registered with
     * the registry.
     * 
     **/
    public Ice.AsyncResult begin_applicationInit(int serial, java.util.List<ApplicationInfo> applications)
    {
        return begin_applicationInit(serial, applications, null, false, null);
    }

    /**
     * <tt>applicationInit</tt> is called after the registration
     * of an observer to indicate the state of the registry.
     * 
     * @param __cb The callback object for the operation.
     * @param serial The current serial number of the registry
     * database. This serial number allows observers to make sure that
     * their internal state is synchronized with the registry.
     * 
     * @param applications The applications currently registered with
     * the registry.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_applicationInit(int serial, java.util.List<ApplicationInfo> applications, java.util.Map<String, String> __ctx)
    {
        return begin_applicationInit(serial, applications, __ctx, true, null);
    }

    /**
     * <tt>applicationInit</tt> is called after the registration
     * of an observer to indicate the state of the registry.
     * 
     * @param __cb The callback object for the operation.
     * @param serial The current serial number of the registry
     * database. This serial number allows observers to make sure that
     * their internal state is synchronized with the registry.
     * 
     * @param applications The applications currently registered with
     * the registry.
     * 
     **/
    public Ice.AsyncResult begin_applicationInit(int serial, java.util.List<ApplicationInfo> applications, Ice.Callback __cb)
    {
        return begin_applicationInit(serial, applications, null, false, __cb);
    }

    /**
     * <tt>applicationInit</tt> is called after the registration
     * of an observer to indicate the state of the registry.
     * 
     * @param __cb The callback object for the operation.
     * @param serial The current serial number of the registry
     * database. This serial number allows observers to make sure that
     * their internal state is synchronized with the registry.
     * 
     * @param applications The applications currently registered with
     * the registry.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_applicationInit(int serial, java.util.List<ApplicationInfo> applications, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_applicationInit(serial, applications, __ctx, true, __cb);
    }

    /**
     * <tt>applicationInit</tt> is called after the registration
     * of an observer to indicate the state of the registry.
     * 
     * @param __cb The callback object for the operation.
     * @param serial The current serial number of the registry
     * database. This serial number allows observers to make sure that
     * their internal state is synchronized with the registry.
     * 
     * @param applications The applications currently registered with
     * the registry.
     * 
     **/
    public Ice.AsyncResult begin_applicationInit(int serial, java.util.List<ApplicationInfo> applications, Callback_ApplicationObserver_applicationInit __cb)
    {
        return begin_applicationInit(serial, applications, null, false, __cb);
    }

    /**
     * <tt>applicationInit</tt> is called after the registration
     * of an observer to indicate the state of the registry.
     * 
     * @param __cb The callback object for the operation.
     * @param serial The current serial number of the registry
     * database. This serial number allows observers to make sure that
     * their internal state is synchronized with the registry.
     * 
     * @param applications The applications currently registered with
     * the registry.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_applicationInit(int serial, java.util.List<ApplicationInfo> applications, java.util.Map<String, String> __ctx, Callback_ApplicationObserver_applicationInit __cb)
    {
        return begin_applicationInit(serial, applications, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_applicationInit(int serial, java.util.List<ApplicationInfo> applications, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __applicationInit_name, __cb);
        try
        {
            __result.__prepare(__applicationInit_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.writeInt(serial);
            ApplicationInfoSeqHelper.write(__os, applications);
            __os.writePendingObjects();
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     **/
    public void end_applicationInit(Ice.AsyncResult __result)
    {
        __end(__result, __applicationInit_name);
    }

    /**
     * <tt>applicationInit</tt> is called after the registration
     * of an observer to indicate the state of the registry.
     * 
     * @param __cb The callback object for the operation.
     * @param serial The current serial number of the registry
     * database. This serial number allows observers to make sure that
     * their internal state is synchronized with the registry.
     * 
     * @param applications The applications currently registered with
     * the registry.
     * 
     **/
    public boolean
    applicationInit_async(AMI_ApplicationObserver_applicationInit __cb, int serial, java.util.List<ApplicationInfo> applications)
    {
        Ice.AsyncResult __r = begin_applicationInit(serial, applications, null, false, __cb);
        return __r.sentSynchronously();
    }

    /**
     * <tt>applicationInit</tt> is called after the registration
     * of an observer to indicate the state of the registry.
     * 
     * @param __cb The callback object for the operation.
     * @param serial The current serial number of the registry
     * database. This serial number allows observers to make sure that
     * their internal state is synchronized with the registry.
     * 
     * @param applications The applications currently registered with
     * the registry.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public boolean
    applicationInit_async(AMI_ApplicationObserver_applicationInit __cb, int serial, java.util.List<ApplicationInfo> applications, java.util.Map<String, String> __ctx)
    {
        Ice.AsyncResult __r = begin_applicationInit(serial, applications, __ctx, true, __cb);
        return __r.sentSynchronously();
    }

    /**
     * The <tt>applicationRemoved</tt> operation is called to notify an observer
     * that an application was removed.
     * 
     * @param serial The new serial number of the registry database.
     * 
     * @param name The name of the application that was removed.
     * 
     **/
    public void
    applicationRemoved(int serial, String name)
    {
        applicationRemoved(serial, name, null, false);
    }

    /**
     * The <tt>applicationRemoved</tt> operation is called to notify an observer
     * that an application was removed.
     * 
     * @param serial The new serial number of the registry database.
     * 
     * @param name The name of the application that was removed.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void
    applicationRemoved(int serial, String name, java.util.Map<String, String> __ctx)
    {
        applicationRemoved(serial, name, __ctx, true);
    }

    private void
    applicationRemoved(int serial, String name, java.util.Map<String, String> __ctx, boolean __explicitCtx)
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __delBase = __getDelegate(false);
                _ApplicationObserverDel __del = (_ApplicationObserverDel)__delBase;
                __del.applicationRemoved(serial, name, __ctx);
                return;
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __applicationRemoved_name = "applicationRemoved";

    /**
     * The <tt>applicationRemoved</tt> operation is called to notify an observer
     * that an application was removed.
     * 
     * @param __cb The callback object for the operation.
     * @param serial The new serial number of the registry database.
     * 
     * @param name The name of the application that was removed.
     * 
     **/
    public Ice.AsyncResult begin_applicationRemoved(int serial, String name)
    {
        return begin_applicationRemoved(serial, name, null, false, null);
    }

    /**
     * The <tt>applicationRemoved</tt> operation is called to notify an observer
     * that an application was removed.
     * 
     * @param __cb The callback object for the operation.
     * @param serial The new serial number of the registry database.
     * 
     * @param name The name of the application that was removed.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_applicationRemoved(int serial, String name, java.util.Map<String, String> __ctx)
    {
        return begin_applicationRemoved(serial, name, __ctx, true, null);
    }

    /**
     * The <tt>applicationRemoved</tt> operation is called to notify an observer
     * that an application was removed.
     * 
     * @param __cb The callback object for the operation.
     * @param serial The new serial number of the registry database.
     * 
     * @param name The name of the application that was removed.
     * 
     **/
    public Ice.AsyncResult begin_applicationRemoved(int serial, String name, Ice.Callback __cb)
    {
        return begin_applicationRemoved(serial, name, null, false, __cb);
    }

    /**
     * The <tt>applicationRemoved</tt> operation is called to notify an observer
     * that an application was removed.
     * 
     * @param __cb The callback object for the operation.
     * @param serial The new serial number of the registry database.
     * 
     * @param name The name of the application that was removed.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_applicationRemoved(int serial, String name, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_applicationRemoved(serial, name, __ctx, true, __cb);
    }

    /**
     * The <tt>applicationRemoved</tt> operation is called to notify an observer
     * that an application was removed.
     * 
     * @param __cb The callback object for the operation.
     * @param serial The new serial number of the registry database.
     * 
     * @param name The name of the application that was removed.
     * 
     **/
    public Ice.AsyncResult begin_applicationRemoved(int serial, String name, Callback_ApplicationObserver_applicationRemoved __cb)
    {
        return begin_applicationRemoved(serial, name, null, false, __cb);
    }

    /**
     * The <tt>applicationRemoved</tt> operation is called to notify an observer
     * that an application was removed.
     * 
     * @param __cb The callback object for the operation.
     * @param serial The new serial number of the registry database.
     * 
     * @param name The name of the application that was removed.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_applicationRemoved(int serial, String name, java.util.Map<String, String> __ctx, Callback_ApplicationObserver_applicationRemoved __cb)
    {
        return begin_applicationRemoved(serial, name, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_applicationRemoved(int serial, String name, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __applicationRemoved_name, __cb);
        try
        {
            __result.__prepare(__applicationRemoved_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.writeInt(serial);
            __os.writeString(name);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     **/
    public void end_applicationRemoved(Ice.AsyncResult __result)
    {
        __end(__result, __applicationRemoved_name);
    }

    /**
     * The <tt>applicationUpdated</tt> operation is called to notify an observer
     * that an application was updated.
     * 
     * @param serial The new serial number of the registry database.
     * 
     * @param desc The descriptor of the update.
     * 
     **/
    public void
    applicationUpdated(int serial, ApplicationUpdateInfo desc)
    {
        applicationUpdated(serial, desc, null, false);
    }

    /**
     * The <tt>applicationUpdated</tt> operation is called to notify an observer
     * that an application was updated.
     * 
     * @param serial The new serial number of the registry database.
     * 
     * @param desc The descriptor of the update.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void
    applicationUpdated(int serial, ApplicationUpdateInfo desc, java.util.Map<String, String> __ctx)
    {
        applicationUpdated(serial, desc, __ctx, true);
    }

    private void
    applicationUpdated(int serial, ApplicationUpdateInfo desc, java.util.Map<String, String> __ctx, boolean __explicitCtx)
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __delBase = __getDelegate(false);
                _ApplicationObserverDel __del = (_ApplicationObserverDel)__delBase;
                __del.applicationUpdated(serial, desc, __ctx);
                return;
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __applicationUpdated_name = "applicationUpdated";

    /**
     * The <tt>applicationUpdated</tt> operation is called to notify an observer
     * that an application was updated.
     * 
     * @param __cb The callback object for the operation.
     * @param serial The new serial number of the registry database.
     * 
     * @param desc The descriptor of the update.
     * 
     **/
    public Ice.AsyncResult begin_applicationUpdated(int serial, ApplicationUpdateInfo desc)
    {
        return begin_applicationUpdated(serial, desc, null, false, null);
    }

    /**
     * The <tt>applicationUpdated</tt> operation is called to notify an observer
     * that an application was updated.
     * 
     * @param __cb The callback object for the operation.
     * @param serial The new serial number of the registry database.
     * 
     * @param desc The descriptor of the update.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_applicationUpdated(int serial, ApplicationUpdateInfo desc, java.util.Map<String, String> __ctx)
    {
        return begin_applicationUpdated(serial, desc, __ctx, true, null);
    }

    /**
     * The <tt>applicationUpdated</tt> operation is called to notify an observer
     * that an application was updated.
     * 
     * @param __cb The callback object for the operation.
     * @param serial The new serial number of the registry database.
     * 
     * @param desc The descriptor of the update.
     * 
     **/
    public Ice.AsyncResult begin_applicationUpdated(int serial, ApplicationUpdateInfo desc, Ice.Callback __cb)
    {
        return begin_applicationUpdated(serial, desc, null, false, __cb);
    }

    /**
     * The <tt>applicationUpdated</tt> operation is called to notify an observer
     * that an application was updated.
     * 
     * @param __cb The callback object for the operation.
     * @param serial The new serial number of the registry database.
     * 
     * @param desc The descriptor of the update.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_applicationUpdated(int serial, ApplicationUpdateInfo desc, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_applicationUpdated(serial, desc, __ctx, true, __cb);
    }

    /**
     * The <tt>applicationUpdated</tt> operation is called to notify an observer
     * that an application was updated.
     * 
     * @param __cb The callback object for the operation.
     * @param serial The new serial number of the registry database.
     * 
     * @param desc The descriptor of the update.
     * 
     **/
    public Ice.AsyncResult begin_applicationUpdated(int serial, ApplicationUpdateInfo desc, Callback_ApplicationObserver_applicationUpdated __cb)
    {
        return begin_applicationUpdated(serial, desc, null, false, __cb);
    }

    /**
     * The <tt>applicationUpdated</tt> operation is called to notify an observer
     * that an application was updated.
     * 
     * @param __cb The callback object for the operation.
     * @param serial The new serial number of the registry database.
     * 
     * @param desc The descriptor of the update.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_applicationUpdated(int serial, ApplicationUpdateInfo desc, java.util.Map<String, String> __ctx, Callback_ApplicationObserver_applicationUpdated __cb)
    {
        return begin_applicationUpdated(serial, desc, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_applicationUpdated(int serial, ApplicationUpdateInfo desc, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __applicationUpdated_name, __cb);
        try
        {
            __result.__prepare(__applicationUpdated_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.writeInt(serial);
            desc.__write(__os);
            __os.writePendingObjects();
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     **/
    public void end_applicationUpdated(Ice.AsyncResult __result)
    {
        __end(__result, __applicationUpdated_name);
    }

    public static ApplicationObserverPrx
    checkedCast(Ice.ObjectPrx __obj)
    {
        ApplicationObserverPrx __d = null;
        if(__obj != null)
        {
            try
            {
                __d = (ApplicationObserverPrx)__obj;
            }
            catch(ClassCastException ex)
            {
                if(__obj.ice_isA("::IceGrid::ApplicationObserver"))
                {
                    ApplicationObserverPrxHelper __h = new ApplicationObserverPrxHelper();
                    __h.__copyFrom(__obj);
                    __d = __h;
                }
            }
        }
        return __d;
    }

    public static ApplicationObserverPrx
    checkedCast(Ice.ObjectPrx __obj, java.util.Map<String, String> __ctx)
    {
        ApplicationObserverPrx __d = null;
        if(__obj != null)
        {
            try
            {
                __d = (ApplicationObserverPrx)__obj;
            }
            catch(ClassCastException ex)
            {
                if(__obj.ice_isA("::IceGrid::ApplicationObserver", __ctx))
                {
                    ApplicationObserverPrxHelper __h = new ApplicationObserverPrxHelper();
                    __h.__copyFrom(__obj);
                    __d = __h;
                }
            }
        }
        return __d;
    }

    public static ApplicationObserverPrx
    checkedCast(Ice.ObjectPrx __obj, String __facet)
    {
        ApplicationObserverPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            try
            {
                if(__bb.ice_isA("::IceGrid::ApplicationObserver"))
                {
                    ApplicationObserverPrxHelper __h = new ApplicationObserverPrxHelper();
                    __h.__copyFrom(__bb);
                    __d = __h;
                }
            }
            catch(Ice.FacetNotExistException ex)
            {
            }
        }
        return __d;
    }

    public static ApplicationObserverPrx
    checkedCast(Ice.ObjectPrx __obj, String __facet, java.util.Map<String, String> __ctx)
    {
        ApplicationObserverPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            try
            {
                if(__bb.ice_isA("::IceGrid::ApplicationObserver", __ctx))
                {
                    ApplicationObserverPrxHelper __h = new ApplicationObserverPrxHelper();
                    __h.__copyFrom(__bb);
                    __d = __h;
                }
            }
            catch(Ice.FacetNotExistException ex)
            {
            }
        }
        return __d;
    }

    public static ApplicationObserverPrx
    uncheckedCast(Ice.ObjectPrx __obj)
    {
        ApplicationObserverPrx __d = null;
        if(__obj != null)
        {
            try
            {
                __d = (ApplicationObserverPrx)__obj;
            }
            catch(ClassCastException ex)
            {
                ApplicationObserverPrxHelper __h = new ApplicationObserverPrxHelper();
                __h.__copyFrom(__obj);
                __d = __h;
            }
        }
        return __d;
    }

    public static ApplicationObserverPrx
    uncheckedCast(Ice.ObjectPrx __obj, String __facet)
    {
        ApplicationObserverPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            ApplicationObserverPrxHelper __h = new ApplicationObserverPrxHelper();
            __h.__copyFrom(__bb);
            __d = __h;
        }
        return __d;
    }

    protected Ice._ObjectDelM
    __createDelegateM()
    {
        return new _ApplicationObserverDelM();
    }

    protected Ice._ObjectDelD
    __createDelegateD()
    {
        return new _ApplicationObserverDelD();
    }

    public static void
    __write(IceInternal.BasicStream __os, ApplicationObserverPrx v)
    {
        __os.writeProxy(v);
    }

    public static ApplicationObserverPrx
    __read(IceInternal.BasicStream __is)
    {
        Ice.ObjectPrx proxy = __is.readProxy();
        if(proxy != null)
        {
            ApplicationObserverPrxHelper result = new ApplicationObserverPrxHelper();
            result.__copyFrom(proxy);
            return result;
        }
        return null;
    }
}
