// **********************************************************************
//
// Copyright (c) 2003-2010 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************

// Ice version 3.4.1

package IceGrid;

// <auto-generated>
//
// Generated from file `Admin.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>


/**
 * This interface provides access to IceGrid log file contents.
 * 
 **/
public final class FileIteratorPrxHelper extends Ice.ObjectPrxHelperBase implements FileIteratorPrx
{
    /**
     * Destroy the iterator.
     * 
     **/
    public void
    destroy()
    {
        destroy(null, false);
    }

    /**
     * Destroy the iterator.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public void
    destroy(java.util.Map<String, String> __ctx)
    {
        destroy(__ctx, true);
    }

    private void
    destroy(java.util.Map<String, String> __ctx, boolean __explicitCtx)
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __delBase = __getDelegate(false);
                _FileIteratorDel __del = (_FileIteratorDel)__delBase;
                __del.destroy(__ctx);
                return;
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __destroy_name = "destroy";

    /**
     * Destroy the iterator.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_destroy()
    {
        return begin_destroy(null, false, null);
    }

    /**
     * Destroy the iterator.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_destroy(java.util.Map<String, String> __ctx)
    {
        return begin_destroy(__ctx, true, null);
    }

    /**
     * Destroy the iterator.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_destroy(Ice.Callback __cb)
    {
        return begin_destroy(null, false, __cb);
    }

    /**
     * Destroy the iterator.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_destroy(java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_destroy(__ctx, true, __cb);
    }

    /**
     * Destroy the iterator.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_destroy(Callback_FileIterator_destroy __cb)
    {
        return begin_destroy(null, false, __cb);
    }

    /**
     * Destroy the iterator.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_destroy(java.util.Map<String, String> __ctx, Callback_FileIterator_destroy __cb)
    {
        return begin_destroy(__ctx, true, __cb);
    }

    private Ice.AsyncResult begin_destroy(java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __destroy_name, __cb);
        try
        {
            __result.__prepare(__destroy_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     **/
    public void end_destroy(Ice.AsyncResult __result)
    {
        __end(__result, __destroy_name);
    }

    /**
     * Read lines from the log file.
     * 
     * @param size Specifies the maximum number of bytes to be
     * received. The server will ensure that the returned message
     * doesn't exceed the given size.
     * 
     * @param lines The lines read from the file. If there was nothing to
     * read from the file since the last call to read, an empty
     * sequence is returned. The last line of the sequence is always
     * incomplete (and therefore no '\n' should be added when writing
     * the last line to the to the output device).
     * 
     * @return True if EOF is encountered.
     * 
     * @throws FileNotAvailableException Raised if there was a problem
     * to read lines from the file.
     * 
     **/
    public boolean
    read(int size, Ice.StringSeqHolder lines)
        throws FileNotAvailableException
    {
        return read(size, lines, null, false);
    }

    /**
     * Read lines from the log file.
     * 
     * @param size Specifies the maximum number of bytes to be
     * received. The server will ensure that the returned message
     * doesn't exceed the given size.
     * 
     * @param lines The lines read from the file. If there was nothing to
     * read from the file since the last call to read, an empty
     * sequence is returned. The last line of the sequence is always
     * incomplete (and therefore no '\n' should be added when writing
     * the last line to the to the output device).
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return True if EOF is encountered.
     * 
     * @throws FileNotAvailableException Raised if there was a problem
     * to read lines from the file.
     * 
     **/
    public boolean
    read(int size, Ice.StringSeqHolder lines, java.util.Map<String, String> __ctx)
        throws FileNotAvailableException
    {
        return read(size, lines, __ctx, true);
    }

    private boolean
    read(int size, Ice.StringSeqHolder lines, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws FileNotAvailableException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("read");
                __delBase = __getDelegate(false);
                _FileIteratorDel __del = (_FileIteratorDel)__delBase;
                return __del.read(size, lines, __ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __read_name = "read";

    /**
     * Read lines from the log file.
     * 
     * @param __cb The callback object for the operation.
     * @param size Specifies the maximum number of bytes to be
     * received. The server will ensure that the returned message
     * doesn't exceed the given size.
     * 
     **/
    public Ice.AsyncResult begin_read(int size)
    {
        return begin_read(size, null, false, null);
    }

    /**
     * Read lines from the log file.
     * 
     * @param __cb The callback object for the operation.
     * @param size Specifies the maximum number of bytes to be
     * received. The server will ensure that the returned message
     * doesn't exceed the given size.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_read(int size, java.util.Map<String, String> __ctx)
    {
        return begin_read(size, __ctx, true, null);
    }

    /**
     * Read lines from the log file.
     * 
     * @param __cb The callback object for the operation.
     * @param size Specifies the maximum number of bytes to be
     * received. The server will ensure that the returned message
     * doesn't exceed the given size.
     * 
     **/
    public Ice.AsyncResult begin_read(int size, Ice.Callback __cb)
    {
        return begin_read(size, null, false, __cb);
    }

    /**
     * Read lines from the log file.
     * 
     * @param __cb The callback object for the operation.
     * @param size Specifies the maximum number of bytes to be
     * received. The server will ensure that the returned message
     * doesn't exceed the given size.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_read(int size, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_read(size, __ctx, true, __cb);
    }

    /**
     * Read lines from the log file.
     * 
     * @param __cb The callback object for the operation.
     * @param size Specifies the maximum number of bytes to be
     * received. The server will ensure that the returned message
     * doesn't exceed the given size.
     * 
     **/
    public Ice.AsyncResult begin_read(int size, Callback_FileIterator_read __cb)
    {
        return begin_read(size, null, false, __cb);
    }

    /**
     * Read lines from the log file.
     * 
     * @param __cb The callback object for the operation.
     * @param size Specifies the maximum number of bytes to be
     * received. The server will ensure that the returned message
     * doesn't exceed the given size.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_read(int size, java.util.Map<String, String> __ctx, Callback_FileIterator_read __cb)
    {
        return begin_read(size, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_read(int size, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__read_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __read_name, __cb);
        try
        {
            __result.__prepare(__read_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.writeInt(size);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) True if EOF is encountered.
     * 
     * @param lines The lines read from the file. If there was nothing to
     * read from the file since the last call to read, an empty
     * sequence is returned. The last line of the sequence is always
     * incomplete (and therefore no '\n' should be added when writing
     * the last line to the to the output device).
     * 
     **/
    public boolean end_read(Ice.StringSeqHolder lines, Ice.AsyncResult __result)
        throws FileNotAvailableException
    {
        Ice.AsyncResult.__check(__result, this, __read_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(FileNotAvailableException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        boolean __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        lines.value = Ice.StringSeqHelper.read(__is);
        __ret = __is.readBool();
        __is.endReadEncaps();
        return __ret;
    }

    public static FileIteratorPrx
    checkedCast(Ice.ObjectPrx __obj)
    {
        FileIteratorPrx __d = null;
        if(__obj != null)
        {
            try
            {
                __d = (FileIteratorPrx)__obj;
            }
            catch(ClassCastException ex)
            {
                if(__obj.ice_isA("::IceGrid::FileIterator"))
                {
                    FileIteratorPrxHelper __h = new FileIteratorPrxHelper();
                    __h.__copyFrom(__obj);
                    __d = __h;
                }
            }
        }
        return __d;
    }

    public static FileIteratorPrx
    checkedCast(Ice.ObjectPrx __obj, java.util.Map<String, String> __ctx)
    {
        FileIteratorPrx __d = null;
        if(__obj != null)
        {
            try
            {
                __d = (FileIteratorPrx)__obj;
            }
            catch(ClassCastException ex)
            {
                if(__obj.ice_isA("::IceGrid::FileIterator", __ctx))
                {
                    FileIteratorPrxHelper __h = new FileIteratorPrxHelper();
                    __h.__copyFrom(__obj);
                    __d = __h;
                }
            }
        }
        return __d;
    }

    public static FileIteratorPrx
    checkedCast(Ice.ObjectPrx __obj, String __facet)
    {
        FileIteratorPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            try
            {
                if(__bb.ice_isA("::IceGrid::FileIterator"))
                {
                    FileIteratorPrxHelper __h = new FileIteratorPrxHelper();
                    __h.__copyFrom(__bb);
                    __d = __h;
                }
            }
            catch(Ice.FacetNotExistException ex)
            {
            }
        }
        return __d;
    }

    public static FileIteratorPrx
    checkedCast(Ice.ObjectPrx __obj, String __facet, java.util.Map<String, String> __ctx)
    {
        FileIteratorPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            try
            {
                if(__bb.ice_isA("::IceGrid::FileIterator", __ctx))
                {
                    FileIteratorPrxHelper __h = new FileIteratorPrxHelper();
                    __h.__copyFrom(__bb);
                    __d = __h;
                }
            }
            catch(Ice.FacetNotExistException ex)
            {
            }
        }
        return __d;
    }

    public static FileIteratorPrx
    uncheckedCast(Ice.ObjectPrx __obj)
    {
        FileIteratorPrx __d = null;
        if(__obj != null)
        {
            try
            {
                __d = (FileIteratorPrx)__obj;
            }
            catch(ClassCastException ex)
            {
                FileIteratorPrxHelper __h = new FileIteratorPrxHelper();
                __h.__copyFrom(__obj);
                __d = __h;
            }
        }
        return __d;
    }

    public static FileIteratorPrx
    uncheckedCast(Ice.ObjectPrx __obj, String __facet)
    {
        FileIteratorPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            FileIteratorPrxHelper __h = new FileIteratorPrxHelper();
            __h.__copyFrom(__bb);
            __d = __h;
        }
        return __d;
    }

    protected Ice._ObjectDelM
    __createDelegateM()
    {
        return new _FileIteratorDelM();
    }

    protected Ice._ObjectDelD
    __createDelegateD()
    {
        return new _FileIteratorDelD();
    }

    public static void
    __write(IceInternal.BasicStream __os, FileIteratorPrx v)
    {
        __os.writeProxy(v);
    }

    public static FileIteratorPrx
    __read(IceInternal.BasicStream __is)
    {
        Ice.ObjectPrx proxy = __is.readProxy();
        if(proxy != null)
        {
            FileIteratorPrxHelper result = new FileIteratorPrxHelper();
            result.__copyFrom(proxy);
            return result;
        }
        return null;
    }
}
