// **********************************************************************
//
// Copyright (c) 2003-2010 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************

// Ice version 3.4.1

package IceGrid;

// <auto-generated>
//
// Generated from file `FileParser.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>


/**
 * <tt>icegridadmin</tt> provides a {@link FileParser}
 * object to transform XML files into {@link ApplicationDescriptor}
 * objects.
 * 
 **/
public interface FileParserPrx extends Ice.ObjectPrx
{
    /**
     * Parse a file.
     * 
     * @param xmlFile Full pathname to the file.
     * 
     * @param adminProxy An Admin proxy, used only to retrieve default
     * templates when needed. May be null.
     * 
     * @returns The application descriptor.
     * 
     * @throws ParseException Raised if an error occurred during parsing.
     * 
     **/
    public ApplicationDescriptor parse(String xmlFile, AdminPrx adminProxy)
        throws ParseException;

    /**
     * Parse a file.
     * 
     * @param xmlFile Full pathname to the file.
     * 
     * @param adminProxy An Admin proxy, used only to retrieve default
     * templates when needed. May be null.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @returns The application descriptor.
     * 
     * @throws ParseException Raised if an error occurred during parsing.
     * 
     **/
    public ApplicationDescriptor parse(String xmlFile, AdminPrx adminProxy, java.util.Map<String, String> __ctx)
        throws ParseException;

    /**
     * Parse a file.
     * 
     * @param xmlFile Full pathname to the file.
     * 
     * @param adminProxy An Admin proxy, used only to retrieve default
     * templates when needed. May be null.
     * 
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_parse(String xmlFile, AdminPrx adminProxy);

    /**
     * Parse a file.
     * 
     * @param xmlFile Full pathname to the file.
     * 
     * @param adminProxy An Admin proxy, used only to retrieve default
     * templates when needed. May be null.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_parse(String xmlFile, AdminPrx adminProxy, java.util.Map<String, String> __ctx);

    /**
     * Parse a file.
     * 
     * @param xmlFile Full pathname to the file.
     * 
     * @param adminProxy An Admin proxy, used only to retrieve default
     * templates when needed. May be null.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_parse(String xmlFile, AdminPrx adminProxy, Ice.Callback __cb);

    /**
     * Parse a file.
     * 
     * @param xmlFile Full pathname to the file.
     * 
     * @param adminProxy An Admin proxy, used only to retrieve default
     * templates when needed. May be null.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_parse(String xmlFile, AdminPrx adminProxy, java.util.Map<String, String> __ctx, Ice.Callback __cb);

    /**
     * Parse a file.
     * 
     * @param xmlFile Full pathname to the file.
     * 
     * @param adminProxy An Admin proxy, used only to retrieve default
     * templates when needed. May be null.
     * 
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_parse(String xmlFile, AdminPrx adminProxy, Callback_FileParser_parse __cb);

    /**
     * Parse a file.
     * 
     * @param xmlFile Full pathname to the file.
     * 
     * @param adminProxy An Admin proxy, used only to retrieve default
     * templates when needed. May be null.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @param __cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_parse(String xmlFile, AdminPrx adminProxy, java.util.Map<String, String> __ctx, Callback_FileParser_parse __cb);

    /**
     * Parse a file.
     * 
     * @param __result The asynchronous result object.
     * @returns The application descriptor.
     * 
     * @throws ParseException Raised if an error occurred during parsing.
     * 
     **/
    public ApplicationDescriptor end_parse(Ice.AsyncResult __result)
        throws ParseException;
}
