// **********************************************************************
//
// Copyright (c) 2003-2010 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************

// Ice version 3.4.1

package IceGrid;

// <auto-generated>
//
// Generated from file `Registry.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>


/**
 * The IceGrid registry allows clients create sessions
 * directly with the registry.
 * 
 * @see Session
 * @see AdminSession
 * 
 **/
public final class RegistryPrxHelper extends Ice.ObjectPrxHelperBase implements RegistryPrx
{
    /**
     * Create an administrative session.
     * 
     * @see Session
     * @see Glacier2.PermissionsVerifier
     * 
     * @return A proxy for the newly created session.
     * 
     * @param userId The user id.
     * 
     * @param password The password for the given user id.
     * 
     * @throws PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     * 
     **/
    public AdminSessionPrx
    createAdminSession(String userId, String password)
        throws PermissionDeniedException
    {
        return createAdminSession(userId, password, null, false);
    }

    /**
     * Create an administrative session.
     * 
     * @see Session
     * @see Glacier2.PermissionsVerifier
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return A proxy for the newly created session.
     * 
     * @param userId The user id.
     * 
     * @param password The password for the given user id.
     * 
     * @throws PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     * 
     **/
    public AdminSessionPrx
    createAdminSession(String userId, String password, java.util.Map<String, String> __ctx)
        throws PermissionDeniedException
    {
        return createAdminSession(userId, password, __ctx, true);
    }

    private AdminSessionPrx
    createAdminSession(String userId, String password, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws PermissionDeniedException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("createAdminSession");
                __delBase = __getDelegate(false);
                _RegistryDel __del = (_RegistryDel)__delBase;
                return __del.createAdminSession(userId, password, __ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __createAdminSession_name = "createAdminSession";

    /**
     * Create an administrative session.
     * 
     * @param __cb The callback object for the operation.
     * @param userId The user id.
     * 
     * @param password The password for the given user id.
     * 
     **/
    public Ice.AsyncResult begin_createAdminSession(String userId, String password)
    {
        return begin_createAdminSession(userId, password, null, false, null);
    }

    /**
     * Create an administrative session.
     * 
     * @param __cb The callback object for the operation.
     * @param userId The user id.
     * 
     * @param password The password for the given user id.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_createAdminSession(String userId, String password, java.util.Map<String, String> __ctx)
    {
        return begin_createAdminSession(userId, password, __ctx, true, null);
    }

    /**
     * Create an administrative session.
     * 
     * @param __cb The callback object for the operation.
     * @param userId The user id.
     * 
     * @param password The password for the given user id.
     * 
     **/
    public Ice.AsyncResult begin_createAdminSession(String userId, String password, Ice.Callback __cb)
    {
        return begin_createAdminSession(userId, password, null, false, __cb);
    }

    /**
     * Create an administrative session.
     * 
     * @param __cb The callback object for the operation.
     * @param userId The user id.
     * 
     * @param password The password for the given user id.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_createAdminSession(String userId, String password, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_createAdminSession(userId, password, __ctx, true, __cb);
    }

    /**
     * Create an administrative session.
     * 
     * @param __cb The callback object for the operation.
     * @param userId The user id.
     * 
     * @param password The password for the given user id.
     * 
     **/
    public Ice.AsyncResult begin_createAdminSession(String userId, String password, Callback_Registry_createAdminSession __cb)
    {
        return begin_createAdminSession(userId, password, null, false, __cb);
    }

    /**
     * Create an administrative session.
     * 
     * @param __cb The callback object for the operation.
     * @param userId The user id.
     * 
     * @param password The password for the given user id.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_createAdminSession(String userId, String password, java.util.Map<String, String> __ctx, Callback_Registry_createAdminSession __cb)
    {
        return begin_createAdminSession(userId, password, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_createAdminSession(String userId, String password, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__createAdminSession_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __createAdminSession_name, __cb);
        try
        {
            __result.__prepare(__createAdminSession_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.writeString(userId);
            __os.writeString(password);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) A proxy for the newly created session.
     * 
     **/
    public AdminSessionPrx end_createAdminSession(Ice.AsyncResult __result)
        throws PermissionDeniedException
    {
        Ice.AsyncResult.__check(__result, this, __createAdminSession_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(PermissionDeniedException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        AdminSessionPrx __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = AdminSessionPrxHelper.__read(__is);
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Create an administrative session from a secure connection.
     * 
     * @see Session
     * @see Glacier2.SSLPermissionsVerifier
     * 
     * @return A proxy for the newly created session.
     * 
     * @throws PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     * 
     **/
    public AdminSessionPrx
    createAdminSessionFromSecureConnection()
        throws PermissionDeniedException
    {
        return createAdminSessionFromSecureConnection(null, false);
    }

    /**
     * Create an administrative session from a secure connection.
     * 
     * @see Session
     * @see Glacier2.SSLPermissionsVerifier
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return A proxy for the newly created session.
     * 
     * @throws PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     * 
     **/
    public AdminSessionPrx
    createAdminSessionFromSecureConnection(java.util.Map<String, String> __ctx)
        throws PermissionDeniedException
    {
        return createAdminSessionFromSecureConnection(__ctx, true);
    }

    private AdminSessionPrx
    createAdminSessionFromSecureConnection(java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws PermissionDeniedException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("createAdminSessionFromSecureConnection");
                __delBase = __getDelegate(false);
                _RegistryDel __del = (_RegistryDel)__delBase;
                return __del.createAdminSessionFromSecureConnection(__ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __createAdminSessionFromSecureConnection_name = "createAdminSessionFromSecureConnection";

    /**
     * Create an administrative session from a secure connection.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_createAdminSessionFromSecureConnection()
    {
        return begin_createAdminSessionFromSecureConnection(null, false, null);
    }

    /**
     * Create an administrative session from a secure connection.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_createAdminSessionFromSecureConnection(java.util.Map<String, String> __ctx)
    {
        return begin_createAdminSessionFromSecureConnection(__ctx, true, null);
    }

    /**
     * Create an administrative session from a secure connection.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_createAdminSessionFromSecureConnection(Ice.Callback __cb)
    {
        return begin_createAdminSessionFromSecureConnection(null, false, __cb);
    }

    /**
     * Create an administrative session from a secure connection.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_createAdminSessionFromSecureConnection(java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_createAdminSessionFromSecureConnection(__ctx, true, __cb);
    }

    /**
     * Create an administrative session from a secure connection.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_createAdminSessionFromSecureConnection(Callback_Registry_createAdminSessionFromSecureConnection __cb)
    {
        return begin_createAdminSessionFromSecureConnection(null, false, __cb);
    }

    /**
     * Create an administrative session from a secure connection.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_createAdminSessionFromSecureConnection(java.util.Map<String, String> __ctx, Callback_Registry_createAdminSessionFromSecureConnection __cb)
    {
        return begin_createAdminSessionFromSecureConnection(__ctx, true, __cb);
    }

    private Ice.AsyncResult begin_createAdminSessionFromSecureConnection(java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__createAdminSessionFromSecureConnection_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __createAdminSessionFromSecureConnection_name, __cb);
        try
        {
            __result.__prepare(__createAdminSessionFromSecureConnection_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) A proxy for the newly created session.
     * 
     **/
    public AdminSessionPrx end_createAdminSessionFromSecureConnection(Ice.AsyncResult __result)
        throws PermissionDeniedException
    {
        Ice.AsyncResult.__check(__result, this, __createAdminSessionFromSecureConnection_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(PermissionDeniedException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        AdminSessionPrx __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = AdminSessionPrxHelper.__read(__is);
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Create a client session.
     * 
     * @see Session
     * @see Glacier2.PermissionsVerifier
     * 
     * @return A proxy for the newly created session.
     * 
     * @param userId The user id.
     * 
     * @param password The password for the given user id.
     * 
     * @throws PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     * 
     **/
    public SessionPrx
    createSession(String userId, String password)
        throws PermissionDeniedException
    {
        return createSession(userId, password, null, false);
    }

    /**
     * Create a client session.
     * 
     * @see Session
     * @see Glacier2.PermissionsVerifier
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return A proxy for the newly created session.
     * 
     * @param userId The user id.
     * 
     * @param password The password for the given user id.
     * 
     * @throws PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     * 
     **/
    public SessionPrx
    createSession(String userId, String password, java.util.Map<String, String> __ctx)
        throws PermissionDeniedException
    {
        return createSession(userId, password, __ctx, true);
    }

    private SessionPrx
    createSession(String userId, String password, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws PermissionDeniedException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("createSession");
                __delBase = __getDelegate(false);
                _RegistryDel __del = (_RegistryDel)__delBase;
                return __del.createSession(userId, password, __ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __createSession_name = "createSession";

    /**
     * Create a client session.
     * 
     * @param __cb The callback object for the operation.
     * @param userId The user id.
     * 
     * @param password The password for the given user id.
     * 
     **/
    public Ice.AsyncResult begin_createSession(String userId, String password)
    {
        return begin_createSession(userId, password, null, false, null);
    }

    /**
     * Create a client session.
     * 
     * @param __cb The callback object for the operation.
     * @param userId The user id.
     * 
     * @param password The password for the given user id.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_createSession(String userId, String password, java.util.Map<String, String> __ctx)
    {
        return begin_createSession(userId, password, __ctx, true, null);
    }

    /**
     * Create a client session.
     * 
     * @param __cb The callback object for the operation.
     * @param userId The user id.
     * 
     * @param password The password for the given user id.
     * 
     **/
    public Ice.AsyncResult begin_createSession(String userId, String password, Ice.Callback __cb)
    {
        return begin_createSession(userId, password, null, false, __cb);
    }

    /**
     * Create a client session.
     * 
     * @param __cb The callback object for the operation.
     * @param userId The user id.
     * 
     * @param password The password for the given user id.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_createSession(String userId, String password, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_createSession(userId, password, __ctx, true, __cb);
    }

    /**
     * Create a client session.
     * 
     * @param __cb The callback object for the operation.
     * @param userId The user id.
     * 
     * @param password The password for the given user id.
     * 
     **/
    public Ice.AsyncResult begin_createSession(String userId, String password, Callback_Registry_createSession __cb)
    {
        return begin_createSession(userId, password, null, false, __cb);
    }

    /**
     * Create a client session.
     * 
     * @param __cb The callback object for the operation.
     * @param userId The user id.
     * 
     * @param password The password for the given user id.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_createSession(String userId, String password, java.util.Map<String, String> __ctx, Callback_Registry_createSession __cb)
    {
        return begin_createSession(userId, password, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_createSession(String userId, String password, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__createSession_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __createSession_name, __cb);
        try
        {
            __result.__prepare(__createSession_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.writeString(userId);
            __os.writeString(password);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) A proxy for the newly created session.
     * 
     **/
    public SessionPrx end_createSession(Ice.AsyncResult __result)
        throws PermissionDeniedException
    {
        Ice.AsyncResult.__check(__result, this, __createSession_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(PermissionDeniedException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        SessionPrx __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = SessionPrxHelper.__read(__is);
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Create a client session from a secure connection.
     * 
     * @see Session
     * @see Glacier2.SSLPermissionsVerifier
     * 
     * @return A proxy for the newly created session.
     * 
     * @throws PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     * 
     **/
    public SessionPrx
    createSessionFromSecureConnection()
        throws PermissionDeniedException
    {
        return createSessionFromSecureConnection(null, false);
    }

    /**
     * Create a client session from a secure connection.
     * 
     * @see Session
     * @see Glacier2.SSLPermissionsVerifier
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return A proxy for the newly created session.
     * 
     * @throws PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     * 
     **/
    public SessionPrx
    createSessionFromSecureConnection(java.util.Map<String, String> __ctx)
        throws PermissionDeniedException
    {
        return createSessionFromSecureConnection(__ctx, true);
    }

    private SessionPrx
    createSessionFromSecureConnection(java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws PermissionDeniedException
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("createSessionFromSecureConnection");
                __delBase = __getDelegate(false);
                _RegistryDel __del = (_RegistryDel)__delBase;
                return __del.createSessionFromSecureConnection(__ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __createSessionFromSecureConnection_name = "createSessionFromSecureConnection";

    /**
     * Create a client session from a secure connection.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_createSessionFromSecureConnection()
    {
        return begin_createSessionFromSecureConnection(null, false, null);
    }

    /**
     * Create a client session from a secure connection.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_createSessionFromSecureConnection(java.util.Map<String, String> __ctx)
    {
        return begin_createSessionFromSecureConnection(__ctx, true, null);
    }

    /**
     * Create a client session from a secure connection.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_createSessionFromSecureConnection(Ice.Callback __cb)
    {
        return begin_createSessionFromSecureConnection(null, false, __cb);
    }

    /**
     * Create a client session from a secure connection.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_createSessionFromSecureConnection(java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_createSessionFromSecureConnection(__ctx, true, __cb);
    }

    /**
     * Create a client session from a secure connection.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_createSessionFromSecureConnection(Callback_Registry_createSessionFromSecureConnection __cb)
    {
        return begin_createSessionFromSecureConnection(null, false, __cb);
    }

    /**
     * Create a client session from a secure connection.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_createSessionFromSecureConnection(java.util.Map<String, String> __ctx, Callback_Registry_createSessionFromSecureConnection __cb)
    {
        return begin_createSessionFromSecureConnection(__ctx, true, __cb);
    }

    private Ice.AsyncResult begin_createSessionFromSecureConnection(java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__createSessionFromSecureConnection_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __createSessionFromSecureConnection_name, __cb);
        try
        {
            __result.__prepare(__createSessionFromSecureConnection_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) A proxy for the newly created session.
     * 
     **/
    public SessionPrx end_createSessionFromSecureConnection(Ice.AsyncResult __result)
        throws PermissionDeniedException
    {
        Ice.AsyncResult.__check(__result, this, __createSessionFromSecureConnection_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(PermissionDeniedException __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        SessionPrx __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = SessionPrxHelper.__read(__is);
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Get the session timeout. If a client or administrative client
     * doesn't call the session keepAlive method in the time interval
     * defined by this timeout, IceGrid might reap the session.
     * 
     * @see Session#keepAlive
     * @see AdminSession#keepAlive
     * 
     * @return The timeout (in seconds).
     * 
     **/
    public int
    getSessionTimeout()
    {
        return getSessionTimeout(null, false);
    }

    /**
     * Get the session timeout. If a client or administrative client
     * doesn't call the session keepAlive method in the time interval
     * defined by this timeout, IceGrid might reap the session.
     * 
     * @see Session#keepAlive
     * @see AdminSession#keepAlive
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return The timeout (in seconds).
     * 
     **/
    public int
    getSessionTimeout(java.util.Map<String, String> __ctx)
    {
        return getSessionTimeout(__ctx, true);
    }

    private int
    getSessionTimeout(java.util.Map<String, String> __ctx, boolean __explicitCtx)
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("getSessionTimeout");
                __delBase = __getDelegate(false);
                _RegistryDel __del = (_RegistryDel)__delBase;
                return __del.getSessionTimeout(__ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __getSessionTimeout_name = "getSessionTimeout";

    /**
     * Get the session timeout. If a client or administrative client
     * doesn't call the session keepAlive method in the time interval
     * defined by this timeout, IceGrid might reap the session.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getSessionTimeout()
    {
        return begin_getSessionTimeout(null, false, null);
    }

    /**
     * Get the session timeout. If a client or administrative client
     * doesn't call the session keepAlive method in the time interval
     * defined by this timeout, IceGrid might reap the session.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getSessionTimeout(java.util.Map<String, String> __ctx)
    {
        return begin_getSessionTimeout(__ctx, true, null);
    }

    /**
     * Get the session timeout. If a client or administrative client
     * doesn't call the session keepAlive method in the time interval
     * defined by this timeout, IceGrid might reap the session.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getSessionTimeout(Ice.Callback __cb)
    {
        return begin_getSessionTimeout(null, false, __cb);
    }

    /**
     * Get the session timeout. If a client or administrative client
     * doesn't call the session keepAlive method in the time interval
     * defined by this timeout, IceGrid might reap the session.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getSessionTimeout(java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_getSessionTimeout(__ctx, true, __cb);
    }

    /**
     * Get the session timeout. If a client or administrative client
     * doesn't call the session keepAlive method in the time interval
     * defined by this timeout, IceGrid might reap the session.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getSessionTimeout(Callback_Registry_getSessionTimeout __cb)
    {
        return begin_getSessionTimeout(null, false, __cb);
    }

    /**
     * Get the session timeout. If a client or administrative client
     * doesn't call the session keepAlive method in the time interval
     * defined by this timeout, IceGrid might reap the session.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getSessionTimeout(java.util.Map<String, String> __ctx, Callback_Registry_getSessionTimeout __cb)
    {
        return begin_getSessionTimeout(__ctx, true, __cb);
    }

    private Ice.AsyncResult begin_getSessionTimeout(java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__getSessionTimeout_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __getSessionTimeout_name, __cb);
        try
        {
            __result.__prepare(__getSessionTimeout_name, Ice.OperationMode.Idempotent, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) The timeout (in seconds).
     * 
     **/
    public int end_getSessionTimeout(Ice.AsyncResult __result)
    {
        Ice.AsyncResult.__check(__result, this, __getSessionTimeout_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        int __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = __is.readInt();
        __is.endReadEncaps();
        return __ret;
    }

    public static RegistryPrx
    checkedCast(Ice.ObjectPrx __obj)
    {
        RegistryPrx __d = null;
        if(__obj != null)
        {
            try
            {
                __d = (RegistryPrx)__obj;
            }
            catch(ClassCastException ex)
            {
                if(__obj.ice_isA("::IceGrid::Registry"))
                {
                    RegistryPrxHelper __h = new RegistryPrxHelper();
                    __h.__copyFrom(__obj);
                    __d = __h;
                }
            }
        }
        return __d;
    }

    public static RegistryPrx
    checkedCast(Ice.ObjectPrx __obj, java.util.Map<String, String> __ctx)
    {
        RegistryPrx __d = null;
        if(__obj != null)
        {
            try
            {
                __d = (RegistryPrx)__obj;
            }
            catch(ClassCastException ex)
            {
                if(__obj.ice_isA("::IceGrid::Registry", __ctx))
                {
                    RegistryPrxHelper __h = new RegistryPrxHelper();
                    __h.__copyFrom(__obj);
                    __d = __h;
                }
            }
        }
        return __d;
    }

    public static RegistryPrx
    checkedCast(Ice.ObjectPrx __obj, String __facet)
    {
        RegistryPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            try
            {
                if(__bb.ice_isA("::IceGrid::Registry"))
                {
                    RegistryPrxHelper __h = new RegistryPrxHelper();
                    __h.__copyFrom(__bb);
                    __d = __h;
                }
            }
            catch(Ice.FacetNotExistException ex)
            {
            }
        }
        return __d;
    }

    public static RegistryPrx
    checkedCast(Ice.ObjectPrx __obj, String __facet, java.util.Map<String, String> __ctx)
    {
        RegistryPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            try
            {
                if(__bb.ice_isA("::IceGrid::Registry", __ctx))
                {
                    RegistryPrxHelper __h = new RegistryPrxHelper();
                    __h.__copyFrom(__bb);
                    __d = __h;
                }
            }
            catch(Ice.FacetNotExistException ex)
            {
            }
        }
        return __d;
    }

    public static RegistryPrx
    uncheckedCast(Ice.ObjectPrx __obj)
    {
        RegistryPrx __d = null;
        if(__obj != null)
        {
            try
            {
                __d = (RegistryPrx)__obj;
            }
            catch(ClassCastException ex)
            {
                RegistryPrxHelper __h = new RegistryPrxHelper();
                __h.__copyFrom(__obj);
                __d = __h;
            }
        }
        return __d;
    }

    public static RegistryPrx
    uncheckedCast(Ice.ObjectPrx __obj, String __facet)
    {
        RegistryPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            RegistryPrxHelper __h = new RegistryPrxHelper();
            __h.__copyFrom(__bb);
            __d = __h;
        }
        return __d;
    }

    protected Ice._ObjectDelM
    __createDelegateM()
    {
        return new _RegistryDelM();
    }

    protected Ice._ObjectDelD
    __createDelegateD()
    {
        return new _RegistryDelD();
    }

    public static void
    __write(IceInternal.BasicStream __os, RegistryPrx v)
    {
        __os.writeProxy(v);
    }

    public static RegistryPrx
    __read(IceInternal.BasicStream __is)
    {
        Ice.ObjectPrx proxy = __is.readProxy();
        if(proxy != null)
        {
            RegistryPrxHelper result = new RegistryPrxHelper();
            result.__copyFrom(proxy);
            return result;
        }
        return null;
    }
}
