// **********************************************************************
//
// Copyright (c) 2003-2010 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************

// Ice version 3.4.1

package IceGrid;

// <auto-generated>
//
// Generated from file `Observer.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>


/**
 * The database observer interface. Observers should implement this
 * interface to receive information about the state of the IceGrid
 * registry database.
 * 
 **/
public interface _ApplicationObserverOperations
{
    /**
     * <tt>applicationInit</tt> is called after the registration
     * of an observer to indicate the state of the registry.
     * 
     * @param serial The current serial number of the registry
     * database. This serial number allows observers to make sure that
     * their internal state is synchronized with the registry.
     * 
     * @param applications The applications currently registered with
     * the registry.
     * 
     * @param __current The Current object for the invocation.
     **/
    void applicationInit(int serial, java.util.List<ApplicationInfo> applications, Ice.Current __current);

    /**
     * The <tt>applicationAdded</tt> operation is called to notify an observer
     * that an application was added.
     * 
     * @param serial The new serial number of the registry database.
     * 
     * @param desc The descriptor of the new application.
     * 
     * @param __current The Current object for the invocation.
     **/
    void applicationAdded(int serial, ApplicationInfo desc, Ice.Current __current);

    /**
     * The <tt>applicationRemoved</tt> operation is called to notify an observer
     * that an application was removed.
     * 
     * @param serial The new serial number of the registry database.
     * 
     * @param name The name of the application that was removed.
     * 
     * @param __current The Current object for the invocation.
     **/
    void applicationRemoved(int serial, String name, Ice.Current __current);

    /**
     * The <tt>applicationUpdated</tt> operation is called to notify an observer
     * that an application was updated.
     * 
     * @param serial The new serial number of the registry database.
     * 
     * @param desc The descriptor of the update.
     * 
     * @param __current The Current object for the invocation.
     **/
    void applicationUpdated(int serial, ApplicationUpdateInfo desc, Ice.Current __current);
}
