// **********************************************************************
//
// Copyright (c) 2003-2010 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************

// Ice version 3.4.1

package IceGrid;

// <auto-generated>
//
// Generated from file `Query.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>


/**
 * The IceGrid query interface. This interface is accessible to
 * Ice clients who wish to look up well-known objects.
 * 
 **/
public interface _QueryOperations
{
    /**
     * Find a well-known object by identity.
     * 
     * @param id The identity.
     * 
     * @param __current The Current object for the invocation.
     * @return The proxy or null if no such object has been found.
     * 
     **/
    Ice.ObjectPrx findObjectById(Ice.Identity id, Ice.Current __current);

    /**
     * Find a well-known object by type. If there are several objects
     * registered for the given type, the object is randomly
     * selected.
     * 
     * @param type The object type.
     * 
     * @param __current The Current object for the invocation.
     * @return The proxy or null, if no such object has been found.
     * 
     **/
    Ice.ObjectPrx findObjectByType(String type, Ice.Current __current);

    /**
     * Find a well-known object by type on the least-loaded node. If
     * the registry does not know which node hosts the object
     * (for example, because the object was registered with a direct proxy), the
     * registry assumes the object is hosted on a node that has a load
     * average of 1.0.
     * 
     * @param type The object type.
     * 
     * @param sample The sampling interval.
     * 
     * @param __current The Current object for the invocation.
     * @return The proxy or null, if no such object has been found.
     * 
     **/
    Ice.ObjectPrx findObjectByTypeOnLeastLoadedNode(String type, LoadSample sample, Ice.Current __current);

    /**
     * Find all the well-known objects with the given type.
     * 
     * @param type The object type.
     * 
     * @param __current The Current object for the invocation.
     * @return The proxies or an empty sequence, if no such objects
     * have been found.
     * 
     **/
    Ice.ObjectPrx[] findAllObjectsByType(String type, Ice.Current __current);

    /**
     * Find all the object replicas associated with the given
     * proxy. If the given proxy is not an indirect proxy from a
     * replica group, an empty sequence is returned.
     * 
     * @param proxy The object proxy.
     * 
     * @param __current The Current object for the invocation.
     * @return The proxies of each object replica or an empty sequence,
     * if the given proxy is not from a replica group.
     * 
     **/
    Ice.ObjectPrx[] findAllReplicas(Ice.ObjectPrx proxy, Ice.Current __current);
}
