// **********************************************************************
//
// Copyright (c) 2003-2010 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************

// Ice version 3.4.1

package IceGrid;

// <auto-generated>
//
// Generated from file `Session.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>


/**
 * A session object is used by IceGrid clients to allocate and
 * release objects. Client sessions are either created with the
 * {@link Registry} object or the registry client {@link Glacier2.SessionManager}
 * object.
 * 
 * @see Registry
 * @see Glacier2.SessionManager
 * 
 **/
public interface _SessionOperationsNC extends Glacier2._SessionOperationsNC
{
    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     * 
     * @see Registry#getSessionTimeout
     * 
     **/
    void keepAlive();

    /**
     * Allocate an object. Depending on the allocation timeout, this
     * operation might hang until the object is available or until the
     * timeout is reached.
     * 
     * @param __cb The callback object for the operation.
     * @param id The identity of the object to allocate.
     * 
     **/
    void allocateObjectById_async(AMD_Session_allocateObjectById __cb, Ice.Identity id)
        throws AllocationException,
               ObjectNotRegisteredException;

    /**
     * Allocate an object with the given type. Depending on the
     * allocation timeout, this operation can block until an object
     * becomes available or until the timeout is reached.
     * 
     * @param __cb The callback object for the operation.
     * @param type The type of the object.
     * 
     **/
    void allocateObjectByType_async(AMD_Session_allocateObjectByType __cb, String type)
        throws AllocationException;

    /**
     * Release an object.
     * 
     * @param id The identity of the object to release.
     * 
     * @throws ObjectNotRegisteredException Raised if the object with
     * the given identity is not registered with the registry.
     * 
     * @throws AllocationException Raised if the given object can't be
     * released. This might happen if the object isn't allocatable or
     * isn't allocated by the session.
     * 
     * @see #allocateObjectById
     * @see #allocateObjectByType
     * 
     **/
    void releaseObject(Ice.Identity id)
        throws AllocationException,
               ObjectNotRegisteredException;

    /**
     * Set the allocation timeout. If no objects are available for an
     * allocation request, the request will hang for the duration of 
     * this timeout.
     * 
     * @param timeout The timeout in milliseconds.
     * 
     * @see #allocateObjectById
     * @see #allocateObjectByType
     * 
     **/
    void setAllocationTimeout(int timeout);
}
