// **********************************************************************
//
// Copyright (c) 2003-2010 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************

// Ice version 3.4.1

package IceStorm;

// <auto-generated>
//
// Generated from file `IceStorm.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>


/**
 * A topic manager manages topics, and subscribers to topics.
 * 
 * @see Topic
 * 
 **/
public final class TopicManagerPrxHelper extends Ice.ObjectPrxHelperBase implements TopicManagerPrx
{
    /**
     * Create a new topic. The topic name must be unique, otherwise
     * {@link TopicExists} is raised.
     * 
     * @param name The name of the topic.
     * 
     * @return A proxy to the topic instance.
     * 
     * @throws TopicExists Raised if a topic with the same name already
     * exists.
     * 
     **/
    public TopicPrx
    create(String name)
        throws TopicExists
    {
        return create(name, null, false);
    }

    /**
     * Create a new topic. The topic name must be unique, otherwise
     * {@link TopicExists} is raised.
     * 
     * @param name The name of the topic.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return A proxy to the topic instance.
     * 
     * @throws TopicExists Raised if a topic with the same name already
     * exists.
     * 
     **/
    public TopicPrx
    create(String name, java.util.Map<String, String> __ctx)
        throws TopicExists
    {
        return create(name, __ctx, true);
    }

    private TopicPrx
    create(String name, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws TopicExists
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("create");
                __delBase = __getDelegate(false);
                _TopicManagerDel __del = (_TopicManagerDel)__delBase;
                return __del.create(name, __ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __handleExceptionWrapper(__delBase, __ex);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __create_name = "create";

    /**
     * Create a new topic. The topic name must be unique, otherwise
     * {@link TopicExists} is raised.
     * 
     * @param __cb The callback object for the operation.
     * @param name The name of the topic.
     * 
     **/
    public Ice.AsyncResult begin_create(String name)
    {
        return begin_create(name, null, false, null);
    }

    /**
     * Create a new topic. The topic name must be unique, otherwise
     * {@link TopicExists} is raised.
     * 
     * @param __cb The callback object for the operation.
     * @param name The name of the topic.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_create(String name, java.util.Map<String, String> __ctx)
    {
        return begin_create(name, __ctx, true, null);
    }

    /**
     * Create a new topic. The topic name must be unique, otherwise
     * {@link TopicExists} is raised.
     * 
     * @param __cb The callback object for the operation.
     * @param name The name of the topic.
     * 
     **/
    public Ice.AsyncResult begin_create(String name, Ice.Callback __cb)
    {
        return begin_create(name, null, false, __cb);
    }

    /**
     * Create a new topic. The topic name must be unique, otherwise
     * {@link TopicExists} is raised.
     * 
     * @param __cb The callback object for the operation.
     * @param name The name of the topic.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_create(String name, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_create(name, __ctx, true, __cb);
    }

    /**
     * Create a new topic. The topic name must be unique, otherwise
     * {@link TopicExists} is raised.
     * 
     * @param __cb The callback object for the operation.
     * @param name The name of the topic.
     * 
     **/
    public Ice.AsyncResult begin_create(String name, Callback_TopicManager_create __cb)
    {
        return begin_create(name, null, false, __cb);
    }

    /**
     * Create a new topic. The topic name must be unique, otherwise
     * {@link TopicExists} is raised.
     * 
     * @param __cb The callback object for the operation.
     * @param name The name of the topic.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_create(String name, java.util.Map<String, String> __ctx, Callback_TopicManager_create __cb)
    {
        return begin_create(name, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_create(String name, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__create_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __create_name, __cb);
        try
        {
            __result.__prepare(__create_name, Ice.OperationMode.Normal, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.writeString(name);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) A proxy to the topic instance.
     * 
     **/
    public TopicPrx end_create(Ice.AsyncResult __result)
        throws TopicExists
    {
        Ice.AsyncResult.__check(__result, this, __create_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(TopicExists __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        TopicPrx __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = TopicPrxHelper.__read(__is);
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Returns the checksums for the IceStorm Slice definitions.
     * 
     * @return A dictionary mapping Slice type ids to their checksums.
     * 
     **/
    public java.util.Map<java.lang.String, java.lang.String>
    getSliceChecksums()
    {
        return getSliceChecksums(null, false);
    }

    /**
     * Returns the checksums for the IceStorm Slice definitions.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return A dictionary mapping Slice type ids to their checksums.
     * 
     **/
    public java.util.Map<java.lang.String, java.lang.String>
    getSliceChecksums(java.util.Map<String, String> __ctx)
    {
        return getSliceChecksums(__ctx, true);
    }

    private java.util.Map<java.lang.String, java.lang.String>
    getSliceChecksums(java.util.Map<String, String> __ctx, boolean __explicitCtx)
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("getSliceChecksums");
                __delBase = __getDelegate(false);
                _TopicManagerDel __del = (_TopicManagerDel)__delBase;
                return __del.getSliceChecksums(__ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __getSliceChecksums_name = "getSliceChecksums";

    /**
     * Returns the checksums for the IceStorm Slice definitions.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getSliceChecksums()
    {
        return begin_getSliceChecksums(null, false, null);
    }

    /**
     * Returns the checksums for the IceStorm Slice definitions.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getSliceChecksums(java.util.Map<String, String> __ctx)
    {
        return begin_getSliceChecksums(__ctx, true, null);
    }

    /**
     * Returns the checksums for the IceStorm Slice definitions.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getSliceChecksums(Ice.Callback __cb)
    {
        return begin_getSliceChecksums(null, false, __cb);
    }

    /**
     * Returns the checksums for the IceStorm Slice definitions.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getSliceChecksums(java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_getSliceChecksums(__ctx, true, __cb);
    }

    /**
     * Returns the checksums for the IceStorm Slice definitions.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_getSliceChecksums(Callback_TopicManager_getSliceChecksums __cb)
    {
        return begin_getSliceChecksums(null, false, __cb);
    }

    /**
     * Returns the checksums for the IceStorm Slice definitions.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_getSliceChecksums(java.util.Map<String, String> __ctx, Callback_TopicManager_getSliceChecksums __cb)
    {
        return begin_getSliceChecksums(__ctx, true, __cb);
    }

    private Ice.AsyncResult begin_getSliceChecksums(java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__getSliceChecksums_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __getSliceChecksums_name, __cb);
        try
        {
            __result.__prepare(__getSliceChecksums_name, Ice.OperationMode.Idempotent, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) A dictionary mapping Slice type ids to their checksums.
     * 
     **/
    public java.util.Map<java.lang.String, java.lang.String> end_getSliceChecksums(Ice.AsyncResult __result)
    {
        Ice.AsyncResult.__check(__result, this, __getSliceChecksums_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        java.util.Map<java.lang.String, java.lang.String> __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = Ice.SliceChecksumDictHelper.read(__is);
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Retrieve a topic by name.
     * 
     * @param name The name of the topic.
     * 
     * @return A proxy to the topic instance.
     * 
     * @throws NoSuchTopic Raised if the topic does not exist.
     * 
     **/
    public TopicPrx
    retrieve(String name)
        throws NoSuchTopic
    {
        return retrieve(name, null, false);
    }

    /**
     * Retrieve a topic by name.
     * 
     * @param name The name of the topic.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return A proxy to the topic instance.
     * 
     * @throws NoSuchTopic Raised if the topic does not exist.
     * 
     **/
    public TopicPrx
    retrieve(String name, java.util.Map<String, String> __ctx)
        throws NoSuchTopic
    {
        return retrieve(name, __ctx, true);
    }

    private TopicPrx
    retrieve(String name, java.util.Map<String, String> __ctx, boolean __explicitCtx)
        throws NoSuchTopic
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("retrieve");
                __delBase = __getDelegate(false);
                _TopicManagerDel __del = (_TopicManagerDel)__delBase;
                return __del.retrieve(name, __ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __retrieve_name = "retrieve";

    /**
     * Retrieve a topic by name.
     * 
     * @param __cb The callback object for the operation.
     * @param name The name of the topic.
     * 
     **/
    public Ice.AsyncResult begin_retrieve(String name)
    {
        return begin_retrieve(name, null, false, null);
    }

    /**
     * Retrieve a topic by name.
     * 
     * @param __cb The callback object for the operation.
     * @param name The name of the topic.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_retrieve(String name, java.util.Map<String, String> __ctx)
    {
        return begin_retrieve(name, __ctx, true, null);
    }

    /**
     * Retrieve a topic by name.
     * 
     * @param __cb The callback object for the operation.
     * @param name The name of the topic.
     * 
     **/
    public Ice.AsyncResult begin_retrieve(String name, Ice.Callback __cb)
    {
        return begin_retrieve(name, null, false, __cb);
    }

    /**
     * Retrieve a topic by name.
     * 
     * @param __cb The callback object for the operation.
     * @param name The name of the topic.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_retrieve(String name, java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_retrieve(name, __ctx, true, __cb);
    }

    /**
     * Retrieve a topic by name.
     * 
     * @param __cb The callback object for the operation.
     * @param name The name of the topic.
     * 
     **/
    public Ice.AsyncResult begin_retrieve(String name, Callback_TopicManager_retrieve __cb)
    {
        return begin_retrieve(name, null, false, __cb);
    }

    /**
     * Retrieve a topic by name.
     * 
     * @param __cb The callback object for the operation.
     * @param name The name of the topic.
     * 
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_retrieve(String name, java.util.Map<String, String> __ctx, Callback_TopicManager_retrieve __cb)
    {
        return begin_retrieve(name, __ctx, true, __cb);
    }

    private Ice.AsyncResult begin_retrieve(String name, java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__retrieve_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __retrieve_name, __cb);
        try
        {
            __result.__prepare(__retrieve_name, Ice.OperationMode.Idempotent, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.writeString(name);
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) A proxy to the topic instance.
     * 
     **/
    public TopicPrx end_retrieve(Ice.AsyncResult __result)
        throws NoSuchTopic
    {
        Ice.AsyncResult.__check(__result, this, __retrieve_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(NoSuchTopic __ex)
            {
                throw __ex;
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        TopicPrx __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = TopicPrxHelper.__read(__is);
        __is.endReadEncaps();
        return __ret;
    }

    /**
     * Retrieve all topics managed by this topic manager.
     * 
     * @return A dictionary of string, topic proxy pairs.
     * 
     **/
    public java.util.Map<java.lang.String, TopicPrx>
    retrieveAll()
    {
        return retrieveAll(null, false);
    }

    /**
     * Retrieve all topics managed by this topic manager.
     * 
     * @param __ctx The Context map to send with the invocation.
     * @return A dictionary of string, topic proxy pairs.
     * 
     **/
    public java.util.Map<java.lang.String, TopicPrx>
    retrieveAll(java.util.Map<String, String> __ctx)
    {
        return retrieveAll(__ctx, true);
    }

    private java.util.Map<java.lang.String, TopicPrx>
    retrieveAll(java.util.Map<String, String> __ctx, boolean __explicitCtx)
    {
        if(__explicitCtx && __ctx == null)
        {
            __ctx = _emptyContext;
        }
        int __cnt = 0;
        while(true)
        {
            Ice._ObjectDel __delBase = null;
            try
            {
                __checkTwowayOnly("retrieveAll");
                __delBase = __getDelegate(false);
                _TopicManagerDel __del = (_TopicManagerDel)__delBase;
                return __del.retrieveAll(__ctx);
            }
            catch(IceInternal.LocalExceptionWrapper __ex)
            {
                __cnt = __handleExceptionWrapperRelaxed(__delBase, __ex, null, __cnt);
            }
            catch(Ice.LocalException __ex)
            {
                __cnt = __handleException(__delBase, __ex, null, __cnt);
            }
        }
    }

    private static final String __retrieveAll_name = "retrieveAll";

    /**
     * Retrieve all topics managed by this topic manager.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_retrieveAll()
    {
        return begin_retrieveAll(null, false, null);
    }

    /**
     * Retrieve all topics managed by this topic manager.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_retrieveAll(java.util.Map<String, String> __ctx)
    {
        return begin_retrieveAll(__ctx, true, null);
    }

    /**
     * Retrieve all topics managed by this topic manager.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_retrieveAll(Ice.Callback __cb)
    {
        return begin_retrieveAll(null, false, __cb);
    }

    /**
     * Retrieve all topics managed by this topic manager.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_retrieveAll(java.util.Map<String, String> __ctx, Ice.Callback __cb)
    {
        return begin_retrieveAll(__ctx, true, __cb);
    }

    /**
     * Retrieve all topics managed by this topic manager.
     * 
     * @param __cb The callback object for the operation.
     **/
    public Ice.AsyncResult begin_retrieveAll(Callback_TopicManager_retrieveAll __cb)
    {
        return begin_retrieveAll(null, false, __cb);
    }

    /**
     * Retrieve all topics managed by this topic manager.
     * 
     * @param __cb The callback object for the operation.
     * @param __ctx The Context map to send with the invocation.
     **/
    public Ice.AsyncResult begin_retrieveAll(java.util.Map<String, String> __ctx, Callback_TopicManager_retrieveAll __cb)
    {
        return begin_retrieveAll(__ctx, true, __cb);
    }

    private Ice.AsyncResult begin_retrieveAll(java.util.Map<String, String> __ctx, boolean __explicitCtx, IceInternal.CallbackBase __cb)
    {
        __checkAsyncTwowayOnly(__retrieveAll_name);
        IceInternal.OutgoingAsync __result = new IceInternal.OutgoingAsync(this, __retrieveAll_name, __cb);
        try
        {
            __result.__prepare(__retrieveAll_name, Ice.OperationMode.Idempotent, __ctx, __explicitCtx);
            IceInternal.BasicStream __os = __result.__os();
            __os.endWriteEncaps();
            __result.__send(true);
        }
        catch(Ice.LocalException __ex)
        {
            __result.__exceptionAsync(__ex);
        }
        return __result;
    }

    /**
     * ice_response indicates that
     * the operation completed successfully.
     * @param __ret (return value) A dictionary of string, topic proxy pairs.
     * 
     **/
    public java.util.Map<java.lang.String, TopicPrx> end_retrieveAll(Ice.AsyncResult __result)
    {
        Ice.AsyncResult.__check(__result, this, __retrieveAll_name);
        if(!__result.__wait())
        {
            try
            {
                __result.__throwUserException();
            }
            catch(Ice.UserException __ex)
            {
                throw new Ice.UnknownUserException(__ex.ice_name());
            }
        }
        java.util.Map<java.lang.String, TopicPrx> __ret;
        IceInternal.BasicStream __is = __result.__is();
        __is.startReadEncaps();
        __ret = TopicDictHelper.read(__is);
        __is.endReadEncaps();
        return __ret;
    }

    public static TopicManagerPrx
    checkedCast(Ice.ObjectPrx __obj)
    {
        TopicManagerPrx __d = null;
        if(__obj != null)
        {
            try
            {
                __d = (TopicManagerPrx)__obj;
            }
            catch(ClassCastException ex)
            {
                if(__obj.ice_isA("::IceStorm::TopicManager"))
                {
                    TopicManagerPrxHelper __h = new TopicManagerPrxHelper();
                    __h.__copyFrom(__obj);
                    __d = __h;
                }
            }
        }
        return __d;
    }

    public static TopicManagerPrx
    checkedCast(Ice.ObjectPrx __obj, java.util.Map<String, String> __ctx)
    {
        TopicManagerPrx __d = null;
        if(__obj != null)
        {
            try
            {
                __d = (TopicManagerPrx)__obj;
            }
            catch(ClassCastException ex)
            {
                if(__obj.ice_isA("::IceStorm::TopicManager", __ctx))
                {
                    TopicManagerPrxHelper __h = new TopicManagerPrxHelper();
                    __h.__copyFrom(__obj);
                    __d = __h;
                }
            }
        }
        return __d;
    }

    public static TopicManagerPrx
    checkedCast(Ice.ObjectPrx __obj, String __facet)
    {
        TopicManagerPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            try
            {
                if(__bb.ice_isA("::IceStorm::TopicManager"))
                {
                    TopicManagerPrxHelper __h = new TopicManagerPrxHelper();
                    __h.__copyFrom(__bb);
                    __d = __h;
                }
            }
            catch(Ice.FacetNotExistException ex)
            {
            }
        }
        return __d;
    }

    public static TopicManagerPrx
    checkedCast(Ice.ObjectPrx __obj, String __facet, java.util.Map<String, String> __ctx)
    {
        TopicManagerPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            try
            {
                if(__bb.ice_isA("::IceStorm::TopicManager", __ctx))
                {
                    TopicManagerPrxHelper __h = new TopicManagerPrxHelper();
                    __h.__copyFrom(__bb);
                    __d = __h;
                }
            }
            catch(Ice.FacetNotExistException ex)
            {
            }
        }
        return __d;
    }

    public static TopicManagerPrx
    uncheckedCast(Ice.ObjectPrx __obj)
    {
        TopicManagerPrx __d = null;
        if(__obj != null)
        {
            try
            {
                __d = (TopicManagerPrx)__obj;
            }
            catch(ClassCastException ex)
            {
                TopicManagerPrxHelper __h = new TopicManagerPrxHelper();
                __h.__copyFrom(__obj);
                __d = __h;
            }
        }
        return __d;
    }

    public static TopicManagerPrx
    uncheckedCast(Ice.ObjectPrx __obj, String __facet)
    {
        TopicManagerPrx __d = null;
        if(__obj != null)
        {
            Ice.ObjectPrx __bb = __obj.ice_facet(__facet);
            TopicManagerPrxHelper __h = new TopicManagerPrxHelper();
            __h.__copyFrom(__bb);
            __d = __h;
        }
        return __d;
    }

    protected Ice._ObjectDelM
    __createDelegateM()
    {
        return new _TopicManagerDelM();
    }

    protected Ice._ObjectDelD
    __createDelegateD()
    {
        return new _TopicManagerDelD();
    }

    public static void
    __write(IceInternal.BasicStream __os, TopicManagerPrx v)
    {
        __os.writeProxy(v);
    }

    public static TopicManagerPrx
    __read(IceInternal.BasicStream __is)
    {
        Ice.ObjectPrx proxy = __is.readProxy();
        if(proxy != null)
        {
            TopicManagerPrxHelper result = new TopicManagerPrxHelper();
            result.__copyFrom(proxy);
            return result;
        }
        return null;
    }
}
