/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.support;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.Addressing;
import javax.xml.ws.soap.AddressingFeature;
import javax.xml.ws.soap.MTOMFeature;
import javax.xml.ws.soap.SOAPBinding;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.SoapBinding;
import org.apache.cxf.binding.soap.saaj.SAAJInInterceptor;
import org.apache.cxf.binding.soap.saaj.SAAJOutInterceptor;
import org.apache.cxf.binding.xml.XMLBinding;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.endpoint.EndpointImpl;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.interceptor.AbstractInDatabindingInterceptor;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.jaxws.binding.DefaultBindingImpl;
import org.apache.cxf.jaxws.binding.http.HTTPBindingImpl;
import org.apache.cxf.jaxws.binding.soap.SOAPBindingImpl;
import org.apache.cxf.jaxws.handler.logical.LogicalHandlerFaultInInterceptor;
import org.apache.cxf.jaxws.handler.logical.LogicalHandlerFaultOutInterceptor;
import org.apache.cxf.jaxws.handler.logical.LogicalHandlerInInterceptor;
import org.apache.cxf.jaxws.handler.logical.LogicalHandlerOutInterceptor;
import org.apache.cxf.jaxws.handler.soap.SOAPHandlerFaultInInterceptor;
import org.apache.cxf.jaxws.handler.soap.SOAPHandlerFaultOutInterceptor;
import org.apache.cxf.jaxws.handler.soap.SOAPHandlerInterceptor;
import org.apache.cxf.jaxws.interceptors.HolderInInterceptor;
import org.apache.cxf.jaxws.interceptors.HolderOutInterceptor;
import org.apache.cxf.jaxws.interceptors.MessageModeInInterceptor;
import org.apache.cxf.jaxws.interceptors.MessageModeOutInterceptor;
import org.apache.cxf.jaxws.interceptors.SwAInInterceptor;
import org.apache.cxf.jaxws.interceptors.SwAOutInterceptor;
import org.apache.cxf.jaxws.interceptors.WrapperClassInInterceptor;
import org.apache.cxf.jaxws.interceptors.WrapperClassOutInterceptor;
import org.apache.cxf.jaxws.support.JaxWsImplementorInfo;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.ws.addressing.JAXWSAConstants;
import org.apache.cxf.ws.addressing.WSAddressingFeature;
import org.apache.cxf.wsdl.WSDLManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxWsEndpointImpl
extends EndpointImpl {
    private javax.xml.ws.Binding jaxwsBinding;
    private JaxWsImplementorInfo implInfo;
    private List<WebServiceFeature> wsFeatures;
    private List<AbstractFeature> features;
    private SOAPHandlerInterceptor soapHandlerInterceptor;
    private LogicalHandlerInInterceptor logicalInInterceptor;
    private LogicalHandlerOutInterceptor logicalOutInterceptor;
    private LogicalHandlerFaultOutInterceptor logicalFaultOutInterceptor;
    private SOAPHandlerFaultOutInterceptor soapFaultOutInterceptor;
    private LogicalHandlerFaultInInterceptor logicalFaultInInterceptor;
    private SOAPHandlerFaultInInterceptor soapFaultInInterceptor;

    public JaxWsEndpointImpl(Bus bus, Service s, EndpointInfo ei) throws EndpointException {
        this(bus, s, ei, null, null, null, true);
    }

    public JaxWsEndpointImpl(Bus bus, Service s, EndpointInfo ei, List<WebServiceFeature> wf) throws EndpointException {
        this(bus, s, ei, null, wf, new ArrayList<AbstractFeature>(), true);
    }

    public JaxWsEndpointImpl(Bus bus, Service s, EndpointInfo ei, JaxWsImplementorInfo implementorInfo, List<WebServiceFeature> wf, List<AbstractFeature> af, boolean isFromWsdl) throws EndpointException {
        super(bus, s, ei);
        Service.Mode mode;
        this.implInfo = implementorInfo;
        this.wsFeatures = wf;
        this.features = af;
        if (this.features == null) {
            this.features = new ArrayList<AbstractFeature>();
        }
        this.createJaxwsBinding();
        List<Interceptor> in = super.getInInterceptors();
        List<Interceptor> out = super.getOutInterceptors();
        boolean isProvider = this.implInfo != null && this.implInfo.isWebServiceProvider();
        Class<?> clazz = this.implInfo != null && isProvider ? this.implInfo.getProviderParameterType() : null;
        Service.Mode mode2 = mode = this.implInfo != null && isProvider ? this.implInfo.getServiceMode() : null;
        if (isProvider) {
            s.put(AbstractInDatabindingInterceptor.NO_VALIDATE_PARTS, Boolean.TRUE);
        }
        this.logicalInInterceptor = new LogicalHandlerInInterceptor(this.jaxwsBinding);
        if (!isProvider) {
            in.add(new WrapperClassInInterceptor());
            in.add(new HolderInInterceptor());
        }
        if (this.getBinding() instanceof SoapBinding) {
            this.soapHandlerInterceptor = new SOAPHandlerInterceptor(this.jaxwsBinding);
            in.add(new SwAInInterceptor());
            this.getOutInterceptors().add(new SwAOutInterceptor());
            if (isProvider && mode == Service.Mode.MESSAGE) {
                in.add(new SAAJInInterceptor());
            }
        }
        if (isProvider && mode == Service.Mode.MESSAGE) {
            in.add(new MessageModeInInterceptor(clazz, this.getBinding().getBindingInfo().getName()));
        }
        this.logicalOutInterceptor = new LogicalHandlerOutInterceptor(this.jaxwsBinding);
        if (!isProvider) {
            out.add(new WrapperClassOutInterceptor());
            out.add(new HolderOutInterceptor());
        }
        if (this.getBinding() instanceof SoapBinding && mode == Service.Mode.MESSAGE) {
            SAAJOutInterceptor saajOut = new SAAJOutInterceptor();
            out.add(saajOut);
            out.add(new MessageModeOutInterceptor(saajOut, this.getBinding().getBindingInfo().getName()));
        } else if (isProvider) {
            out.add(new MessageModeOutInterceptor(clazz, this.getBinding().getBindingInfo().getName()));
        }
        this.logicalFaultOutInterceptor = new LogicalHandlerFaultOutInterceptor(this.jaxwsBinding);
        this.logicalFaultInInterceptor = new LogicalHandlerFaultInInterceptor(this.jaxwsBinding);
        if (this.getBinding() instanceof SoapBinding) {
            this.soapFaultOutInterceptor = new SOAPHandlerFaultOutInterceptor(this.jaxwsBinding);
            this.soapFaultInInterceptor = new SOAPHandlerFaultInInterceptor(this.jaxwsBinding);
        }
        if (ei != null) {
            if (!isFromWsdl) {
                this.buildWsdlExtensibilities(ei.getBinding());
            }
            this.extractWsdlExtensibilities(ei);
        }
        this.resolveFeatures();
    }

    private void extractWsdlExtensibilities(EndpointInfo endpoint) {
        List<ExtensibilityElement> bindingExtensors = endpoint.getBinding().getExtensors(ExtensibilityElement.class);
        List<ExtensibilityElement> portExtensors = endpoint.getExtensors(ExtensibilityElement.class);
        if (this.hasUsingAddressing(bindingExtensors) || this.hasUsingAddressing(portExtensors)) {
            WSAddressingFeature feature = new WSAddressingFeature();
            if (this.addressingRequired(bindingExtensors) || this.addressingRequired(portExtensors)) {
                feature.setAddressingRequired(true);
            }
            this.addAddressingFeature(feature);
        }
    }

    private boolean hasUsingAddressing(List<ExtensibilityElement> exts) {
        boolean found = false;
        if (exts != null) {
            Iterator<ExtensibilityElement> extensionElements = exts.iterator();
            while (extensionElements.hasNext() && !found) {
                ExtensibilityElement ext = extensionElements.next();
                found = JAXWSAConstants.WSAW_USINGADDRESSING_QNAME.equals(ext.getElementType());
            }
        }
        return found;
    }

    private boolean addressingRequired(List<ExtensibilityElement> exts) {
        boolean found = false;
        if (exts != null) {
            Iterator<ExtensibilityElement> extensionElements = exts.iterator();
            while (extensionElements.hasNext() && !found) {
                ExtensibilityElement ext = extensionElements.next();
                if (!JAXWSAConstants.WSAW_USINGADDRESSING_QNAME.equals(ext.getElementType()) || ext.getRequired() == null) continue;
                return ext.getRequired();
            }
        }
        return false;
    }

    private void buildWsdlExtensibilities(BindingInfo bindingInfo) {
        Addressing addressing = this.getAddressing();
        if (addressing != null) {
            ExtensionRegistry extensionRegistry = this.getBus().getExtension(WSDLManager.class).getExtensionRegistry();
            try {
                ExtensibilityElement el = extensionRegistry.createExtension(Binding.class, JAXWSAConstants.WSAW_USINGADDRESSING_QNAME);
                el.setRequired(Boolean.valueOf(addressing.required()));
                bindingInfo.addExtensor(el);
            }
            catch (WSDLException e) {
                e.printStackTrace();
            }
        }
    }

    private Addressing getAddressing() {
        Class<?> serviceClass = this.implInfo.getSEIClass();
        if (serviceClass == null) {
            serviceClass = this.implInfo.getImplementorClass();
        }
        if (serviceClass == null) {
            return null;
        }
        return serviceClass.getAnnotation(Addressing.class);
    }

    public javax.xml.ws.Binding getJaxwsBinding() {
        return this.jaxwsBinding;
    }

    private AddressingFeature getAddressingFeature() {
        if (this.wsFeatures == null) {
            return null;
        }
        for (WebServiceFeature feature : this.wsFeatures) {
            if (!(feature instanceof AddressingFeature)) continue;
            return (AddressingFeature)feature;
        }
        return null;
    }

    public final void resolveFeatures() {
        AddressingFeature addressing = this.getAddressingFeature();
        if (addressing == null) {
            return;
        }
        if (addressing.isEnabled()) {
            WSAddressingFeature feature = this.getWSAddressingFeature();
            if (feature == null) {
                feature = new WSAddressingFeature();
                this.addAddressingFeature(feature);
            }
            feature.setAddressingRequired(addressing.isRequired());
        } else {
            this.removeAddressingFeature();
        }
    }

    public List<AbstractFeature> getFeatures() {
        return this.features;
    }

    private WSAddressingFeature getWSAddressingFeature() {
        if (this.features == null) {
            return null;
        }
        for (AbstractFeature f : this.features) {
            if (!(f instanceof WSAddressingFeature)) continue;
            return (WSAddressingFeature)f;
        }
        return null;
    }

    private void addAddressingFeature(AbstractFeature a) {
        WSAddressingFeature f = this.getWSAddressingFeature();
        if (f == null) {
            this.features.add(a);
        }
    }

    private void removeAddressingFeature() {
        WSAddressingFeature f = this.getWSAddressingFeature();
        if (f != null) {
            this.features.remove(f);
        }
    }

    private MTOMFeature getMTOMFeature() {
        if (this.wsFeatures == null) {
            return null;
        }
        for (WebServiceFeature feature : this.wsFeatures) {
            if (!(feature instanceof MTOMFeature)) continue;
            return (MTOMFeature)feature;
        }
        return null;
    }

    final void createJaxwsBinding() {
        if (this.getBinding() instanceof SoapBinding) {
            this.jaxwsBinding = new SOAPBindingImpl(this.getEndpointInfo().getBinding(), this);
            MTOMFeature mtomFeature = this.getMTOMFeature();
            if (mtomFeature != null && mtomFeature.isEnabled()) {
                ((SOAPBinding)this.jaxwsBinding).setMTOMEnabled(true);
            }
        } else {
            this.jaxwsBinding = this.getBinding() instanceof XMLBinding ? new HTTPBindingImpl(this.getEndpointInfo().getBinding(), this) : new DefaultBindingImpl(this);
        }
    }

    public void addHandlerInterceptors() {
        List<Interceptor> in = super.getInInterceptors();
        List<Interceptor> out = super.getOutInterceptors();
        List<Interceptor> outFault = super.getOutFaultInterceptors();
        List<Interceptor> inFault = super.getInFaultInterceptors();
        in.add(this.logicalInInterceptor);
        out.add(this.logicalOutInterceptor);
        inFault.add(this.logicalFaultInInterceptor);
        outFault.add(this.logicalFaultOutInterceptor);
        if (this.soapHandlerInterceptor != null) {
            in.add(this.soapHandlerInterceptor);
            out.add(this.soapHandlerInterceptor);
        }
        if (this.soapFaultInInterceptor != null) {
            inFault.add(this.soapFaultInInterceptor);
        }
        if (this.soapFaultOutInterceptor != null) {
            outFault.add(this.soapFaultOutInterceptor);
        }
    }

    public void removeHandlerInterceptors() {
        List<Interceptor> in = super.getInInterceptors();
        List<Interceptor> out = super.getOutInterceptors();
        List<Interceptor> outFault = super.getOutFaultInterceptors();
        List<Interceptor> inFault = super.getInFaultInterceptors();
        in.remove(this.logicalInInterceptor);
        out.remove(this.logicalOutInterceptor);
        inFault.remove(this.logicalFaultInInterceptor);
        outFault.remove(this.logicalFaultOutInterceptor);
        if (this.soapHandlerInterceptor != null) {
            in.remove(this.soapHandlerInterceptor);
            out.remove(this.soapHandlerInterceptor);
        }
        if (this.soapFaultInInterceptor != null) {
            inFault.remove(this.soapFaultInInterceptor);
        }
        if (this.soapFaultOutInterceptor != null) {
            outFault.remove(this.soapFaultOutInterceptor);
        }
    }
}

