/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday.unmarshalling;

import java.io.InputStream;
import java.net.URL;
import org.jboss.logging.Logger;
import org.jboss.util.xml.JBossEntityResolver;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
import org.jboss.xb.binding.sunday.unmarshalling.XsdBinder;
import org.xml.sax.InputSource;

public class DefaultSchemaResolver
implements SchemaBindingResolver {
    private static Logger log = Logger.getLogger(DefaultSchemaResolver.class);
    private String baseURI;
    private JBossEntityResolver resolver;

    public DefaultSchemaResolver() {
        this(new JBossEntityResolver());
    }

    public DefaultSchemaResolver(JBossEntityResolver resolver) {
        this.resolver = resolver;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    public SchemaBinding resolve(String nsUri, String localName, String baseURI, String schemaLocation) {
        InputSource is;
        block15: {
            boolean trace;
            block13: {
                trace = log.isTraceEnabled();
                is = null;
                try {
                    is = this.resolver.resolveEntity(null, nsUri);
                }
                catch (Exception e) {
                    if (!trace) break block13;
                    log.trace("Failed to use nsUri as systemID", e);
                }
            }
            if (is == null && schemaLocation != null) {
                block14: {
                    try {
                        is = this.resolver.resolveEntity(null, schemaLocation);
                    }
                    catch (Exception e) {
                        if (!trace) break block14;
                        log.trace("Failed to use schemaLocation as systemID", e);
                    }
                }
                if (is == null) {
                    URL schemaURL = null;
                    try {
                        if (baseURI == null) {
                            baseURI = this.baseURI;
                        }
                        if (baseURI != null) {
                            URL baseURL = new URL(baseURI);
                            schemaURL = new URL(baseURL, schemaLocation);
                        } else {
                            schemaURL = new URL(schemaLocation);
                        }
                        if (schemaURL != null) {
                            InputStream is2 = schemaURL.openStream();
                            is = new InputSource(is2);
                        }
                    }
                    catch (Exception e) {
                        if (!trace) break block15;
                        log.trace("Failed to use schemaLocation as URL", e);
                    }
                }
            }
        }
        SchemaBinding schema = null;
        if (is != null) {
            schema = XsdBinder.bind(is.getByteStream(), null, baseURI);
        }
        return schema;
    }
}

