/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.db;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.hibernate.cfg.Configuration;
import org.jbpm.AbstractJbpmTestCase;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.db.ContextSession;
import org.jbpm.db.GraphSession;
import org.jbpm.db.JbpmSchema;
import org.jbpm.db.JobSession;
import org.jbpm.db.LoggingSession;
import org.jbpm.db.TaskMgmtSession;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.job.executor.JobExecutor;
import org.jbpm.logging.log.ProcessLog;
import org.jbpm.persistence.db.DbPersistenceServiceFactory;
import org.jbpm.taskmgmt.exe.TaskInstance;

public abstract class AbstractDbTestCase
extends AbstractJbpmTestCase {
    protected JbpmConfiguration jbpmConfiguration;
    protected JbpmContext jbpmContext;
    protected Session session;
    protected GraphSession graphSession;
    protected TaskMgmtSession taskMgmtSession;
    protected ContextSession contextSession;
    protected JobSession jobSession;
    protected LoggingSession loggingSession;
    protected JobExecutor jobExecutor;
    private static final Log log = LogFactory.getLog((Class)AbstractDbTestCase.class);

    protected void setUp() throws Exception {
        super.setUp();
        this.beginSessionTransaction();
    }

    protected void runTest() throws Throwable {
        try {
            super.runTest();
        }
        catch (Exception e) {
            this.jbpmContext.setRollbackOnly();
            throw e;
        }
    }

    protected void tearDown() throws Exception {
        this.commitAndCloseSession();
        this.ensureCleanDatabase();
        super.tearDown();
    }

    private void ensureCleanDatabase() {
        DbPersistenceServiceFactory persistenceServiceFactory = (DbPersistenceServiceFactory)this.getJbpmConfiguration().getServiceFactory("persistence");
        if (persistenceServiceFactory == null) {
            return;
        }
        boolean hasLeftOvers = false;
        Configuration configuration = persistenceServiceFactory.getConfiguration();
        JbpmSchema jbpmSchema = new JbpmSchema(configuration);
        Iterator i = jbpmSchema.getRowsPerTable().entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            Long count = (Long)entry.getValue();
            if (count.intValue() == 0) continue;
            hasLeftOvers = true;
            System.err.println("FIXME: " + ((Object)((Object)this)).getClass().getName() + "." + this.getName() + " left " + count + " records in " + entry.getKey());
        }
        if (hasLeftOvers) {
            jbpmSchema.cleanSchema();
        }
    }

    protected String getHibernateDialect() {
        DbPersistenceServiceFactory persistenceServiceFactory = (DbPersistenceServiceFactory)this.jbpmContext.getServiceFactory("persistence");
        return persistenceServiceFactory.getConfiguration().getProperty("hibernate.dialect");
    }

    protected void beginSessionTransaction() {
        this.createJbpmContext();
        this.initializeMembers();
    }

    protected void commitAndCloseSession() {
        this.closeJbpmContext();
        this.resetMembers();
    }

    protected void newTransaction() {
        this.commitAndCloseSession();
        this.beginSessionTransaction();
    }

    protected ProcessInstance saveAndReload(ProcessInstance pi) {
        this.jbpmContext.save(pi);
        this.newTransaction();
        return this.graphSession.loadProcessInstance(pi.getId());
    }

    protected TaskInstance saveAndReload(TaskInstance taskInstance) {
        this.jbpmContext.save(taskInstance);
        this.newTransaction();
        return (TaskInstance)this.session.load(TaskInstance.class, (Serializable)new Long(taskInstance.getId()));
    }

    protected ProcessDefinition saveAndReload(ProcessDefinition pd) {
        this.graphSession.saveProcessDefinition(pd);
        this.newTransaction();
        return this.graphSession.loadProcessDefinition(pd.getId());
    }

    protected ProcessLog saveAndReload(ProcessLog processLog) {
        this.loggingSession.saveProcessLog(processLog);
        this.newTransaction();
        return this.loggingSession.loadProcessLog(processLog.getId());
    }

    protected void createSchema() {
        this.getJbpmConfiguration().createSchema();
    }

    protected void cleanSchema() {
        this.getJbpmConfiguration().cleanSchema();
    }

    protected void dropSchema() {
        this.getJbpmConfiguration().dropSchema();
    }

    protected String getJbpmTestConfig() {
        return "org/jbpm/db/jbpm.db.test.cfg.xml";
    }

    protected JbpmConfiguration getJbpmConfiguration() {
        if (this.jbpmConfiguration == null) {
            String jbpmTestConfiguration = this.getJbpmTestConfig();
            this.jbpmConfiguration = JbpmConfiguration.getInstance(jbpmTestConfiguration);
        }
        return this.jbpmConfiguration;
    }

    protected void createJbpmContext() {
        this.jbpmContext = this.getJbpmConfiguration().createJbpmContext();
    }

    protected void closeJbpmContext() {
        if (this.jbpmContext != null) {
            this.jbpmContext.close();
            this.jbpmContext = null;
        }
    }

    protected void startJobExecutor() {
        this.jobExecutor = this.getJbpmConfiguration().getJobExecutor();
        this.jobExecutor.start();
    }

    protected void waitForJobs(long timeout) {
        int currentCount;
        long startTime = System.currentTimeMillis();
        int previousCount = 0;
        long previousTime = 0L;
        long waitPeriod = 500L;
        while ((currentCount = this.getNbrOfJobsAvailable()) > 0) {
            long currentTime = System.currentTimeMillis();
            long elapsedTime = currentTime - startTime;
            if (elapsedTime > timeout) {
                AbstractDbTestCase.fail((String)("test execution exceeded threshold of " + timeout + " ms"));
            }
            if (currentCount < previousCount) {
                waitPeriod = (long)currentCount * (currentTime - previousTime) / (long)(previousCount - currentCount);
                if (waitPeriod < 500L) {
                    waitPeriod = 500L;
                }
            } else {
                waitPeriod <<= 1;
            }
            if (waitPeriod > 5000L) {
                waitPeriod = 5000L;
            } else {
                long remainingTime = timeout - elapsedTime;
                if (waitPeriod > remainingTime) {
                    waitPeriod = remainingTime;
                }
            }
            log.debug((Object)("waiting " + waitPeriod + " ms for " + currentCount + " jobs to be executed"));
            try {
                Thread.sleep(waitPeriod);
            }
            catch (InterruptedException e) {
                AbstractDbTestCase.fail((String)"wait for jobs got interrupted");
            }
            previousCount = currentCount;
            previousTime = currentTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getNbrOfJobsAvailable() {
        if (this.session != null) {
            return this.getNbrOfJobsAvailable(this.session);
        }
        this.beginSessionTransaction();
        try {
            int n = this.getNbrOfJobsAvailable(this.session);
            return n;
        }
        finally {
            this.commitAndCloseSession();
        }
    }

    private int getNbrOfJobsAvailable(Session session) {
        Number jobs = (Number)session.createQuery("select count(*) from org.jbpm.job.Job").uniqueResult();
        return jobs.intValue();
    }

    protected int getTimerCount() {
        Number timerCount = (Number)this.session.createQuery("select count(*) from org.jbpm.job.Timer").uniqueResult();
        log.debug((Object)("there are " + timerCount + " timers in the database"));
        return timerCount.intValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processJobs(long maxWait) {
        this.commitAndCloseSession();
        try {
            this.startJobExecutor();
            this.waitForJobs(maxWait);
        }
        finally {
            this.stopJobExecutor();
            this.beginSessionTransaction();
        }
    }

    protected void stopJobExecutor() {
        if (this.jobExecutor != null) {
            try {
                this.jobExecutor.stopAndJoin();
            }
            catch (InterruptedException e) {
                log.debug((Object)"wait for job executor to stop and join got interrupted", (Throwable)e);
            }
        }
    }

    protected void initializeMembers() {
        this.session = this.jbpmContext.getSession();
        this.graphSession = this.jbpmContext.getGraphSession();
        this.taskMgmtSession = this.jbpmContext.getTaskMgmtSession();
        this.loggingSession = this.jbpmContext.getLoggingSession();
        this.jobSession = this.jbpmContext.getJobSession();
        this.contextSession = this.jbpmContext.getContextSession();
    }

    protected void resetMembers() {
        this.session = null;
        this.graphSession = null;
        this.taskMgmtSession = null;
        this.loggingSession = null;
        this.jobSession = null;
        this.contextSession = null;
    }
}

