/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.db.hibernate;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.jbpm.util.ClassLoaderUtil;

public class HibernateHelper {
    static Map configurations = new HashMap();
    private static Log log = LogFactory.getLog((Class)HibernateHelper.class);

    private HibernateHelper() {
    }

    public static void clearConfigurationsCache() {
        configurations.clear();
    }

    public static SessionFactory createSessionFactory() {
        return HibernateHelper.createSessionFactory(null, null, true);
    }

    public static SessionFactory createSessionFactory(String cfgXmlResource) {
        return HibernateHelper.createSessionFactory(cfgXmlResource, null, true);
    }

    public static SessionFactory createSessionFactory(String cfgXmlResource, String propertiesResource) {
        return HibernateHelper.createSessionFactory(cfgXmlResource, propertiesResource, true);
    }

    public static SessionFactory createSessionFactory(String cfgXmlResource, String propertiesResource, boolean isConfigLookupEnabled) {
        Configuration configuration = HibernateHelper.createConfiguration(cfgXmlResource, propertiesResource);
        return HibernateHelper.createSessionFactory(configuration, isConfigLookupEnabled);
    }

    public static SessionFactory createSessionFactory(Configuration configuration, boolean isConfigLookupEnabled) {
        SessionFactory sessionFactory = configuration.buildSessionFactory();
        if (isConfigLookupEnabled) {
            configurations.put(sessionFactory, configuration);
        }
        return sessionFactory;
    }

    public static Configuration createConfiguration(String cfgXmlResource, String propertiesResource) {
        Configuration configuration = new Configuration();
        if (cfgXmlResource != null) {
            log.debug((Object)("using hibernate configuration resource: " + cfgXmlResource));
            configuration.configure(cfgXmlResource);
        } else {
            log.debug((Object)"using default hibernate configuration resource: hibernate.cfg.xml");
            configuration.configure();
        }
        if (propertiesResource != null) {
            log.debug((Object)("using hibernate properties resource: " + propertiesResource));
            Properties properties = HibernateHelper.loadPropertiesFromResource(propertiesResource);
            if (!properties.isEmpty()) {
                configuration.setProperties(properties);
            }
        }
        return configuration;
    }

    public static Configuration getConfiguration(SessionFactory sessionFactory) {
        return (Configuration)configurations.get(sessionFactory);
    }

    public static SchemaExport createSchemaExport(SessionFactory sessionFactory) {
        return new SchemaExport(HibernateHelper.getConfiguration(sessionFactory));
    }

    public static boolean createSchemaExportScript(SessionFactory sessionFactory) {
        String showSql = HibernateHelper.getConfiguration(sessionFactory).getProperty("hibernate.show_sql");
        return "true".equalsIgnoreCase(showSql);
    }

    public static void clearHibernateCache(SessionFactory sessionFactory) {
        sessionFactory.evictQueries();
        Map classMetadata = sessionFactory.getAllClassMetadata();
        Iterator iter = classMetadata.keySet().iterator();
        while (iter.hasNext()) {
            String entityName = (String)iter.next();
            sessionFactory.evictEntity(entityName);
        }
        Map collectionMetadata = sessionFactory.getAllCollectionMetadata();
        Iterator iter2 = collectionMetadata.keySet().iterator();
        while (iter2.hasNext()) {
            String collectionName = (String)iter2.next();
            sessionFactory.evictCollection(collectionName);
        }
    }

    static Properties loadPropertiesFromResource(String resource) {
        Properties properties = new Properties();
        InputStream inputStream = ClassLoaderUtil.getStream(resource);
        if (inputStream != null) {
            try {
                properties.load(inputStream);
            }
            catch (IOException e) {
                log.warn((Object)("could not load hibernate properties from resource: " + resource), (Throwable)e);
            }
        } else {
            log.warn((Object)("hibernate properties resource not found: " + resource));
        }
        return properties;
    }
}

