/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;

public class OracleSql {
    boolean isV8Compatible = false;
    int current_argument;
    int i;
    int length;
    char c;
    boolean first;
    boolean in_string;
    String odbc_sql;
    StringBuffer oracle_sql = new StringBuffer(128);
    StringBuffer token_buffer = new StringBuffer(32);
    boolean isLocate = false;

    public synchronized String parse(String string) throws SQLException {
        this.current_argument = 1;
        this.i = 0;
        this.first = true;
        this.in_string = false;
        this.oracle_sql.ensureCapacity(this.length);
        this.oracle_sql.setLength(0);
        this.odbc_sql = string;
        this.length = this.odbc_sql.length();
        this.handleODBC();
        if (this.i < this.length) {
            Integer n = new Integer(this.i);
            DBError.check_error(33, n);
        }
        return this.oracle_sql.toString();
    }

    void handleODBC() throws SQLException {
        StringBuffer stringBuffer = null;
        StringBuffer stringBuffer2 = null;
        boolean bl = false;
        while (this.i < this.length) {
            this.c = this.odbc_sql.charAt(this.i);
            if (this.in_string) {
                this.oracle_sql.append(this.c);
                if (this.c == '\'') {
                    this.in_string = false;
                }
                ++this.i;
                continue;
            }
            switch (this.c) {
                case '\'': {
                    this.oracle_sql.append(this.c);
                    this.in_string = true;
                    ++this.i;
                    this.first = false;
                    break;
                }
                case '{': {
                    this.token_buffer.setLength(0);
                    ++this.i;
                    this.skipSpace();
                    while (this.i < this.length && (Character.isJavaLetterOrDigit(this.c = this.odbc_sql.charAt(this.i)) || this.c == '?')) {
                        this.token_buffer.append(this.c);
                        ++this.i;
                    }
                    this.handleToken(this.token_buffer.toString());
                    this.c = this.odbc_sql.charAt(this.i);
                    if (this.c != '}') {
                        String string = new String(this.i + ": Expecting \"}\" got \"" + this.c + "\"");
                        DBError.check_error(33, string);
                    }
                    ++this.i;
                    break;
                }
                case '}': {
                    return;
                }
                default: {
                    if (this.c != ' ' && this.c != '(' && this.isLocate) {
                        if (this.c == ')') {
                            this.oracle_sql.append(stringBuffer2);
                            this.oracle_sql.append(", ");
                            this.oracle_sql.append(stringBuffer);
                            this.appendChar(this.oracle_sql, this.c);
                            this.isLocate = false;
                        }
                        if (stringBuffer == null) {
                            stringBuffer = new StringBuffer();
                            stringBuffer2 = new StringBuffer();
                        }
                        if (this.c == ',') {
                            bl = true;
                            ++this.i;
                            this.first = false;
                            break;
                        }
                        if (!bl) {
                            stringBuffer.append(this.c);
                        } else {
                            stringBuffer2.append(this.c);
                        }
                    } else {
                        this.appendChar(this.oracle_sql, this.c);
                    }
                    ++this.i;
                    this.first = false;
                }
            }
        }
    }

    void handleToken(String string) throws SQLException {
        if (string.equalsIgnoreCase("?")) {
            this.handleFunction();
        } else if (string.equalsIgnoreCase("call")) {
            this.handleCall();
        } else if (string.equalsIgnoreCase("ts")) {
            this.handleTimestamp();
        } else if (string.equalsIgnoreCase("t")) {
            this.handleTime();
        } else if (string.equalsIgnoreCase("d")) {
            this.handleDate();
        } else if (string.equalsIgnoreCase("escape")) {
            this.handleEscape();
        } else if (string.equalsIgnoreCase("fn")) {
            this.handleScalarFunction();
        } else if (string.equalsIgnoreCase("oj")) {
            this.handleOuterJoin();
        } else {
            String string2 = new String(this.i + ": " + string);
            DBError.check_error(34, string2);
        }
    }

    void handleFunction() throws SQLException {
        String string;
        boolean bl = this.first;
        if (bl) {
            this.oracle_sql.append("BEGIN ");
        }
        this.appendChar(this.oracle_sql, '?');
        this.skipSpace();
        if (this.c != '=') {
            string = new String(this.i + ". Expecting \"=\" got \"" + this.c + "\"");
            DBError.check_error(33, string);
        }
        ++this.i;
        this.skipSpace();
        if (!this.odbc_sql.startsWith("call", this.i)) {
            string = new String(this.i + ". Expecting \"call\"");
            DBError.check_error(33, string);
        }
        this.i += 4;
        this.oracle_sql.append(" := ");
        this.skipSpace();
        this.handleODBC();
        if (bl) {
            this.oracle_sql.append("; END;");
        }
    }

    void handleCall() throws SQLException {
        boolean bl = this.first;
        if (bl) {
            this.oracle_sql.append("BEGIN ");
        }
        this.skipSpace();
        this.handleODBC();
        this.skipSpace();
        if (bl) {
            this.oracle_sql.append("; END;");
        }
    }

    void handleTimestamp() throws SQLException {
        if (this.isV8Compatible) {
            this.oracle_sql.append("TO_DATE (");
            this.skipSpace();
            boolean bl = false;
            while (this.i < this.length && (this.c = this.odbc_sql.charAt(this.i)) != '}') {
                if (!bl) {
                    if (this.c == '.') {
                        bl = true;
                    } else {
                        this.oracle_sql.append(this.c);
                    }
                }
                ++this.i;
            }
            if (bl) {
                this.oracle_sql.append('\'');
            }
            this.oracle_sql.append(", 'YYYY-MM-DD HH24:MI:SS')");
        } else {
            this.oracle_sql.append("TO_TIMESTAMP (");
            this.skipSpace();
            this.handleODBC();
            this.oracle_sql.append(", 'YYYY-MM-DD HH24:MI:SS.FF')");
        }
    }

    void handleTime() throws SQLException {
        this.oracle_sql.append("TO_DATE (");
        this.skipSpace();
        this.handleODBC();
        this.oracle_sql.append(", 'HH24:MI:SS')");
    }

    void handleDate() throws SQLException {
        this.oracle_sql.append("TO_DATE (");
        this.skipSpace();
        this.handleODBC();
        this.oracle_sql.append(", 'YYYY-MM-DD')");
    }

    void handleEscape() throws SQLException {
        this.oracle_sql.append("ESCAPE ");
        this.skipSpace();
        this.handleODBC();
    }

    void handleScalarFunction() throws SQLException {
        this.token_buffer.setLength(0);
        ++this.i;
        this.skipSpace();
        while (this.i < this.length && (Character.isJavaLetterOrDigit(this.c = this.odbc_sql.charAt(this.i)) || this.c == '?')) {
            this.token_buffer.append(this.c);
            ++this.i;
        }
        String string = this.token_buffer.toString().toUpperCase();
        if (string.equals("ABS")) {
            this.usingFunctionName(string);
        } else if (string.equals("ACOS")) {
            this.usingFunctionName(string);
        } else if (string.equals("ASIN")) {
            this.usingFunctionName(string);
        } else if (string.equals("ATAN")) {
            this.usingFunctionName(string);
        } else if (string.equals("ATAN2")) {
            this.usingFunctionName(string);
        } else if (string.equals("CEILING")) {
            this.usingFunctionName("CEIL");
        } else if (string.equals("COS")) {
            this.usingFunctionName(string);
        } else if (string.equals("COT")) {
            DBError.check_error(34, string);
        } else if (string.equals("DEGREES")) {
            DBError.check_error(34, string);
        } else if (string.equals("EXP")) {
            this.usingFunctionName(string);
        } else if (string.equals("FLOOR")) {
            this.usingFunctionName(string);
        } else if (string.equals("LOG")) {
            this.usingFunctionName("LN");
        } else if (string.equals("LOG10")) {
            this.replacingFunctionPrefix("LOG ( 10, ");
        } else if (string.equals("MOD")) {
            this.usingFunctionName(string);
        } else if (string.equals("PI")) {
            this.replacingFunctionPrefix("( 3.141592653589793238462643383279502884197169399375 ");
        } else if (string.equals("POWER")) {
            this.usingFunctionName(string);
        } else if (string.equals("RADIANS")) {
            DBError.check_error(34, string);
        } else if (string.equals("RAND")) {
            DBError.check_error(34, string);
        } else if (string.equals("ROUND")) {
            this.usingFunctionName(string);
        } else if (string.equals("SIGN")) {
            this.usingFunctionName(string);
        } else if (string.equals("SIN")) {
            this.usingFunctionName(string);
        } else if (string.equals("SQRT")) {
            this.usingFunctionName(string);
        } else if (string.equals("TAN")) {
            this.usingFunctionName(string);
        } else if (string.equals("TRUNCATE")) {
            this.usingFunctionName("TRUNC");
        } else if (string.equals("ASCII")) {
            this.usingFunctionName(string);
        } else if (string.equals("CHAR")) {
            this.usingFunctionName("CHR");
        } else if (string.equals("CONCAT")) {
            this.usingFunctionName(string);
        } else if (string.equals("DIFFERENCE")) {
            DBError.check_error(34, string);
        } else if (string.equals("INSERT")) {
            DBError.check_error(34, string);
        } else if (string.equals("LCASE")) {
            this.usingFunctionName("LOWER");
        } else if (string.equals("LEFT")) {
            DBError.check_error(34, string);
        } else if (string.equals("LENGTH")) {
            this.usingFunctionName(string);
        } else if (string.equals("LOCATE")) {
            this.isLocate = true;
            this.usingFunctionName("INSTR");
        } else if (string.equals("LTRIM")) {
            this.usingFunctionName(string);
        } else if (string.equals("REPEAT")) {
            DBError.check_error(34, string);
        } else if (string.equals("REPLACE")) {
            this.usingFunctionName(string);
        } else if (string.equals("RIGHT")) {
            DBError.check_error(34, string);
        } else if (string.equals("RTRIM")) {
            this.usingFunctionName(string);
        } else if (string.equals("SOUNDEX")) {
            this.usingFunctionName(string);
        } else if (string.equals("SPACE")) {
            DBError.check_error(34, string);
        } else if (string.equals("SUBSTRING")) {
            this.usingFunctionName("SUBSTR");
        } else if (string.equals("UCASE")) {
            this.usingFunctionName("UPPER");
        } else if (string.equals("CURDATE")) {
            this.replacingFunctionPrefix("(CURRENT_DATE");
        } else if (string.equals("CURTIME")) {
            this.replacingFunctionPrefix("(CURRENT_TIMESTAMP");
        } else if (string.equals("DAYNAME")) {
            DBError.check_error(34, string);
        } else if (string.equals("DAYOFMONTH")) {
            this.replacingFunctionPrefix("EXTRACT ( DAY FROM ");
        } else if (string.equals("DAYOFWEEK")) {
            DBError.check_error(34, string);
        } else if (string.equals("DAYOFYEAR")) {
            DBError.check_error(34, string);
        } else if (string.equals("HOUR")) {
            this.replacingFunctionPrefix("EXTRACT ( HOUR FROM ");
        } else if (string.equals("MINUTE")) {
            this.replacingFunctionPrefix("EXTRACT ( MINUTE FROM ");
        } else if (string.equals("MONTH")) {
            this.replacingFunctionPrefix("EXTRACT ( MONTH FROM ");
        } else if (string.equals("MONTHNAME")) {
            DBError.check_error(34, string);
        } else if (string.equals("NOW")) {
            this.replacingFunctionPrefix("(CURRENT_TIMESTAMP");
        } else if (string.equals("QUARTER")) {
            DBError.check_error(34, string);
        } else if (string.equals("SECOND")) {
            this.replacingFunctionPrefix("EXTRACT ( SECOND FROM ");
        } else if (string.equals("TIMESTAMPADD")) {
            DBError.check_error(34, string);
        } else if (string.equals("TIMESTAMPDIFF")) {
            DBError.check_error(34, string);
        } else if (string.equals("WEEK")) {
            DBError.check_error(34, string);
        } else if (string.equals("YEAR")) {
            this.replacingFunctionPrefix("EXTRACT ( YEAR FROM ");
        } else if (string.equals("DATABASE")) {
            DBError.check_error(34, string);
        } else if (string.equals("IFNULL")) {
            DBError.check_error(34, string);
        } else if (string.equals("USER")) {
            this.replacingFunctionPrefix("(USER");
        } else if (string.equals("CONVERT")) {
            DBError.check_error(34, string);
        } else {
            DBError.check_error(34, string);
        }
    }

    void usingFunctionName(String string) throws SQLException {
        this.oracle_sql.append(string);
        this.skipSpace();
        this.handleODBC();
    }

    void replacingFunctionPrefix(String string) throws SQLException {
        this.skipSpace();
        if (this.i < this.length && (this.c = this.odbc_sql.charAt(this.i)) == '(') {
            ++this.i;
        } else {
            DBError.check_error(33);
        }
        this.oracle_sql.append(string);
        this.skipSpace();
        this.handleODBC();
    }

    void handleOuterJoin() throws SQLException {
        this.oracle_sql.append(" ( ");
        this.skipSpace();
        this.handleODBC();
        this.oracle_sql.append(" ) ");
    }

    String nextArgument() {
        String string = ":" + this.current_argument;
        ++this.current_argument;
        return string;
    }

    void appendChar(StringBuffer stringBuffer, char c) {
        if (c == '?') {
            stringBuffer.append(this.nextArgument());
        } else {
            stringBuffer.append(c);
        }
    }

    void skipSpace() {
        while (this.i < this.length && (this.c = this.odbc_sql.charAt(this.i)) == ' ') {
            ++this.i;
        }
    }
}

