/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OraclePreparedStatement;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.OffsetDST;
import oracle.sql.TIMEZONETAB;
import oracle.sql.ZONEIDMAP;

public class TIMESTAMPLTZ
extends Datum {
    private static int SIZE_TIMESTAMPLTZ = 11;
    private static int SIZE_TIMESTAMPLTZ_NOFRAC = 7;
    private static int SIZE_DATE = 7;
    private static int CENTURY_DEFAULT = 119;
    private static int DECADE_DEFAULT = 100;
    private static int MONTH_DEFAULT = 1;
    private static int DAY_DEFAULT = 1;
    private static int DECADE_INIT = 170;
    private static int HOUR_MILLISECOND = 3600000;
    private static int MINUTE_MILLISECOND = 60000;
    private static int JAVA_YEAR = 1970;
    private static int JAVA_MONTH = 0;
    private static int JAVA_DATE = 1;
    private static boolean cached = false;
    private static Calendar dbtz;

    public TIMESTAMPLTZ() {
        super(TIMESTAMPLTZ.initTimestampltz());
    }

    public TIMESTAMPLTZ(byte[] byArray) {
        super(byArray);
    }

    public TIMESTAMPLTZ(Connection connection, Time time, Calendar calendar) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(connection, time, calendar));
    }

    public TIMESTAMPLTZ(Connection connection, Date date, Calendar calendar) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(connection, date, calendar));
    }

    public TIMESTAMPLTZ(Connection connection, Timestamp timestamp, Calendar calendar) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(connection, timestamp, calendar));
    }

    public TIMESTAMPLTZ(Connection connection, DATE dATE, Calendar calendar) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(connection, dATE, calendar));
    }

    public TIMESTAMPLTZ(Connection connection, String string, Calendar calendar) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(connection, string, calendar));
    }

    public TIMESTAMPLTZ(Connection connection, Calendar calendar, Time time) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(connection, calendar, time));
    }

    public TIMESTAMPLTZ(Connection connection, Calendar calendar, Date date) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(connection, calendar, date));
    }

    public TIMESTAMPLTZ(Connection connection, Calendar calendar, Timestamp timestamp) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(connection, calendar, timestamp));
    }

    public TIMESTAMPLTZ(Connection connection, Calendar calendar, DATE dATE) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(connection, calendar, dATE));
    }

    public TIMESTAMPLTZ(Connection connection, Calendar calendar, String string) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(connection, TIMESTAMPLTZ.getSessCalendar(connection), string));
    }

    public TIMESTAMPLTZ(Connection connection, Time time) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(connection, TIMESTAMPLTZ.getSessCalendar(connection), time));
    }

    public TIMESTAMPLTZ(Connection connection, Date date) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(connection, TIMESTAMPLTZ.getSessCalendar(connection), date));
    }

    public TIMESTAMPLTZ(Connection connection, Timestamp timestamp) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(connection, TIMESTAMPLTZ.getSessCalendar(connection), timestamp));
    }

    public TIMESTAMPLTZ(Connection connection, DATE dATE) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(connection, TIMESTAMPLTZ.getSessCalendar(connection), dATE));
    }

    public TIMESTAMPLTZ(Connection connection, String string) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(connection, TIMESTAMPLTZ.getSessCalendar(connection), Timestamp.valueOf(string)));
    }

    public static Date toDate(Connection connection, byte[] byArray, Calendar calendar) throws SQLException {
        int n;
        int n2 = byArray.length;
        int[] nArray = n2 == SIZE_TIMESTAMPLTZ ? new int[SIZE_TIMESTAMPLTZ] : new int[SIZE_TIMESTAMPLTZ_NOFRAC];
        for (n = 0; n < byArray.length; ++n) {
            nArray[n] = byArray[n] & 0xFF;
        }
        n = TIMESTAMPLTZ.getJavaYear(nArray[0], nArray[1]);
        Calendar calendar2 = Calendar.getInstance();
        TimeZone.setDefault(calendar.getTimeZone());
        calendar.set(1, n);
        calendar.set(2, nArray[2] - 1);
        calendar.set(5, nArray[3]);
        calendar.set(11, nArray[4] - 1);
        calendar.set(12, nArray[5] - 1);
        calendar.set(13, nArray[6] - 1);
        calendar.set(14, 0);
        TIMESTAMPLTZ.TimeZoneAdjust(connection, calendar, calendar2);
        long l = calendar2.getTime().getTime();
        return new Date(l);
    }

    public static Time toTime(Connection connection, byte[] byArray, Calendar calendar) throws SQLException {
        int n;
        int n2 = byArray.length;
        int[] nArray = n2 == SIZE_TIMESTAMPLTZ ? new int[SIZE_TIMESTAMPLTZ] : new int[SIZE_TIMESTAMPLTZ_NOFRAC];
        for (n = 0; n < byArray.length; ++n) {
            nArray[n] = byArray[n] & 0xFF;
        }
        n = TIMESTAMPLTZ.getJavaYear(nArray[0], nArray[1]);
        Calendar calendar2 = Calendar.getInstance();
        TimeZone.setDefault(calendar.getTimeZone());
        calendar.set(1, n);
        calendar.set(2, nArray[2] - 1);
        calendar.set(5, nArray[3]);
        calendar.set(11, nArray[4] - 1);
        calendar.set(12, nArray[5] - 1);
        calendar.set(13, nArray[6] - 1);
        TIMESTAMPLTZ.TimeZoneAdjust(connection, calendar, calendar2);
        TimeZone.setDefault(calendar2.getTimeZone());
        return new Time(calendar2.get(11), calendar2.get(12), calendar2.get(13));
    }

    public static Timestamp toTimestamp(Connection connection, byte[] byArray, Calendar calendar) throws SQLException {
        int n;
        int n2 = byArray.length;
        int[] nArray = n2 == SIZE_TIMESTAMPLTZ ? new int[SIZE_TIMESTAMPLTZ] : new int[SIZE_TIMESTAMPLTZ_NOFRAC];
        for (n = 0; n < byArray.length; ++n) {
            nArray[n] = byArray[n] & 0xFF;
        }
        n = TIMESTAMPLTZ.getJavaYear(nArray[0], nArray[1]);
        Calendar calendar2 = Calendar.getInstance();
        TimeZone.setDefault(calendar.getTimeZone());
        calendar.set(1, n);
        calendar.set(2, nArray[2] - 1);
        calendar.set(5, nArray[3]);
        calendar.set(11, nArray[4] - 1);
        calendar.set(12, nArray[5] - 1);
        calendar.set(13, nArray[6] - 1);
        calendar.set(14, 0);
        TIMESTAMPLTZ.TimeZoneAdjust(connection, calendar, calendar2);
        long l = calendar2.getTime().getTime();
        TimeZone.setDefault(calendar2.getTimeZone());
        Timestamp timestamp = new Timestamp(l);
        int n3 = 0;
        if (byArray.length == SIZE_TIMESTAMPLTZ) {
            n3 = nArray[7] << 24;
            n3 |= nArray[8] << 16;
            n3 |= nArray[9] << 8;
            timestamp.setNanos(n3 |= nArray[10] & 0xFF);
        } else {
            timestamp.setNanos(0);
        }
        return timestamp;
    }

    public static DATE toDATE(Connection connection, byte[] byArray, Calendar calendar) throws SQLException {
        int n;
        int[] nArray = new int[SIZE_TIMESTAMPLTZ];
        for (n = 0; n < byArray.length; ++n) {
            nArray[n] = byArray[n] & 0xFF;
        }
        n = TIMESTAMPLTZ.getJavaYear(nArray[0], nArray[1]);
        Calendar calendar2 = Calendar.getInstance();
        TimeZone.setDefault(calendar.getTimeZone());
        calendar.set(1, n);
        calendar.set(2, nArray[2] - 1);
        calendar.set(5, nArray[3]);
        calendar.set(11, nArray[4] - 1);
        calendar.set(12, nArray[5] - 1);
        calendar.set(13, nArray[6] - 1);
        TIMESTAMPLTZ.TimeZoneAdjust(connection, calendar, calendar2);
        long l = calendar2.getTime().getTime();
        TimeZone.setDefault(calendar2.getTimeZone());
        return new DATE(new Date(l));
    }

    public Timestamp timestampValue(Connection connection, Calendar calendar) throws SQLException {
        return TIMESTAMPLTZ.toTimestamp(connection, this.getBytes(), calendar);
    }

    public static String toString(Connection connection, byte[] byArray, Calendar calendar) throws SQLException {
        Timestamp timestamp = TIMESTAMPLTZ.toTimestamp(connection, byArray, calendar);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(timestamp);
        int n = calendar2.get(1);
        int n2 = calendar2.get(2) + 1;
        int n3 = calendar2.get(5);
        int n4 = calendar2.get(11);
        int n5 = calendar2.get(12);
        int n6 = calendar2.get(13);
        int n7 = 0;
        if (byArray.length == SIZE_TIMESTAMPLTZ) {
            n7 = (byArray[7] & 0xFF) << 24;
            n7 |= (byArray[8] & 0xFF) << 16;
            n7 |= (byArray[9] & 0xFF) << 8;
            n7 |= byArray[10] & 0xFF & 0xFF;
        }
        return n + "-" + n2 + "-" + n3 + " " + n4 + "." + n5 + "." + n6 + "." + n7;
    }

    public byte[] toBytes() {
        return this.getBytes();
    }

    public static byte[] toBytes(Connection connection, Time time, Calendar calendar) throws SQLException {
        if (time == null) {
            return null;
        }
        byte[] byArray = new byte[SIZE_TIMESTAMPLTZ_NOFRAC];
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(time);
        if (calendar.getTimeZone().inDaylightTime(time)) {
            boolean bl = true;
        } else {
            boolean bl = false;
        }
        calendar2.set(1, (CENTURY_DEFAULT - 100) * 100 + DECADE_DEFAULT % 100);
        calendar2.set(2, MONTH_DEFAULT - 1);
        calendar2.set(5, DAY_DEFAULT);
        TIMESTAMPLTZ.TimeZoneAdjust(connection, calendar2, calendar);
        byArray[0] = (byte)(calendar.get(1) / 100 + 100);
        byArray[1] = (byte)(calendar.get(1) % 100 + 100);
        byArray[2] = (byte)(calendar.get(2) + 1);
        byArray[3] = (byte)calendar.get(5);
        byArray[4] = (byte)(calendar.get(11) + 1);
        byArray[5] = (byte)(calendar.get(12) + 1);
        byArray[6] = (byte)(calendar.get(13) + 1);
        TimeZone.setDefault(calendar2.getTimeZone());
        return byArray;
    }

    public static byte[] toBytes(Connection connection, Date date, Calendar calendar) throws SQLException {
        if (date == null) {
            return null;
        }
        byte[] byArray = new byte[SIZE_TIMESTAMPLTZ_NOFRAC];
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date);
        if (calendar2.getTimeZone().inDaylightTime(date)) {
            boolean bl = true;
        } else {
            boolean bl = false;
        }
        calendar2.set(11, 0);
        calendar2.set(12, 0);
        calendar2.set(13, 0);
        TIMESTAMPLTZ.TimeZoneAdjust(connection, calendar2, calendar);
        byArray[0] = (byte)(calendar.get(1) / 100 + 100);
        byArray[1] = (byte)(calendar.get(1) % 100 + 100);
        byArray[2] = (byte)(calendar.get(2) + 1);
        byArray[3] = (byte)calendar.get(5);
        byArray[4] = (byte)(calendar.get(11) + 1);
        byArray[5] = (byte)(calendar.get(12) + 1);
        byArray[6] = (byte)(calendar.get(13) + 1);
        TimeZone.setDefault(calendar2.getTimeZone());
        return byArray;
    }

    public static byte[] toBytes(Connection connection, Timestamp timestamp, Calendar calendar) throws SQLException {
        if (timestamp == null) {
            return null;
        }
        int n = timestamp.getNanos();
        byte[] byArray = n == 0 ? new byte[SIZE_TIMESTAMPLTZ_NOFRAC] : new byte[SIZE_TIMESTAMPLTZ];
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(timestamp);
        if (calendar2.getTimeZone().inDaylightTime(timestamp)) {
            boolean bl = true;
        } else {
            boolean bl = false;
        }
        TIMESTAMPLTZ.TimeZoneAdjust(connection, calendar2, calendar);
        byArray[0] = (byte)(calendar.get(1) / 100 + 100);
        byArray[1] = (byte)(calendar.get(1) % 100 + 100);
        byArray[2] = (byte)(calendar.get(2) + 1);
        byArray[3] = (byte)calendar.get(5);
        byArray[4] = (byte)(calendar.get(11) + 1);
        byArray[5] = (byte)(calendar.get(12) + 1);
        byArray[6] = (byte)(calendar.get(13) + 1);
        if (n != 0) {
            byArray[7] = (byte)(timestamp.getNanos() >> 24);
            byArray[8] = (byte)(timestamp.getNanos() >> 16 & 0xFF);
            byArray[9] = (byte)(timestamp.getNanos() >> 8 & 0xFF);
            byArray[10] = (byte)(timestamp.getNanos() & 0xFF);
        }
        TimeZone.setDefault(calendar2.getTimeZone());
        return byArray;
    }

    public static byte[] toBytes(Connection connection, DATE dATE, Calendar calendar) throws SQLException {
        if (dATE == null) {
            return null;
        }
        byte[] byArray = new byte[SIZE_TIMESTAMPLTZ_NOFRAC];
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(DATE.toDate(dATE.toBytes()));
        if (calendar2.getTimeZone().inDaylightTime(new Date(calendar2.getTime().getTime()))) {
            boolean bl = true;
        } else {
            boolean bl = false;
        }
        TIMESTAMPLTZ.TimeZoneAdjust(connection, calendar2, calendar);
        byArray[0] = (byte)(calendar.get(1) / 100 + 100);
        byArray[1] = (byte)(calendar.get(1) % 100 + 100);
        byArray[2] = (byte)(calendar.get(2) + 1);
        byArray[3] = (byte)calendar.get(5);
        byArray[4] = (byte)(calendar.get(11) + 1);
        byArray[5] = (byte)(calendar.get(12) + 1);
        byArray[6] = (byte)(calendar.get(13) + 1);
        TimeZone.setDefault(calendar2.getTimeZone());
        return byArray;
    }

    public static byte[] toBytes(Connection connection, String string, Calendar calendar) throws SQLException {
        return TIMESTAMPLTZ.toBytes(connection, Timestamp.valueOf(string), calendar);
    }

    public static Date toDate(Connection connection, byte[] byArray) throws SQLException {
        int n = byArray.length;
        int[] nArray = n == SIZE_TIMESTAMPLTZ ? new int[SIZE_TIMESTAMPLTZ] : new int[SIZE_TIMESTAMPLTZ_NOFRAC];
        for (int i = 0; i < byArray.length; ++i) {
            nArray[i] = byArray[i] & 0xFF;
        }
        TimeZone timeZone = TimeZone.getDefault();
        TIMESTAMPLTZ.getDbTimeZone(connection);
        Calendar calendar = TIMESTAMPLTZ.getSessCalendar(connection);
        int n2 = TIMESTAMPLTZ.getJavaYear(nArray[0], nArray[1]);
        TimeZone.setDefault(dbtz.getTimeZone());
        dbtz.set(1, n2);
        dbtz.set(2, nArray[2] - 1);
        dbtz.set(5, nArray[3]);
        dbtz.set(11, nArray[4] - 1);
        dbtz.set(12, nArray[5] - 1);
        dbtz.set(13, nArray[6] - 1);
        dbtz.set(14, 0);
        TIMESTAMPLTZ.TimeZoneAdjust(connection, dbtz, calendar);
        long l = calendar.getTime().getTime();
        TimeZone.setDefault(timeZone);
        return new Date(l);
    }

    public static Time toTime(Connection connection, byte[] byArray) throws SQLException {
        int n = byArray.length;
        int[] nArray = n == SIZE_TIMESTAMPLTZ ? new int[SIZE_TIMESTAMPLTZ] : new int[SIZE_TIMESTAMPLTZ_NOFRAC];
        for (int i = 0; i < byArray.length; ++i) {
            nArray[i] = byArray[i] & 0xFF;
        }
        TimeZone timeZone = TimeZone.getDefault();
        TIMESTAMPLTZ.getDbTimeZone(connection);
        Calendar calendar = TIMESTAMPLTZ.getSessCalendar(connection);
        int n2 = TIMESTAMPLTZ.getJavaYear(nArray[0], nArray[1]);
        TimeZone.setDefault(dbtz.getTimeZone());
        dbtz.set(1, n2);
        dbtz.set(2, nArray[2] - 1);
        dbtz.set(5, nArray[3]);
        dbtz.set(11, nArray[4] - 1);
        dbtz.set(12, nArray[5] - 1);
        dbtz.set(13, nArray[6] - 1);
        TIMESTAMPLTZ.TimeZoneAdjust(connection, dbtz, calendar);
        TimeZone.setDefault(timeZone);
        return new Time(calendar.get(11), calendar.get(12), calendar.get(13));
    }

    public static Timestamp toTimestamp(Connection connection, byte[] byArray) throws SQLException {
        int n = byArray.length;
        int[] nArray = n == SIZE_TIMESTAMPLTZ ? new int[SIZE_TIMESTAMPLTZ] : new int[SIZE_TIMESTAMPLTZ_NOFRAC];
        for (int i = 0; i < byArray.length; ++i) {
            nArray[i] = byArray[i] & 0xFF;
        }
        TimeZone timeZone = TimeZone.getDefault();
        TIMESTAMPLTZ.getDbTimeZone(connection);
        Calendar calendar = TIMESTAMPLTZ.getSessCalendar(connection);
        int n2 = TIMESTAMPLTZ.getJavaYear(nArray[0], nArray[1]);
        TimeZone.setDefault(dbtz.getTimeZone());
        dbtz.set(1, n2);
        dbtz.set(2, nArray[2] - 1);
        dbtz.set(5, nArray[3]);
        dbtz.set(11, nArray[4] - 1);
        dbtz.set(12, nArray[5] - 1);
        dbtz.set(13, nArray[6] - 1);
        dbtz.set(14, 0);
        TIMESTAMPLTZ.TimeZoneAdjust(connection, dbtz, calendar);
        long l = calendar.getTime().getTime();
        TimeZone.setDefault(timeZone);
        Timestamp timestamp = new Timestamp(l);
        int n3 = 0;
        if (byArray.length == SIZE_TIMESTAMPLTZ) {
            n3 = nArray[7] << 24;
            n3 |= nArray[8] << 16;
            n3 |= nArray[9] << 8;
            timestamp.setNanos(n3 |= nArray[10] & 0xFF);
        } else {
            timestamp.setNanos(n3);
        }
        return timestamp;
    }

    public static DATE toDATE(Connection connection, byte[] byArray) throws SQLException {
        int n = byArray.length;
        int[] nArray = n == SIZE_TIMESTAMPLTZ ? new int[SIZE_TIMESTAMPLTZ] : new int[SIZE_TIMESTAMPLTZ_NOFRAC];
        for (int i = 0; i < byArray.length; ++i) {
            nArray[i] = byArray[i] & 0xFF;
        }
        TimeZone timeZone = TimeZone.getDefault();
        TIMESTAMPLTZ.getDbTimeZone(connection);
        Calendar calendar = TIMESTAMPLTZ.getSessCalendar(connection);
        int n2 = TIMESTAMPLTZ.getJavaYear(nArray[0], nArray[1]);
        TimeZone.setDefault(dbtz.getTimeZone());
        dbtz.set(1, n2);
        dbtz.set(2, nArray[2] - 1);
        dbtz.set(5, nArray[3]);
        dbtz.set(11, nArray[4] - 1);
        dbtz.set(12, nArray[5] - 1);
        dbtz.set(13, nArray[6] - 1);
        TIMESTAMPLTZ.TimeZoneAdjust(connection, dbtz, calendar);
        long l = calendar.getTime().getTime();
        TimeZone.setDefault(timeZone);
        return new DATE(new Date(l));
    }

    public static String toString(Connection connection, byte[] byArray) throws SQLException {
        Timestamp timestamp = TIMESTAMPLTZ.toTimestamp(connection, byArray);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(timestamp);
        int n = calendar.get(1);
        int n2 = calendar.get(2) + 1;
        int n3 = calendar.get(5);
        int n4 = calendar.get(11);
        int n5 = calendar.get(12);
        int n6 = calendar.get(13);
        int n7 = 0;
        if (byArray.length == SIZE_TIMESTAMPLTZ) {
            n7 = (byArray[7] & 0xFF) << 24;
            n7 |= (byArray[8] & 0xFF) << 16;
            n7 |= (byArray[9] & 0xFF) << 8;
            n7 |= byArray[10] & 0xFF;
        }
        return n + "-" + n2 + "-" + n3 + " " + n4 + "." + n5 + "." + n6 + "." + n7;
    }

    public static byte[] toBytes(Connection connection, Calendar calendar, Time time) throws SQLException {
        if (time == null) {
            return null;
        }
        byte[] byArray = new byte[SIZE_TIMESTAMPLTZ_NOFRAC];
        TimeZone timeZone = TimeZone.getDefault();
        TIMESTAMPLTZ.getDbTimeZone(connection);
        calendar.setTime(time);
        if (dbtz.getTimeZone().inDaylightTime(time)) {
            boolean bl = true;
        } else {
            boolean bl = false;
        }
        calendar.set(1, (CENTURY_DEFAULT - 100) * 100 + DECADE_DEFAULT % 100);
        calendar.set(2, MONTH_DEFAULT - 1);
        calendar.set(5, DAY_DEFAULT);
        TIMESTAMPLTZ.TimeZoneAdjust(connection, calendar, dbtz);
        byArray[0] = (byte)(dbtz.get(1) / 100 + 100);
        byArray[1] = (byte)(dbtz.get(1) % 100 + 100);
        byArray[2] = (byte)(dbtz.get(2) + 1);
        byArray[3] = (byte)dbtz.get(5);
        byArray[4] = (byte)(dbtz.get(11) + 1);
        byArray[5] = (byte)(dbtz.get(12) + 1);
        byArray[6] = (byte)(dbtz.get(13) + 1);
        TimeZone.setDefault(timeZone);
        return byArray;
    }

    public static byte[] toBytes(Connection connection, Calendar calendar, Date date) throws SQLException {
        if (date == null) {
            return null;
        }
        byte[] byArray = new byte[SIZE_TIMESTAMPLTZ_NOFRAC];
        TimeZone timeZone = TimeZone.getDefault();
        TIMESTAMPLTZ.getDbTimeZone(connection);
        calendar.setTime(date);
        if (calendar.getTimeZone().inDaylightTime(date)) {
            boolean bl = true;
        } else {
            boolean bl = false;
        }
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        TIMESTAMPLTZ.TimeZoneAdjust(connection, calendar, dbtz);
        byArray[0] = (byte)(dbtz.get(1) / 100 + 100);
        byArray[1] = (byte)(dbtz.get(1) % 100 + 100);
        byArray[2] = (byte)(dbtz.get(2) + 1);
        byArray[3] = (byte)dbtz.get(5);
        byArray[4] = (byte)(dbtz.get(11) + 1);
        byArray[5] = (byte)(dbtz.get(12) + 1);
        byArray[6] = (byte)(dbtz.get(13) + 1);
        TimeZone.setDefault(timeZone);
        return byArray;
    }

    public static byte[] toBytes(Connection connection, Calendar calendar, Timestamp timestamp) throws SQLException {
        if (timestamp == null) {
            return null;
        }
        int n = timestamp.getNanos();
        byte[] byArray = n == 0 ? new byte[SIZE_TIMESTAMPLTZ_NOFRAC] : new byte[SIZE_TIMESTAMPLTZ];
        TimeZone timeZone = TimeZone.getDefault();
        TIMESTAMPLTZ.getDbTimeZone(connection);
        calendar.setTime(timestamp);
        if (calendar.getTimeZone().inDaylightTime(timestamp)) {
            boolean bl = true;
        } else {
            boolean bl = false;
        }
        TIMESTAMPLTZ.TimeZoneAdjust(connection, calendar, dbtz);
        byArray[0] = (byte)(dbtz.get(1) / 100 + 100);
        byArray[1] = (byte)(dbtz.get(1) % 100 + 100);
        byArray[2] = (byte)(dbtz.get(2) + 1);
        byArray[3] = (byte)dbtz.get(5);
        byArray[4] = (byte)(dbtz.get(11) + 1);
        byArray[5] = (byte)(dbtz.get(12) + 1);
        byArray[6] = (byte)(dbtz.get(13) + 1);
        if (n != 0) {
            byArray[7] = (byte)(timestamp.getNanos() >> 24);
            byArray[8] = (byte)(timestamp.getNanos() >> 16 & 0xFF);
            byArray[9] = (byte)(timestamp.getNanos() >> 8 & 0xFF);
            byArray[10] = (byte)(timestamp.getNanos() & 0xFF);
        }
        TimeZone.setDefault(timeZone);
        return byArray;
    }

    public static byte[] toBytes(Connection connection, Calendar calendar, DATE dATE) throws SQLException {
        if (dATE == null) {
            return null;
        }
        byte[] byArray = new byte[SIZE_TIMESTAMPLTZ_NOFRAC];
        TimeZone timeZone = TimeZone.getDefault();
        TIMESTAMPLTZ.getDbTimeZone(connection);
        calendar.setTime(DATE.toDate(dATE.toBytes()));
        if (calendar.getTimeZone().inDaylightTime(new Date(calendar.getTime().getTime()))) {
            boolean bl = true;
        } else {
            boolean bl = false;
        }
        TIMESTAMPLTZ.TimeZoneAdjust(connection, calendar, dbtz);
        byArray[0] = (byte)(dbtz.get(1) / 100 + 100);
        byArray[1] = (byte)(dbtz.get(1) % 100 + 100);
        byArray[2] = (byte)(dbtz.get(2) + 1);
        byArray[3] = (byte)dbtz.get(5);
        byArray[4] = (byte)(dbtz.get(11) + 1);
        byArray[5] = (byte)(dbtz.get(12) + 1);
        byArray[6] = (byte)(dbtz.get(13) + 1);
        TimeZone.setDefault(timeZone);
        return byArray;
    }

    public static byte[] toBytes(Connection connection, Calendar calendar, String string) throws SQLException {
        return TIMESTAMPLTZ.toBytes(connection, calendar, Timestamp.valueOf(string));
    }

    public String stringValue(Connection connection) throws SQLException {
        return TIMESTAMPLTZ.toString(connection, this.getBytes());
    }

    public String stringValue(Connection connection, Calendar calendar) throws SQLException {
        return TIMESTAMPLTZ.toString(connection, this.getBytes(), calendar);
    }

    public Date dateValue(Connection connection, Calendar calendar) throws SQLException {
        return TIMESTAMPLTZ.toDate(connection, this.getBytes(), calendar);
    }

    public Date dateValue(Connection connection) throws SQLException {
        return TIMESTAMPLTZ.toDate(connection, this.getBytes());
    }

    public Time timeValue(Connection connection) throws SQLException {
        return TIMESTAMPLTZ.toTime(connection, this.getBytes());
    }

    public Time timeValue(Connection connection, Calendar calendar) throws SQLException {
        return TIMESTAMPLTZ.toTime(connection, this.getBytes(), calendar);
    }

    private static byte[] initTimestampltz() {
        byte[] byArray = new byte[SIZE_TIMESTAMPLTZ];
        byArray[0] = (byte)CENTURY_DEFAULT;
        byArray[1] = (byte)DECADE_INIT;
        byArray[2] = (byte)MONTH_DEFAULT;
        byArray[3] = (byte)DAY_DEFAULT;
        byArray[4] = 1;
        byArray[5] = 1;
        byArray[6] = 1;
        return byArray;
    }

    public Object toJdbc() throws SQLException {
        return this.timestampValue();
    }

    public Object makeJdbcArray(int n) {
        Timestamp[] timestampArray = new Timestamp[n];
        return timestampArray;
    }

    public boolean isConvertibleTo(Class clazz) {
        return clazz.getName().compareTo("java.sql.Date") == 0 || clazz.getName().compareTo("java.sql.Time") == 0 || clazz.getName().compareTo("java.sql.Timestamp") == 0 || clazz.getName().compareTo("java.lang.String") == 0;
    }

    static void TimeZoneAdjust(Connection connection, Calendar calendar, Calendar calendar2) throws SQLException {
        int n;
        int n2;
        int n3;
        String string = new String(calendar.getTimeZone().getID());
        String string2 = new String(calendar2.getTimeZone().getID());
        if (!(string2.equals(string) || string2.equals("Custom") && string.equals("Custom"))) {
            int n4;
            OffsetDST offsetDST = new OffsetDST();
            n3 = TIMESTAMPLTZ.getZoneOffset(connection, calendar, offsetDST);
            n2 = offsetDST.getOFFSET();
            calendar.add(11, -(n2 / HOUR_MILLISECOND));
            calendar.add(12, -(n2 % HOUR_MILLISECOND) / MINUTE_MILLISECOND);
            if (string2.equals("Custom")) {
                n4 = calendar2.getTimeZone().getRawOffset();
            } else {
                n = ZONEIDMAP.getID(string2);
                if (n == ZONEIDMAP.INV_ZONEID) {
                    if (calendar2.getTimeZone().useDaylightTime()) {
                        throw new SQLException("Timezone not supported");
                    }
                    n4 = calendar2.getTimeZone().getRawOffset();
                } else {
                    if (TIMEZONETAB.checkID(n)) {
                        TIMEZONETAB.updateTable(connection, n);
                    }
                    n4 = TIMEZONETAB.getOffset(calendar, n);
                }
            }
            calendar.add(11, n4 / HOUR_MILLISECOND);
            calendar.add(12, n4 % HOUR_MILLISECOND / MINUTE_MILLISECOND);
        }
        if (string2.equals("Custom") && string.equals("Custom")) {
            int n5 = calendar.getTimeZone().getRawOffset();
            n3 = calendar2.getTimeZone().getRawOffset();
            n2 = 0;
            if (n5 != n3) {
                n2 = n5 - n3;
                int n6 = n2 = n2 > 0 ? n2 : -n2;
            }
            if (n5 > n3) {
                n2 = -n2;
            }
            calendar.add(11, n2 / HOUR_MILLISECOND);
            calendar.add(12, n2 % HOUR_MILLISECOND / MINUTE_MILLISECOND);
        }
        int n7 = calendar.get(1);
        n3 = calendar.get(2);
        n2 = calendar.get(5);
        n = calendar.get(11);
        int n8 = calendar.get(12);
        int n9 = calendar.get(13);
        int n10 = calendar.get(14);
        TimeZone.setDefault(calendar2.getTimeZone());
        calendar2.set(1, n7);
        calendar2.set(2, n3);
        calendar2.set(5, n2);
        calendar2.set(11, n);
        calendar2.set(12, n8);
        calendar2.set(13, n9);
        calendar2.set(14, n10);
    }

    private static int getJavaYear(int n, int n2) {
        return (n - 100) * 100 + (n2 - 100);
    }

    private static byte getZoneOffset(Connection connection, Calendar calendar, OffsetDST offsetDST) throws SQLException {
        byte by = 0;
        if (calendar.getTimeZone().getID() == "Custom") {
            offsetDST.setOFFSET(calendar.getTimeZone().getRawOffset());
        } else {
            String string = new String(calendar.getTimeZone().getID());
            int n = ZONEIDMAP.getID(string);
            if (n == ZONEIDMAP.INV_ZONEID) {
                if (calendar.getTimeZone().useDaylightTime()) {
                    throw new SQLException("Timezone not supported");
                }
                offsetDST.setOFFSET(calendar.getTimeZone().getRawOffset());
            } else {
                if (TIMEZONETAB.checkID(n)) {
                    TIMEZONETAB.updateTable(connection, n);
                }
                by = TIMEZONETAB.getLocalOffset(calendar, n, offsetDST);
            }
        }
        return by;
    }

    private static Calendar getDbTzCalendar(String string) {
        char c = string.charAt(0);
        String string2 = c == '+' || c == '-' ? "GMT" + string : string;
        TimeZone timeZone = TimeZone.getTimeZone(string2);
        return new GregorianCalendar(timeZone);
    }

    private static Calendar getSessCalendar(Connection connection) {
        Calendar calendar;
        String string = ((OracleConnection)connection).getSessionTimeZone();
        if (string == null) {
            calendar = Calendar.getInstance();
        } else {
            TimeZone timeZone = TimeZone.getDefault();
            timeZone.setID(string);
            calendar = Calendar.getInstance(timeZone);
        }
        return calendar;
    }

    private static synchronized void getDbTimeZone(Connection connection) throws SQLException {
        if (!cached) {
            OraclePreparedStatement oraclePreparedStatement = null;
            ResultSet resultSet = null;
            oraclePreparedStatement = (OraclePreparedStatement)connection.prepareStatement("SELECT DBTIMEZONE FROM DUAL");
            resultSet = oraclePreparedStatement.executeQuery();
            resultSet.next();
            String string = resultSet.getString(1);
            resultSet.close();
            oraclePreparedStatement.close();
            dbtz = TIMESTAMPLTZ.getDbTzCalendar(string);
            cached = true;
        }
    }
}

