/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text.converter;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import oracle.i18n.util.ConverterArchive;
import oracle.i18n.util.GDKOracleMetaData;
import oracle.sql.converter.CharacterConverters;

public abstract class CharacterConverterOGS
extends CharacterConverters {
    static final long serialVersionUID = GDKOracleMetaData.getOracleVersionID();
    static final String CONVERTERNAMEPREFIX = "/oracle/i18n/data/lx2";
    static final String CONVERTERIDPREFIX = "0000";
    static final int HIBYTEMASK = 65280;
    static final int LOWBYTEMASK = 255;
    static final int STORE_INCREMENT = 10;
    static final int INVALID_ORA_CHAR = -1;
    static final int FIRSTBSHIFT = 24;
    static final int SECONDBSHIFT = 16;
    static final int THIRDBSHIFT = 8;
    static final int UB2MASK = 65535;
    static final int UB4MASK = 65535;
    protected static final String BEGIN_UNISTR = "UNISTR('";
    protected static final String END_UNISTR = "')";
    static final HashMap m_converterStore = new HashMap();
    public int m_groupId;
    public int m_oracleId;
    protected float averageCharsPerByte;
    protected float maxCharsPerByte;
    protected float maxBytesPerChar;

    public static final synchronized CharacterConverters getInstance(int n) {
        CharacterConverterOGS characterConverterOGS = null;
        boolean bl = false;
        boolean bl2 = false;
        String string = Integer.toHexString(n);
        characterConverterOGS = (CharacterConverterOGS)m_converterStore.get(string);
        if (characterConverterOGS != null) {
            return characterConverterOGS;
        }
        ConverterArchive converterArchive = new ConverterArchive();
        String string2 = CONVERTERNAMEPREFIX + CONVERTERIDPREFIX.substring(0, 4 - string.length()) + string;
        characterConverterOGS = (CharacterConverterOGS)converterArchive.readObj(string2 + ".glb");
        if (characterConverterOGS == null) {
            return null;
        }
        characterConverterOGS.buildUnicodeToOracleMapping();
        m_converterStore.put(string, characterConverterOGS);
        return characterConverterOGS;
    }

    protected void storeMappingRange(int n, Hashtable hashtable, Hashtable hashtable2) {
        char[] cArray;
        int n2 = n >> 24 & 0xFF;
        int n3 = n >> 16 & 0xFF;
        int n4 = n >> 8 & 0xFF;
        int n5 = n & 0xFF;
        Integer n6 = new Integer(n2);
        Integer n7 = new Integer(n >> 16 & 0xFFFF);
        Integer n8 = new Integer(n >> 8 & 0xFFFFFF);
        if (n >>> 26 == 54) {
            cArray = (char[])hashtable.get(n6);
            if (cArray == null) {
                cArray = new char[]{'\u00ff', '\u0000'};
            }
            if (cArray[0] == '\u00ff' && cArray[1] == '\u0000') {
                cArray[0] = (char)n3;
                cArray[1] = (char)n3;
            } else {
                if (n3 < (cArray[0] & 0xFFFF)) {
                    cArray[0] = (char)n3;
                }
                if (n3 > (cArray[0] & 0xFFFF)) {
                    cArray[1] = (char)n3;
                }
            }
            hashtable.put(n6, cArray);
            cArray = (char[])hashtable.get(n7);
            if (cArray == null) {
                cArray = new char[]{'\u00ff', '\u0000'};
            }
            if (cArray[0] == '\u00ff' && cArray[1] == '\u0000') {
                cArray[0] = (char)n4;
                cArray[1] = (char)n4;
            } else {
                if (n4 < (cArray[0] & 0xFFFF)) {
                    cArray[0] = (char)n4;
                }
                if (n4 > (cArray[0] & 0xFFFF)) {
                    cArray[1] = (char)n4;
                }
            }
            hashtable.put(n7, cArray);
        }
        if ((cArray = (char[])hashtable2.get(n8)) == null) {
            cArray = new char[]{'\u00ff', '\u0000'};
        }
        if (cArray[0] == '\u00ff' && cArray[1] == '\u0000') {
            cArray[0] = (char)n5;
            cArray[1] = (char)n5;
        } else {
            if (n5 < (cArray[0] & 0xFFFF)) {
                cArray[0] = (char)n5;
            }
            if (n5 > (cArray[0] & 0xFFFF)) {
                cArray[1] = (char)n5;
            }
        }
        hashtable2.put(n8, cArray);
    }

    public int getGroupId() {
        return this.m_groupId;
    }

    public int getOracleId() {
        return this.m_oracleId;
    }

    public float getAverageRatio() {
        return this.averageCharsPerByte;
    }

    public float getMaxRatio() {
        return this.maxCharsPerByte;
    }

    public float getMaxBytesRatio() {
        return this.maxBytesPerChar;
    }

    protected static String toUnistrChar(char c) {
        String string = Integer.toHexString(c);
        return "\\" + new String("000" + string).substring(string.length() - 1);
    }

    public abstract String toUnicodeString(byte[] var1, int var2, int var3) throws SQLException;

    public abstract String toUnicodeStringWithReplacement(byte[] var1, int var2, int var3);

    public abstract byte[] toOracleString(String var1) throws SQLException;

    public abstract byte[] toOracleStringWithReplacement(String var1);

    public abstract void buildUnicodeToOracleMapping();

    public abstract void extractCodepoints(Vector var1);

    public abstract void extractExtraMappings(Vector var1);

    public abstract boolean hasExtraMappings();

    public abstract char getOraChar1ByteRep();

    public abstract char getOraChar2ByteRep();

    public abstract int getUCS2CharRep();

    protected abstract boolean isOraCharacterReplacement(char var1, char var2);

    public String toUnistr(String string) {
        StringBuffer stringBuffer = new StringBuffer(BEGIN_UNISTR);
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] >= '\ud800' && cArray[n] <= '\udbff') {
                if (n + 1 < cArray.length && cArray[n + 1] >= '\udc00' && cArray[n + 1] <= '\udfff') {
                    if (this.isOraCharacterReplacement(cArray[n], cArray[n + 1])) {
                        stringBuffer.append(CharacterConverterOGS.toUnistrChar(cArray[n++]));
                        stringBuffer.append(CharacterConverterOGS.toUnistrChar(cArray[n]));
                    } else {
                        stringBuffer.append(cArray[n++]);
                        stringBuffer.append(cArray[n]);
                    }
                } else {
                    stringBuffer.append(CharacterConverterOGS.toUnistrChar(cArray[n]));
                }
            } else if (this.isOraCharacterReplacement(cArray[n], '\u0000')) {
                stringBuffer.append(CharacterConverterOGS.toUnistrChar(cArray[n]));
            } else if (cArray[n] == '\'') {
                stringBuffer.append("''");
            } else {
                stringBuffer.append(cArray[n]);
            }
            ++n;
        }
        stringBuffer.append(END_UNISTR);
        return stringBuffer.toString();
    }
}

