/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ProcessEnvironment
extends HashMap<String, String> {
    static final int MIN_NAME_LENGTH = 1;
    private static final NameComparator nameComparator;
    private static final EntryComparator entryComparator;
    private static final ProcessEnvironment theEnvironment;
    private static final Map<String, String> theUnmodifiableEnvironment;
    private static final Map<String, String> theCaseInsensitiveEnvironment;

    private static String validateName(String string) {
        if (string.indexOf(61, 1) != -1 || string.indexOf(0) != -1) {
            throw new IllegalArgumentException("Invalid environment variable name: \"" + string + "\"");
        }
        return string;
    }

    private static String validateValue(String string) {
        if (string.indexOf(0) != -1) {
            throw new IllegalArgumentException("Invalid environment variable value: \"" + string + "\"");
        }
        return string;
    }

    private static String nonNullString(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return (String)object;
    }

    @Override
    public String put(String string, String string2) {
        return super.put(ProcessEnvironment.validateName(string), ProcessEnvironment.validateValue(string2));
    }

    @Override
    public String get(Object object) {
        return (String)super.get(ProcessEnvironment.nonNullString(object));
    }

    @Override
    public boolean containsKey(Object object) {
        return super.containsKey(ProcessEnvironment.nonNullString(object));
    }

    @Override
    public boolean containsValue(Object object) {
        return super.containsValue(ProcessEnvironment.nonNullString(object));
    }

    @Override
    public String remove(Object object) {
        return (String)super.remove(ProcessEnvironment.nonNullString(object));
    }

    @Override
    public Set<String> keySet() {
        return new CheckedKeySet(super.keySet());
    }

    @Override
    public Collection<String> values() {
        return new CheckedValues(super.values());
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return new CheckedEntrySet(super.entrySet());
    }

    private ProcessEnvironment() {
    }

    private ProcessEnvironment(int n) {
        super(n);
    }

    static String getenv(String string) {
        return theCaseInsensitiveEnvironment.get(string);
    }

    static Map<String, String> getenv() {
        return theUnmodifiableEnvironment;
    }

    static Map<String, String> environment() {
        return (Map)theEnvironment.clone();
    }

    static Map<String, String> emptyEnvironment(int n) {
        return new ProcessEnvironment(n);
    }

    private static native String environmentBlock();

    String toEnvironmentBlock() {
        ArrayList<Map.Entry<String, String>> arrayList = new ArrayList<Map.Entry<String, String>>(this.entrySet());
        Collections.sort(arrayList, entryComparator);
        StringBuilder stringBuilder = new StringBuilder(this.size() * 30);
        for (Map.Entry entry : arrayList) {
            stringBuilder.append((String)entry.getKey()).append('=').append((String)entry.getValue()).append('\u0000');
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append('\u0000');
        }
        stringBuilder.append('\u0000');
        return stringBuilder.toString();
    }

    static String toEnvironmentBlock(Map<String, String> map) {
        return map == null ? null : ((ProcessEnvironment)map).toEnvironmentBlock();
    }

    static {
        int n;
        int n2;
        nameComparator = new NameComparator();
        entryComparator = new EntryComparator();
        theEnvironment = new ProcessEnvironment();
        theUnmodifiableEnvironment = Collections.unmodifiableMap(theEnvironment);
        String string = ProcessEnvironment.environmentBlock();
        int n3 = 0;
        while ((n2 = string.indexOf(0, n3)) != -1 && (n = string.indexOf(61, n3 + 1)) != -1) {
            if (n < n2) {
                theEnvironment.put(string.substring(n3, n), string.substring(n + 1, n2));
            }
            n3 = n2 + 1;
        }
        theCaseInsensitiveEnvironment = new TreeMap<String, String>(nameComparator);
        theCaseInsensitiveEnvironment.putAll(theEnvironment);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CheckedEntry
    implements Map.Entry<String, String> {
        private final Map.Entry<String, String> e;

        public CheckedEntry(Map.Entry<String, String> entry) {
            this.e = entry;
        }

        @Override
        public String getKey() {
            return this.e.getKey();
        }

        @Override
        public String getValue() {
            return this.e.getValue();
        }

        @Override
        public String setValue(String string) {
            return this.e.setValue(ProcessEnvironment.validateValue(string));
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }

        @Override
        public boolean equals(Object object) {
            return ((Object)this.e).equals(object);
        }

        @Override
        public int hashCode() {
            return ((Object)this.e).hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CheckedEntrySet
    extends AbstractSet<Map.Entry<String, String>> {
        private final Set<Map.Entry<String, String>> s;

        public CheckedEntrySet(Set<Map.Entry<String, String>> set) {
            this.s = set;
        }

        @Override
        public int size() {
            return this.s.size();
        }

        @Override
        public boolean isEmpty() {
            return this.s.isEmpty();
        }

        @Override
        public void clear() {
            this.s.clear();
        }

        @Override
        public Iterator<Map.Entry<String, String>> iterator() {
            return new Iterator<Map.Entry<String, String>>(){
                Iterator<Map.Entry<String, String>> i;
                {
                    this.i = CheckedEntrySet.this.s.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public Map.Entry<String, String> next() {
                    return new CheckedEntry(this.i.next());
                }

                @Override
                public void remove() {
                    this.i.remove();
                }
            };
        }

        private static Map.Entry<String, String> checkedEntry(Object object) {
            Map.Entry entry = (Map.Entry)object;
            ProcessEnvironment.nonNullString(entry.getKey());
            ProcessEnvironment.nonNullString(entry.getValue());
            return entry;
        }

        @Override
        public boolean contains(Object object) {
            return this.s.contains(CheckedEntrySet.checkedEntry(object));
        }

        @Override
        public boolean remove(Object object) {
            return this.s.remove(CheckedEntrySet.checkedEntry(object));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CheckedKeySet
    extends AbstractSet<String> {
        private final Set<String> s;

        public CheckedKeySet(Set<String> set) {
            this.s = set;
        }

        @Override
        public int size() {
            return this.s.size();
        }

        @Override
        public boolean isEmpty() {
            return this.s.isEmpty();
        }

        @Override
        public void clear() {
            this.s.clear();
        }

        @Override
        public Iterator<String> iterator() {
            return this.s.iterator();
        }

        @Override
        public boolean contains(Object object) {
            return this.s.contains(ProcessEnvironment.nonNullString(object));
        }

        @Override
        public boolean remove(Object object) {
            return this.s.remove(ProcessEnvironment.nonNullString(object));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CheckedValues
    extends AbstractCollection<String> {
        private final Collection<String> c;

        public CheckedValues(Collection<String> collection) {
            this.c = collection;
        }

        @Override
        public int size() {
            return this.c.size();
        }

        @Override
        public boolean isEmpty() {
            return this.c.isEmpty();
        }

        @Override
        public void clear() {
            this.c.clear();
        }

        @Override
        public Iterator<String> iterator() {
            return this.c.iterator();
        }

        @Override
        public boolean contains(Object object) {
            return this.c.contains(ProcessEnvironment.nonNullString(object));
        }

        @Override
        public boolean remove(Object object) {
            return this.c.remove(ProcessEnvironment.nonNullString(object));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EntryComparator
    implements Comparator<Map.Entry<String, String>> {
        private EntryComparator() {
        }

        @Override
        public int compare(Map.Entry<String, String> entry, Map.Entry<String, String> entry2) {
            return entry.getKey().compareToIgnoreCase(entry2.getKey());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NameComparator
    implements Comparator<String> {
        private NameComparator() {
        }

        @Override
        public int compare(String string, String string2) {
            return string.compareToIgnoreCase(string2);
        }
    }
}

