/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import java.util.TreeMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;

public class CompositeType
extends OpenType
implements Serializable {
    static final long serialVersionUID = -5366242454346948798L;
    private TreeMap nameToDescription;
    private TreeMap nameToType;
    private transient Integer myHashCode = null;
    private transient String myToString = null;
    private transient Set myNamesSet = null;

    public CompositeType(String string, String string2, String[] stringArray, String[] stringArray2, OpenType[] openTypeArray) throws OpenDataException {
        super(CompositeData.class.getName(), string, string2);
        CompositeType.checkForNullElement(stringArray, "itemNames");
        CompositeType.checkForNullElement(stringArray2, "itemDescriptions");
        CompositeType.checkForNullElement(openTypeArray, "itemTypes");
        CompositeType.checkForEmptyString(stringArray, "itemNames");
        CompositeType.checkForEmptyString(stringArray2, "itemDescriptions");
        if (stringArray.length != stringArray2.length || stringArray.length != openTypeArray.length) {
            throw new IllegalArgumentException("Array arguments itemNames[], itemDescriptions[] and itemTypes[] should be of same length (got " + stringArray.length + ", " + stringArray2.length + " and " + openTypeArray.length + ").");
        }
        this.nameToDescription = new TreeMap();
        this.nameToType = new TreeMap();
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i].trim();
            if (this.nameToDescription.containsKey(string3)) {
                throw new OpenDataException("Argument's element itemNames[" + i + "]=\"" + stringArray[i] + "\" duplicates a previous item names.");
            }
            this.nameToDescription.put(string3, stringArray2[i].trim());
            this.nameToType.put(string3, openTypeArray[i]);
        }
    }

    private static void checkForNullElement(Object[] objectArray, String string) {
        if (objectArray == null || objectArray.length == 0) {
            throw new IllegalArgumentException("Argument " + string + "[] cannot be null or empty.");
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != null) continue;
            throw new IllegalArgumentException("Argument's element " + string + "[" + i + "] cannot be null.");
        }
    }

    private static void checkForEmptyString(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].trim().equals("")) continue;
            throw new IllegalArgumentException("Argument's element " + string + "[" + i + "] cannot be an empty string.");
        }
    }

    public boolean containsKey(String string) {
        if (string == null) {
            return false;
        }
        return this.nameToDescription.containsKey(string);
    }

    public String getDescription(String string) {
        if (string == null) {
            return null;
        }
        return (String)this.nameToDescription.get(string);
    }

    public OpenType getType(String string) {
        if (string == null) {
            return null;
        }
        return (OpenType)this.nameToType.get(string);
    }

    public Set keySet() {
        if (this.myNamesSet == null) {
            this.myNamesSet = Collections.unmodifiableSet(this.nameToDescription.keySet());
        }
        return this.myNamesSet;
    }

    public boolean isValue(Object object) {
        CompositeData compositeData;
        if (object == null) {
            return false;
        }
        try {
            compositeData = (CompositeData)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return this.equals(compositeData.getCompositeType());
    }

    public boolean equals(Object object) {
        CompositeType compositeType;
        if (object == null) {
            return false;
        }
        try {
            compositeType = (CompositeType)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        if (!this.getTypeName().equals(compositeType.getTypeName())) {
            return false;
        }
        return this.nameToType.equals(compositeType.nameToType);
    }

    public int hashCode() {
        if (this.myHashCode == null) {
            int n = 0;
            n += this.getTypeName().hashCode();
            for (String string : this.nameToDescription.keySet()) {
                n += string.hashCode();
                n += this.nameToType.get(string).hashCode();
            }
            this.myHashCode = new Integer(n);
        }
        return this.myHashCode;
    }

    public String toString() {
        if (this.myToString == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getClass().getName());
            stringBuffer.append("(name=");
            stringBuffer.append(this.getTypeName());
            stringBuffer.append(",items=(");
            int n = 0;
            for (String string : this.nameToType.keySet()) {
                if (n > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append("(itemName=");
                stringBuffer.append(string);
                stringBuffer.append(",itemType=");
                stringBuffer.append(this.nameToType.get(string).toString() + ")");
                ++n;
            }
            stringBuffer.append("))");
            this.myToString = stringBuffer.toString();
        }
        return this.myToString;
    }
}

