/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import com.sun.java.swing.SwingUtilities2;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseMotionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;

public class BasicButtonUI
extends ButtonUI {
    private static final BasicButtonUI buttonUI = new BasicButtonUI();
    protected int defaultTextIconGap;
    private int shiftOffset = 0;
    protected int defaultTextShiftOffset;
    private static final String propertyPrefix = "Button.";
    private static Rectangle viewRect = new Rectangle();
    private static Rectangle textRect = new Rectangle();
    private static Rectangle iconRect = new Rectangle();

    public static ComponentUI createUI(JComponent jComponent) {
        return buttonUI;
    }

    protected String getPropertyPrefix() {
        return propertyPrefix;
    }

    public void installUI(JComponent jComponent) {
        this.installDefaults((AbstractButton)jComponent);
        this.installListeners((AbstractButton)jComponent);
        this.installKeyboardActions((AbstractButton)jComponent);
        BasicHTML.updateRenderer(jComponent, ((AbstractButton)jComponent).getText());
    }

    protected void installDefaults(AbstractButton abstractButton) {
        String string = this.getPropertyPrefix();
        this.defaultTextShiftOffset = UIManager.getInt(string + "textShiftOffset");
        if (abstractButton.isContentAreaFilled()) {
            LookAndFeel.installProperty(abstractButton, "opaque", Boolean.TRUE);
        } else {
            LookAndFeel.installProperty(abstractButton, "opaque", Boolean.FALSE);
        }
        if (abstractButton.getMargin() == null || abstractButton.getMargin() instanceof UIResource) {
            abstractButton.setMargin(UIManager.getInsets(string + "margin"));
        }
        LookAndFeel.installColorsAndFont(abstractButton, string + "background", string + "foreground", string + "font");
        LookAndFeel.installBorder(abstractButton, string + "border");
        Object object = UIManager.get(string + "rollover");
        if (object != null) {
            LookAndFeel.installProperty(abstractButton, "rolloverEnabled", object);
        }
    }

    protected void installListeners(AbstractButton abstractButton) {
        BasicButtonListener basicButtonListener = this.createButtonListener(abstractButton);
        if (basicButtonListener != null) {
            abstractButton.addMouseListener(basicButtonListener);
            abstractButton.addMouseMotionListener(basicButtonListener);
            abstractButton.addFocusListener(basicButtonListener);
            abstractButton.addPropertyChangeListener(basicButtonListener);
            abstractButton.addChangeListener(basicButtonListener);
        }
    }

    protected void installKeyboardActions(AbstractButton abstractButton) {
        BasicButtonListener basicButtonListener = this.getButtonListener(abstractButton);
        if (basicButtonListener != null) {
            basicButtonListener.installKeyboardActions(abstractButton);
        }
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallKeyboardActions((AbstractButton)jComponent);
        this.uninstallListeners((AbstractButton)jComponent);
        this.uninstallDefaults((AbstractButton)jComponent);
        BasicHTML.updateRenderer(jComponent, "");
    }

    protected void uninstallKeyboardActions(AbstractButton abstractButton) {
        BasicButtonListener basicButtonListener = this.getButtonListener(abstractButton);
        if (basicButtonListener != null) {
            basicButtonListener.uninstallKeyboardActions(abstractButton);
        }
    }

    protected void uninstallListeners(AbstractButton abstractButton) {
        BasicButtonListener basicButtonListener = this.getButtonListener(abstractButton);
        if (basicButtonListener != null) {
            abstractButton.removeMouseListener(basicButtonListener);
            abstractButton.removeMouseListener(basicButtonListener);
            abstractButton.removeMouseMotionListener(basicButtonListener);
            abstractButton.removeFocusListener(basicButtonListener);
            abstractButton.removeChangeListener(basicButtonListener);
            abstractButton.removePropertyChangeListener(basicButtonListener);
        }
    }

    protected void uninstallDefaults(AbstractButton abstractButton) {
        LookAndFeel.uninstallBorder(abstractButton);
    }

    protected BasicButtonListener createButtonListener(AbstractButton abstractButton) {
        return new BasicButtonListener(abstractButton);
    }

    public int getDefaultTextIconGap(AbstractButton abstractButton) {
        return this.defaultTextIconGap;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        FontMetrics fontMetrics = SwingUtilities2.getFontMetrics(abstractButton, graphics);
        Insets insets = jComponent.getInsets();
        BasicButtonUI.viewRect.x = insets.left;
        BasicButtonUI.viewRect.y = insets.top;
        BasicButtonUI.viewRect.width = abstractButton.getWidth() - (insets.right + BasicButtonUI.viewRect.x);
        BasicButtonUI.viewRect.height = abstractButton.getHeight() - (insets.bottom + BasicButtonUI.viewRect.y);
        BasicButtonUI.textRect.height = 0;
        BasicButtonUI.textRect.width = 0;
        BasicButtonUI.textRect.y = 0;
        BasicButtonUI.textRect.x = 0;
        BasicButtonUI.iconRect.height = 0;
        BasicButtonUI.iconRect.width = 0;
        BasicButtonUI.iconRect.y = 0;
        BasicButtonUI.iconRect.x = 0;
        Font font = jComponent.getFont();
        graphics.setFont(font);
        String string = SwingUtilities.layoutCompoundLabel(jComponent, fontMetrics, abstractButton.getText(), abstractButton.getIcon(), abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), viewRect, iconRect, textRect, abstractButton.getText() == null ? 0 : abstractButton.getIconTextGap());
        this.clearTextShiftOffset();
        if (buttonModel.isArmed() && buttonModel.isPressed()) {
            this.paintButtonPressed(graphics, abstractButton);
        }
        if (abstractButton.getIcon() != null) {
            this.paintIcon(graphics, jComponent, iconRect);
        }
        if (string != null && !string.equals("")) {
            View view = (View)jComponent.getClientProperty("html");
            if (view != null) {
                view.paint(graphics, textRect);
            } else {
                this.paintText(graphics, abstractButton, textRect, string);
            }
        }
        if (abstractButton.isFocusPainted() && abstractButton.hasFocus()) {
            this.paintFocus(graphics, abstractButton, viewRect, textRect, iconRect);
        }
    }

    protected void paintIcon(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        Icon icon = abstractButton.getIcon();
        Icon icon2 = null;
        if (icon == null) {
            return;
        }
        if (!buttonModel.isEnabled()) {
            icon2 = buttonModel.isSelected() ? abstractButton.getDisabledSelectedIcon() : abstractButton.getDisabledIcon();
        } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
            icon2 = abstractButton.getPressedIcon();
            if (icon2 != null) {
                this.clearTextShiftOffset();
            }
        } else if (abstractButton.isRolloverEnabled() && buttonModel.isRollover()) {
            icon2 = buttonModel.isSelected() ? abstractButton.getRolloverSelectedIcon() : abstractButton.getRolloverIcon();
        } else if (buttonModel.isSelected()) {
            icon2 = abstractButton.getSelectedIcon();
        }
        if (icon2 != null) {
            icon = icon2;
        }
        if (buttonModel.isPressed() && buttonModel.isArmed()) {
            icon.paintIcon(jComponent, graphics, rectangle.x + this.getTextShiftOffset(), rectangle.y + this.getTextShiftOffset());
        } else {
            icon.paintIcon(jComponent, graphics, rectangle.x, rectangle.y);
        }
    }

    protected void paintText(Graphics graphics, JComponent jComponent, Rectangle rectangle, String string) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        FontMetrics fontMetrics = SwingUtilities2.getFontMetrics(jComponent, graphics);
        int n = abstractButton.getDisplayedMnemonicIndex();
        if (buttonModel.isEnabled()) {
            graphics.setColor(abstractButton.getForeground());
            SwingUtilities2.drawStringUnderlineCharAt(jComponent, graphics, string, n, rectangle.x + this.getTextShiftOffset(), rectangle.y + fontMetrics.getAscent() + this.getTextShiftOffset());
        } else {
            graphics.setColor(abstractButton.getBackground().brighter());
            SwingUtilities2.drawStringUnderlineCharAt(jComponent, graphics, string, n, rectangle.x, rectangle.y + fontMetrics.getAscent());
            graphics.setColor(abstractButton.getBackground().darker());
            SwingUtilities2.drawStringUnderlineCharAt(jComponent, graphics, string, n, rectangle.x - 1, rectangle.y + fontMetrics.getAscent() - 1);
        }
    }

    protected void paintText(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, String string) {
        this.paintText(graphics, (JComponent)abstractButton, rectangle, string);
    }

    protected void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
    }

    protected void paintButtonPressed(Graphics graphics, AbstractButton abstractButton) {
    }

    protected void clearTextShiftOffset() {
        this.shiftOffset = 0;
    }

    protected void setTextShiftOffset() {
        this.shiftOffset = this.defaultTextShiftOffset;
    }

    protected int getTextShiftOffset() {
        return this.shiftOffset;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(jComponent);
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension.width = (int)((float)dimension.width - (view.getPreferredSpan(0) - view.getMinimumSpan(0)));
        }
        return dimension;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        return BasicGraphicsUtils.getPreferredButtonSize(abstractButton, abstractButton.getIconTextGap());
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(jComponent);
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension.width = (int)((float)dimension.width + (view.getMaximumSpan(0) - view.getPreferredSpan(0)));
        }
        return dimension;
    }

    private BasicButtonListener getButtonListener(AbstractButton abstractButton) {
        MouseMotionListener[] mouseMotionListenerArray = abstractButton.getMouseMotionListeners();
        if (mouseMotionListenerArray != null) {
            for (int i = 0; i < mouseMotionListenerArray.length; ++i) {
                if (!(mouseMotionListenerArray[i] instanceof BasicButtonListener)) continue;
                return (BasicButtonListener)mouseMotionListenerArray[i];
            }
        }
        return null;
    }
}

