/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicEditorPaneUI;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthTextFieldUI;
import javax.swing.text.JTextComponent;
import sun.swing.plaf.synth.SynthUI;

class SynthEditorPaneUI
extends BasicEditorPaneUI
implements SynthUI {
    private SynthStyle style;
    private Boolean localTrue = new Boolean(true);
    private Boolean localFalse = new Boolean(false);

    SynthEditorPaneUI() {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthEditorPaneUI();
    }

    protected void installDefaults() {
        JTextComponent jTextComponent = this.getComponent();
        Object object = jTextComponent.getClientProperty("JEditorPane.honorDisplayProperties");
        if (object == null || object == this.localFalse) {
            jTextComponent.putClientProperty("JEditorPane.honorDisplayProperties", this.localTrue);
        }
        this.updateStyle(this.getComponent());
    }

    protected void uninstallDefaults() {
        SynthContext synthContext = this.getContext(this.getComponent(), 1);
        JTextComponent jTextComponent = this.getComponent();
        jTextComponent.putClientProperty("caretAspectRatio", null);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
        Object object = jTextComponent.getClientProperty("JEditorPane.honorDisplayProperties");
        if (object == this.localTrue) {
            this.getComponent().putClientProperty("JEditorPane.honorDisplayProperties", Boolean.FALSE);
        }
        super.uninstallDefaults();
    }

    protected void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
            this.updateStyle((JTextComponent)propertyChangeEvent.getSource());
        }
        super.propertyChange(propertyChangeEvent);
    }

    private void updateStyle(JTextComponent jTextComponent) {
        SynthContext synthContext = this.getContext(jTextComponent, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (this.style != synthStyle) {
            SynthTextFieldUI.updateStyle(jTextComponent, synthContext, this.getPropertyPrefix());
            if (synthStyle != null) {
                this.uninstallKeyboardActions();
                this.installKeyboardActions();
            }
        }
        synthContext.dispose();
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n) {
        return SynthContext.getContext(SynthContext.class, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n);
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        this.paintBackground(synthContext, graphics, jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
        super.paint(graphics, this.getComponent());
    }

    protected void paintBackground(Graphics graphics) {
    }

    void paintBackground(SynthContext synthContext, Graphics graphics, JComponent jComponent) {
        synthContext.getPainter().paintEditorPaneBackground(synthContext, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
    }

    public void paintBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        synthContext.getPainter().paintEditorPaneBorder(synthContext, graphics, n, n2, n3, n4);
    }
}

