/*
 * Decompiled with CFR 0.152.
 */
package CoreFS.SA04;

import CoreFS.SA01.CoreException;
import CoreFS.SA01.CoreExceptionHandler;
import CoreFS.SA04.CoreDBProxy;
import CoreFS.SA06.CoreReturnObject;
import CoreFS.SA06.CoreSqlType;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.rowset.SqlRowSet;

public class CoreDBManager {
    private static final long serialVersionUID = -986600646149636690L;
    protected final Log log = LogFactory.getLog(this.getClass());
    public CoreDBProxy dbProxy;

    public CoreDBManager() {
    }

    public CoreDBManager(CoreDBProxy dbproxy) {
        this.dbProxy = dbproxy;
    }

    public Connection getConnection() {
        Connection conn = null;
        try {
            conn = this.dbProxy.getJdbcTemplate().getDataSource().getConnection();
            this.log.info((Object)("\u8fde\u63a5\u6570\u636e\u5e93\u6210\u529f\uff01 " + conn));
        }
        catch (SQLException e) {
            throw new CoreException("\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25 \u8bf7\u68c0\u67e5\u7f51\u7edc\u6216\u6570\u636e\u5e93\u914d\u7f6e\u6587\u4ef6...");
        }
        return conn;
    }

    public CoreReturnObject ExcuteQuery(String sql) {
        return this.ExcuteQuery(sql, null);
    }

    public CoreReturnObject ExcuteQuery(String sql, Object[] args) {
        List rsls = new ArrayList();
        CoreReturnObject cro = new CoreReturnObject();
        rsls = this.dbProxy.getJdbcTemplate().queryForList(sql, args);
        System.out.println("size:" + rsls.size());
        cro.setResult(rsls);
        return cro;
    }

    public List ExcuteQueryReturnList(String sql, Object[] args) {
        List rsls = new ArrayList();
        CoreReturnObject cro = new CoreReturnObject();
        rsls = this.dbProxy.getJdbcTemplate().queryForList(sql, args);
        System.out.println("size:" + rsls.size());
        cro.setResult(rsls);
        return rsls;
    }

    public CoreReturnObject ExcuteQueryById(String sid) {
        return this.ExcuteQueryById(sid, null);
    }

    public CoreReturnObject ExcuteQueryById(String sid, Object[] args) {
        List rsls = new ArrayList();
        String sql = "";
        sql = this.LoadSqlByDB(sid);
        CoreReturnObject cro = new CoreReturnObject();
        rsls = this.dbProxy.getJdbcTemplate().queryForList(sql, args);
        System.out.println("size:" + rsls.size());
        cro.setResult(rsls);
        return cro;
    }

    public CoreReturnObject ExecutequeryForRowSet(String sql, Object[] args) {
        SqlRowSet srs = null;
        CoreReturnObject cro = new CoreReturnObject();
        srs = this.dbProxy.getJdbcTemplate().queryForRowSet(sql, args);
        cro.setResult(srs);
        return cro;
    }

    public CoreReturnObject ExecutequeryForRowSet(String sql) {
        return this.ExecutequeryForRowSet(sql, null);
    }

    public int getQueryCount(String sql) {
        return this.getQueryCount(sql, null);
    }

    public int getQueryCount(String sql, Object[] args) {
        return this.dbProxy.getJdbcTemplate().queryForList(sql, args).size();
    }

    public CoreReturnObject ExceuteNonQueryForBlobList(String sql) throws SQLException {
        return this.ExceuteNonQueryForBlobList(sql, null);
    }

    public CoreReturnObject ExceuteNonQueryForBlobList(String sql, Object[] args) throws SQLException {
        CoreReturnObject cro = new CoreReturnObject();
        PreparedStatement stmt = null;
        stmt = this.getPreparedStatement(sql);
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                int j = i + 1;
                if (args[i] != null) {
                    if (args[i] instanceof String) {
                        if (((String)args[i]).length() < 800) {
                            stmt.setString(j, (String)args[i]);
                        } else {
                            this.dbProxy.getLobHandler().getLobCreator().setClobAsString(stmt, j, (String)args[i]);
                        }
                    } else if (args[i] instanceof Integer) {
                        stmt.setInt(i, (Integer)args[i]);
                    } else if (args[i] instanceof Double) {
                        stmt.setDouble(i, (Double)args[i]);
                    } else if (args[i] instanceof Float) {
                        stmt.setFloat(i, ((Float)args[i]).floatValue());
                    } else if (args[i] instanceof Date) {
                        stmt.setDate(i, (Date)args[i]);
                    }
                }
                ++i;
            }
        }
        int count = stmt.executeUpdate();
        cro.setResult(count);
        return cro;
    }

    public CoreReturnObject ExceuteQueryForBlobList(String sql, Object[] args) {
        ArrayList ls;
        CoreReturnObject cro;
        block52: {
            cro = new CoreReturnObject();
            Connection conn = null;
            ls = new ArrayList();
            ResultSet rs = null;
            Statement stmt = null;
            try {
                try {
                    conn = this.dbProxy.getJdbcTemplate().getDataSource().getConnection();
                    this.log.info((Object)("\u8fde\u63a5\u6570\u636e\u5e93\u6210\u529f\uff01 " + conn));
                }
                catch (SQLException e) {
                    throw new CoreException("\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25 \u8bf7\u68c0\u67e5\u7f51\u7edc\u6216\u6570\u636e\u5e93\u914d\u7f6e\u6587\u4ef6...");
                }
                stmt = conn.prepareStatement(sql);
                if (args != null) {
                    int i = 0;
                    while (i < args.length) {
                        int j = i + 1;
                        String ii = args[i].toString();
                        if (args[i] != null) {
                            if (args[i] instanceof String) {
                                stmt.setString(j, (String)args[i]);
                            } else if (args[i] instanceof Integer) {
                                stmt.setInt(i, (Integer)args[i]);
                            } else if (args[i] instanceof Double) {
                                stmt.setDouble(i, (Double)args[i]);
                            } else if (args[i] instanceof Float) {
                                stmt.setFloat(i, ((Float)args[i]).floatValue());
                            } else if (args[i] instanceof Date) {
                                stmt.setDate(i, (Date)args[i]);
                            }
                        }
                        ++i;
                    }
                }
                rs = stmt.executeQuery();
                int clumncount = rs.getMetaData().getColumnCount();
                int columntype = 0;
                String columnname = "";
                while (rs.next()) {
                    LinkedHashMap rowmap = new LinkedHashMap();
                    int i = 1;
                    while (i <= clumncount) {
                        HashMap<String, Object> table = new HashMap<String, Object>();
                        columntype = rs.getMetaData().getColumnType(i);
                        columnname = rs.getMetaData().getColumnName(i);
                        switch (columntype) {
                            case 12: {
                                table.put(columnname, (String)rs.getObject(i));
                                break;
                            }
                            case 2: {
                                table.put(columnname, (Number)rs.getObject(i));
                                break;
                            }
                            case 2004: {
                                byte[] barry = this.dbProxy.getLobHandler().getBlobAsBytes(rs, i);
                                if (barry == null) {
                                    table.put(columnname, new byte[0]);
                                    break;
                                }
                                table.put(columnname, barry);
                                break;
                            }
                            case 2005: {
                                table.put(columnname, this.dbProxy.getLobHandler().getClobAsString(rs, i));
                                break;
                            }
                            case 4: {
                                table.put(columnname, (Integer)rs.getObject(i));
                                break;
                            }
                            case 8: {
                                table.put(columnname, (Double)rs.getObject(i));
                                break;
                            }
                            case 6: {
                                table.put(columnname, (Float)rs.getObject(i));
                                break;
                            }
                            case 91: {
                                table.put(columnname, (Date)rs.getObject(i));
                                break;
                            }
                            default: {
                                throw new CoreException("\u8d85\u51fa\u5e73\u53f0\u6240\u5b9a\u4e49\u7684\u7c7b\u578b ... ");
                            }
                        }
                        rowmap.putAll(table);
                        ++i;
                    }
                    ls.add(rowmap);
                }
            }
            catch (SQLException e) {
                this.log.equals(e);
                try {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (stmt != null) {
                            stmt.close();
                        }
                        if (conn != null) {
                            conn.close();
                        }
                    }
                    catch (SQLException e1) {
                        e1.printStackTrace();
                        try {
                            if (rs != null) {
                                rs.close();
                            }
                            if (stmt != null) {
                                stmt.close();
                            }
                            if (conn != null) {
                                conn.close();
                            }
                            break block52;
                        }
                        catch (SQLException e12) {
                            e12.printStackTrace();
                        }
                        break block52;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (stmt != null) {
                            stmt.close();
                        }
                        if (conn != null) {
                            conn.close();
                        }
                    }
                    catch (SQLException e1) {
                        e1.printStackTrace();
                    }
                    throw throwable;
                }
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
        }
        cro.setResult(ls);
        System.out.print(ls.size());
        return cro;
    }

    public CoreReturnObject ExceuteQueryForBlobList(String sql) {
        return this.ExceuteQueryForBlobList(sql, null);
    }

    public ResultSet ExceuteQueryForResultSet(String sql, Object[] args) {
        ResultSet rs = null;
        Statement stmt = null;
        Connection conn = this.getConnection();
        try {
            stmt = conn.createStatement(1005, 1008);
            rs = stmt.executeQuery(sql);
        }
        catch (SQLException e) {
            JdbcUtils.closeConnection((Connection)conn);
            conn = null;
            JdbcUtils.closeStatement((Statement)stmt);
            stmt = null;
            JdbcUtils.closeResultSet((ResultSet)rs);
            rs = null;
            e.printStackTrace();
        }
        return rs;
    }

    public ResultSet ExceuteQueryForResultSet(String sql) {
        return this.ExceuteQueryForResultSet(sql, null);
    }

    public CoreReturnObject ExcuteNonQuery(String sql) {
        return this.ExcuteNonQuery(sql, null);
    }

    public CoreReturnObject ExcuteNonQuery(String sql, Object[] args) {
        CoreReturnObject cro = new CoreReturnObject();
        int count = 0;
        try {
            count = this.dbProxy.getJdbcTemplate().update(sql, args);
        }
        catch (CoreException ce) {
            cro = CoreExceptionHandler.coreExceptionHandler(ce);
        }
        catch (Exception e) {
            cro = CoreExceptionHandler.exceptionHandler(e);
        }
        cro.setResult(count);
        return cro;
    }

    public CoreReturnObject ExcuteNonQueryById(String sid) {
        return this.ExcuteNonQueryById(sid, null);
    }

    public CoreReturnObject ExcuteNonQueryById(String sid, Object[] args) {
        CoreReturnObject cro = new CoreReturnObject();
        String sql = "";
        sql = this.LoadSqlByDB(sid);
        int count = 0;
        try {
            count = this.dbProxy.getJdbcTemplate().update(sql, args);
        }
        catch (CoreException ce) {
            cro = CoreExceptionHandler.coreExceptionHandler(ce);
        }
        catch (Exception e) {
            cro = CoreExceptionHandler.exceptionHandler(e);
        }
        cro.setResult(count);
        return cro;
    }

    public CallableStatement getCallableStatement(String s) {
        CallableStatement callablestatement = null;
        try {
            callablestatement = this.getConnection().prepareCall(s);
        }
        catch (Exception e) {
            try {
                throw new Exception("Can not create CallableStatement!! SQL [" + s + "]", e);
            }
            catch (Exception ex) {
                try {
                    callablestatement.close();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
                callablestatement = null;
                ex.printStackTrace();
            }
        }
        return callablestatement;
    }

    public CoreReturnObject ExcuteProcedure(String name, ArrayList sqltypes, ArrayList sqlparams) {
        CallableStatement cstmt = null;
        cstmt = this.getCallableStatement(name);
        return this.setbatch(sqltypes, sqlparams, cstmt);
    }

    public CoreReturnObject ExcuteProcedure(String name, ArrayList sqltypes, ArrayList sqlparams, ArrayList outSqltypes, ArrayList outparm) {
        int len = sqltypes.size() + outSqltypes.size();
        String query = "";
        int i = 0;
        while (i < len) {
            query = i == len - 1 ? String.valueOf(query) + "?" : String.valueOf(query) + "?,";
            ++i;
        }
        String sname = "{call " + name + "(" + query + ")}";
        CallableStatement cstmt = null;
        cstmt = this.getCallableStatement(sname);
        return this.setbatch(sqltypes, sqlparams, cstmt, outSqltypes, outparm);
    }

    public CoreReturnObject ExcuteProcedure(String name, String[] inparams, String[] outparams) {
        CoreReturnObject cro = new CoreReturnObject();
        CallableStatement cstmt = null;
        cstmt = this.getCallableStatement(name);
        try {
            try {
                if (cstmt != null) {
                    int i = 0;
                    while (i < inparams.length) {
                        cstmt.setString(i + 1, inparams[i]);
                        ++i;
                    }
                    i = 0;
                    int j = inparams.length + 1;
                    while (i < outparams.length) {
                        cstmt.registerOutParameter(j, 12);
                        ++i;
                        ++j;
                    }
                    cstmt.execute();
                    ArrayList<String> outls = new ArrayList<String>();
                    int i2 = 0;
                    int j2 = inparams.length + 1;
                    while (i2 < outparams.length) {
                        outparams[i2] = cstmt.getString(j2);
                        outls.add(outparams[i2]);
                        ++i2;
                        ++j2;
                    }
                    cro.setResult(outls);
                }
            }
            catch (CoreException ce) {
                cro = CoreExceptionHandler.coreExceptionHandler(ce);
                try {
                    cstmt.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                cstmt = null;
            }
            catch (Exception e) {
                cro = CoreExceptionHandler.exceptionHandler(e);
                try {
                    cstmt.close();
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
                cstmt = null;
            }
        }
        finally {
            try {
                cstmt.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            cstmt = null;
        }
        return cro;
    }

    public PreparedStatement getPreparedStatement(String sql) {
        Statement pstmt = null;
        Connection conn = null;
        try {
            conn = this.getConnection();
            pstmt = conn.prepareStatement(sql);
        }
        catch (SQLException e) {
            try {
                pstmt.close();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            conn = null;
            e.printStackTrace();
        }
        return pstmt;
    }

    public CoreReturnObject setbatch(ArrayList lts, ArrayList lps, CallableStatement cstmt) {
        CoreReturnObject cro = new CoreReturnObject();
        try {
            try {
                if (cstmt != null) {
                    ArrayList<String> outMsgList = new ArrayList<String>();
                    Object obj = null;
                    int outbegin = 0;
                    boolean cnt_out_begin = false;
                    int i = 0;
                    while (i < lts.size()) {
                        int j = i + 1;
                        CoreSqlType.CoreOracleType m = (CoreSqlType.CoreOracleType)((Object)lts.get(i));
                        obj = lps.get(i);
                        if (m == CoreSqlType.CoreOracleType.STRING_TYPE) {
                            cstmt.setString(j, (String)obj);
                        } else if (m == CoreSqlType.CoreOracleType.INTEGER_TYPE) {
                            cstmt.setInt(j, (int)obj);
                        } else if (m == CoreSqlType.CoreOracleType.FLOAT_TYPE) {
                            cstmt.setFloat(j, ((Float)obj).floatValue());
                        } else if (m == CoreSqlType.CoreOracleType.DOUBLE_TYPE) {
                            cstmt.setDouble(j, (double)obj);
                        } else if (m == CoreSqlType.CoreOracleType.DATE_TYPE) {
                            cstmt.setDate(j, (Date)obj);
                        } else if (m == CoreSqlType.CoreOracleType.TIME_TYPE) {
                            cstmt.setTime(j, (Time)obj);
                        } else if (m == CoreSqlType.CoreOracleType.TIMESTAMP_TYPE) {
                            cstmt.setTimestamp(j, (Timestamp)obj);
                        } else if (m == CoreSqlType.CoreOracleType.BLOB_TYPE) {
                            this.dbProxy.getLobHandler().getLobCreator().setBlobAsBytes((PreparedStatement)cstmt, j, (byte[])obj);
                        } else if (m == CoreSqlType.CoreOracleType.CLOB_TYPE) {
                            this.dbProxy.getLobHandler().getLobCreator().setClobAsString((PreparedStatement)cstmt, j, (String)obj);
                        } else if (m == CoreSqlType.CoreOracleType.BOOLEAN_TYPE) {
                            cstmt.setBoolean(j, (boolean)obj);
                        } else if (m == CoreSqlType.CoreOracleType.BYTES_TYPE) {
                            this.dbProxy.getLobHandler().getLobCreator().setBlobAsBytes((PreparedStatement)cstmt, j, (byte[])obj);
                        }
                        ++i;
                    }
                    cstmt.execute();
                    int j = outbegin;
                    while (outbegin <= lts.size()) {
                        outMsgList.add(cstmt.getString(j));
                        ++outbegin;
                    }
                    cro.setResult(outMsgList);
                }
            }
            catch (CoreException ce) {
                cro = CoreExceptionHandler.coreExceptionHandler(ce);
                try {
                    cstmt.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                cstmt = null;
            }
            catch (Exception e) {
                cro = CoreExceptionHandler.exceptionHandler(e);
                try {
                    cstmt.close();
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
                cstmt = null;
            }
        }
        finally {
            try {
                cstmt.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            cstmt = null;
        }
        return cro;
    }

    public CoreReturnObject setbatch(ArrayList lts, ArrayList lps, CallableStatement cstmt, ArrayList outparm, ArrayList outty) {
        CoreReturnObject cro = new CoreReturnObject();
        try {
            try {
                if (cstmt != null) {
                    int m;
                    int j;
                    Object obj = null;
                    boolean outbegin = false;
                    boolean cnt_out_begin = false;
                    int i = 0;
                    while (i < lts.size()) {
                        j = i + 1;
                        m = Integer.parseInt(lts.get(i).toString());
                        obj = lps.get(i);
                        if (m == CoreSqlType.CoreOracleType.STRING_TYPE.ordinal()) {
                            cstmt.setString(j, (String)obj);
                        } else if (m == CoreSqlType.CoreOracleType.INTEGER_TYPE.ordinal()) {
                            cstmt.setInt(j, (int)obj);
                        } else if (m == CoreSqlType.CoreOracleType.FLOAT_TYPE.ordinal()) {
                            cstmt.setFloat(j, ((Float)obj).floatValue());
                        } else if (m == CoreSqlType.CoreOracleType.DOUBLE_TYPE.ordinal()) {
                            cstmt.setDouble(j, (double)obj);
                        } else if (m == CoreSqlType.CoreOracleType.DATE_TYPE.ordinal()) {
                            cstmt.setDate(j, (Date)obj);
                        } else if (m == CoreSqlType.CoreOracleType.TIME_TYPE.ordinal()) {
                            cstmt.setTime(j, (Time)obj);
                        } else if (m == CoreSqlType.CoreOracleType.TIMESTAMP_TYPE.ordinal()) {
                            cstmt.setTimestamp(j, (Timestamp)obj);
                        } else if (m == CoreSqlType.CoreOracleType.BLOB_TYPE.ordinal()) {
                            this.dbProxy.getLobHandler().getLobCreator().setBlobAsBytes((PreparedStatement)cstmt, j, (byte[])obj);
                        } else if (m == CoreSqlType.CoreOracleType.CLOB_TYPE.ordinal()) {
                            this.dbProxy.getLobHandler().getLobCreator().setClobAsString((PreparedStatement)cstmt, j, (String)obj);
                        } else if (m == CoreSqlType.CoreOracleType.BOOLEAN_TYPE.ordinal()) {
                            cstmt.setBoolean(j, (boolean)obj);
                        } else if (m == CoreSqlType.CoreOracleType.BYTES_TYPE.ordinal()) {
                            this.dbProxy.getLobHandler().getLobCreator().setBlobAsBytes((PreparedStatement)cstmt, j, (byte[])obj);
                        }
                        ++i;
                    }
                    i = 0;
                    j = lts.size() + 1;
                    while (i < outparm.size()) {
                        m = Integer.parseInt(outparm.get(i).toString());
                        if (m == CoreSqlType.CoreOracleType.STRING_TYPE.ordinal()) {
                            cstmt.registerOutParameter(j, 12);
                        } else if (m == CoreSqlType.CoreOracleType.INTEGER_TYPE.ordinal()) {
                            cstmt.registerOutParameter(j, 4);
                        } else if (m == CoreSqlType.CoreOracleType.FLOAT_TYPE.ordinal()) {
                            cstmt.registerOutParameter(j, 6);
                        } else if (m == CoreSqlType.CoreOracleType.DOUBLE_TYPE.ordinal()) {
                            cstmt.registerOutParameter(j, 8);
                        } else if (m == CoreSqlType.CoreOracleType.DATE_TYPE.ordinal()) {
                            cstmt.registerOutParameter(j, 91);
                        } else if (m == CoreSqlType.CoreOracleType.TIME_TYPE.ordinal()) {
                            cstmt.registerOutParameter(j, 92);
                        } else if (m == CoreSqlType.CoreOracleType.TIMESTAMP_TYPE.ordinal()) {
                            cstmt.registerOutParameter(j, 93);
                        } else if (m == CoreSqlType.CoreOracleType.BLOB_TYPE.ordinal()) {
                            cstmt.registerOutParameter(j, 2004);
                        } else if (m == CoreSqlType.CoreOracleType.CLOB_TYPE.ordinal()) {
                            cstmt.registerOutParameter(j, 2005);
                        } else if (m == CoreSqlType.CoreOracleType.BOOLEAN_TYPE.ordinal()) {
                            cstmt.registerOutParameter(j, 16);
                        }
                        ++i;
                        ++j;
                    }
                    cstmt.execute();
                    i = 0;
                    j = lts.size() + 1;
                    while (i < outparm.size()) {
                        m = Integer.parseInt(outparm.get(i).toString());
                        if (m == CoreSqlType.CoreOracleType.STRING_TYPE.ordinal()) {
                            outty.add(cstmt.getString(j));
                        } else if (m == CoreSqlType.CoreOracleType.INTEGER_TYPE.ordinal()) {
                            outty.add(cstmt.getInt(j));
                        } else if (m == CoreSqlType.CoreOracleType.FLOAT_TYPE.ordinal()) {
                            outty.add(Float.valueOf(cstmt.getFloat(j)));
                        } else if (m == CoreSqlType.CoreOracleType.DOUBLE_TYPE.ordinal()) {
                            outty.add(cstmt.getDouble(j));
                        } else if (m == CoreSqlType.CoreOracleType.DATE_TYPE.ordinal()) {
                            outty.add(cstmt.getDate(j));
                        } else if (m == CoreSqlType.CoreOracleType.TIME_TYPE.ordinal()) {
                            outty.add(cstmt.getTime(j));
                        } else if (m == CoreSqlType.CoreOracleType.TIMESTAMP_TYPE.ordinal()) {
                            outty.add(cstmt.getTimestamp(j));
                        } else if (m == CoreSqlType.CoreOracleType.BLOB_TYPE.ordinal()) {
                            outty.add(cstmt.getBlob(j));
                        } else if (m == CoreSqlType.CoreOracleType.CLOB_TYPE.ordinal()) {
                            outty.add(cstmt.getClob(j));
                        } else if (m == CoreSqlType.CoreOracleType.BOOLEAN_TYPE.ordinal()) {
                            outty.add(cstmt.getBoolean(j));
                        }
                        ++i;
                        ++j;
                    }
                    cro.setResult(outty);
                }
            }
            catch (CoreException ce) {
                cro = CoreExceptionHandler.coreExceptionHandler(ce);
                try {
                    cstmt.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                cstmt = null;
            }
            catch (Exception e) {
                cro = CoreExceptionHandler.exceptionHandler(e);
                try {
                    cstmt.close();
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
                cstmt = null;
            }
        }
        finally {
            try {
                cstmt.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            cstmt = null;
        }
        return cro;
    }

    public String LoadXMLFromDB(String sql, String id) {
        Connection conn = null;
        String xml = "";
        ResultSet rs = null;
        Statement stmt = null;
        try {
            try {
                try {
                    conn = this.dbProxy.getJdbcTemplate().getDataSource().getConnection();
                    this.log.info((Object)("\u8fde\u63a5\u6570\u636e\u5e93\u6210\u529f\uff01 " + conn));
                }
                catch (SQLException e) {
                    System.out.println("\u9519\u8bed\uff1a" + e);
                    throw new CoreException("\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25 \u8bf7\u68c0\u67e5\u7f51\u7edc\u6216\u6570\u636e\u5e93\u914d\u7f6e\u6587\u4ef6...");
                }
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, id);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    xml = this.dbProxy.getLobHandler().getClobAsString(rs, 1);
                }
            }
            catch (SQLException e) {
                this.log.error((Object)e);
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
        }
        return xml;
    }

    public String LoadSqlByDB(String sid) {
        String sql = "";
        String selSql = "select CONTENT from core_app_sqldir where ID='" + sid + "'";
        Connection conn = null;
        ResultSet rs = null;
        Statement stmt = null;
        try {
            try {
                try {
                    conn = this.dbProxy.getJdbcTemplate().getDataSource().getConnection();
                    this.log.info((Object)("\u8fde\u63a5\u6570\u636e\u5e93\u6210\u529f\uff01 " + conn));
                }
                catch (SQLException e) {
                    throw new CoreException("\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25 \u8bf7\u68c0\u67e5\u7f51\u7edc\u6216\u6570\u636e\u5e93\u914d\u7f6e\u6587\u4ef6...");
                }
                stmt = conn.prepareStatement(selSql);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    sql = this.dbProxy.getLobHandler().getClobAsString(rs, 1);
                }
            }
            catch (SQLException e) {
                this.log.error((Object)e);
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
        }
        return sql;
    }

    public static void main(String[] args) {
    }
}

