/*
 * Decompiled with CFR 0.152.
 */
package CoreFS.SC01;

import CoreFS.SA06.CoreReturnObject;
import CoreFS.SC01.Bytes;
import com.sun.management.OperatingSystemMXBean;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Serializable;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import sun.management.ManagementFactory;

public class CorePerformanceMonitor {
    private static final int CPUTIME = 1000;
    private static final int PERCENT = 100;
    private static final int FAULTLENGTH = 10;
    private static final int delt = 0x100000;
    private static List monitorInfoList = new ArrayList();

    public static CoreReturnObject getMonitorInfo() {
        ArrayList<Serializable> monitorInfoList = new ArrayList<Serializable>();
        monitorInfoList.add(0, CorePerformanceMonitor.getJvmMemoryInfo());
        monitorInfoList.add(1, CorePerformanceMonitor.getPhysicMemoryInfo());
        monitorInfoList.add(2, Double.valueOf(CorePerformanceMonitor.getCpuUsedInfo()));
        monitorInfoList.add(3, CorePerformanceMonitor.getThreadInfo());
        CoreReturnObject cro = new CoreReturnObject();
        cro.setResult(monitorInfoList);
        return cro;
    }

    public static HashMap getJvmMemoryInfo() {
        long totalMemory = Runtime.getRuntime().totalMemory() / 0x100000L;
        long freeMemory = Runtime.getRuntime().freeMemory() / 0x100000L;
        long maxMemory = Runtime.getRuntime().maxMemory() / 0x100000L;
        HashMap<String, Long> jvmMemoryHash = new HashMap<String, Long>();
        jvmMemoryHash.put("jvmTotalMemory", totalMemory);
        jvmMemoryHash.put("jvmFreeMemory", freeMemory);
        jvmMemoryHash.put("jvmMaxMemory", maxMemory);
        return jvmMemoryHash;
    }

    public static HashMap getPhysicMemoryInfo() {
        OperatingSystemMXBean osmxb = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        long totalPhysicMemory = osmxb.getTotalPhysicalMemorySize() / 0x100000L;
        long freePhysicalMemory = osmxb.getFreePhysicalMemorySize() / 0x100000L;
        long usedPhysicMemory = (osmxb.getTotalPhysicalMemorySize() - osmxb.getFreePhysicalMemorySize()) / 0x100000L;
        HashMap<String, Long> physicMemoryHash = new HashMap<String, Long>();
        physicMemoryHash.put("physicTotalMemory", totalPhysicMemory);
        physicMemoryHash.put("physicFreeMemory", freePhysicalMemory);
        physicMemoryHash.put("physicUsedMemory", usedPhysicMemory);
        return physicMemoryHash;
    }

    public static double getCpuUsedInfo() {
        String osName = System.getProperty("os.name");
        double cpuUsedRatio = 0.0;
        cpuUsedRatio = osName.toLowerCase().startsWith("windows") ? CorePerformanceMonitor.getCpuRatioForWindows() : CorePerformanceMonitor.getCpuRateForUnix();
        return cpuUsedRatio;
    }

    private static double getCpuRateForUnix() {
        double d;
        InputStream is = null;
        InputStreamReader isr = null;
        BufferedReader brStat = null;
        StringTokenizer tokenStat = null;
        try {
            Process process = Runtime.getRuntime().exec("top -b -n 1");
            is = process.getInputStream();
            isr = new InputStreamReader(is);
            brStat = new BufferedReader(isr);
            brStat.readLine();
            brStat.readLine();
            brStat.readLine();
            brStat.readLine();
            tokenStat = new StringTokenizer(brStat.readLine());
            tokenStat.nextToken();
            tokenStat.nextToken();
            String user = tokenStat.nextToken();
            tokenStat.nextToken();
            String system = tokenStat.nextToken();
            tokenStat.nextToken();
            String nice = tokenStat.nextToken();
            System.out.println(String.valueOf(user) + " , " + system + " , " + nice);
            user = user.substring(0, user.indexOf("%"));
            system = system.substring(0, system.indexOf("%"));
            nice = nice.substring(0, nice.indexOf("%"));
            double userUsage = new Float(user).floatValue();
            double systemUsage = new Float(system).floatValue();
            double niceUsage = new Float(nice).floatValue();
            d = (userUsage + systemUsage + niceUsage) / 100.0;
        }
        catch (IOException ioe) {
            try {
                System.out.println(ioe.getMessage());
                CorePerformanceMonitor.freeResource(is, isr, brStat);
            }
            catch (Throwable throwable) {
                CorePerformanceMonitor.freeResource(is, isr, brStat);
                throw throwable;
            }
            CorePerformanceMonitor.freeResource(is, isr, brStat);
            return 1.0;
        }
        CorePerformanceMonitor.freeResource(is, isr, brStat);
        return d;
    }

    private static void freeResource(InputStream is, InputStreamReader isr, BufferedReader br) {
        try {
            if (is != null) {
                is.close();
            }
            if (isr != null) {
                isr.close();
            }
            if (br != null) {
                br.close();
            }
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
        }
    }

    private static double getCpuRatioForWindows() {
        try {
            String procCmd = String.valueOf(System.getenv("windir")) + "\\system32\\wbem\\wmic.exe process get Caption,CommandLine," + "KernelModeTime,ReadOperationCount,ThreadCount,UserModeTime,WriteOperationCount";
            long[] c0 = CorePerformanceMonitor.readCpu(Runtime.getRuntime().exec(procCmd));
            Thread.sleep(1000L);
            long[] c1 = CorePerformanceMonitor.readCpu(Runtime.getRuntime().exec(procCmd));
            if (c0 != null && c1 != null) {
                long idletime = c1[0] - c0[0];
                long busytime = c1[1] - c0[1];
                return 100L * busytime / (busytime + idletime);
            }
            return 0.0;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0.0;
        }
    }

    private static long[] readCpu(Process proc) {
        long[] retn = new long[2];
        try {
            proc.getOutputStream().close();
            InputStreamReader ir = new InputStreamReader(proc.getInputStream());
            LineNumberReader input = new LineNumberReader(ir);
            String line = input.readLine();
            if (line == null || line.length() < 10) {
                return null;
            }
            int capidx = line.indexOf("Caption");
            int cmdidx = line.indexOf("CommandLine");
            int rocidx = line.indexOf("ReadOperationCount");
            int umtidx = line.indexOf("UserModeTime");
            int kmtidx = line.indexOf("KernelModeTime");
            int wocidx = line.indexOf("WriteOperationCount");
            long idletime = 0L;
            long kneltime = 0L;
            long usertime = 0L;
            while ((line = input.readLine()) != null) {
                if (line.length() < wocidx) continue;
                String caption = Bytes.substring(line, capidx, cmdidx - 1).trim();
                String cmd = Bytes.substring(line, cmdidx, kmtidx - 1).trim();
                if (cmd.indexOf("wmic.exe") >= 0) continue;
                if (caption.equals("System Idle Process") || caption.equals("System")) {
                    idletime += Long.valueOf(Bytes.substring(line, kmtidx, rocidx - 1).trim()).longValue();
                    idletime += Long.valueOf(Bytes.substring(line, umtidx, wocidx - 1).trim()).longValue();
                    continue;
                }
                kneltime += Long.valueOf(Bytes.substring(line, kmtidx, rocidx - 1).trim()).longValue();
                usertime += Long.valueOf(Bytes.substring(line, umtidx, wocidx - 1).trim()).longValue();
            }
            retn[0] = idletime;
            retn[1] = kneltime + usertime;
            long[] lArray = retn;
            return lArray;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                proc.getInputStream().close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static HashMap getThreadInfo() {
        ThreadMXBean th = ManagementFactory.getThreadMXBean();
        int activeThrdCount = th.getThreadCount();
        int daemonThrdCount = th.getDaemonThreadCount();
        int peakThrdCount = th.getPeakThreadCount();
        long currentThrdTime = th.getCurrentThreadCpuTime();
        long currentThrdUserTime = th.getCurrentThreadUserTime();
        HashMap<String, Number> threadHash = new HashMap<String, Number>();
        threadHash.put("activeThrdCount", activeThrdCount);
        threadHash.put("deamonThrdCount", daemonThrdCount);
        threadHash.put("peakThrdCount", peakThrdCount);
        threadHash.put("currentThrdTime", currentThrdTime / 1000L);
        threadHash.put("currentThrdUserTime", currentThrdUserTime / 1000L);
        return threadHash;
    }
}

