/*
 * Decompiled with CFR 0.152.
 */
package CoreFS.SD01;

import CoreFS.SA01.CoreException;
import CoreFS.SA01.CoreExceptionHandler;
import CoreFS.SA01.CoreGlobalConstants;
import CoreFS.SA01.CoreIComponent;
import CoreFS.SA05.CoreFileOperation;
import CoreFS.SA06.CoreReturnObject;
import CoreFS.SD01.CoreIRoleManage;
import CoreFS.SD01.CoreRoleBean;
import CoreFS.SD01.CoreXmlRoleBean;
import CoreFS.Util.XmlUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CoreRoleManage
extends CoreIComponent
implements CoreIRoleManage {
    private static CoreXmlRoleBean xmlbean = null;
    protected final Log log = LogFactory.getLog(this.getClass());

    public CoreXmlRoleBean getXmlbean() {
        if (xmlbean == null) {
            xmlbean = new CoreXmlRoleBean(CoreGlobalConstants.ROLEBEAN_REMOTEXMLCONFIGPATH);
        }
        return xmlbean;
    }

    private void setXmlbean(CoreXmlRoleBean xmlbean) {
        CoreRoleManage.xmlbean = xmlbean;
    }

    public CoreReturnObject add(CoreRoleBean r) {
        CoreReturnObject crb = new CoreReturnObject();
        try {
            crb = this.getXmlbean().add(CoreGlobalConstants.ROLEBEAN_REMOTEXMLCONFIGPATH, r);
        }
        catch (CoreException ce) {
            crb = CoreExceptionHandler.coreExceptionHandler(ce);
        }
        catch (Exception e) {
            crb = CoreExceptionHandler.exceptionHandler(e);
        }
        return crb;
    }

    public CoreReturnObject delete(String rid) {
        CoreReturnObject crb = new CoreReturnObject();
        try {
            crb = this.getXmlbean().delete(CoreGlobalConstants.ROLEBEAN_REMOTEXMLCONFIGPATH, rid);
        }
        catch (CoreException ce) {
            crb = CoreExceptionHandler.coreExceptionHandler(ce);
        }
        catch (Exception e) {
            crb = CoreExceptionHandler.exceptionHandler(e);
        }
        return crb;
    }

    public CoreReturnObject findByParams(String rname) {
        CoreReturnObject crb = new CoreReturnObject();
        try {
            crb = this.getXmlbean().findByParams(CoreGlobalConstants.ROLEBEAN_REMOTEXMLCONFIGPATH, rname);
        }
        catch (CoreException ce) {
            crb = CoreExceptionHandler.coreExceptionHandler(ce);
        }
        catch (Exception e) {
            crb = CoreExceptionHandler.exceptionHandler(e);
        }
        return crb;
    }

    public CoreReturnObject GetRoleData() {
        CoreReturnObject crb = new CoreReturnObject();
        try {
            XmlUtil xu = new XmlUtil();
            Document doc = xu.getDoc(CoreGlobalConstants.ROLE_REMOTEXMLCONFIGPATH);
            Element re = doc.getDocumentElement();
            NodeList rlist = re.getElementsByTagName("Row");
            ArrayList<LinkedMap> rolelist = new ArrayList<LinkedMap>();
            int i = 0;
            while (i < rlist.getLength()) {
                LinkedMap rowmap = new LinkedMap();
                Node nd = rlist.item(i);
                if (nd.hasAttributes()) {
                    HashMap<String, String> table = new HashMap<String, String>();
                    NamedNodeMap nnm = nd.getAttributes();
                    table.put("ROLEID", nnm.getNamedItem("c1").getNodeValue());
                    table.put("ROLENAME", nnm.getNamedItem("c2").getNodeValue());
                    table.put("DESC", nnm.getNamedItem("c3").getNodeValue());
                    rowmap.putAll(table);
                }
                rolelist.add(rowmap);
                ++i;
            }
            crb.setResult(rolelist);
        }
        catch (CoreException ce) {
            crb = crb.SetErrInfo(ce.getMessage());
        }
        catch (Exception e) {
            crb = crb.SetErrInfo(e.getMessage());
        }
        return crb;
    }

    public CoreReturnObject update(CoreRoleBean bean) {
        CoreReturnObject crb = new CoreReturnObject();
        try {
            crb = this.getXmlbean().update(CoreGlobalConstants.ROLEBEAN_REMOTEXMLCONFIGPATH, bean);
        }
        catch (CoreException ce) {
            crb = CoreExceptionHandler.coreExceptionHandler(ce);
        }
        catch (Exception e) {
            crb = CoreExceptionHandler.exceptionHandler(e);
        }
        return crb;
    }

    public CoreReturnObject SaveAsXmlFiles(String xmlfilename, String strXML) {
        CoreReturnObject crb = new CoreReturnObject();
        try {
            crb = this.getXmlbean().SaveAsXmlFiles(xmlfilename, strXML);
        }
        catch (CoreException ce) {
            crb = CoreExceptionHandler.coreExceptionHandler(ce);
        }
        catch (Exception e) {
            crb = CoreExceptionHandler.exceptionHandler(e);
        }
        return crb;
    }

    public CoreReturnObject ReadXmlFiles(String srcpath) {
        CoreReturnObject crb = null;
        try {
            String path = String.valueOf(CoreGlobalConstants.ROLEBEAN_REMOTEXMLCONFIGPATH) + "//" + srcpath + ".xml";
            crb = new CoreReturnObject();
            CoreFileOperation cfo = new CoreFileOperation();
            crb.setResult(cfo.ReadText(path));
        }
        catch (CoreException ce) {
            crb = CoreExceptionHandler.coreExceptionHandler(ce);
        }
        catch (Exception e) {
            crb = CoreExceptionHandler.exceptionHandler(e);
        }
        return crb;
    }

    public CoreReturnObject UpdateData(String roleid, String strxml) throws SQLException {
        CoreReturnObject cro = new CoreReturnObject();
        String sel = "select * from core_app_role where DID='" + roleid + "'";
        String sql = "";
        int count = this.getDao("KgDao").getQueryCount(sel);
        if (count > 0) {
            sql = "update core_app_role set DNAME=? where DID=?";
            cro = this.getDao("KgDao").ExceuteNonQueryForBlobList(sql, new Object[]{strxml, roleid});
        } else {
            sql = "insert into core_app_role values(?,?)";
            cro = this.getDao("KgDao").ExceuteNonQueryForBlobList(sql, new Object[]{roleid, strxml});
        }
        return cro;
    }

    public CoreReturnObject ModiRoleData(String sql, String did, String strxml) throws SQLException {
        CoreReturnObject cro = new CoreReturnObject();
        cro = this.getDao("KgDao").ExceuteNonQueryForBlobList(sql, new Object[]{strxml, did});
        return cro;
    }

    public static void main(String[] args) {
        CoreRoleManage test = new CoreRoleManage();
        test.GetRoleData();
    }
}

