/*
 * Decompiled with CFR 0.152.
 */
package CoreFS.SD03;

import CoreFS.SA01.CoreException;
import CoreFS.SD03.CoreFileLog;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;

public class CoreLogFactory {
    protected static boolean isLog4JAvailable;
    protected static boolean isJdk14Available;
    protected static Hashtable instances;

    static {
        instances = new Hashtable();
        try {
            CoreLogFactory.loadClass("org.apache.log4j.Logger");
            CoreLogFactory.loadClass("org.apache.commons.logging.impl.Log4JLogger");
            isLog4JAvailable = true;
        }
        catch (Throwable throwable) {
            isLog4JAvailable = false;
        }
        try {
            CoreLogFactory.loadClass("java.util.logging.Logger");
            CoreLogFactory.loadClass("org.apache.commons.logging.impl.Jdk14Logger");
            isJdk14Available = true;
        }
        catch (Exception exception) {
            isJdk14Available = false;
        }
    }

    private static Class loadClass(String s) throws ClassNotFoundException {
        Class<?> class1 = null;
        try {
            ClassLoader classloader = Thread.currentThread().getContextClassLoader();
            class1 = classloader.loadClass(s);
        }
        catch (ClassNotFoundException classnotfoundexception) {
            class1 = CoreLogFactory.class.getClassLoader().loadClass(s);
        }
        return class1;
    }

    public static CoreFileLog getLogger(String s) {
        if (isLog4JAvailable) {
            return CoreLogFactory.getLogger("CoreLog4JLogger", s);
        }
        if (isJdk14Available) {
            return CoreLogFactory.getLogger("CoreJdk14Logger", s);
        }
        return CoreLogFactory.getLogger("CoreSimpleLogger", s);
    }

    public static CoreFileLog getLogger(Class class1) {
        return CoreLogFactory.getLogger(class1.getName());
    }

    public static CoreFileLog getLogger(String s, String s1) {
        if (s == null) {
            throw new CoreException("Logger class can not be NULL");
        }
        if (s1 == null) {
            throw new CoreException("Logger instance name can not be NULL");
        }
        CoreFileLog CoreILog = (CoreFileLog)instances.get(s1);
        if (CoreILog == null) {
            CoreILog = CoreLogFactory.newInstance(s, s1);
            instances.put(s1, CoreILog);
        }
        return CoreILog;
    }

    public static CoreFileLog getLogger(String s, Class class1) {
        return CoreLogFactory.getLogger(s, class1.getName());
    }

    private static CoreFileLog newInstance(String s, String s1) {
        try {
            Class<?> class1 = null;
            ClassLoader classloader = Thread.currentThread().getContextClassLoader();
            try {
                class1 = classloader.loadClass(s);
            }
            catch (ClassNotFoundException classnotfoundexception1) {
                class1 = classloader.loadClass(String.valueOf(CoreFileLog.class.getPackage().getName()) + "." + s);
            }
            Constructor<?> constructor = class1.getConstructor(String.class);
            return (CoreFileLog)constructor.newInstance(s1);
        }
        catch (ClassNotFoundException classnotfoundexception) {
            throw new CoreException("Unable to load class for logger '" + s + "'");
        }
        catch (NoSuchMethodException nosuchmethodexception) {
            throw new CoreException("Logger class does not have a single-arg constructor that takes an instance name");
        }
        catch (InstantiationException instantiationexception) {
            throw new CoreException("Unable to instantiate logger class '" + s + "', exception in constructor?");
        }
        catch (InvocationTargetException invocationtargetexception) {
            throw new CoreException("Unable to instantiate logger class '" + s + "', exception in constructor?");
        }
        catch (IllegalAccessException illegalaccessexception) {
            throw new CoreException("Unable to instantiate logger class '" + s + "', constructor not public");
        }
        catch (ClassCastException classcastexception) {
            throw new CoreException("Logger class '" + s + "' does not implement the '" + CoreFileLog.class.getName());
        }
    }
}

